/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.beam.sdk.util.Sleeper;

public class SystemNanoTimeSleeper
implements Sleeper {
    public static final Sleeper INSTANCE = new SystemNanoTimeSleeper();

    private SystemNanoTimeSleeper() {
    }

    public void sleep(long millis) throws InterruptedException {
        long currentTime;
        long endTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(millis, TimeUnit.MILLISECONDS);
        while ((currentTime = System.nanoTime()) < endTime) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            LockSupport.parkNanos(endTime - currentTime);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static void sleepMillis(long millis) throws InterruptedException {
        INSTANCE.sleep(millis);
    }
}

