/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.testing.StaticWindows;
import org.apache.beam.sdk.testing.WindowFnTestUtils;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StaticWindowsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final IntervalWindow first = new IntervalWindow(new Instant(0L), new Instant(100000L));
    private final IntervalWindow second = new IntervalWindow(new Instant(1000000L), GlobalWindow.INSTANCE.maxTimestamp());

    @Test
    public void singleWindowSucceeds() throws Exception {
        StaticWindows fn = StaticWindows.of((Coder)IntervalWindow.getCoder(), (BoundedWindow)this.first);
        Assert.assertThat((Object)WindowFnTestUtils.assignedWindows((WindowFn)fn, (long)100L), (Matcher)Matchers.contains((Object[])new BoundedWindow[]{this.first}));
        Assert.assertThat((Object)WindowFnTestUtils.assignedWindows((WindowFn)fn, (long)-100L), (Matcher)Matchers.contains((Object[])new BoundedWindow[]{this.first}));
    }

    @Test
    public void multipleWindowsSucceeds() throws Exception {
        StaticWindows fn = StaticWindows.of((Coder)IntervalWindow.getCoder(), ImmutableList.of(this.first, this.second));
        Assert.assertThat((Object)WindowFnTestUtils.assignedWindows((WindowFn)fn, (long)100L), (Matcher)Matchers.containsInAnyOrder((Object[])new BoundedWindow[]{this.first, this.second}));
        Assert.assertThat((Object)WindowFnTestUtils.assignedWindows((WindowFn)fn, (long)1000000000L), (Matcher)Matchers.containsInAnyOrder((Object[])new BoundedWindow[]{this.first, this.second}));
        Assert.assertThat((Object)WindowFnTestUtils.assignedWindows((WindowFn)fn, (long)-100L), (Matcher)Matchers.containsInAnyOrder((Object[])new BoundedWindow[]{this.first, this.second}));
    }

    @Test
    public void getSideInputWindowIdentity() {
        StaticWindows fn = StaticWindows.of((Coder)IntervalWindow.getCoder(), ImmutableList.of(this.first, this.second));
        Assert.assertThat((Object)fn.getDefaultWindowMappingFn().getSideInputWindow((BoundedWindow)this.first), (Matcher)Matchers.equalTo((Object)this.first));
        Assert.assertThat((Object)fn.getDefaultWindowMappingFn().getSideInputWindow((BoundedWindow)this.second), (Matcher)Matchers.equalTo((Object)this.second));
    }

    @Test
    public void getSideInputWindowNotPresent() {
        StaticWindows fn = StaticWindows.of((Coder)IntervalWindow.getCoder(), ImmutableList.of(this.second));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("contains");
        fn.getDefaultWindowMappingFn().getSideInputWindow((BoundedWindow)this.first);
    }

    @Test
    public void emptyIterableThrows() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("may not be empty");
        StaticWindows.of((Coder)GlobalWindow.Coder.INSTANCE, ImmutableList.of());
    }

    @Test
    public void testCompatibility() throws IncompatibleWindowException {
        StaticWindows staticWindows = StaticWindows.of((Coder)IntervalWindow.getCoder(), ImmutableList.of(this.first, this.second));
        staticWindows.verifyCompatibility((WindowFn)StaticWindows.of((Coder)IntervalWindow.getCoder(), ImmutableList.of(this.first, this.second)));
        this.thrown.expect(IncompatibleWindowException.class);
        staticWindows.verifyCompatibility((WindowFn)StaticWindows.of((Coder)IntervalWindow.getCoder(), ImmutableList.of(this.first)));
    }
}

