/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.util.HashSet;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Sets;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.CountingSource;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SourceTestUtilsTest {
    @Test
    public void testToUnsplittableSource() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        BoundedSource baseSource = CountingSource.upTo((long)100L);
        BoundedSource unsplittableSource = SourceTestUtils.toUnsplittableSource((BoundedSource)baseSource);
        List splits = unsplittableSource.split(1L, options);
        Assert.assertEquals((long)1L, (long)splits.size());
        Assert.assertEquals((Object)unsplittableSource, splits.get(0));
        BoundedSource.BoundedReader unsplittableReader = unsplittableSource.createReader(options);
        Assert.assertEquals((double)0.0, (double)unsplittableReader.getFractionConsumed(), (double)1.0E-15);
        HashSet expected = Sets.newHashSet(SourceTestUtils.readFromSource((BoundedSource)baseSource, (PipelineOptions)options));
        HashSet actual = Sets.newHashSet();
        actual.addAll(SourceTestUtils.readNItemsFromUnstartedReader((Source.Reader)unsplittableReader, (int)40));
        Assert.assertNull((Object)unsplittableReader.splitAtFraction(0.5));
        actual.addAll(SourceTestUtils.readRemainingFromReader((Source.Reader)unsplittableReader, (boolean)true));
        Assert.assertEquals((double)1.0, (double)unsplittableReader.getFractionConsumed(), (double)1.0E-15);
        Assert.assertEquals((long)100L, (long)actual.size());
        Assert.assertEquals(Sets.newHashSet(expected), Sets.newHashSet(actual));
    }
}

