/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.testing.SerializableMatchers;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.KV;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SerializableMatchersTest
implements Serializable {
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    public void testAnythingSerializable() throws Exception {
        SerializableUtils.ensureSerializable((Serializable)SerializableMatchers.anything());
    }

    @Test
    public void testAllOfSerializable() throws Exception {
        SerializableUtils.ensureSerializable((Serializable)SerializableMatchers.allOf((SerializableMatcher[])new SerializableMatcher[]{SerializableMatchers.anything()}));
    }

    @Test
    public void testContainsInAnyOrderSerializable() throws Exception {
        Assert.assertThat(ImmutableList.of(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(3)), (Matcher)((Matcher)SerializableUtils.ensureSerializable((Serializable)SerializableMatchers.containsInAnyOrder((Serializable[])new Integer[]{1, 2, 3}))));
    }

    @Test
    public void testContainsInAnyOrderNotSerializable() throws Exception {
        Assert.assertThat(ImmutableList.of(new NotSerializableClass()), (Matcher)((Matcher)SerializableUtils.ensureSerializable((Serializable)SerializableMatchers.containsInAnyOrder((Coder)new NotSerializableClassCoder(), (Object[])new NotSerializableClass[]{new NotSerializableClass()}))));
    }

    @Test
    public void testKvKeyMatcherSerializable() throws Exception {
        Assert.assertThat((Object)KV.of((Object)"hello", (Object)42L), (Matcher)((Matcher)SerializableUtils.ensureSerializable((Serializable)SerializableMatchers.kvWithKey((Serializable)((Object)"hello")))));
    }

    @Test
    public void testKvMatcherBasicSuccess() throws Exception {
        Assert.assertThat((Object)KV.of((Object)1, (Object)2), (Matcher)SerializableMatchers.kv((SerializableMatcher)SerializableMatchers.anything(), (SerializableMatcher)SerializableMatchers.anything()));
    }

    @Test
    public void testKvMatcherKeyFailure() throws Exception {
        AssertionError exc = SerializableMatchersTest.assertionShouldFail(() -> Assert.assertThat((Object)KV.of((Object)1, (Object)2), (Matcher)SerializableMatchers.kv((SerializableMatcher)SerializableMatchers.not((SerializableMatcher)SerializableMatchers.anything()), (SerializableMatcher)SerializableMatchers.anything())));
        Assert.assertThat((Object)((Throwable)((Object)exc)).getMessage(), (Matcher)Matchers.containsString((String)"key did not match"));
    }

    @Test
    public void testKvMatcherValueFailure() throws Exception {
        AssertionError exc = SerializableMatchersTest.assertionShouldFail(() -> Assert.assertThat((Object)KV.of((Object)1, (Object)2), (Matcher)SerializableMatchers.kv((SerializableMatcher)SerializableMatchers.anything(), (SerializableMatcher)SerializableMatchers.not((SerializableMatcher)SerializableMatchers.anything()))));
        Assert.assertThat((Object)((Throwable)((Object)exc)).getMessage(), (Matcher)Matchers.containsString((String)"value did not match"));
    }

    @Test
    public void testKvMatcherGBKLikeSuccess() throws Exception {
        Assert.assertThat((Object)KV.of((Object)"key", ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))), (Matcher)SerializableMatchers.kv((SerializableMatcher)SerializableMatchers.anything(), (SerializableMatcher)SerializableMatchers.containsInAnyOrder((Serializable[])new Integer[]{3, 2, 1})));
    }

    @Test
    public void testKvMatcherGBKLikeFailure() throws Exception {
        AssertionError exc = SerializableMatchersTest.assertionShouldFail(() -> Assert.assertThat((Object)KV.of((Object)"key", ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))), (Matcher)SerializableMatchers.kv((SerializableMatcher)SerializableMatchers.anything(), (SerializableMatcher)SerializableMatchers.containsInAnyOrder((Serializable[])new Integer[]{1, 2, 3, 4}))));
        Assert.assertThat((Object)((Throwable)((Object)exc)).getMessage(), (Matcher)Matchers.containsString((String)"value did not match"));
    }

    private static AssertionError assertionShouldFail(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (AssertionError expected) {
            return expected;
        }
        throw new AssertionError((Object)"Should have failed.");
    }

    private static class NotSerializableClassCoder
    extends AtomicCoder<NotSerializableClass> {
        private NotSerializableClassCoder() {
        }

        public void encode(NotSerializableClass value, OutputStream outStream) {
        }

        public NotSerializableClass decode(InputStream inStream) {
            return new NotSerializableClass();
        }
    }

    private static class NotSerializableClass {
        private NotSerializableClass() {
        }

        public boolean equals(Object other) {
            return other instanceof NotSerializableClass;
        }

        public int hashCode() {
            return 0;
        }
    }
}

