/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;

public class RestoreSystemProperties
extends ExternalResource
implements TestRule {
    private byte[] originalProperties;

    protected void before() throws Throwable {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.getProperties().store(baos, "");
        baos.close();
        this.originalProperties = baos.toByteArray();
    }

    protected void after() {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(this.originalProperties);){
            System.getProperties().clear();
            System.getProperties().load(bais);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

