/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.PaneExtractors;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PaneExtractorsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void onlyPaneNoFiring() {
        SimpleFunction extractor = PaneExtractors.onlyPane((PAssert.PAssertionSite)PAssert.PAssertionSite.capture((String)""));
        ImmutableList<ValueInSingleWindow> noFiring = ImmutableList.of(ValueInSingleWindow.of((Object)9, (Instant)BoundedWindow.TIMESTAMP_MIN_VALUE, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING), ValueInSingleWindow.of((Object)19, (Instant)BoundedWindow.TIMESTAMP_MIN_VALUE, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING));
        Assert.assertThat((Object)((Iterable)extractor.apply(noFiring)), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{9, 19}));
    }

    @Test
    public void onlyPaneOnlyOneFiring() {
        SimpleFunction extractor = PaneExtractors.onlyPane((PAssert.PAssertionSite)PAssert.PAssertionSite.capture((String)""));
        ImmutableList<ValueInSingleWindow> onlyFiring = ImmutableList.of(ValueInSingleWindow.of((Object)2, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING), ValueInSingleWindow.of((Object)1, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING));
        Assert.assertThat((Object)((Iterable)extractor.apply(onlyFiring)), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{2, 1}));
    }

    @Test
    public void onlyPaneMultiplePanesFails() {
        SimpleFunction extractor = PaneExtractors.onlyPane((PAssert.PAssertionSite)PAssert.PAssertionSite.capture((String)""));
        ImmutableList<ValueInSingleWindow> multipleFiring = ImmutableList.of(ValueInSingleWindow.of((Object)4, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY)), ValueInSingleWindow.of((Object)2, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L)), ValueInSingleWindow.of((Object)1, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)2L, (long)1L)));
        this.thrown.expectMessage("trigger that fires at most once");
        extractor.apply(multipleFiring);
    }

    @Test
    public void onTimePane() {
        SimpleFunction extractor = PaneExtractors.onTimePane();
        ImmutableList<ValueInSingleWindow> onlyOnTime = ImmutableList.of(ValueInSingleWindow.of((Object)4, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L)), ValueInSingleWindow.of((Object)2, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L)));
        Assert.assertThat((Object)((Iterable)extractor.apply(onlyOnTime)), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{2, 4}));
    }

    @Test
    public void onTimePaneOnlyEarlyAndLate() {
        SimpleFunction extractor = PaneExtractors.onTimePane();
        ImmutableList<ValueInSingleWindow> onlyOnTime = ImmutableList.of(ValueInSingleWindow.of((Object)8, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)2L, (long)1L)), ValueInSingleWindow.of((Object)4, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L)), ValueInSingleWindow.of((Object)2, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L)), ValueInSingleWindow.of((Object)1, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY)));
        Assert.assertThat((Object)((Iterable)extractor.apply(onlyOnTime)), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{2, 4}));
    }

    @Test
    public void finalPane() {
        SimpleFunction extractor = PaneExtractors.finalPane();
        ImmutableList<ValueInSingleWindow> onlyOnTime = ImmutableList.of(ValueInSingleWindow.of((Object)8, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)2L, (long)1L)), ValueInSingleWindow.of((Object)4, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L)), ValueInSingleWindow.of((Object)1, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY)));
        Assert.assertThat((Object)((Iterable)extractor.apply(onlyOnTime)), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{8}));
    }

    @Test
    public void finalPaneNoExplicitFinalEmpty() {
        SimpleFunction extractor = PaneExtractors.finalPane();
        ImmutableList<ValueInSingleWindow> onlyOnTime = ImmutableList.of(ValueInSingleWindow.of((Object)8, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)2L, (long)1L)), ValueInSingleWindow.of((Object)4, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L)), ValueInSingleWindow.of((Object)1, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY)));
        Assert.assertThat((Object)((Iterable)extractor.apply(onlyOnTime)), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void nonLatePanesSingleOnTime() {
        SimpleFunction extractor = PaneExtractors.nonLatePanes();
        ImmutableList<ValueInSingleWindow> onlyOnTime = ImmutableList.of(ValueInSingleWindow.of((Object)8, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING), ValueInSingleWindow.of((Object)4, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING), ValueInSingleWindow.of((Object)2, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING));
        Assert.assertThat((Object)((Iterable)extractor.apply(onlyOnTime)), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{2, 4, 8}));
    }

    @Test
    public void nonLatePanesSingleEarly() {
        SimpleFunction extractor = PaneExtractors.nonLatePanes();
        ImmutableList<ValueInSingleWindow> onlyOnTime = ImmutableList.of(ValueInSingleWindow.of((Object)8, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY)), ValueInSingleWindow.of((Object)4, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY)));
        Assert.assertThat((Object)((Iterable)extractor.apply(onlyOnTime)), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{4, 8}));
    }

    @Test
    public void allPanesSingleLate() {
        SimpleFunction extractor = PaneExtractors.nonLatePanes();
        ImmutableList<ValueInSingleWindow> onlyOnTime = ImmutableList.of(ValueInSingleWindow.of((Object)8, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)0L, (long)0L)));
        Assert.assertThat((Object)((Iterable)extractor.apply(onlyOnTime)), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void nonLatePanesMultiplePanes() {
        SimpleFunction extractor = PaneExtractors.nonLatePanes();
        ImmutableList<ValueInSingleWindow> onlyOnTime = ImmutableList.of(ValueInSingleWindow.of((Object)8, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)2L, (long)1L)), ValueInSingleWindow.of((Object)7, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING), ValueInSingleWindow.of((Object)4, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L)), ValueInSingleWindow.of((Object)1, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY)));
        Assert.assertThat((Object)((Iterable)extractor.apply(onlyOnTime)), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{4, 1, 7}));
    }

    @Test
    public void allPanesSinglePane() {
        SimpleFunction extractor = PaneExtractors.allPanes();
        ImmutableList<ValueInSingleWindow> onlyOnTime = ImmutableList.of(ValueInSingleWindow.of((Object)8, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING), ValueInSingleWindow.of((Object)4, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING), ValueInSingleWindow.of((Object)2, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING));
        Assert.assertThat((Object)((Iterable)extractor.apply(onlyOnTime)), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{2, 4, 8}));
    }

    @Test
    public void allPanesMultiplePanes() {
        SimpleFunction extractor = PaneExtractors.allPanes();
        ImmutableList<ValueInSingleWindow> onlyOnTime = ImmutableList.of(ValueInSingleWindow.of((Object)8, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)2L, (long)1L)), ValueInSingleWindow.of((Object)4, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L)), ValueInSingleWindow.of((Object)1, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY)));
        Assert.assertThat((Object)((Iterable)extractor.apply(onlyOnTime)), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{4, 8, 1}));
    }

    @Test
    public void allPanesEmpty() {
        SimpleFunction extractor = PaneExtractors.allPanes();
        ImmutableList noPanes = ImmutableList.of();
        Assert.assertThat((Object)((Iterable)extractor.apply(noPanes)), (Matcher)Matchers.emptyIterable());
    }
}

