/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Throwables;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SerializableMatchers;
import org.apache.beam.sdk.testing.SuccessOrFailure;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PAssertTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    private void throwNestedError() {
        throw new RuntimeException("Nested error");
    }

    private void throwWrappedError() {
        try {
            this.throwNestedError();
        }
        catch (Exception e) {
            throw new RuntimeException("Wrapped error", e);
        }
    }

    @Test
    public void testFailureWithExceptionEncodedDecoded() throws IOException {
        try {
            this.throwWrappedError();
            throw new IllegalStateException("Should have failed");
        }
        catch (Throwable e) {
            Throwable error = e;
            SuccessOrFailure failure = SuccessOrFailure.failure((PAssert.PAssertionSite)PAssert.PAssertionSite.capture((String)"here"), (Throwable)error);
            SuccessOrFailure res = (SuccessOrFailure)CoderUtils.clone((Coder)SerializableCoder.of(SuccessOrFailure.class), (Object)failure);
            Assert.assertEquals((String)"Encode-decode failed SuccessOrFailure", (Object)Throwables.getStackTraceAsString((Throwable)((Object)failure.assertionError())), (Object)Throwables.getStackTraceAsString((Throwable)((Object)res.assertionError())));
            return;
        }
    }

    @Test
    public void testSuccessEncodedDecoded() throws IOException {
        SuccessOrFailure success = SuccessOrFailure.success();
        SerializableCoder coder = SerializableCoder.of(SuccessOrFailure.class);
        byte[] encoded = CoderUtils.encodeToByteArray((Coder)coder, (Object)success);
        SuccessOrFailure res = (SuccessOrFailure)CoderUtils.decodeFromByteArray((Coder)coder, (byte[])encoded);
        Assert.assertEquals((String)"Encode-decode successful SuccessOrFailure", (Object)success.isSuccess(), (Object)res.isSuccess());
        Assert.assertEquals((String)"Encode-decode successful SuccessOrFailure", (Object)success.assertionError(), (Object)res.assertionError());
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testContainsInAnyOrderNotSerializable() throws Exception {
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)new NotSerializableObject(), (Object[])new NotSerializableObject[]{new NotSerializableObject()}).withCoder((Coder)NotSerializableObjectCoder.of()));
        PAssert.that((PCollection)pcollection).containsInAnyOrder((Object[])new NotSerializableObject[]{new NotSerializableObject(), new NotSerializableObject()});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testSerializablePredicate() throws Exception {
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)new NotSerializableObject(), (Object[])new NotSerializableObject[]{new NotSerializableObject()}).withCoder((Coder)NotSerializableObjectCoder.of()));
        PAssert.that((PCollection)pcollection).satisfies((SerializableFunction & Serializable)contents -> null);
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedSerializablePredicate() throws Exception {
        PCollection pcollection = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)new NotSerializableObject(), (Instant)new Instant(250L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)new NotSerializableObject(), (Instant)new Instant(500L))}).withCoder((Coder)NotSerializableObjectCoder.of()))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)300L))));
        PAssert.that((PCollection)pcollection).inWindow((BoundedWindow)new IntervalWindow(new Instant(0L), new Instant(300L))).satisfies((SerializableFunction & Serializable)contents -> {
            Assert.assertThat((Object)Iterables.isEmpty(contents), (Matcher)Matchers.is((Object)false));
            return null;
        });
        PAssert.that((PCollection)pcollection).inWindow((BoundedWindow)new IntervalWindow(new Instant(300L), new Instant(600L))).satisfies((SerializableFunction & Serializable)contents -> {
            Assert.assertThat((Object)Iterables.isEmpty(contents), (Matcher)Matchers.is((Object)false));
            return null;
        });
        this.pipeline.run();
    }

    @Test
    public void testPAssertEqualsSingletonUnsupported() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("isEqualTo");
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)42, (Object[])new Integer[0]));
        PAssert.thatSingleton((PCollection)pcollection).equals(42);
    }

    @Test
    public void testPAssertEqualsIterableUnsupported() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("containsInAnyOrder");
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)42, (Object[])new Integer[0]));
        PAssert.that((PCollection)pcollection).equals(42);
    }

    @Test
    public void testPAssertHashCodeSingletonUnsupported() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage(".hashCode() is not supported.");
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)42, (Object[])new Integer[0]));
        PAssert.thatSingleton((PCollection)pcollection).hashCode();
    }

    @Test
    public void testPAssertHashCodeIterableUnsupported() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage(".hashCode() is not supported.");
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)42, (Object[])new Integer[0]));
        PAssert.that((PCollection)pcollection).hashCode();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testIsEqualTo() throws Exception {
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)43, (Object[])new Integer[0]));
        PAssert.thatSingleton((PCollection)pcollection).isEqualTo((Object)43);
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedIsEqualTo() throws Exception {
        PCollection pcollection = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)43, (Instant)new Instant(250L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)22, (Instant)new Instant(-250L))}))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)500L))));
        PAssert.thatSingleton((PCollection)pcollection).inOnlyPane((BoundedWindow)new IntervalWindow(new Instant(0L), new Instant(500L))).isEqualTo((Object)43);
        PAssert.thatSingleton((PCollection)pcollection).inOnlyPane((BoundedWindow)new IntervalWindow(new Instant(-500L), new Instant(0L))).isEqualTo((Object)22);
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testNotEqualTo() throws Exception {
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)43, (Object[])new Integer[0]));
        PAssert.thatSingleton((PCollection)pcollection).notEqualTo((Object)42);
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testPAssertEqualsSingletonFalse() throws Exception {
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)42, (Object[])new Integer[0]));
        PAssert.thatSingleton((String)"The value was not equal to 44", (PCollection)pcollection).isEqualTo((Object)44);
        Throwable thrown = PAssertTest.runExpectingAssertionFailure((Pipeline)this.pipeline);
        String message = thrown.getMessage();
        Assert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"The value was not equal to 44"));
        Assert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"Expected: <44>"));
        Assert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"but: was <42>"));
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testPAssertEqualsSingletonFalseDefaultReasonString() throws Exception {
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)42, (Object[])new Integer[0]));
        PAssert.thatSingleton((PCollection)pcollection).isEqualTo((Object)44);
        Throwable thrown = PAssertTest.runExpectingAssertionFailure((Pipeline)this.pipeline);
        String message = thrown.getMessage();
        Assert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"Create.Values/Read(CreateSource).out"));
        Assert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"Expected: <44>"));
        Assert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"but: was <42>"));
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testContainsInAnyOrder() throws Exception {
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}));
        PAssert.that((PCollection)pcollection).containsInAnyOrder((Object[])new Integer[]{2, 1, 4, 3});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testGlobalWindowContainsInAnyOrder() throws Exception {
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}));
        PAssert.that((PCollection)pcollection).inWindow((BoundedWindow)GlobalWindow.INSTANCE).containsInAnyOrder((Object[])new Integer[]{2, 1, 4, 3});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedContainsInAnyOrder() throws Exception {
        PCollection pcollection = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)1, (Instant)new Instant(100L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)2, (Instant)new Instant(200L)), TimestampedValue.of((Object)3, (Instant)new Instant(300L)), TimestampedValue.of((Object)4, (Instant)new Instant(400L))}))).apply((PTransform)Window.into((WindowFn)SlidingWindows.of((Duration)Duration.millis((long)200L)).every(Duration.millis((long)100L)).withOffset(Duration.millis((long)50L))));
        PAssert.that((PCollection)pcollection).inWindow((BoundedWindow)new IntervalWindow(new Instant(-50L), new Instant(150L))).containsInAnyOrder((Object[])new Integer[]{1});
        PAssert.that((PCollection)pcollection).inWindow((BoundedWindow)new IntervalWindow(new Instant(50L), new Instant(250L))).containsInAnyOrder((Object[])new Integer[]{2, 1});
        PAssert.that((PCollection)pcollection).inWindow((BoundedWindow)new IntervalWindow(new Instant(150L), new Instant(350L))).containsInAnyOrder((Object[])new Integer[]{2, 3});
        PAssert.that((PCollection)pcollection).inWindow((BoundedWindow)new IntervalWindow(new Instant(250L), new Instant(450L))).containsInAnyOrder((Object[])new Integer[]{4, 3});
        PAssert.that((PCollection)pcollection).inWindow((BoundedWindow)new IntervalWindow(new Instant(350L), new Instant(550L))).containsInAnyOrder((Object[])new Integer[]{4});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testEmpty() {
        PCollection vals = (PCollection)this.pipeline.apply((PTransform)Create.empty((Coder)VarLongCoder.of()));
        PAssert.that((PCollection)vals).empty();
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testContainsInAnyOrderFalse() throws Exception {
        PCollection pcollection = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}));
        PAssert.that((PCollection)pcollection).containsInAnyOrder((Object[])new Integer[]{2, 1, 4, 3, 7});
        Throwable exc = PAssertTest.runExpectingAssertionFailure((Pipeline)this.pipeline);
        Pattern expectedPattern = Pattern.compile("Expected: iterable over \\[((<4>|<7>|<3>|<2>|<1>)(, )?){5}\\] in any order");
        Assert.assertTrue((String)("Expected error message from PAssert with substring matching " + expectedPattern + " but the message was \"" + exc.getMessage() + "\""), (boolean)expectedPattern.matcher(exc.getMessage()).find());
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testEmptyFalse() throws Exception {
        PCollection vals = (PCollection)this.pipeline.apply((PTransform)GenerateSequence.from((long)0L).to(5L));
        PAssert.that((String)"Vals should have been empty", (PCollection)vals).empty();
        Throwable thrown = PAssertTest.runExpectingAssertionFailure((Pipeline)this.pipeline);
        String message = thrown.getMessage();
        Assert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"Vals should have been empty"));
        Assert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"Expected: iterable over [] in any order"));
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testEmptyFalseDefaultReasonString() throws Exception {
        PCollection vals = (PCollection)this.pipeline.apply((PTransform)GenerateSequence.from((long)0L).to(5L));
        PAssert.that((PCollection)vals).empty();
        Throwable thrown = PAssertTest.runExpectingAssertionFailure((Pipeline)this.pipeline);
        String message = thrown.getMessage();
        Assert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"GenerateSequence/Read(BoundedCountingSource).out"));
        Assert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"Expected: iterable over [] in any order"));
    }

    @Test
    public void testAssertionSiteIsCaptured() {
        SuccessOrFailure res = PAssert.doChecks((PAssert.PAssertionSite)PAssert.PAssertionSite.capture((String)"Captured assertion message."), (Object)10, (SerializableFunction)new PAssert.PCollectionContentsAssert.MatcherCheckerFn(SerializableMatchers.contains((Serializable[])new Integer[]{11})));
        String stacktrace = Throwables.getStackTraceAsString((Throwable)((Object)res.assertionError()));
        Assert.assertEquals((Object)false, (Object)res.isSuccess());
        Assert.assertThat((Object)stacktrace, (Matcher)Matchers.containsString((String)"PAssertionSite.capture"));
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testAssertionSiteIsCapturedWithMessage() throws Exception {
        PCollection vals = (PCollection)this.pipeline.apply((PTransform)GenerateSequence.from((long)0L).to(5L));
        PAssertTest.assertThatCollectionIsEmptyWithMessage((PCollection<Long>)vals);
        Throwable thrown = PAssertTest.runExpectingAssertionFailure((Pipeline)this.pipeline);
        Assert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Should be empty"));
        Assert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Expected: iterable over [] in any order"));
        String stacktrace = Throwables.getStackTraceAsString(thrown);
        Assert.assertThat((Object)stacktrace, (Matcher)Matchers.containsString((String)"testAssertionSiteIsCapturedWithMessage"));
        Assert.assertThat((Object)stacktrace, (Matcher)Matchers.containsString((String)"assertThatCollectionIsEmptyWithMessage"));
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testAssertionSiteIsCapturedWithoutMessage() throws Exception {
        PCollection vals = (PCollection)this.pipeline.apply((PTransform)GenerateSequence.from((long)0L).to(5L));
        PAssertTest.assertThatCollectionIsEmptyWithoutMessage((PCollection<Long>)vals);
        Throwable thrown = PAssertTest.runExpectingAssertionFailure((Pipeline)this.pipeline);
        Assert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Expected: iterable over [] in any order"));
        String stacktrace = Throwables.getStackTraceAsString(thrown);
        Assert.assertThat((Object)stacktrace, (Matcher)Matchers.containsString((String)"testAssertionSiteIsCapturedWithoutMessage"));
        Assert.assertThat((Object)stacktrace, (Matcher)Matchers.containsString((String)"assertThatCollectionIsEmptyWithoutMessage"));
    }

    private static void assertThatCollectionIsEmptyWithMessage(PCollection<Long> vals) {
        PAssert.that((String)"Should be empty", vals).empty();
    }

    private static void assertThatCollectionIsEmptyWithoutMessage(PCollection<Long> vals) {
        PAssert.that(vals).empty();
    }

    private static Throwable runExpectingAssertionFailure(Pipeline pipeline) {
        try {
            pipeline.run();
        }
        catch (Throwable exc) {
            return exc;
        }
        Assert.fail((String)"assertion should have failed");
        throw new RuntimeException("unreachable");
    }

    @Test
    public void countAssertsSucceeds() {
        PCollection create = (PCollection)this.pipeline.apply("FirstCreate", (PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        PAssert.that((PCollection)create).containsInAnyOrder((Object[])new Integer[]{1, 2, 3});
        PAssert.thatSingleton((PCollection)((PCollection)create.apply((PTransform)Sum.integersGlobally()))).isEqualTo((Object)6);
        PAssert.thatMap((PCollection)((PCollection)this.pipeline.apply("CreateMap", (PTransform)Create.of((Object)KV.of((Object)1, (Object)2), (Object[])new KV[0])))).isEqualTo(Collections.singletonMap(1, 2));
        Assert.assertThat((Object)PAssert.countAsserts((Pipeline)this.pipeline), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void countAssertsMultipleCallsIndependent() {
        PCollection create = (PCollection)this.pipeline.apply("FirstCreate", (PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        PAssert.that((PCollection)create).containsInAnyOrder((Object[])new Integer[]{1, 2, 3});
        PAssert.thatSingleton((PCollection)((PCollection)create.apply((PTransform)Sum.integersGlobally()))).isEqualTo((Object)6);
        Assert.assertThat((Object)PAssert.countAsserts((Pipeline)this.pipeline), (Matcher)Matchers.equalTo((Object)2));
        PAssert.thatMap((PCollection)((PCollection)this.pipeline.apply("CreateMap", (PTransform)Create.of((Object)KV.of((Object)1, (Object)2), (Object[])new KV[0])))).isEqualTo(Collections.singletonMap(1, 2));
        Assert.assertThat((Object)PAssert.countAsserts((Pipeline)this.pipeline), (Matcher)Matchers.equalTo((Object)3));
    }

    private static class NotSerializableObjectCoder
    extends AtomicCoder<NotSerializableObject> {
        private static final NotSerializableObjectCoder INSTANCE = new NotSerializableObjectCoder();

        private NotSerializableObjectCoder() {
        }

        @JsonCreator
        public static NotSerializableObjectCoder of() {
            return INSTANCE;
        }

        public void encode(NotSerializableObject value, OutputStream outStream) throws CoderException, IOException {
        }

        public NotSerializableObject decode(InputStream inStream) throws CoderException, IOException {
            return new NotSerializableObject();
        }

        public boolean isRegisterByteSizeObserverCheap(NotSerializableObject value) {
            return true;
        }

        public void registerByteSizeObserver(NotSerializableObject value, ElementByteSizeObserver observer) throws Exception {
            observer.update((Object)0L);
        }
    }

    private static class NotSerializableObject {
        private NotSerializableObject() {
        }

        public boolean equals(Object other) {
            return other instanceof NotSerializableObject;
        }

        public int hashCode() {
            return 73;
        }
    }
}

