/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.io.IOException;
import java.util.function.Predicate;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Predicates;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Sets;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.ByteStreams;

public class InterceptingUrlClassLoader
extends ClassLoader {
    private final Predicate<String> test;

    public InterceptingUrlClassLoader(ClassLoader parent, String ... ownedClasses) {
        this(parent, Predicates.in(Sets.newHashSet(ownedClasses))::apply);
    }

    public InterceptingUrlClassLoader(ClassLoader parent, Predicate<String> test) {
        super(parent);
        this.test = test;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> alreadyLoaded = super.findLoadedClass(name);
        if (alreadyLoaded != null) {
            return alreadyLoaded;
        }
        if (name != null && this.test.test(name)) {
            try {
                String classAsResource = name.replace('.', '/') + ".class";
                byte[] classBytes = ByteStreams.toByteArray(this.getParent().getResourceAsStream(classAsResource));
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getParent().loadClass(name);
    }
}

