/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.io.Serializable;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.testing.GatherAllPanes;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GatherAllPanesTest
implements Serializable {
    @Rule
    public transient TestPipeline p = TestPipeline.create();

    @Test
    @Category(value={NeedsRunner.class})
    public void singlePaneSingleReifiedPane() {
        PCollection accumulatedPanes = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)this.p.apply((PTransform)GenerateSequence.from((long)0L).to(20000L))).apply((PTransform)WithTimestamps.of((SerializableFunction & Serializable)input -> new Instant(input * 10L)))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))).triggering((Trigger)AfterWatermark.pastEndOfWindow()).withAllowedLateness(Duration.ZERO).discardingFiredPanes())).apply((PTransform)WithKeys.of((Object)null).withKeyType((TypeDescriptor)new TypeDescriptor<Void>(){}))).apply((PTransform)GroupByKey.create())).apply((PTransform)Values.create())).apply((PTransform)GatherAllPanes.globally());
        PAssert.that((PCollection)accumulatedPanes).satisfies((SerializableFunction & Serializable)input -> {
            for (Iterable windowedInput : input) {
                if (Iterables.size(windowedInput) <= 1) continue;
                Assert.fail((String)("Expected all windows to have exactly one pane, got " + windowedInput));
                return null;
            }
            return null;
        });
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void multiplePanesMultipleReifiedPane() {
        PCollection someElems = (PCollection)this.p.apply("someLongs", (PTransform)GenerateSequence.from((long)0L).to(20000L));
        PCollection otherElems = (PCollection)this.p.apply("otherLongs", (PTransform)GenerateSequence.from((long)0L).to(20000L));
        PCollection accumulatedPanes = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)PCollectionList.of((PCollection)someElems).and(otherElems).apply((PTransform)Flatten.pCollections())).apply((PTransform)WithTimestamps.of((SerializableFunction & Serializable)input -> new Instant(input * 10L)))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))).triggering((Trigger)AfterWatermark.pastEndOfWindow().withEarlyFirings((Trigger.OnceTrigger)AfterPane.elementCountAtLeast((int)1))).withAllowedLateness(Duration.ZERO).discardingFiredPanes())).apply((PTransform)WithKeys.of((Object)null).withKeyType((TypeDescriptor)new TypeDescriptor<Void>(){}))).apply((PTransform)GroupByKey.create())).apply((PTransform)Values.create())).apply((PTransform)GatherAllPanes.globally());
        PAssert.that((PCollection)accumulatedPanes).satisfies((SerializableFunction & Serializable)input -> {
            for (Iterable windowedInput : input) {
                if (Iterables.size(windowedInput) <= 1) continue;
                return null;
            }
            Assert.fail((String)"Expected at least one window to have multiple panes");
            return null;
        });
        this.p.run();
    }
}

