/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.Files;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.testing.FileChecksumMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class FileChecksumMatcherTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    private PipelineResult pResult = (PipelineResult)Mockito.mock(PipelineResult.class);

    @Test
    public void testPreconditionChecksumIsNull() throws IOException {
        String tmpPath = this.tmpFolder.newFile().getPath();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Expected valid checksum, but received"));
        new FileChecksumMatcher(null, tmpPath);
    }

    @Test
    public void testPreconditionChecksumIsEmpty() throws IOException {
        String tmpPath = this.tmpFolder.newFile().getPath();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Expected valid checksum, but received"));
        new FileChecksumMatcher("", tmpPath);
    }

    @Test
    public void testPreconditionFilePathIsEmpty() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Expected valid file path, but received"));
        new FileChecksumMatcher("checksumString", "");
    }

    @Test
    public void testPreconditionShardTemplateIsNull() throws IOException {
        String tmpPath = this.tmpFolder.newFile().getPath();
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Expected non-null shard pattern. Please call the other constructor to use default pattern:"));
        new FileChecksumMatcher("checksumString", tmpPath, null);
    }

    @Test
    public void testMatcherThatVerifiesSingleFile() throws IOException {
        File tmpFile = this.tmpFolder.newFile("result-000-of-001");
        Files.write("Test for file checksum verifier.", tmpFile, StandardCharsets.UTF_8);
        FileChecksumMatcher matcher = new FileChecksumMatcher("a8772322f5d7b851777f820fc79d050f9d302915", tmpFile.getPath());
        MatcherAssert.assertThat((Object)this.pResult, (Matcher)matcher);
    }

    @Test
    public void testMatcherThatVerifiesMultipleFiles() throws IOException {
        File tmpFile1 = this.tmpFolder.newFile("result-000-of-002");
        File tmpFile2 = this.tmpFolder.newFile("result-001-of-002");
        File tmpFile3 = this.tmpFolder.newFile("tmp");
        Files.write("To be or not to be, ", tmpFile1, StandardCharsets.UTF_8);
        Files.write("it is not a question.", tmpFile2, StandardCharsets.UTF_8);
        Files.write("tmp", tmpFile3, StandardCharsets.UTF_8);
        FileChecksumMatcher matcher = new FileChecksumMatcher("90552392c28396935fe4f123bd0b5c2d0f6260c8", this.tmpFolder.getRoot().toPath().resolve("result-*").toString());
        MatcherAssert.assertThat((Object)this.pResult, (Matcher)matcher);
    }

    @Test
    public void testMatcherThatVerifiesFileWithEmptyContent() throws IOException {
        File emptyFile = this.tmpFolder.newFile("result-000-of-001");
        Files.write("", emptyFile, StandardCharsets.UTF_8);
        FileChecksumMatcher matcher = new FileChecksumMatcher("da39a3ee5e6b4b0d3255bfef95601890afd80709", this.tmpFolder.getRoot().toPath().resolve("*").toString());
        MatcherAssert.assertThat((Object)this.pResult, (Matcher)matcher);
    }

    @Test
    public void testMatcherThatUsesCustomizedTemplate() throws Exception {
        File tmpFile1 = this.tmpFolder.newFile("result0-total2");
        File tmpFile2 = this.tmpFolder.newFile("result1-total2");
        Files.write("To be or not to be, ", tmpFile1, StandardCharsets.UTF_8);
        Files.write("it is not a question.", tmpFile2, StandardCharsets.UTF_8);
        Pattern customizedTemplate = Pattern.compile("(?x) result (?<shardnum>\\d+) - total (?<numshards>\\d+)");
        FileChecksumMatcher matcher = new FileChecksumMatcher("90552392c28396935fe4f123bd0b5c2d0f6260c8", this.tmpFolder.getRoot().toPath().resolve("*").toString(), customizedTemplate);
        MatcherAssert.assertThat((Object)this.pResult, (Matcher)matcher);
    }
}

