/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.SystemNanoTimeSleeper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class ExpectedLogsTest {
    private static final Logger LOG = LoggerFactory.getLogger(ExpectedLogsTest.class);
    private Random random = new Random();
    @Rule
    public ExpectedLogs expectedLogs = ExpectedLogs.none(ExpectedLogsTest.class);

    @Test
    public void testWhenNoExpectations() throws Throwable {
        LOG.error(this.generateRandomString());
    }

    @Test
    public void testVerifyWhenMatchedFully() throws Throwable {
        String expected = this.generateRandomString();
        LOG.error(expected);
        this.expectedLogs.verifyError(expected);
    }

    @Test
    public void testVerifyWhenMatchedPartially() throws Throwable {
        String expected = this.generateRandomString();
        LOG.error("Extra stuff around expected " + expected + " blah");
        this.expectedLogs.verifyError(expected);
    }

    @Test
    public void testVerifyWhenMatchedWithExceptionBeingLogged() throws Throwable {
        String expected = this.generateRandomString();
        LOG.error(expected, (Throwable)new IOException("Fake Exception"));
        this.expectedLogs.verifyError(expected);
    }

    @Test(expected=AssertionError.class)
    public void testVerifyWhenNotMatched() throws Throwable {
        String expected = this.generateRandomString();
        this.expectedLogs.verifyError(expected);
    }

    @Test(expected=AssertionError.class)
    public void testVerifyNotLoggedWhenMatchedFully() throws Throwable {
        String expected = this.generateRandomString();
        LOG.error(expected);
        this.expectedLogs.verifyNotLogged(expected);
    }

    @Test(expected=AssertionError.class)
    public void testVerifyNotLoggedWhenMatchedPartially() throws Throwable {
        String expected = this.generateRandomString();
        LOG.error("Extra stuff around expected " + expected + " blah");
        this.expectedLogs.verifyNotLogged(expected);
    }

    @Test(expected=AssertionError.class)
    public void testVerifyNotLoggedWhenMatchedWithException() throws Throwable {
        String expected = this.generateRandomString();
        LOG.error(expected, (Throwable)new IOException("Fake Exception"));
        this.expectedLogs.verifyNotLogged(expected);
    }

    @Test
    public void testVerifyNotLoggedWhenNotMatched() throws Throwable {
        String expected = this.generateRandomString();
        this.expectedLogs.verifyNotLogged(expected);
    }

    @Test
    public void testLogCaptureOccursAtLowestLogLevel() throws Throwable {
        String expected = this.generateRandomString();
        LOG.trace(expected);
        this.expectedLogs.verifyTrace(expected);
    }

    @Test
    public void testThreadSafetyOfLogSaver() throws Throwable {
        int i;
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(Executors.newCachedThreadPool());
        long scheduledLogTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS) + 500L;
        ArrayList<String> expectedStrings = new ArrayList<String>();
        for (i = 0; i < 100; ++i) {
            String expected = this.generateRandomString();
            expectedStrings.add(expected);
            completionService.submit(() -> {
                SystemNanoTimeSleeper.sleepMillis(Math.max(1L, scheduledLogTime - TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS)));
                LOG.trace(expected);
                return null;
            });
        }
        for (i = 0; i < 100; ++i) {
            completionService.take().get();
        }
        for (String expected : expectedStrings) {
            this.expectedLogs.verifyTrace(expected);
        }
    }

    @Test
    public void testLogsCleared() throws Throwable {
        String messageUnexpected = "Message prior to ExpectedLogs.";
        String messageExpected = "Message expected.";
        LOG.info("Message prior to ExpectedLogs.");
        this.expectedLogs = ExpectedLogs.none(ExpectedLogsTest.class);
        final boolean[] evaluateRan = new boolean[1];
        this.expectedLogs.apply(new Statement(){

            public void evaluate() throws Throwable {
                evaluateRan[0] = true;
                ExpectedLogsTest.this.expectedLogs.verifyNotLogged("Message prior to ExpectedLogs.");
                LOG.info("Message expected.");
                ExpectedLogsTest.this.expectedLogs.verifyInfo("Message expected.");
            }
        }, Description.EMPTY).evaluate();
        Assert.assertTrue((boolean)evaluateRan[0]);
        this.expectedLogs.verifyNotLogged("Message expected.");
        this.expectedLogs.verifyNotLogged("Message prior to ExpectedLogs.");
    }

    private String generateRandomString() {
        return "Fake error message: " + this.random.nextInt();
    }
}

