/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.annotation.concurrent.ThreadSafe;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public class ExpectedLogs
extends ExternalResource {
    private final Logger log;
    private final LogSaver logSaver;
    private final Formatter logFormatter = new SimpleFormatter();
    private Level previousLevel;

    public static ExpectedLogs none(String name) {
        return new ExpectedLogs(name);
    }

    public static ExpectedLogs none(Class<?> klass) {
        return ExpectedLogs.none(klass.getName());
    }

    public void verifyTrace(String substring) {
        this.verify(Level.FINEST, substring);
    }

    public void verifyTrace(String substring, Throwable t) {
        this.verify(Level.FINEST, substring, t);
    }

    public void verifyDebug(String substring) {
        this.verify(Level.FINE, substring);
    }

    public void verifyDebug(String message, Throwable t) {
        this.verify(Level.FINE, message, t);
    }

    public void verifyInfo(String substring) {
        this.verify(Level.INFO, substring);
    }

    public void verifyInfo(String message, Throwable t) {
        this.verify(Level.INFO, message, t);
    }

    public void verifyWarn(String substring) {
        this.verify(Level.WARNING, substring);
    }

    public void verifyWarn(String substring, Throwable t) {
        this.verify(Level.WARNING, substring, t);
    }

    public void verifyError(String substring) {
        this.verify(Level.SEVERE, substring);
    }

    public void verifyError(String substring, Throwable t) {
        this.verify(Level.SEVERE, substring, t);
    }

    public void verifyNotLogged(String substring) {
        this.verifyNotLogged((Matcher<LogRecord>)this.matcher(substring));
    }

    public void verifyNoError(String substring, Throwable t) {
        this.verifyNo(Level.SEVERE, substring, t);
    }

    private void verify(Level level, String substring) {
        this.verifyLogged((Matcher<LogRecord>)this.matcher(level, substring));
    }

    private TypeSafeMatcher<LogRecord> matcher(final String substring) {
        return new TypeSafeMatcher<LogRecord>(){

            public void describeTo(Description description) {
                description.appendText(String.format("log message containing message [%s]", substring));
            }

            protected boolean matchesSafely(LogRecord item) {
                return item.getMessage().contains(substring);
            }
        };
    }

    private TypeSafeMatcher<LogRecord> matcher(final Level level, final String substring) {
        return new TypeSafeMatcher<LogRecord>(){

            public void describeTo(Description description) {
                description.appendText(String.format("log message of level [%s] containing message [%s]", level, substring));
            }

            protected boolean matchesSafely(LogRecord item) {
                return level.equals(item.getLevel()) && item.getMessage().contains(substring);
            }
        };
    }

    private void verify(Level level, String substring, Throwable throwable) {
        this.verifyLogged((Matcher<LogRecord>)this.matcher(level, substring, throwable));
    }

    private void verifyNo(Level level, String substring, Throwable throwable) {
        this.verifyNotLogged((Matcher<LogRecord>)this.matcher(level, substring, throwable));
    }

    private TypeSafeMatcher<LogRecord> matcher(final Level level, final String substring, final Throwable throwable) {
        return new TypeSafeMatcher<LogRecord>(){

            public void describeTo(Description description) {
                description.appendText(String.format("log message of level [%s] containg message [%s] with exception [%s] containing message [%s]", level, substring, throwable.getClass(), throwable.getMessage()));
            }

            protected boolean matchesSafely(LogRecord item) {
                return level.equals(item.getLevel()) && item.getMessage().contains(substring) && item.getThrown().getClass().equals(throwable.getClass()) && item.getThrown().getMessage().contains(throwable.getMessage());
            }
        };
    }

    private void verifyLogged(Matcher<LogRecord> matcher) {
        for (LogRecord record : this.logSaver.getLogs()) {
            if (!matcher.matches((Object)record)) continue;
            return;
        }
        Assert.fail((String)String.format("Missing match for [%s]", matcher));
    }

    private void verifyNotLogged(Matcher<LogRecord> matcher) {
        for (LogRecord record : this.logSaver.getLogs()) {
            if (!matcher.matches((Object)record)) continue;
            Assert.fail((String)String.format("Unexpected match of [%s]: [%s]", matcher, this.logFormatter.format(record)));
        }
    }

    protected void before() throws Throwable {
        this.previousLevel = this.log.getLevel();
        this.log.setLevel(Level.ALL);
        this.log.addHandler(this.logSaver);
    }

    protected void after() {
        this.log.removeHandler(this.logSaver);
        this.log.setLevel(this.previousLevel);
        this.logSaver.reset();
    }

    private ExpectedLogs(String name) {
        this.log = Logger.getLogger(name);
        this.logSaver = new LogSaver();
    }

    @ThreadSafe
    private static class LogSaver
    extends Handler {
        private final Collection<LogRecord> logRecords = new ConcurrentLinkedDeque<LogRecord>();

        private LogSaver() {
        }

        @Override
        public void publish(LogRecord record) {
            this.logRecords.add(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }

        private Collection<LogRecord> getLogs() {
            return this.logRecords;
        }

        private void reset() {
            this.logRecords.clear();
        }
    }
}

