/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.CrashingRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CrashingRunnerTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void fromOptionsCreatesInstance() {
        PipelineOptions opts = PipelineOptionsFactory.create();
        opts.setRunner(CrashingRunner.class);
        PipelineRunner runner = PipelineRunner.fromOptions((PipelineOptions)opts);
        Assert.assertTrue((String)"Should have created a CrashingRunner", (boolean)(runner instanceof CrashingRunner));
    }

    @Test
    public void applySucceeds() {
        PipelineOptions opts = PipelineOptionsFactory.create();
        opts.setRunner(CrashingRunner.class);
        Pipeline p = Pipeline.create((PipelineOptions)opts);
        p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
    }

    @Test
    public void runThrows() {
        PipelineOptions opts = PipelineOptionsFactory.create();
        opts.setRunner(CrashingRunner.class);
        Pipeline p = Pipeline.create((PipelineOptions)opts);
        p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Cannot call #run");
        this.thrown.expectMessage("beamTestPipelineOptions");
        p.run();
    }
}

