/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.sdk.testing.CombineFnTester;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.KV;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CombineFnTesterTest {
    @Test
    public void checksMergeWithEmptyAccumulators() {
        final AtomicBoolean sawEmpty = new AtomicBoolean(false);
        Combine.CombineFn<Integer, Integer, Integer> combineFn = new Combine.CombineFn<Integer, Integer, Integer>(){

            public Integer createAccumulator() {
                return 0;
            }

            public Integer addInput(Integer accumulator, Integer input) {
                return accumulator + input;
            }

            public Integer mergeAccumulators(Iterable<Integer> accumulators) {
                int result = 0;
                for (int accum : accumulators) {
                    if (accum == 0) {
                        sawEmpty.set(true);
                    }
                    result += accum;
                }
                return result;
            }

            public Integer extractOutput(Integer accumulator) {
                return accumulator;
            }
        };
        CombineFnTester.testCombineFn((Combine.CombineFn)combineFn, Arrays.asList(1, 2, 3, 4, 5), (Object)15);
        Assert.assertThat((Object)sawEmpty.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void checksWithSingleShard() {
        final AtomicBoolean sawSingleShard = new AtomicBoolean();
        Combine.CombineFn<Integer, Integer, Integer> combineFn = new Combine.CombineFn<Integer, Integer, Integer>(){
            int accumCount = 0;

            public Integer createAccumulator() {
                ++this.accumCount;
                return 0;
            }

            public Integer addInput(Integer accumulator, Integer input) {
                return accumulator + input;
            }

            public Integer mergeAccumulators(Iterable<Integer> accumulators) {
                int result = 0;
                for (int accum : accumulators) {
                    result += accum;
                }
                return result;
            }

            public Integer extractOutput(Integer accumulator) {
                if (this.accumCount == 1) {
                    sawSingleShard.set(true);
                }
                this.accumCount = 0;
                return accumulator;
            }
        };
        CombineFnTester.testCombineFn((Combine.CombineFn)combineFn, Arrays.asList(1, 2, 3, 4, 5), (Object)15);
        Assert.assertThat((Object)sawSingleShard.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void checksWithShards() {
        final AtomicBoolean sawManyShards = new AtomicBoolean();
        Combine.CombineFn<Integer, Integer, Integer> combineFn = new Combine.CombineFn<Integer, Integer, Integer>(){

            public Integer createAccumulator() {
                return 0;
            }

            public Integer addInput(Integer accumulator, Integer input) {
                return accumulator + input;
            }

            public Integer mergeAccumulators(Iterable<Integer> accumulators) {
                if (Iterables.size(accumulators) > 2) {
                    sawManyShards.set(true);
                }
                int result = 0;
                for (int accum : accumulators) {
                    result += accum;
                }
                return result;
            }

            public Integer extractOutput(Integer accumulator) {
                return accumulator;
            }
        };
        CombineFnTester.testCombineFn((Combine.CombineFn)combineFn, Arrays.asList(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3), (Object)30);
        Assert.assertThat((Object)sawManyShards.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void checksWithMultipleMerges() {
        final AtomicBoolean sawMultipleMerges = new AtomicBoolean();
        Combine.CombineFn<Integer, KV<Integer, Integer>, Integer> combineFn = new Combine.CombineFn<Integer, KV<Integer, Integer>, Integer>(){

            public KV<Integer, Integer> createAccumulator() {
                return KV.of((Object)0, (Object)0);
            }

            public KV<Integer, Integer> addInput(KV<Integer, Integer> accumulator, Integer input) {
                return KV.of((Object)((Integer)accumulator.getKey() + input), (Object)((Integer)accumulator.getValue()));
            }

            public KV<Integer, Integer> mergeAccumulators(Iterable<KV<Integer, Integer>> accumulators) {
                int result = 0;
                int numMerges = 0;
                for (KV<Integer, Integer> accum : accumulators) {
                    result += ((Integer)accum.getKey()).intValue();
                    numMerges += ((Integer)accum.getValue()).intValue();
                }
                return KV.of((Object)result, (Object)(numMerges + 1));
            }

            public Integer extractOutput(KV<Integer, Integer> accumulator) {
                if ((Integer)accumulator.getValue() > 1) {
                    sawMultipleMerges.set(true);
                }
                return (Integer)accumulator.getKey();
            }
        };
        CombineFnTester.testCombineFn((Combine.CombineFn)combineFn, Arrays.asList(1, 1, 2, 2, 3, 3, 4, 4, 5, 5), (Object)30);
        Assert.assertThat((Object)sawMultipleMerges.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void checksAlternateOrder() {
        final AtomicBoolean sawOutOfOrder = new AtomicBoolean();
        Combine.CombineFn<Integer, List<Integer>, Integer> combineFn = new Combine.CombineFn<Integer, List<Integer>, Integer>(){

            public List<Integer> createAccumulator() {
                return new ArrayList<Integer>();
            }

            public List<Integer> addInput(List<Integer> accumulator, Integer input) {
                if (!accumulator.isEmpty() && accumulator.get(accumulator.size() - 1) > input) {
                    sawOutOfOrder.set(true);
                }
                accumulator.add(input);
                return accumulator;
            }

            public List<Integer> mergeAccumulators(Iterable<List<Integer>> accumulators) {
                ArrayList<Integer> result = new ArrayList<Integer>();
                for (List<Integer> accum : accumulators) {
                    result.addAll(accum);
                }
                return result;
            }

            public Integer extractOutput(List<Integer> accumulator) {
                int value = 0;
                for (int i : accumulator) {
                    value += i;
                }
                return value;
            }
        };
        CombineFnTester.testCombineFn((Combine.CombineFn)combineFn, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14), (Object)105);
        Assert.assertThat((Object)sawOutOfOrder.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void usesMatcher() {
        final AtomicBoolean matcherUsed = new AtomicBoolean();
        TypeSafeMatcher<Integer> matcher = new TypeSafeMatcher<Integer>(){

            public void describeTo(Description description) {
            }

            protected boolean matchesSafely(Integer item) {
                matcherUsed.set(true);
                return item == 30;
            }
        };
        CombineFnTester.testCombineFn((Combine.CombineFn)Sum.ofIntegers(), Arrays.asList(1, 1, 2, 2, 3, 3, 4, 4, 5, 5), (Matcher)matcher);
        Assert.assertThat((Object)matcherUsed.get(), (Matcher)Matchers.is((Object)true));
        try {
            CombineFnTester.testCombineFn((Combine.CombineFn)Sum.ofIntegers(), Arrays.asList(1, 2, 3, 4, 5), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)15)));
        }
        catch (AssertionError ignored) {
            return;
        }
        Assert.fail((String)"The matcher should have failed, throwing an error");
    }
}

