/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Strings;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CoderPropertiesTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testGoodCoderIsDeterministic() throws Exception {
        CoderProperties.coderDeterministic((Coder)StringUtf8Coder.of(), (Object)"TestData", (Object)"TestData");
    }

    @Test
    public void testNonDeterministicCoder() throws Exception {
        try {
            CoderProperties.coderDeterministic((Coder)new NonDeterministicCoder(), (Object)"TestData", (Object)"TestData");
        }
        catch (AssertionError error) {
            Assert.assertThat((Object)((Throwable)((Object)error)).getMessage(), (Matcher)CoreMatchers.containsString((String)"Expected that the coder is deterministic"));
            return;
        }
        Assert.fail((String)"Expected AssertionError");
    }

    @Test
    public void testPassingInNonEqualValuesWithDeterministicCoder() throws Exception {
        AssertionError error = null;
        try {
            CoderProperties.coderDeterministic((Coder)StringUtf8Coder.of(), (Object)"AAA", (Object)"BBB");
        }
        catch (AssertionError e) {
            error = e;
        }
        Assert.assertNotNull((String)"Expected AssertionError", (Object)error);
        Assert.assertThat((Object)((Throwable)((Object)error)).getMessage(), (Matcher)CoreMatchers.containsString((String)"Expected that the passed in values"));
    }

    @Test
    public void testBadCoderIsNotDeterministic() throws Exception {
        AssertionError error = null;
        try {
            CoderProperties.coderDeterministic((Coder)new BadDeterminsticCoder(), (Object)"TestData", (Object)"TestData");
        }
        catch (AssertionError e) {
            error = e;
        }
        Assert.assertNotNull((String)"Expected AssertionError", (Object)error);
        Assert.assertThat((Object)((Throwable)((Object)error)).getMessage(), (Matcher)CoreMatchers.containsString((String)"<84>, <101>, <115>, <116>, <68>"));
    }

    @Test
    public void testGoodCoderEncodesEqualValues() throws Exception {
        CoderProperties.coderDecodeEncodeEqual((Coder)StringUtf8Coder.of(), (Object)"TestData");
    }

    @Test
    public void testBadCoderThatDependsOnChangingState() throws Exception {
        AssertionError error = null;
        try {
            CoderProperties.coderDecodeEncodeEqual((Coder)new StateChangingSerializingCoder(), (Object)"TestData");
        }
        catch (AssertionError e) {
            error = e;
        }
        Assert.assertNotNull((String)"Expected AssertionError", (Object)error);
        Assert.assertThat((Object)((Throwable)((Object)error)).getMessage(), (Matcher)CoreMatchers.containsString((String)"TestData"));
    }

    @Test
    public void testBadCoderThatDependsOnStateThatIsLost() throws Exception {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("I forgot something...");
        CoderProperties.coderDecodeEncodeEqual((Coder)new ForgetfulSerializingCoder(1), (Object)"TestData");
    }

    @Test
    public void testClosingCoderFailsWhenDecoding() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Caller does not own the underlying");
        CoderProperties.decode((Coder)new ClosingCoder(), (Coder.Context)Coder.Context.NESTED, (byte[])new byte[0]);
    }

    @Test
    public void testClosingCoderFailsWhenEncoding() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Caller does not own the underlying");
        CoderProperties.encode((Coder)new ClosingCoder(), (Coder.Context)Coder.Context.NESTED, (Object)"test-value");
    }

    @Test
    public void testCoderWhichConsumesMoreBytesThanItProducesFail() throws IOException {
        AssertionError error = null;
        try {
            BadCoderThatConsumesMoreBytes coder = new BadCoderThatConsumesMoreBytes();
            byte[] bytes = CoderProperties.encode((Coder)coder, (Coder.Context)Coder.Context.NESTED, (Object)"TestData");
            CoderProperties.decode((Coder)coder, (Coder.Context)Coder.Context.NESTED, (byte[])bytes);
        }
        catch (AssertionError e) {
            error = e;
        }
        Assert.assertNotNull((String)"Expected Assertion Error", (Object)error);
        Assert.assertThat((Object)((Throwable)((Object)error)).getMessage(), (Matcher)CoreMatchers.containsString((String)"consumed bytes equal to encoded bytes"));
    }

    public static class BadCoderThatConsumesMoreBytes
    extends NonDeterministicCoder {
        public String decode(InputStream inStream, Coder.Context context) throws IOException {
            String value = (String)super.decode(inStream, context);
            inStream.read();
            return value;
        }
    }

    public static class ClosingCoder
    extends AtomicCoder<String> {
        public void encode(String value, OutputStream outStream) throws IOException {
            outStream.close();
        }

        public String decode(InputStream inStream) throws IOException {
            inStream.close();
            return null;
        }
    }

    private static class ForgetfulSerializingCoder
    extends CustomCoder<String> {
        private transient int lostState;

        public ForgetfulSerializingCoder(int lostState) {
            this.lostState = lostState;
        }

        public void encode(String value, OutputStream outStream) throws CoderException, IOException {
            if (this.lostState == 0) {
                throw new RuntimeException("I forgot something...");
            }
            StringUtf8Coder.of().encode(value, outStream);
        }

        public String decode(InputStream inStream) throws CoderException, IOException {
            return StringUtf8Coder.of().decode(inStream);
        }

        public boolean equals(Object other) {
            return other instanceof ForgetfulSerializingCoder && ((ForgetfulSerializingCoder)((Object)other)).lostState == this.lostState;
        }

        public int hashCode() {
            return this.lostState;
        }
    }

    private static class StateChangingSerializingCoder
    extends CustomCoder<String> {
        private int changedState = 10;

        public void encode(String value, OutputStream outStream) throws CoderException, IOException {
            ++this.changedState;
            StringUtf8Coder.of().encode(value + Strings.repeat("A", this.changedState), outStream);
        }

        public String decode(InputStream inStream) throws CoderException, IOException {
            String decodedValue = StringUtf8Coder.of().decode(inStream);
            return decodedValue.substring(0, decodedValue.length() - this.changedState);
        }

        public boolean equals(Object other) {
            return other instanceof StateChangingSerializingCoder && ((StateChangingSerializingCoder)((Object)other)).changedState == this.changedState;
        }

        public int hashCode() {
            return this.changedState;
        }
    }

    private static class BadDeterminsticCoder
    extends AtomicCoder<String> {
        public void encode(String value, OutputStream outStream) throws IOException, CoderException {
            StringUtf8Coder.of().encode(value + System.nanoTime(), outStream);
        }

        public String decode(InputStream inStream) throws CoderException, IOException {
            return StringUtf8Coder.of().decode(inStream);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }
    }

    public static class NonDeterministicCoder
    extends AtomicCoder<String> {
        public void encode(String value, OutputStream outStream) throws CoderException, IOException {
            StringUtf8Coder.of().encode(value, outStream);
        }

        public String decode(InputStream inStream) throws CoderException, IOException {
            return StringUtf8Coder.of().decode(inStream);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            throw new Coder.NonDeterministicException((Coder)this, "Not Deterministic");
        }
    }
}

