/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.DefaultSchema;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.joda.time.DateTime;
import org.joda.time.Instant;

public class TestPOJOs {
    public static final Schema NULLABLES_SCHEMA = Schema.builder().addNullableField("str", Schema.FieldType.STRING).addInt32Field("anInt").build();
    public static final Schema NESTED_NULLABLE_SCHEMA = Schema.builder().addNullableField("nested", Schema.FieldType.row((Schema)NULLABLES_SCHEMA)).build();
    public static final Schema SIMPLE_POJO_SCHEMA = Schema.builder().addStringField("str").addByteField("aByte").addInt16Field("aShort").addInt32Field("anInt").addInt64Field("aLong").addBooleanField("aBoolean").addDateTimeField("dateTime").addDateTimeField("instant").addByteArrayField("bytes").addByteArrayField("byteBuffer").addDecimalField("bigDecimal").addStringField("stringBuilder").build();
    public static final Schema NESTED_POJO_SCHEMA = Schema.builder().addRowField("nested", SIMPLE_POJO_SCHEMA).build();
    public static final Schema PRIMITIVE_ARRAY_POJO_SCHEMA = Schema.builder().addArrayField("strings", Schema.FieldType.STRING).addArrayField("integers", Schema.FieldType.INT32).addArrayField("longs", Schema.FieldType.INT64).build();
    public static final Schema NESTED_ARRAY_POJO_SCHEMA = Schema.builder().addArrayField("pojos", Schema.FieldType.row((Schema)SIMPLE_POJO_SCHEMA)).build();
    public static final Schema NESTED_ARRAYS_POJO_SCHEMA = Schema.builder().addArrayField("lists", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).build();
    public static final Schema NESTED_COLLECTION_POJO_SCHEMA = Schema.builder().addArrayField("simples", Schema.FieldType.row((Schema)SIMPLE_POJO_SCHEMA)).build();
    public static final Schema PRIMITIVE_MAP_POJO_SCHEMA = Schema.builder().addMapField("map", Schema.FieldType.STRING, Schema.FieldType.INT32).build();
    public static final Schema NESTED_MAP_POJO_SCHEMA = Schema.builder().addMapField("map", Schema.FieldType.STRING, Schema.FieldType.row((Schema)SIMPLE_POJO_SCHEMA)).build();
    public static final Schema POJO_WITH_BOXED_FIELDS_SCHEMA = Schema.builder().addByteField("aByte").addInt16Field("aShort").addInt32Field("anInt").addInt64Field("aLong").addBooleanField("aBoolean").build();
    public static final Schema POJO_WITH_BYTE_ARRAY_SCHEMA = Schema.builder().addByteArrayField("bytes1").addByteArrayField("bytes2").build();

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class POJOWithByteArray {
        public byte[] bytes1;
        public ByteBuffer bytes2;

        public POJOWithByteArray(byte[] bytes1, ByteBuffer bytes2) {
            this.bytes1 = bytes1;
            this.bytes2 = bytes2;
        }

        public POJOWithByteArray() {
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class POJOWithBoxedFields {
        public Byte aByte;
        public Short aShort;
        public Integer anInt;
        public Long aLong;
        public Boolean aBoolean;

        public POJOWithBoxedFields(Byte aByte, Short aShort, Integer anInt, Long aLong, Boolean aBoolean) {
            this.aByte = aByte;
            this.aShort = aShort;
            this.anInt = anInt;
            this.aLong = aLong;
            this.aBoolean = aBoolean;
        }

        public POJOWithBoxedFields() {
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class NestedMapPOJO {
        public Map<String, SimplePOJO> map;

        public NestedMapPOJO(Map<String, SimplePOJO> map) {
            this.map = map;
        }

        public NestedMapPOJO() {
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class PrimitiveMapPOJO {
        public Map<String, Integer> map;

        public PrimitiveMapPOJO(Map<String, Integer> map) {
            this.map = map;
        }

        public PrimitiveMapPOJO() {
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class NestedCollectionPOJO {
        public List<SimplePOJO> simples;

        public NestedCollectionPOJO(List<SimplePOJO> simples) {
            this.simples = simples;
        }

        public NestedCollectionPOJO() {
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class NestedArraysPOJO {
        public List<List<String>> lists;

        public NestedArraysPOJO(List<List<String>> lists) {
            this.lists = lists;
        }

        public NestedArraysPOJO() {
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class NestedArrayPOJO {
        public SimplePOJO[] pojos;

        public NestedArrayPOJO(SimplePOJO ... pojos) {
            this.pojos = pojos;
        }

        public NestedArrayPOJO() {
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class PrimitiveArrayPOJO {
        public List<String> strings;
        public int[] integers;
        public Long[] longs;

        public PrimitiveArrayPOJO() {
        }

        public PrimitiveArrayPOJO(List<String> strings, int[] integers, Long[] longs) {
            this.strings = strings;
            this.integers = integers;
            this.longs = longs;
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class NestedPOJO {
        public SimplePOJO nested;

        public NestedPOJO(SimplePOJO nested) {
            this.nested = nested;
        }

        public NestedPOJO() {
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class SimplePOJO {
        public String str;
        public byte aByte;
        public short aShort;
        public int anInt;
        public long aLong;
        public boolean aBoolean;
        public DateTime dateTime;
        public Instant instant;
        public byte[] bytes;
        public ByteBuffer byteBuffer;
        public BigDecimal bigDecimal;
        public StringBuilder stringBuilder;

        public SimplePOJO() {
        }

        public SimplePOJO(String str, byte aByte, short aShort, int anInt, long aLong, boolean aBoolean, DateTime dateTime, Instant instant, byte[] bytes, ByteBuffer byteBuffer, BigDecimal bigDecimal, StringBuilder stringBuilder) {
            this.str = str;
            this.aByte = aByte;
            this.aShort = aShort;
            this.anInt = anInt;
            this.aLong = aLong;
            this.aBoolean = aBoolean;
            this.dateTime = dateTime;
            this.instant = instant;
            this.bytes = bytes;
            this.byteBuffer = byteBuffer;
            this.bigDecimal = bigDecimal;
            this.stringBuilder = stringBuilder;
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class POJOWithNestedNullable {
        @Nullable
        public POJOWithNullables nested;

        public POJOWithNestedNullable(@Nullable POJOWithNullables nested) {
            this.nested = nested;
        }

        public POJOWithNestedNullable() {
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class POJOWithNullables {
        @Nullable
        public String str;
        public int anInt;

        public POJOWithNullables(@Nullable String str, int anInt) {
            this.str = str;
            this.anInt = anInt;
        }

        public POJOWithNullables() {
        }
    }
}

