/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.DefaultSchema;
import org.apache.beam.sdk.schemas.JavaBeanSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.joda.time.DateTime;
import org.joda.time.Instant;

public class TestJavaBeans {
    public static final Schema SIMPLE_BEAN_SCHEMA = Schema.builder().addStringField("str").addByteField("aByte").addInt16Field("aShort").addInt32Field("anInt").addInt64Field("aLong").addBooleanField("aBoolean").addDateTimeField("dateTime").addDateTimeField("instant").addByteArrayField("bytes").addByteArrayField("byteBuffer").addDecimalField("bigDecimal").addStringField("stringBuilder").build();
    public static final Schema NESTED_BEAN_SCHEMA = Schema.builder().addRowField("nested", SIMPLE_BEAN_SCHEMA).build();
    public static final Schema PRIMITIVE_ARRAY_BEAN_SCHEMA = Schema.builder().addArrayField("strings", Schema.FieldType.STRING).addArrayField("integers", Schema.FieldType.INT32).addArrayField("longs", Schema.FieldType.INT64).build();
    public static final Schema NESTED_ARRAY_BEAN_SCHEMA = Schema.builder().addArrayField("beans", Schema.FieldType.row((Schema)SIMPLE_BEAN_SCHEMA)).build();
    public static final Schema NESTED_ARRAYS_BEAM_SCHEMA = Schema.builder().addArrayField("lists", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).build();
    public static final Schema NESTED_COLLECTION_BEAN_SCHEMA = Schema.builder().addArrayField("simples", Schema.FieldType.row((Schema)SIMPLE_BEAN_SCHEMA)).build();
    public static final Schema PRIMITIVE_MAP_BEAN_SCHEMA = Schema.builder().addMapField("map", Schema.FieldType.STRING, Schema.FieldType.INT32).build();
    public static final Schema NESTED_MAP_BEAN_SCHEMA = Schema.builder().addMapField("map", Schema.FieldType.STRING, Schema.FieldType.row((Schema)SIMPLE_BEAN_SCHEMA)).build();
    public static final Schema BEAN_WITH_BOXED_FIELDS_SCHEMA = Schema.builder().addByteField("aByte").addInt16Field("aShort").addInt32Field("anInt").addInt64Field("aLong").addBooleanField("aBoolean").build();
    public static final Schema BEAN_WITH_BYTE_ARRAY_SCHEMA = Schema.builder().addByteArrayField("bytes1").addByteArrayField("bytes2").build();

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class BeanWithByteArray {
        private byte[] bytes1;
        private ByteBuffer bytes2;

        public BeanWithByteArray(byte[] bytes1, ByteBuffer bytes2) {
            this.bytes1 = bytes1;
            this.bytes2 = bytes2;
        }

        public BeanWithByteArray() {
        }

        public byte[] getBytes1() {
            return this.bytes1;
        }

        public void setBytes1(byte[] bytes1) {
            this.bytes1 = bytes1;
        }

        public ByteBuffer getBytes2() {
            return this.bytes2;
        }

        public void setBytes2(ByteBuffer bytes2) {
            this.bytes2 = bytes2;
        }
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class BeanWithBoxedFields {
        private Byte aByte;
        private Short aShort;
        private Integer anInt;
        private Long aLong;
        private Boolean aBoolean;

        public BeanWithBoxedFields(Byte aByte, Short aShort, Integer anInt, Long aLong, Boolean aBoolean) {
            this.aByte = aByte;
            this.aShort = aShort;
            this.anInt = anInt;
            this.aLong = aLong;
            this.aBoolean = aBoolean;
        }

        public BeanWithBoxedFields() {
        }

        public Byte getaByte() {
            return this.aByte;
        }

        public void setaByte(Byte aByte) {
            this.aByte = aByte;
        }

        public Short getaShort() {
            return this.aShort;
        }

        public void setaShort(Short aShort) {
            this.aShort = aShort;
        }

        public Integer getAnInt() {
            return this.anInt;
        }

        public void setAnInt(Integer anInt) {
            this.anInt = anInt;
        }

        public Long getaLong() {
            return this.aLong;
        }

        public void setaLong(Long aLong) {
            this.aLong = aLong;
        }

        public Boolean getaBoolean() {
            return this.aBoolean;
        }

        public void setaBoolean(Boolean aBoolean) {
            this.aBoolean = aBoolean;
        }
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class NestedMapBean {
        private Map<String, SimpleBean> map;

        public NestedMapBean(Map<String, SimpleBean> map) {
            this.map = map;
        }

        public NestedMapBean() {
        }

        public Map<String, SimpleBean> getMap() {
            return this.map;
        }

        public void setMap(Map<String, SimpleBean> map) {
            this.map = map;
        }
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class PrimitiveMapBean {
        private Map<String, Integer> map;

        public PrimitiveMapBean(Map<String, Integer> map) {
            this.map = map;
        }

        public PrimitiveMapBean() {
        }

        public Map<String, Integer> getMap() {
            return this.map;
        }

        public void setMap(Map<String, Integer> map) {
            this.map = map;
        }
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class NestedCollectionBean {
        private List<SimpleBean> simples;

        public NestedCollectionBean(List<SimpleBean> simples) {
            this.simples = simples;
        }

        public NestedCollectionBean() {
        }

        public List<SimpleBean> getSimples() {
            return this.simples;
        }

        public void setSimples(List<SimpleBean> simples) {
            this.simples = simples;
        }
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class NestedArraysBean {
        private List<List<String>> lists;

        public NestedArraysBean(List<List<String>> lists) {
            this.lists = lists;
        }

        public NestedArraysBean() {
        }

        public List<List<String>> getLists() {
            return this.lists;
        }

        public void setLists(List<List<String>> lists) {
            this.lists = lists;
        }
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class NestedArrayBean {
        private SimpleBean[] beans;

        public NestedArrayBean(SimpleBean ... beans) {
            this.beans = beans;
        }

        public NestedArrayBean() {
        }

        public SimpleBean[] getBeans() {
            return this.beans;
        }

        public void setBeans(SimpleBean[] beans) {
            this.beans = beans;
        }
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class PrimitiveArrayBean {
        private List<String> strings;
        private int[] integers;
        private Long[] longs;

        public PrimitiveArrayBean() {
        }

        public PrimitiveArrayBean(List<String> strings, int[] integers, Long[] longs) {
            this.strings = strings;
            this.integers = integers;
            this.longs = longs;
        }

        public List<String> getStrings() {
            return this.strings;
        }

        public void setStrings(List<String> strings) {
            this.strings = strings;
        }

        public int[] getIntegers() {
            return this.integers;
        }

        public void setIntegers(int[] integers) {
            this.integers = integers;
        }

        public Long[] getLongs() {
            return this.longs;
        }

        public void setLongs(Long[] longs) {
            this.longs = longs;
        }
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class NestedBean {
        private SimpleBean nested;

        public NestedBean(SimpleBean nested) {
            this.nested = nested;
        }

        public NestedBean() {
        }

        public SimpleBean getNested() {
            return this.nested;
        }

        public void setNested(SimpleBean nested) {
            this.nested = nested;
        }
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class SimpleBean {
        private String str;
        private byte aByte;
        private short aShort;
        private int anInt;
        private long aLong;
        private boolean aBoolean;
        private DateTime dateTime;
        private Instant instant;
        private byte[] bytes;
        private ByteBuffer byteBuffer;
        private BigDecimal bigDecimal;
        private StringBuilder stringBuilder;

        public SimpleBean() {
        }

        public SimpleBean(String str, byte aByte, short aShort, int anInt, long aLong, boolean aBoolean, DateTime dateTime, Instant instant, byte[] bytes, BigDecimal bigDecimal, StringBuilder stringBuilder) {
            this.str = str;
            this.aByte = aByte;
            this.aShort = aShort;
            this.anInt = anInt;
            this.aLong = aLong;
            this.aBoolean = aBoolean;
            this.dateTime = dateTime;
            this.instant = instant;
            this.bytes = bytes;
            this.byteBuffer = ByteBuffer.wrap(bytes);
            this.bigDecimal = bigDecimal;
            this.stringBuilder = stringBuilder;
        }

        public String getStr() {
            return this.str;
        }

        public void setStr(String str) {
            this.str = str;
        }

        public byte getaByte() {
            return this.aByte;
        }

        public void setaByte(byte aByte) {
            this.aByte = aByte;
        }

        public short getaShort() {
            return this.aShort;
        }

        public void setaShort(short aShort) {
            this.aShort = aShort;
        }

        public int getAnInt() {
            return this.anInt;
        }

        public void setAnInt(int anInt) {
            this.anInt = anInt;
        }

        public long getaLong() {
            return this.aLong;
        }

        public void setaLong(long aLong) {
            this.aLong = aLong;
        }

        public boolean isaBoolean() {
            return this.aBoolean;
        }

        public void setaBoolean(boolean aBoolean) {
            this.aBoolean = aBoolean;
        }

        public DateTime getDateTime() {
            return this.dateTime;
        }

        public void setDateTime(DateTime dateTime) {
            this.dateTime = dateTime;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        public void setByteBuffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        public Instant getInstant() {
            return this.instant;
        }

        public void setInstant(Instant instant) {
            this.instant = instant;
        }

        public BigDecimal getBigDecimal() {
            return this.bigDecimal;
        }

        public void setBigDecimal(BigDecimal bigDecimal) {
            this.bigDecimal = bigDecimal;
        }

        public StringBuilder getStringBuilder() {
            return this.stringBuilder;
        }

        public void setStringBuilder(StringBuilder stringBuilder) {
            this.stringBuilder = stringBuilder;
        }
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class MismatchingNullableBean {
        @Nullable
        private String str;

        @Nullable
        public String getStr() {
            return this.str;
        }

        public void setStr(String str) {
            this.str = str;
        }
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class NullableBean {
        @Nullable
        private String str;
        private int anInt;

        @Nullable
        public String getStr() {
            return this.str;
        }

        public void setStr(@Nullable String str) {
            this.str = str;
        }

        public int getAnInt() {
            return this.anInt;
        }

        public void setAnInt(int anInt) {
            this.anInt = anInt;
        }
    }
}

