/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.utils.POJOUtils;
import org.apache.beam.sdk.schemas.utils.SchemaTestUtils;
import org.apache.beam.sdk.schemas.utils.TestPOJOs;
import org.apache.beam.sdk.values.reflect.FieldValueGetter;
import org.apache.beam.sdk.values.reflect.FieldValueSetter;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;

public class POJOUtilsTest {
    static final DateTime DATE = DateTime.parse((String)"1979-03-14");
    static final Instant INSTANT = DateTime.parse((String)"1979-03-15").toInstant();
    static final byte[] BYTE_ARRAY = "byteArray".getBytes(Charset.defaultCharset());
    static final ByteBuffer BYTE_BUFFER = ByteBuffer.wrap("byteBuffer".getBytes(Charset.defaultCharset()));

    @Test
    public void testNullables() {
        Schema schema = POJOUtils.schemaFromPojoClass(TestPOJOs.POJOWithNullables.class);
        Assert.assertTrue((boolean)schema.getField("str").getNullable());
        Assert.assertFalse((boolean)schema.getField("anInt").getNullable());
    }

    @Test
    public void testSimplePOJO() {
        Schema schema = POJOUtils.schemaFromPojoClass(TestPOJOs.SimplePOJO.class);
        Assert.assertEquals((Object)TestPOJOs.SIMPLE_POJO_SCHEMA, (Object)schema);
    }

    @Test
    public void testNestedPOJO() {
        Schema schema = POJOUtils.schemaFromPojoClass(TestPOJOs.NestedPOJO.class);
        SchemaTestUtils.assertSchemaEquivalent(TestPOJOs.NESTED_POJO_SCHEMA, schema);
    }

    @Test
    public void testPrimitiveArray() {
        Schema schema = POJOUtils.schemaFromPojoClass(TestPOJOs.PrimitiveArrayPOJO.class);
        SchemaTestUtils.assertSchemaEquivalent(TestPOJOs.PRIMITIVE_ARRAY_POJO_SCHEMA, schema);
    }

    @Test
    public void testNestedArray() {
        Schema schema = POJOUtils.schemaFromPojoClass(TestPOJOs.NestedArrayPOJO.class);
        SchemaTestUtils.assertSchemaEquivalent(TestPOJOs.NESTED_ARRAY_POJO_SCHEMA, schema);
    }

    @Test
    public void testNestedCollection() {
        Schema schema = POJOUtils.schemaFromPojoClass(TestPOJOs.NestedCollectionPOJO.class);
        SchemaTestUtils.assertSchemaEquivalent(TestPOJOs.NESTED_COLLECTION_POJO_SCHEMA, schema);
    }

    @Test
    public void testPrimitiveMap() {
        Schema schema = POJOUtils.schemaFromPojoClass(TestPOJOs.PrimitiveMapPOJO.class);
        SchemaTestUtils.assertSchemaEquivalent(TestPOJOs.PRIMITIVE_MAP_POJO_SCHEMA, schema);
    }

    @Test
    public void testNestedMap() {
        Schema schema = POJOUtils.schemaFromPojoClass(TestPOJOs.NestedMapPOJO.class);
        SchemaTestUtils.assertSchemaEquivalent(TestPOJOs.NESTED_MAP_POJO_SCHEMA, schema);
    }

    @Test
    public void testGeneratedSimpleGetters() {
        TestPOJOs.SimplePOJO simplePojo = new TestPOJOs.SimplePOJO("field1", 41, 42, 43, 44L, true, DATE, INSTANT, BYTE_ARRAY, BYTE_BUFFER, new BigDecimal(42), new StringBuilder("stringBuilder"));
        List getters = POJOUtils.getGetters(TestPOJOs.SimplePOJO.class, (Schema)TestPOJOs.SIMPLE_POJO_SCHEMA);
        Assert.assertEquals((long)12L, (long)getters.size());
        Assert.assertEquals((Object)"str", (Object)((FieldValueGetter)getters.get(0)).name());
        Assert.assertEquals((Object)"field1", (Object)((FieldValueGetter)getters.get(0)).get((Object)simplePojo));
        Assert.assertEquals((Object)41, (Object)((FieldValueGetter)getters.get(1)).get((Object)simplePojo));
        Assert.assertEquals((Object)42, (Object)((FieldValueGetter)getters.get(2)).get((Object)simplePojo));
        Assert.assertEquals((Object)43, (Object)((FieldValueGetter)getters.get(3)).get((Object)simplePojo));
        Assert.assertEquals((Object)44L, (Object)((FieldValueGetter)getters.get(4)).get((Object)simplePojo));
        Assert.assertEquals((Object)true, (Object)((FieldValueGetter)getters.get(5)).get((Object)simplePojo));
        Assert.assertEquals((Object)DATE.toInstant(), (Object)((FieldValueGetter)getters.get(6)).get((Object)simplePojo));
        Assert.assertEquals((Object)INSTANT, (Object)((FieldValueGetter)getters.get(7)).get((Object)simplePojo));
        Assert.assertArrayEquals((String)"Unexpected bytes", (byte[])BYTE_ARRAY, (byte[])((byte[])((FieldValueGetter)getters.get(8)).get((Object)simplePojo)));
        Assert.assertArrayEquals((String)"Unexpected bytes", (byte[])BYTE_BUFFER.array(), (byte[])((byte[])((FieldValueGetter)getters.get(9)).get((Object)simplePojo)));
        Assert.assertEquals((Object)new BigDecimal(42), (Object)((FieldValueGetter)getters.get(10)).get((Object)simplePojo));
        Assert.assertEquals((Object)"stringBuilder", (Object)((FieldValueGetter)getters.get(11)).get((Object)simplePojo));
    }

    @Test
    public void testGeneratedSimpleSetters() {
        TestPOJOs.SimplePOJO simplePojo = new TestPOJOs.SimplePOJO();
        List setters = POJOUtils.getSetters(TestPOJOs.SimplePOJO.class, (Schema)TestPOJOs.SIMPLE_POJO_SCHEMA);
        Assert.assertEquals((long)12L, (long)setters.size());
        ((FieldValueSetter)setters.get(0)).set((Object)simplePojo, (Object)"field1");
        ((FieldValueSetter)setters.get(1)).set((Object)simplePojo, (Object)41);
        ((FieldValueSetter)setters.get(2)).set((Object)simplePojo, (Object)42);
        ((FieldValueSetter)setters.get(3)).set((Object)simplePojo, (Object)43);
        ((FieldValueSetter)setters.get(4)).set((Object)simplePojo, (Object)44L);
        ((FieldValueSetter)setters.get(5)).set((Object)simplePojo, (Object)true);
        ((FieldValueSetter)setters.get(6)).set((Object)simplePojo, (Object)DATE.toInstant());
        ((FieldValueSetter)setters.get(7)).set((Object)simplePojo, (Object)INSTANT);
        ((FieldValueSetter)setters.get(8)).set((Object)simplePojo, (Object)BYTE_ARRAY);
        ((FieldValueSetter)setters.get(9)).set((Object)simplePojo, (Object)BYTE_BUFFER.array());
        ((FieldValueSetter)setters.get(10)).set((Object)simplePojo, (Object)new BigDecimal(42));
        ((FieldValueSetter)setters.get(11)).set((Object)simplePojo, (Object)"stringBuilder");
        Assert.assertEquals((Object)"field1", (Object)simplePojo.str);
        Assert.assertEquals((long)41L, (long)simplePojo.aByte);
        Assert.assertEquals((long)42L, (long)simplePojo.aShort);
        Assert.assertEquals((long)43L, (long)simplePojo.anInt);
        Assert.assertEquals((long)44L, (long)simplePojo.aLong);
        Assert.assertEquals((Object)true, (Object)simplePojo.aBoolean);
        Assert.assertEquals((Object)DATE, (Object)simplePojo.dateTime);
        Assert.assertEquals((Object)INSTANT, (Object)simplePojo.instant);
        Assert.assertArrayEquals((String)"Unexpected bytes", (byte[])BYTE_ARRAY, (byte[])simplePojo.bytes);
        Assert.assertEquals((Object)BYTE_BUFFER, (Object)simplePojo.byteBuffer);
        Assert.assertEquals((Object)new BigDecimal(42), (Object)simplePojo.bigDecimal);
        Assert.assertEquals((Object)"stringBuilder", (Object)simplePojo.stringBuilder.toString());
    }

    @Test
    public void testGeneratedSimpleBoxedGetters() {
        TestPOJOs.POJOWithBoxedFields pojo = new TestPOJOs.POJOWithBoxedFields((byte)41, (short)42, 43, 44L, true);
        List getters = POJOUtils.getGetters(TestPOJOs.POJOWithBoxedFields.class, (Schema)TestPOJOs.POJO_WITH_BOXED_FIELDS_SCHEMA);
        Assert.assertEquals((Object)41, (Object)((FieldValueGetter)getters.get(0)).get((Object)pojo));
        Assert.assertEquals((Object)42, (Object)((FieldValueGetter)getters.get(1)).get((Object)pojo));
        Assert.assertEquals((Object)43, (Object)((FieldValueGetter)getters.get(2)).get((Object)pojo));
        Assert.assertEquals((Object)44L, (Object)((FieldValueGetter)getters.get(3)).get((Object)pojo));
        Assert.assertEquals((Object)true, (Object)((FieldValueGetter)getters.get(4)).get((Object)pojo));
    }

    @Test
    public void testGeneratedSimpleBoxedSetters() {
        TestPOJOs.POJOWithBoxedFields pojo = new TestPOJOs.POJOWithBoxedFields();
        List setters = POJOUtils.getSetters(TestPOJOs.POJOWithBoxedFields.class, (Schema)TestPOJOs.POJO_WITH_BOXED_FIELDS_SCHEMA);
        ((FieldValueSetter)setters.get(0)).set((Object)pojo, (Object)41);
        ((FieldValueSetter)setters.get(1)).set((Object)pojo, (Object)42);
        ((FieldValueSetter)setters.get(2)).set((Object)pojo, (Object)43);
        ((FieldValueSetter)setters.get(3)).set((Object)pojo, (Object)44L);
        ((FieldValueSetter)setters.get(4)).set((Object)pojo, (Object)true);
        Assert.assertEquals((long)41L, (long)pojo.aByte.byteValue());
        Assert.assertEquals((long)42L, (long)pojo.aShort.shortValue());
        Assert.assertEquals((long)43L, (long)pojo.anInt.intValue());
        Assert.assertEquals((long)44L, (long)pojo.aLong);
        Assert.assertEquals((Object)true, (Object)pojo.aBoolean);
    }

    @Test
    public void testGeneratedByteBufferSetters() {
        TestPOJOs.POJOWithByteArray pojo = new TestPOJOs.POJOWithByteArray();
        List setters = POJOUtils.getSetters(TestPOJOs.POJOWithByteArray.class, (Schema)TestPOJOs.POJO_WITH_BYTE_ARRAY_SCHEMA);
        ((FieldValueSetter)setters.get(0)).set((Object)pojo, (Object)BYTE_ARRAY);
        ((FieldValueSetter)setters.get(1)).set((Object)pojo, (Object)BYTE_BUFFER.array());
        Assert.assertArrayEquals((String)"not equal", (byte[])BYTE_ARRAY, (byte[])pojo.bytes1);
        Assert.assertEquals((Object)BYTE_BUFFER, (Object)pojo.bytes2);
    }
}

