/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.SchemaTestUtils;
import org.apache.beam.sdk.schemas.utils.TestJavaBeans;
import org.apache.beam.sdk.values.reflect.FieldValueGetter;
import org.apache.beam.sdk.values.reflect.FieldValueSetter;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JavaBeanUtilsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testNullable() {
        Schema schema = JavaBeanUtils.schemaFromJavaBeanClass(TestJavaBeans.NullableBean.class);
        Assert.assertTrue((boolean)schema.getField("str").getNullable());
        Assert.assertFalse((boolean)schema.getField("anInt").getNullable());
    }

    @Test
    public void testMismatchingNullable() {
        this.thrown.expect(RuntimeException.class);
        Schema schema = JavaBeanUtils.schemaFromJavaBeanClass(TestJavaBeans.MismatchingNullableBean.class);
    }

    @Test
    public void testSimpleBean() {
        Schema schema = JavaBeanUtils.schemaFromJavaBeanClass(TestJavaBeans.SimpleBean.class);
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.SIMPLE_BEAN_SCHEMA, schema);
    }

    @Test
    public void testNestedBean() {
        Schema schema = JavaBeanUtils.schemaFromJavaBeanClass(TestJavaBeans.NestedBean.class);
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.NESTED_BEAN_SCHEMA, schema);
    }

    @Test
    public void testPrimitiveArray() {
        Schema schema = JavaBeanUtils.schemaFromJavaBeanClass(TestJavaBeans.PrimitiveArrayBean.class);
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.PRIMITIVE_ARRAY_BEAN_SCHEMA, schema);
    }

    @Test
    public void testNestedArray() {
        Schema schema = JavaBeanUtils.schemaFromJavaBeanClass(TestJavaBeans.NestedArrayBean.class);
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.NESTED_ARRAY_BEAN_SCHEMA, schema);
    }

    @Test
    public void testNestedCollection() {
        Schema schema = JavaBeanUtils.schemaFromJavaBeanClass(TestJavaBeans.NestedCollectionBean.class);
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.NESTED_COLLECTION_BEAN_SCHEMA, schema);
    }

    @Test
    public void testPrimitiveMap() {
        Schema schema = JavaBeanUtils.schemaFromJavaBeanClass(TestJavaBeans.PrimitiveMapBean.class);
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.PRIMITIVE_MAP_BEAN_SCHEMA, schema);
    }

    @Test
    public void testNestedMap() {
        Schema schema = JavaBeanUtils.schemaFromJavaBeanClass(TestJavaBeans.NestedMapBean.class);
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.NESTED_MAP_BEAN_SCHEMA, schema);
    }

    @Test
    public void testGeneratedSimpleGetters() {
        TestJavaBeans.SimpleBean simpleBean = new TestJavaBeans.SimpleBean();
        simpleBean.setStr("field1");
        simpleBean.setaByte((byte)41);
        simpleBean.setaShort((short)42);
        simpleBean.setAnInt(43);
        simpleBean.setaLong(44L);
        simpleBean.setaBoolean(true);
        simpleBean.setDateTime(DateTime.parse((String)"1979-03-14"));
        simpleBean.setInstant(DateTime.parse((String)"1979-03-15").toInstant());
        simpleBean.setBytes("bytes1".getBytes(Charset.defaultCharset()));
        simpleBean.setByteBuffer(ByteBuffer.wrap("bytes2".getBytes(Charset.defaultCharset())));
        simpleBean.setBigDecimal(new BigDecimal(42));
        simpleBean.setStringBuilder(new StringBuilder("stringBuilder"));
        List getters = JavaBeanUtils.getGetters(TestJavaBeans.SimpleBean.class, (Schema)TestJavaBeans.SIMPLE_BEAN_SCHEMA);
        Assert.assertEquals((long)12L, (long)getters.size());
        Assert.assertEquals((Object)"str", (Object)((FieldValueGetter)getters.get(0)).name());
        Assert.assertEquals((Object)"field1", (Object)((FieldValueGetter)getters.get(0)).get((Object)simpleBean));
        Assert.assertEquals((Object)41, (Object)((FieldValueGetter)getters.get(1)).get((Object)simpleBean));
        Assert.assertEquals((Object)42, (Object)((FieldValueGetter)getters.get(2)).get((Object)simpleBean));
        Assert.assertEquals((Object)43, (Object)((FieldValueGetter)getters.get(3)).get((Object)simpleBean));
        Assert.assertEquals((Object)44L, (Object)((FieldValueGetter)getters.get(4)).get((Object)simpleBean));
        Assert.assertEquals((Object)true, (Object)((FieldValueGetter)getters.get(5)).get((Object)simpleBean));
        Assert.assertEquals((Object)DateTime.parse((String)"1979-03-14").toInstant(), (Object)((FieldValueGetter)getters.get(6)).get((Object)simpleBean));
        Assert.assertEquals((Object)DateTime.parse((String)"1979-03-15").toInstant(), (Object)((FieldValueGetter)getters.get(7)).get((Object)simpleBean));
        Assert.assertArrayEquals((String)"Unexpected bytes", (byte[])"bytes1".getBytes(Charset.defaultCharset()), (byte[])((byte[])((FieldValueGetter)getters.get(8)).get((Object)simpleBean)));
        Assert.assertArrayEquals((String)"Unexpected bytes", (byte[])"bytes2".getBytes(Charset.defaultCharset()), (byte[])((byte[])((FieldValueGetter)getters.get(9)).get((Object)simpleBean)));
        Assert.assertEquals((Object)new BigDecimal(42), (Object)((FieldValueGetter)getters.get(10)).get((Object)simpleBean));
        Assert.assertEquals((Object)"stringBuilder", (Object)((FieldValueGetter)getters.get(11)).get((Object)simpleBean).toString());
    }

    @Test
    public void testGeneratedSimpleSetters() {
        TestJavaBeans.SimpleBean simpleBean = new TestJavaBeans.SimpleBean();
        List setters = JavaBeanUtils.getSetters(TestJavaBeans.SimpleBean.class, (Schema)TestJavaBeans.SIMPLE_BEAN_SCHEMA);
        Assert.assertEquals((long)12L, (long)setters.size());
        ((FieldValueSetter)setters.get(0)).set((Object)simpleBean, (Object)"field1");
        ((FieldValueSetter)setters.get(1)).set((Object)simpleBean, (Object)41);
        ((FieldValueSetter)setters.get(2)).set((Object)simpleBean, (Object)42);
        ((FieldValueSetter)setters.get(3)).set((Object)simpleBean, (Object)43);
        ((FieldValueSetter)setters.get(4)).set((Object)simpleBean, (Object)44L);
        ((FieldValueSetter)setters.get(5)).set((Object)simpleBean, (Object)true);
        ((FieldValueSetter)setters.get(6)).set((Object)simpleBean, (Object)DateTime.parse((String)"1979-03-14").toInstant());
        ((FieldValueSetter)setters.get(7)).set((Object)simpleBean, (Object)DateTime.parse((String)"1979-03-15").toInstant());
        ((FieldValueSetter)setters.get(8)).set((Object)simpleBean, (Object)"bytes1".getBytes(Charset.defaultCharset()));
        ((FieldValueSetter)setters.get(9)).set((Object)simpleBean, (Object)"bytes2".getBytes(Charset.defaultCharset()));
        ((FieldValueSetter)setters.get(10)).set((Object)simpleBean, (Object)new BigDecimal(42));
        ((FieldValueSetter)setters.get(11)).set((Object)simpleBean, (Object)"stringBuilder");
        Assert.assertEquals((Object)"field1", (Object)simpleBean.getStr());
        Assert.assertEquals((long)41L, (long)simpleBean.getaByte());
        Assert.assertEquals((long)42L, (long)simpleBean.getaShort());
        Assert.assertEquals((long)43L, (long)simpleBean.getAnInt());
        Assert.assertEquals((long)44L, (long)simpleBean.getaLong());
        Assert.assertEquals((Object)true, (Object)simpleBean.isaBoolean());
        Assert.assertEquals((Object)DateTime.parse((String)"1979-03-14"), (Object)simpleBean.getDateTime());
        Assert.assertEquals((Object)DateTime.parse((String)"1979-03-15").toInstant(), (Object)simpleBean.getInstant());
        Assert.assertArrayEquals((String)"Unexpected bytes", (byte[])"bytes1".getBytes(Charset.defaultCharset()), (byte[])simpleBean.getBytes());
        Assert.assertEquals((Object)ByteBuffer.wrap("bytes2".getBytes(Charset.defaultCharset())), (Object)simpleBean.getByteBuffer());
        Assert.assertEquals((Object)new BigDecimal(42), (Object)simpleBean.getBigDecimal());
        Assert.assertEquals((Object)"stringBuilder", (Object)simpleBean.getStringBuilder().toString());
    }

    @Test
    public void testGeneratedSimpleBoxedGetters() {
        TestJavaBeans.BeanWithBoxedFields bean = new TestJavaBeans.BeanWithBoxedFields();
        bean.setaByte((byte)41);
        bean.setaShort((short)42);
        bean.setAnInt(43);
        bean.setaLong(44L);
        bean.setaBoolean(true);
        List getters = JavaBeanUtils.getGetters(TestJavaBeans.BeanWithBoxedFields.class, (Schema)TestJavaBeans.BEAN_WITH_BOXED_FIELDS_SCHEMA);
        Assert.assertEquals((Object)41, (Object)((FieldValueGetter)getters.get(0)).get((Object)bean));
        Assert.assertEquals((Object)42, (Object)((FieldValueGetter)getters.get(1)).get((Object)bean));
        Assert.assertEquals((Object)43, (Object)((FieldValueGetter)getters.get(2)).get((Object)bean));
        Assert.assertEquals((Object)44L, (Object)((FieldValueGetter)getters.get(3)).get((Object)bean));
        Assert.assertEquals((Object)true, (Object)((FieldValueGetter)getters.get(4)).get((Object)bean));
    }

    @Test
    public void testGeneratedSimpleBoxedSetters() {
        TestJavaBeans.BeanWithBoxedFields bean = new TestJavaBeans.BeanWithBoxedFields();
        List setters = JavaBeanUtils.getSetters(TestJavaBeans.BeanWithBoxedFields.class, (Schema)TestJavaBeans.BEAN_WITH_BOXED_FIELDS_SCHEMA);
        ((FieldValueSetter)setters.get(0)).set((Object)bean, (Object)41);
        ((FieldValueSetter)setters.get(1)).set((Object)bean, (Object)42);
        ((FieldValueSetter)setters.get(2)).set((Object)bean, (Object)43);
        ((FieldValueSetter)setters.get(3)).set((Object)bean, (Object)44L);
        ((FieldValueSetter)setters.get(4)).set((Object)bean, (Object)true);
        Assert.assertEquals((long)41L, (long)bean.getaByte().byteValue());
        Assert.assertEquals((long)42L, (long)bean.getaShort().shortValue());
        Assert.assertEquals((long)43L, (long)bean.getAnInt().intValue());
        Assert.assertEquals((long)44L, (long)bean.getaLong());
        Assert.assertEquals((Object)true, (Object)bean.getaBoolean());
    }

    @Test
    public void testGeneratedByteBufferSetters() {
        TestJavaBeans.BeanWithByteArray bean = new TestJavaBeans.BeanWithByteArray();
        List setters = JavaBeanUtils.getSetters(TestJavaBeans.BeanWithByteArray.class, (Schema)TestJavaBeans.BEAN_WITH_BYTE_ARRAY_SCHEMA);
        ((FieldValueSetter)setters.get(0)).set((Object)bean, (Object)"field1".getBytes(Charset.defaultCharset()));
        ((FieldValueSetter)setters.get(1)).set((Object)bean, (Object)"field2".getBytes(Charset.defaultCharset()));
        Assert.assertArrayEquals((String)"not equal", (byte[])"field1".getBytes(Charset.defaultCharset()), (byte[])bean.getBytes1());
        Assert.assertEquals((Object)ByteBuffer.wrap("field2".getBytes(Charset.defaultCharset())), (Object)bean.getBytes2());
    }
}

