/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.schemas.DefaultSchema;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class ConvertTest {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    private static final Schema EXPECTED_SCHEMA1_NESTED = Schema.builder().addStringField("yard1").addInt64Field("yard2").build();
    private static final Schema EXPECTED_SCHEMA1 = Schema.builder().addStringField("field1").addInt64Field("field2").addRowField("field3", EXPECTED_SCHEMA1_NESTED).addArrayField("field4", Schema.FieldType.row((Schema)EXPECTED_SCHEMA1_NESTED)).addMapField("field5", Schema.FieldType.STRING, Schema.FieldType.row((Schema)EXPECTED_SCHEMA1_NESTED)).build();
    private static final Row EXPECTED_ROW1_NESTED = Row.withSchema((Schema)EXPECTED_SCHEMA1_NESTED).addValues(new Object[]{"yard2", 43L}).build();
    private static final Row EXPECTED_ROW1 = Row.withSchema((Schema)EXPECTED_SCHEMA1).addValue((Object)"field1").addValue((Object)42L).addValue((Object)EXPECTED_ROW1_NESTED).addArray(ImmutableList.of(EXPECTED_ROW1_NESTED, EXPECTED_ROW1_NESTED)).addValue(ImmutableMap.of("first", EXPECTED_ROW1_NESTED, "second", EXPECTED_ROW1_NESTED)).build();

    @Test
    @Category(value={NeedsRunner.class})
    public void testToRows() {
        PCollection rows = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)new POJO1(), (Object[])new POJO1[0]))).apply(Convert.toRows());
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new Row[]{EXPECTED_ROW1});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFromRows() {
        PCollection pojos = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)EXPECTED_ROW1, (Object[])new Row[0]).withSchema(EXPECTED_SCHEMA1, SerializableFunctions.identity(), SerializableFunctions.identity()))).apply(Convert.fromRows(POJO1.class));
        PAssert.that((PCollection)pojos).containsInAnyOrder((Object[])new POJO1[]{new POJO1()});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testGeneralConvert() {
        PCollection pojos = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)new POJO1(), (Object[])new POJO1[0]))).apply(Convert.to(POJO2.class));
        PAssert.that((PCollection)pojos).containsInAnyOrder((Object[])new POJO2[]{new POJO2()});
        this.pipeline.run();
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class POJO2Nested {
        public long yard2 = 43L;
        public String yard1 = "yard2";

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            POJO2Nested that = (POJO2Nested)o;
            return this.yard2 == that.yard2 && Objects.equals(this.yard1, that.yard1);
        }

        public int hashCode() {
            return Objects.hash(this.yard2, this.yard1);
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class POJO2 {
        public Map<String, POJO2Nested> field5 = ImmutableMap.of("first", new POJO2Nested(), "second", new POJO2Nested());
        public POJO2Nested[] field4 = new POJO2Nested[]{new POJO2Nested(), new POJO2Nested()};
        public POJO2Nested field3 = new POJO2Nested();
        public long field2 = 42L;
        public String field1 = "field1";

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            POJO2 pojo2 = (POJO2)o;
            return this.field2 == pojo2.field2 && Objects.equals(this.field5, pojo2.field5) && Arrays.equals(this.field4, pojo2.field4) && Objects.equals(this.field3, pojo2.field3) && Objects.equals(this.field1, pojo2.field1);
        }

        public int hashCode() {
            int result = Objects.hash(this.field5, this.field3, this.field2, this.field1);
            result = 31 * result + Arrays.hashCode(this.field4);
            return result;
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class POJO1Nested {
        public String yard1 = "yard2";
        public long yard2 = 43L;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            POJO1Nested that = (POJO1Nested)o;
            return this.yard2 == that.yard2 && Objects.equals(this.yard1, that.yard1);
        }

        public int hashCode() {
            return Objects.hash(this.yard1, this.yard2);
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class POJO1 {
        public String field1 = "field1";
        public long field2 = 42L;
        public POJO1Nested field3 = new POJO1Nested();
        public POJO1Nested[] field4 = new POJO1Nested[]{new POJO1Nested(), new POJO1Nested()};
        public Map<String, POJO1Nested> field5 = ImmutableMap.of("first", new POJO1Nested(), "second", new POJO1Nested());

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            POJO1 pojo1 = (POJO1)o;
            return this.field2 == pojo1.field2 && Objects.equals(this.field1, pojo1.field1) && Objects.equals(this.field3, pojo1.field3) && Arrays.equals(this.field4, pojo1.field4) && Objects.equals(this.field5, pojo1.field5);
        }

        public int hashCode() {
            int result = Objects.hash(this.field1, this.field2, this.field3, this.field5);
            result = 31 * result + Arrays.hashCode(this.field4);
            return result;
        }
    }
}

