/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.stream.Stream;
import org.apache.beam.sdk.schemas.Schema;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SchemaTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testCreate() {
        Schema schema = Schema.builder().addByteField("f_byte").addInt16Field("f_int16").addInt32Field("f_int32").addInt64Field("f_int64").addDecimalField("f_decimal").addFloatField("f_float").addDoubleField("f_double").addStringField("f_string").addDateTimeField("f_datetime").addBooleanField("f_boolean").build();
        Assert.assertEquals((long)10L, (long)schema.getFieldCount());
        Assert.assertEquals((long)0L, (long)schema.indexOf("f_byte"));
        Assert.assertEquals((Object)"f_byte", (Object)schema.getField(0).getName());
        Assert.assertEquals((Object)Schema.FieldType.BYTE, (Object)schema.getField(0).getType());
        Assert.assertEquals((long)1L, (long)schema.indexOf("f_int16"));
        Assert.assertEquals((Object)"f_int16", (Object)schema.getField(1).getName());
        Assert.assertEquals((Object)Schema.FieldType.INT16, (Object)schema.getField(1).getType());
        Assert.assertEquals((long)2L, (long)schema.indexOf("f_int32"));
        Assert.assertEquals((Object)"f_int32", (Object)schema.getField(2).getName());
        Assert.assertEquals((Object)Schema.FieldType.INT32, (Object)schema.getField(2).getType());
        Assert.assertEquals((long)3L, (long)schema.indexOf("f_int64"));
        Assert.assertEquals((Object)"f_int64", (Object)schema.getField(3).getName());
        Assert.assertEquals((Object)Schema.FieldType.INT64, (Object)schema.getField(3).getType());
        Assert.assertEquals((long)4L, (long)schema.indexOf("f_decimal"));
        Assert.assertEquals((Object)"f_decimal", (Object)schema.getField(4).getName());
        Assert.assertEquals((Object)Schema.FieldType.DECIMAL, (Object)schema.getField(4).getType());
        Assert.assertEquals((long)5L, (long)schema.indexOf("f_float"));
        Assert.assertEquals((Object)"f_float", (Object)schema.getField(5).getName());
        Assert.assertEquals((Object)Schema.FieldType.FLOAT, (Object)schema.getField(5).getType());
        Assert.assertEquals((long)6L, (long)schema.indexOf("f_double"));
        Assert.assertEquals((Object)"f_double", (Object)schema.getField(6).getName());
        Assert.assertEquals((Object)Schema.FieldType.DOUBLE, (Object)schema.getField(6).getType());
        Assert.assertEquals((long)7L, (long)schema.indexOf("f_string"));
        Assert.assertEquals((Object)"f_string", (Object)schema.getField(7).getName());
        Assert.assertEquals((Object)Schema.FieldType.STRING, (Object)schema.getField(7).getType());
        Assert.assertEquals((long)8L, (long)schema.indexOf("f_datetime"));
        Assert.assertEquals((Object)"f_datetime", (Object)schema.getField(8).getName());
        Assert.assertEquals((Object)Schema.FieldType.DATETIME, (Object)schema.getField(8).getType());
        Assert.assertEquals((long)9L, (long)schema.indexOf("f_boolean"));
        Assert.assertEquals((Object)"f_boolean", (Object)schema.getField(9).getName());
        Assert.assertEquals((Object)Schema.FieldType.BOOLEAN, (Object)schema.getField(9).getType());
    }

    @Test
    public void testNestedSchema() {
        Schema nestedSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"f1_str", (Schema.FieldType)Schema.FieldType.STRING)});
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"nested", (Schema.FieldType)Schema.FieldType.row((Schema)nestedSchema))});
        Schema.Field inner = schema.getField("nested").getType().getRowSchema().getField("f1_str");
        Assert.assertEquals((Object)"f1_str", (Object)inner.getName());
        Assert.assertEquals((Object)Schema.FieldType.STRING, (Object)inner.getType());
    }

    @Test
    public void testArraySchema() {
        Schema.FieldType arrayType = Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING);
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"f_array", (Schema.FieldType)arrayType)});
        Schema.Field field = schema.getField("f_array");
        Assert.assertEquals((Object)"f_array", (Object)field.getName());
        Assert.assertEquals((Object)arrayType, (Object)field.getType());
    }

    @Test
    public void testArrayOfRowSchema() {
        Schema nestedSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"f1_str", (Schema.FieldType)Schema.FieldType.STRING)});
        Schema.FieldType arrayType = Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)nestedSchema));
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"f_array", (Schema.FieldType)arrayType)});
        Schema.Field field = schema.getField("f_array");
        Assert.assertEquals((Object)"f_array", (Object)field.getName());
        Assert.assertEquals((Object)arrayType, (Object)field.getType());
    }

    @Test
    public void testNestedArraySchema() {
        Schema.FieldType arrayType = Schema.FieldType.array((Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING));
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"f_array", (Schema.FieldType)arrayType)});
        Schema.Field field = schema.getField("f_array");
        Assert.assertEquals((Object)"f_array", (Object)field.getName());
        Assert.assertEquals((Object)arrayType, (Object)field.getType());
    }

    @Test
    public void testWrongName() {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"f_byte", (Schema.FieldType)Schema.FieldType.BYTE)});
        this.thrown.expect(IllegalArgumentException.class);
        schema.getField("f_string");
    }

    @Test
    public void testWrongIndex() {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"f_byte", (Schema.FieldType)Schema.FieldType.BYTE)});
        this.thrown.expect(IndexOutOfBoundsException.class);
        schema.getField(1);
    }

    @Test
    public void testCollector() {
        Schema schema = (Schema)Stream.of(Schema.Field.of((String)"f_int", (Schema.FieldType)Schema.FieldType.INT32), Schema.Field.of((String)"f_string", (Schema.FieldType)Schema.FieldType.STRING)).collect(Schema.toSchema());
        Assert.assertEquals((long)2L, (long)schema.getFieldCount());
        Assert.assertEquals((Object)"f_int", (Object)schema.getField(0).getName());
        Assert.assertEquals((Object)Schema.FieldType.INT32, (Object)schema.getField(0).getType());
        Assert.assertEquals((Object)"f_string", (Object)schema.getField(1).getName());
        Assert.assertEquals((Object)Schema.FieldType.STRING, (Object)schema.getField(1).getType());
    }

    @Test
    public void testEquivalent() {
        Schema expectedNested1 = Schema.builder().addStringField("yard1").addInt64Field("yard2").build();
        Schema expectedSchema1 = Schema.builder().addStringField("field1").addInt64Field("field2").addRowField("field3", expectedNested1).addArrayField("field4", Schema.FieldType.row((Schema)expectedNested1)).addMapField("field5", Schema.FieldType.STRING, Schema.FieldType.row((Schema)expectedNested1)).build();
        Schema expectedNested2 = Schema.builder().addInt64Field("yard2").addStringField("yard1").build();
        Schema expectedSchema2 = Schema.builder().addMapField("field5", Schema.FieldType.STRING, Schema.FieldType.row((Schema)expectedNested2)).addArrayField("field4", Schema.FieldType.row((Schema)expectedNested2)).addRowField("field3", expectedNested2).addInt64Field("field2").addStringField("field1").build();
        Assert.assertNotEquals((Object)expectedSchema1, (Object)expectedSchema2);
        Assert.assertTrue((boolean)expectedSchema1.equivalent(expectedSchema2));
    }

    @Test
    public void testPrimitiveNotEquivalent() {
        Schema schema1 = Schema.builder().addInt64Field("foo").build();
        Schema schema2 = Schema.builder().addStringField("foo").build();
        Assert.assertNotEquals((Object)schema1, (Object)schema2);
        Assert.assertFalse((boolean)schema1.equivalent(schema2));
        schema1 = Schema.builder().addInt64Field("foo").build();
        schema2 = Schema.builder().addInt64Field("bar").build();
        Assert.assertNotEquals((Object)schema1, (Object)schema2);
        Assert.assertFalse((boolean)schema1.equivalent(schema2));
        schema1 = Schema.builder().addInt64Field("foo").build();
        schema2 = Schema.builder().addNullableField("foo", Schema.FieldType.INT64).build();
        Assert.assertNotEquals((Object)schema1, (Object)schema2);
        Assert.assertFalse((boolean)schema1.equivalent(schema2));
    }

    @Test
    public void testNestedNotEquivalent() {
        Schema nestedSchema1 = Schema.builder().addInt64Field("foo").build();
        Schema nestedSchema2 = Schema.builder().addStringField("foo").build();
        Schema schema1 = Schema.builder().addRowField("foo", nestedSchema1).build();
        Schema schema2 = Schema.builder().addRowField("foo", nestedSchema2).build();
        Assert.assertNotEquals((Object)schema1, (Object)schema2);
        Assert.assertFalse((boolean)schema1.equivalent(schema2));
    }

    @Test
    public void testArrayNotEquivalent() {
        Schema schema1 = Schema.builder().addArrayField("foo", Schema.FieldType.BOOLEAN).build();
        Schema schema2 = Schema.builder().addArrayField("foo", Schema.FieldType.DATETIME).build();
        Assert.assertNotEquals((Object)schema1, (Object)schema2);
        Assert.assertFalse((boolean)schema1.equivalent(schema2));
    }

    @Test
    public void testNestedArraysNotEquivalent() {
        Schema nestedSchema1 = Schema.builder().addInt64Field("foo").build();
        Schema nestedSchema2 = Schema.builder().addStringField("foo").build();
        Schema schema1 = Schema.builder().addArrayField("foo", Schema.FieldType.row((Schema)nestedSchema1)).build();
        Schema schema2 = Schema.builder().addArrayField("foo", Schema.FieldType.row((Schema)nestedSchema2)).build();
        Assert.assertNotEquals((Object)schema1, (Object)schema2);
        Assert.assertFalse((boolean)schema1.equivalent(schema2));
    }

    @Test
    public void testMapNotEquivalent() {
        Schema schema1 = Schema.builder().addMapField("foo", Schema.FieldType.STRING, Schema.FieldType.BOOLEAN).build();
        Schema schema2 = Schema.builder().addMapField("foo", Schema.FieldType.DATETIME, Schema.FieldType.BOOLEAN).build();
        Assert.assertNotEquals((Object)schema1, (Object)schema2);
        Assert.assertFalse((boolean)schema1.equivalent(schema2));
        schema1 = Schema.builder().addMapField("foo", Schema.FieldType.STRING, Schema.FieldType.BOOLEAN).build();
        schema2 = Schema.builder().addMapField("foo", Schema.FieldType.STRING, Schema.FieldType.STRING).build();
        Assert.assertNotEquals((Object)schema1, (Object)schema2);
        Assert.assertFalse((boolean)schema1.equivalent(schema2));
    }

    @Test
    public void testNestedMapsNotEquivalent() {
        Schema nestedSchema1 = Schema.builder().addInt64Field("foo").build();
        Schema nestedSchema2 = Schema.builder().addStringField("foo").build();
        Schema schema1 = Schema.builder().addMapField("foo", Schema.FieldType.STRING, Schema.FieldType.row((Schema)nestedSchema1)).build();
        Schema schema2 = Schema.builder().addMapField("foo", Schema.FieldType.STRING, Schema.FieldType.row((Schema)nestedSchema2)).build();
        Assert.assertNotEquals((Object)schema1, (Object)schema2);
        Assert.assertFalse((boolean)schema1.equivalent(schema2));
    }
}

