/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.schemas.DefaultSchema;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.SchemaProviderRegistrar;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SchemaRegistryTest {
    static final Schema EMPTY_SCHEMA = Schema.builder().build();
    static final Schema STRING_SCHEMA = Schema.builder().addStringField("string").build();
    static final Schema INTEGER_SCHEMA = Schema.builder().addInt32Field("integer").build();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private void tryGetters(SchemaRegistry registry) throws NoSuchSchemaException {
        Assert.assertEquals((Object)STRING_SCHEMA, (Object)registry.getSchema(String.class));
        Assert.assertEquals((Object)STRING_SCHEMA, (Object)registry.getSchema(TypeDescriptors.strings()));
        Assert.assertEquals((Object)Row.withSchema((Schema)STRING_SCHEMA).addValue((Object)"foobar").build(), (Object)registry.getToRowFunction(String.class).apply((Object)"foobar"));
        Assert.assertEquals((Object)Row.withSchema((Schema)STRING_SCHEMA).addValue((Object)"foobar").build(), (Object)registry.getToRowFunction(TypeDescriptors.strings()).apply((Object)"foobar"));
        Assert.assertEquals((Object)INTEGER_SCHEMA, (Object)registry.getSchema(Integer.class));
        Assert.assertEquals((Object)INTEGER_SCHEMA, (Object)registry.getSchema(TypeDescriptors.integers()));
        Assert.assertEquals((Object)Row.withSchema((Schema)INTEGER_SCHEMA).addValue((Object)42).build(), (Object)registry.getToRowFunction(Integer.class).apply((Object)42));
        Assert.assertEquals((Object)Row.withSchema((Schema)INTEGER_SCHEMA).addValue((Object)42).build(), (Object)registry.getToRowFunction(TypeDescriptors.integers()).apply((Object)42));
        this.thrown.expect(NoSuchSchemaException.class);
        registry.getSchema(Double.class);
    }

    @Test
    public void testRegisterForClass() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        registry.registerSchemaForClass(String.class, STRING_SCHEMA, (SerializableFunction & Serializable)s -> Row.withSchema((Schema)STRING_SCHEMA).addValue(s).build(), (SerializableFunction & Serializable)r -> r.getString("string"));
        registry.registerSchemaForClass(Integer.class, INTEGER_SCHEMA, (SerializableFunction & Serializable)s -> Row.withSchema((Schema)INTEGER_SCHEMA).addValue(s).build(), (SerializableFunction & Serializable)r -> r.getInt32("integer"));
        this.tryGetters(registry);
    }

    @Test
    public void testRegisterForType() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        registry.registerSchemaForType(TypeDescriptors.strings(), STRING_SCHEMA, (SerializableFunction & Serializable)s -> Row.withSchema((Schema)STRING_SCHEMA).addValue(s).build(), (SerializableFunction & Serializable)r -> r.getString("string"));
        registry.registerSchemaForType(TypeDescriptors.integers(), INTEGER_SCHEMA, (SerializableFunction & Serializable)s -> Row.withSchema((Schema)INTEGER_SCHEMA).addValue(s).build(), (SerializableFunction & Serializable)r -> r.getInt32("integer"));
        this.tryGetters(registry);
    }

    @Test
    public void testRegisterProvider() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        registry.registerSchemaProvider((SchemaProvider)new Provider());
        this.tryGetters(registry);
    }

    @Test
    public void testAutoSchemaProvider() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Assert.assertEquals((Object)EMPTY_SCHEMA, (Object)registry.getSchema(TestSchemaClass.class));
    }

    @Test
    public void testDefaultSchemaProvider() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Assert.assertEquals((Object)EMPTY_SCHEMA, (Object)registry.getSchema(TestDefaultSchemaClass.class));
    }

    static final class TestDefaultSchemaProvider
    implements SchemaProvider {
        TestDefaultSchemaProvider() {
        }

        public <T> Schema schemaFor(TypeDescriptor<T> typeDescriptor) {
            if (typeDescriptor.equals((Object)TypeDescriptor.of(TestDefaultSchemaClass.class))) {
                return EMPTY_SCHEMA;
            }
            return null;
        }

        public <T> SerializableFunction<T, Row> toRowFunction(TypeDescriptor<T> typeDescriptor) {
            if (typeDescriptor.equals((Object)TypeDescriptor.of(TestDefaultSchemaClass.class))) {
                return (SerializableFunction & Serializable)v -> Row.withSchema((Schema)EMPTY_SCHEMA).build();
            }
            return null;
        }

        public <T> SerializableFunction<Row, T> fromRowFunction(TypeDescriptor<T> typeDescriptor) {
            if (typeDescriptor.equals((Object)TypeDescriptor.of(TestDefaultSchemaClass.class))) {
                return (SerializableFunction & Serializable)r -> new TestSchemaClass();
            }
            return null;
        }
    }

    @DefaultSchema(value=TestDefaultSchemaProvider.class)
    static class TestDefaultSchemaClass {
        TestDefaultSchemaClass() {
        }
    }

    @AutoService(value=SchemaProviderRegistrar.class)
    public static class TestSchemaProviderRegistrar
    implements SchemaProviderRegistrar {
        public List<SchemaProvider> getSchemaProviders() {
            return ImmutableList.of(new TestAutoProvider());
        }
    }

    static final class TestAutoProvider
    implements SchemaProvider {
        TestAutoProvider() {
        }

        public <T> Schema schemaFor(TypeDescriptor<T> typeDescriptor) {
            if (typeDescriptor.equals((Object)TypeDescriptor.of(TestSchemaClass.class))) {
                return EMPTY_SCHEMA;
            }
            return null;
        }

        public <T> SerializableFunction<T, Row> toRowFunction(TypeDescriptor<T> typeDescriptor) {
            if (typeDescriptor.equals((Object)TypeDescriptor.of(TestSchemaClass.class))) {
                return (SerializableFunction & Serializable)v -> Row.withSchema((Schema)EMPTY_SCHEMA).build();
            }
            return null;
        }

        public <T> SerializableFunction<Row, T> fromRowFunction(TypeDescriptor<T> typeDescriptor) {
            if (typeDescriptor.equals((Object)TypeDescriptor.of(TestSchemaClass.class))) {
                return (SerializableFunction & Serializable)r -> new TestSchemaClass();
            }
            return null;
        }
    }

    static class TestSchemaClass {
        TestSchemaClass() {
        }
    }

    static final class Provider
    implements SchemaProvider {
        Provider() {
        }

        public <T> Schema schemaFor(TypeDescriptor<T> typeDescriptor) {
            if (typeDescriptor.equals((Object)TypeDescriptors.strings())) {
                return STRING_SCHEMA;
            }
            if (typeDescriptor.equals((Object)TypeDescriptors.integers())) {
                return INTEGER_SCHEMA;
            }
            return null;
        }

        public <T> SerializableFunction<T, Row> toRowFunction(TypeDescriptor<T> typeDescriptor) {
            return (SerializableFunction & Serializable)v -> Row.withSchema((Schema)this.schemaFor(typeDescriptor)).addValue(v).build();
        }

        public <T> SerializableFunction<Row, T> fromRowFunction(TypeDescriptor<T> typeDescriptor) {
            return (SerializableFunction & Serializable)r -> r.getValue(0);
        }
    }
}

