/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.primitives.Ints;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.utils.SchemaTestUtils;
import org.apache.beam.sdk.schemas.utils.TestPOJOs;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;

public class JavaFieldSchemaTest {
    static final DateTime DATE = DateTime.parse((String)"1979-03-14");
    static final Instant INSTANT = DateTime.parse((String)"1979-03-15").toInstant();
    static final byte[] BYTE_ARRAY = "bytearray".getBytes(Charset.defaultCharset());
    static final ByteBuffer BYTE_BUFFER = ByteBuffer.wrap("byteBuffer".getBytes(Charset.defaultCharset()));

    private TestPOJOs.SimplePOJO createSimple(String name) {
        return new TestPOJOs.SimplePOJO(name, 1, 2, 3, 4L, true, DATE, INSTANT, BYTE_ARRAY, BYTE_BUFFER, BigDecimal.ONE, new StringBuilder(name).append("builder"));
    }

    private Row createSimpleRow(String name) {
        return Row.withSchema((Schema)TestPOJOs.SIMPLE_POJO_SCHEMA).addValues(new Object[]{name, (byte)1, (short)2, 3, 4L, true, DATE, INSTANT, BYTE_ARRAY, BYTE_BUFFER.array(), BigDecimal.ONE, name + "builder"}).build();
    }

    @Test
    public void testSchema() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Schema schema = registry.getSchema(TestPOJOs.SimplePOJO.class);
        SchemaTestUtils.assertSchemaEquivalent(TestPOJOs.SIMPLE_POJO_SCHEMA, schema);
    }

    @Test
    public void testToRow() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        TestPOJOs.SimplePOJO pojo = this.createSimple("string");
        Row row = (Row)registry.getToRowFunction(TestPOJOs.SimplePOJO.class).apply((Object)pojo);
        Assert.assertEquals((long)12L, (long)row.getFieldCount());
        Assert.assertEquals((Object)"string", (Object)row.getString("str"));
        Assert.assertEquals((long)1L, (long)row.getByte("aByte"));
        Assert.assertEquals((long)2L, (long)row.getInt16("aShort"));
        Assert.assertEquals((long)3L, (long)row.getInt32("anInt"));
        Assert.assertEquals((long)4L, (long)row.getInt64("aLong"));
        Assert.assertEquals((Object)true, (Object)row.getBoolean("aBoolean"));
        Assert.assertEquals((Object)DATE.toInstant(), (Object)row.getDateTime("dateTime"));
        Assert.assertEquals((Object)INSTANT, (Object)row.getDateTime("instant").toInstant());
        Assert.assertArrayEquals((byte[])BYTE_ARRAY, (byte[])row.getBytes("bytes"));
        Assert.assertArrayEquals((byte[])BYTE_BUFFER.array(), (byte[])row.getBytes("byteBuffer"));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)row.getDecimal("bigDecimal"));
        Assert.assertEquals((Object)"stringbuilder", (Object)row.getString("stringBuilder"));
    }

    @Test
    public void testFromRow() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row row = this.createSimpleRow("string");
        TestPOJOs.SimplePOJO pojo = (TestPOJOs.SimplePOJO)registry.getFromRowFunction(TestPOJOs.SimplePOJO.class).apply((Object)row);
        Assert.assertEquals((Object)"string", (Object)pojo.str);
        Assert.assertEquals((long)1L, (long)pojo.aByte);
        Assert.assertEquals((long)2L, (long)pojo.aShort);
        Assert.assertEquals((long)3L, (long)pojo.anInt);
        Assert.assertEquals((long)4L, (long)pojo.aLong);
        Assert.assertEquals((Object)true, (Object)pojo.aBoolean);
        Assert.assertEquals((Object)DATE, (Object)pojo.dateTime);
        Assert.assertEquals((Object)INSTANT, (Object)pojo.instant);
        Assert.assertArrayEquals((String)"not equal", (byte[])BYTE_ARRAY, (byte[])pojo.bytes);
        Assert.assertEquals((Object)BYTE_BUFFER, (Object)pojo.byteBuffer);
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)pojo.bigDecimal);
        Assert.assertEquals((Object)"stringbuilder", (Object)pojo.stringBuilder.toString());
    }

    @Test
    public void testFromRowWithGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        TestPOJOs.SimplePOJO pojo = this.createSimple("string");
        Row row = (Row)registry.getToRowFunction(TestPOJOs.SimplePOJO.class).apply((Object)pojo);
        TestPOJOs.SimplePOJO extracted = (TestPOJOs.SimplePOJO)registry.getFromRowFunction(TestPOJOs.SimplePOJO.class).apply((Object)row);
        Assert.assertSame((Object)pojo, (Object)extracted);
    }

    @Test
    public void testRecursiveGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        SchemaTestUtils.assertSchemaEquivalent(TestPOJOs.NESTED_POJO_SCHEMA, registry.getSchema(TestPOJOs.NestedPOJO.class));
        TestPOJOs.NestedPOJO pojo = new TestPOJOs.NestedPOJO(this.createSimple("string"));
        Row row = (Row)registry.getToRowFunction(TestPOJOs.NestedPOJO.class).apply((Object)pojo);
        Row nestedRow = row.getRow("nested");
        Assert.assertEquals((Object)"string", (Object)nestedRow.getString("str"));
        Assert.assertEquals((long)1L, (long)nestedRow.getByte("aByte"));
        Assert.assertEquals((long)2L, (long)nestedRow.getInt16("aShort"));
        Assert.assertEquals((long)3L, (long)nestedRow.getInt32("anInt"));
        Assert.assertEquals((long)4L, (long)nestedRow.getInt64("aLong"));
        Assert.assertEquals((Object)true, (Object)nestedRow.getBoolean("aBoolean"));
        Assert.assertEquals((Object)DATE.toInstant(), (Object)nestedRow.getDateTime("dateTime"));
        Assert.assertEquals((Object)INSTANT, (Object)nestedRow.getDateTime("instant").toInstant());
        Assert.assertArrayEquals((String)"not equal", (byte[])BYTE_ARRAY, (byte[])nestedRow.getBytes("bytes"));
        Assert.assertArrayEquals((String)"not equal", (byte[])BYTE_BUFFER.array(), (byte[])nestedRow.getBytes("byteBuffer"));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)nestedRow.getDecimal("bigDecimal"));
        Assert.assertEquals((Object)"stringbuilder", (Object)nestedRow.getString("stringBuilder"));
    }

    @Test
    public void testRecursiveSetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row nestedRow = this.createSimpleRow("string");
        Row row = Row.withSchema((Schema)TestPOJOs.NESTED_POJO_SCHEMA).addValue((Object)nestedRow).build();
        TestPOJOs.NestedPOJO pojo = (TestPOJOs.NestedPOJO)registry.getFromRowFunction(TestPOJOs.NestedPOJO.class).apply((Object)row);
        Assert.assertEquals((Object)"string", (Object)pojo.nested.str);
        Assert.assertEquals((long)1L, (long)pojo.nested.aByte);
        Assert.assertEquals((long)2L, (long)pojo.nested.aShort);
        Assert.assertEquals((long)3L, (long)pojo.nested.anInt);
        Assert.assertEquals((long)4L, (long)pojo.nested.aLong);
        Assert.assertEquals((Object)true, (Object)pojo.nested.aBoolean);
        Assert.assertEquals((Object)DATE, (Object)pojo.nested.dateTime);
        Assert.assertEquals((Object)INSTANT, (Object)pojo.nested.instant);
        Assert.assertArrayEquals((String)"not equal", (byte[])BYTE_ARRAY, (byte[])pojo.nested.bytes);
        Assert.assertEquals((Object)BYTE_BUFFER, (Object)pojo.nested.byteBuffer);
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)pojo.nested.bigDecimal);
        Assert.assertEquals((Object)"stringbuilder", (Object)pojo.nested.stringBuilder.toString());
    }

    @Test
    public void testPrimitiveArrayGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        SchemaTestUtils.assertSchemaEquivalent(TestPOJOs.PRIMITIVE_ARRAY_POJO_SCHEMA, registry.getSchema(TestPOJOs.PrimitiveArrayPOJO.class));
        ImmutableList<String> strList = ImmutableList.of("a", "b", "c");
        int[] intArray = new int[]{1, 2, 3, 4};
        Long[] longArray = new Long[]{42L, 43L, 44L};
        TestPOJOs.PrimitiveArrayPOJO pojo = new TestPOJOs.PrimitiveArrayPOJO(strList, intArray, longArray);
        Row row = (Row)registry.getToRowFunction(TestPOJOs.PrimitiveArrayPOJO.class).apply((Object)pojo);
        Assert.assertEquals(strList, (Object)row.getArray("strings"));
        Assert.assertEquals(Ints.asList(intArray), (Object)row.getArray("integers"));
        Assert.assertEquals(Arrays.asList(longArray), (Object)row.getArray("longs"));
        Assert.assertSame((Object)row.getArray("strings"), (Object)row.getArray("strings"));
        Assert.assertSame((Object)row.getArray("integers"), (Object)row.getArray("integers"));
        Assert.assertSame((Object)row.getArray("longs"), (Object)row.getArray("longs"));
    }

    @Test
    public void testPrimitiveArraySetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row row = Row.withSchema((Schema)TestPOJOs.PRIMITIVE_ARRAY_POJO_SCHEMA).addArray(new Object[]{"a", "b", "c", "d"}).addArray(new Object[]{1, 2, 3, 4}).addArray(new Object[]{42L, 43L, 44L, 45L}).build();
        TestPOJOs.PrimitiveArrayPOJO pojo = (TestPOJOs.PrimitiveArrayPOJO)registry.getFromRowFunction(TestPOJOs.PrimitiveArrayPOJO.class).apply((Object)row);
        Assert.assertEquals((Object)row.getArray("strings"), pojo.strings);
        Assert.assertEquals((Object)row.getArray("integers"), Ints.asList(pojo.integers));
        Assert.assertEquals((Object)row.getArray("longs"), Arrays.asList(pojo.longs));
    }

    @Test
    public void testRecursiveArrayGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        SchemaTestUtils.assertSchemaEquivalent(TestPOJOs.NESTED_ARRAY_POJO_SCHEMA, registry.getSchema(TestPOJOs.NestedArrayPOJO.class));
        TestPOJOs.SimplePOJO simple1 = this.createSimple("string1");
        TestPOJOs.SimplePOJO simple2 = this.createSimple("string2");
        TestPOJOs.SimplePOJO simple3 = this.createSimple("string3");
        TestPOJOs.NestedArrayPOJO pojo = new TestPOJOs.NestedArrayPOJO(simple1, simple2, simple3);
        Row row = (Row)registry.getToRowFunction(TestPOJOs.NestedArrayPOJO.class).apply((Object)pojo);
        List rows = row.getArray("pojos");
        Assert.assertSame((Object)simple1, (Object)registry.getFromRowFunction(TestPOJOs.NestedArrayPOJO.class).apply((Object)((Row)rows.get(0))));
        Assert.assertSame((Object)simple2, (Object)registry.getFromRowFunction(TestPOJOs.NestedArrayPOJO.class).apply((Object)((Row)rows.get(1))));
        Assert.assertSame((Object)simple3, (Object)registry.getFromRowFunction(TestPOJOs.NestedArrayPOJO.class).apply((Object)((Row)rows.get(2))));
    }

    @Test
    public void testRecursiveArraySetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row row1 = this.createSimpleRow("string1");
        Row row2 = this.createSimpleRow("string2");
        Row row3 = this.createSimpleRow("string3");
        Row row = Row.withSchema((Schema)TestPOJOs.NESTED_ARRAY_POJO_SCHEMA).addArray(new Object[]{row1, row2, row3}).build();
        TestPOJOs.NestedArrayPOJO pojo = (TestPOJOs.NestedArrayPOJO)registry.getFromRowFunction(TestPOJOs.NestedArrayPOJO.class).apply((Object)row);
        Assert.assertEquals((long)3L, (long)pojo.pojos.length);
        Assert.assertEquals((Object)"string1", (Object)pojo.pojos[0].str);
        Assert.assertEquals((Object)"string2", (Object)pojo.pojos[1].str);
        Assert.assertEquals((Object)"string3", (Object)pojo.pojos[2].str);
    }

    @Test
    public void testNestedArraysGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        SchemaTestUtils.assertSchemaEquivalent(TestPOJOs.NESTED_ARRAYS_POJO_SCHEMA, registry.getSchema(TestPOJOs.NestedArraysPOJO.class));
        ArrayList<List<String>> listOfLists = Lists.newArrayList(Lists.newArrayList("a", "b", "c"), Lists.newArrayList("d", "e", "f"), Lists.newArrayList("g", "h", "i"));
        TestPOJOs.NestedArraysPOJO pojo = new TestPOJOs.NestedArraysPOJO(listOfLists);
        Row row = (Row)registry.getToRowFunction(TestPOJOs.NestedArraysPOJO.class).apply((Object)pojo);
        Assert.assertEquals(listOfLists, (Object)row.getArray("lists"));
    }

    @Test
    public void testNestedArraysSetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        ArrayList<List> listOfLists = Lists.newArrayList(Lists.newArrayList("a", "b", "c"), Lists.newArrayList("d", "e", "f"), Lists.newArrayList("g", "h", "i"));
        Row row = Row.withSchema((Schema)TestPOJOs.NESTED_ARRAYS_POJO_SCHEMA).addArray(listOfLists).build();
        TestPOJOs.NestedArraysPOJO pojo = (TestPOJOs.NestedArraysPOJO)registry.getFromRowFunction(TestPOJOs.NestedArraysPOJO.class).apply((Object)row);
        Assert.assertEquals(listOfLists, pojo.lists);
    }

    @Test
    public void testMapFieldGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        SchemaTestUtils.assertSchemaEquivalent(TestPOJOs.NESTED_MAP_POJO_SCHEMA, registry.getSchema(TestPOJOs.NestedMapPOJO.class));
        TestPOJOs.SimplePOJO simple1 = this.createSimple("string1");
        TestPOJOs.SimplePOJO simple2 = this.createSimple("string2");
        TestPOJOs.SimplePOJO simple3 = this.createSimple("string3");
        TestPOJOs.NestedMapPOJO pojo = new TestPOJOs.NestedMapPOJO(ImmutableMap.of("simple1", simple1, "simple2", simple2, "simple3", simple3));
        Row row = (Row)registry.getToRowFunction(TestPOJOs.NestedMapPOJO.class).apply((Object)pojo);
        Map extractedMap = row.getMap("map");
        Assert.assertEquals((long)3L, (long)extractedMap.size());
        Assert.assertEquals((Object)"string1", (Object)((Row)extractedMap.get("simple1")).getString("str"));
        Assert.assertEquals((Object)"string2", (Object)((Row)extractedMap.get("simple2")).getString("str"));
        Assert.assertEquals((Object)"string3", (Object)((Row)extractedMap.get("simple3")).getString("str"));
    }

    @Test
    public void testMapFieldSetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row row1 = this.createSimpleRow("string1");
        Row row2 = this.createSimpleRow("string2");
        Row row3 = this.createSimpleRow("string3");
        Row row = Row.withSchema((Schema)TestPOJOs.NESTED_MAP_POJO_SCHEMA).addValue(ImmutableMap.of("simple1", row1, "simple2", row2, "simple3", row3)).build();
        TestPOJOs.NestedMapPOJO pojo = (TestPOJOs.NestedMapPOJO)registry.getFromRowFunction(TestPOJOs.NestedMapPOJO.class).apply((Object)row);
        Assert.assertEquals((long)3L, (long)pojo.map.size());
        Assert.assertEquals((Object)"string1", (Object)pojo.map.get((Object)"simple1").str);
        Assert.assertEquals((Object)"string2", (Object)pojo.map.get((Object)"simple2").str);
        Assert.assertEquals((Object)"string3", (Object)pojo.map.get((Object)"simple3").str);
    }

    @Test
    public void testNullValuesGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row row = (Row)registry.getToRowFunction(TestPOJOs.POJOWithNullables.class).apply((Object)new TestPOJOs.POJOWithNullables(null, 42));
        Assert.assertNull((Object)row.getString("str"));
        Assert.assertEquals((long)42L, (long)row.getInt32("anInt"));
    }

    @Test
    public void testNullValuesSetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row row = Row.withSchema((Schema)TestPOJOs.NULLABLES_SCHEMA).addValues(new Object[]{null, 42}).build();
        TestPOJOs.POJOWithNullables pojo = (TestPOJOs.POJOWithNullables)registry.getFromRowFunction(TestPOJOs.POJOWithNullables.class).apply((Object)row);
        Assert.assertNull((Object)pojo.str);
        Assert.assertEquals((long)42L, (long)pojo.anInt);
    }

    @Test
    public void testNestedNullValuesGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row row = (Row)registry.getToRowFunction(TestPOJOs.POJOWithNestedNullable.class).apply((Object)new TestPOJOs.POJOWithNestedNullable(null));
        Assert.assertNull((Object)row.getValue("nested"));
    }

    @Test
    public void testNNestedullValuesSetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row row = Row.withSchema((Schema)TestPOJOs.NESTED_NULLABLE_SCHEMA).addValue(null).build();
        TestPOJOs.POJOWithNestedNullable pojo = (TestPOJOs.POJOWithNestedNullable)registry.getFromRowFunction(TestPOJOs.POJOWithNestedNullable.class).apply((Object)row);
        Assert.assertNull((Object)pojo.nested);
    }
}

