/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.primitives.Ints;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.utils.SchemaTestUtils;
import org.apache.beam.sdk.schemas.utils.TestJavaBeans;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class JavaBeanSchemaTest {
    static final DateTime DATE = DateTime.parse((String)"1979-03-14");
    static final byte[] BYTE_ARRAY = "bytearray".getBytes(Charset.defaultCharset());

    private TestJavaBeans.SimpleBean createSimple(String name) {
        return new TestJavaBeans.SimpleBean(name, 1, 2, 3, 4L, true, DATE, DATE.toInstant(), BYTE_ARRAY, BigDecimal.ONE, new StringBuilder(name).append("builder"));
    }

    private Row createSimpleRow(String name) {
        return Row.withSchema((Schema)TestJavaBeans.SIMPLE_BEAN_SCHEMA).addValues(new Object[]{name, (byte)1, (short)2, 3, 4L, true, DATE, DATE, BYTE_ARRAY, BYTE_ARRAY, BigDecimal.ONE, name + "builder"}).build();
    }

    @Test
    public void testSchema() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Schema schema = registry.getSchema(TestJavaBeans.SimpleBean.class);
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.SIMPLE_BEAN_SCHEMA, schema);
    }

    @Test
    public void testToRow() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        TestJavaBeans.SimpleBean bean = this.createSimple("string");
        Row row = (Row)registry.getToRowFunction(TestJavaBeans.SimpleBean.class).apply((Object)bean);
        Assert.assertEquals((long)12L, (long)row.getFieldCount());
        Assert.assertEquals((Object)"string", (Object)row.getString("str"));
        Assert.assertEquals((long)1L, (long)row.getByte("aByte"));
        Assert.assertEquals((long)2L, (long)row.getInt16("aShort"));
        Assert.assertEquals((long)3L, (long)row.getInt32("anInt"));
        Assert.assertEquals((long)4L, (long)row.getInt64("aLong"));
        Assert.assertEquals((Object)true, (Object)row.getBoolean("aBoolean"));
        Assert.assertEquals((Object)DATE.toInstant(), (Object)row.getDateTime("dateTime"));
        Assert.assertEquals((Object)DATE.toInstant(), (Object)row.getDateTime("instant"));
        Assert.assertArrayEquals((byte[])BYTE_ARRAY, (byte[])row.getBytes("bytes"));
        Assert.assertArrayEquals((byte[])BYTE_ARRAY, (byte[])row.getBytes("byteBuffer"));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)row.getDecimal("bigDecimal"));
        Assert.assertEquals((Object)"stringbuilder", (Object)row.getString("stringBuilder"));
    }

    @Test
    public void testFromRow() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row row = this.createSimpleRow("string");
        TestJavaBeans.SimpleBean bean = (TestJavaBeans.SimpleBean)registry.getFromRowFunction(TestJavaBeans.SimpleBean.class).apply((Object)row);
        Assert.assertEquals((Object)"string", (Object)bean.getStr());
        Assert.assertEquals((long)1L, (long)bean.getaByte());
        Assert.assertEquals((long)2L, (long)bean.getaShort());
        Assert.assertEquals((long)3L, (long)bean.getAnInt());
        Assert.assertEquals((long)4L, (long)bean.getaLong());
        Assert.assertEquals((Object)true, (Object)bean.isaBoolean());
        Assert.assertEquals((Object)DATE, (Object)bean.getDateTime());
        Assert.assertEquals((Object)DATE.toInstant(), (Object)bean.getInstant());
        Assert.assertArrayEquals((String)"not equal", (byte[])BYTE_ARRAY, (byte[])bean.getBytes());
        Assert.assertArrayEquals((String)"not equal", (byte[])BYTE_ARRAY, (byte[])bean.getByteBuffer().array());
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)bean.getBigDecimal());
        Assert.assertEquals((Object)"stringbuilder", (Object)bean.getStringBuilder().toString());
    }

    @Test
    public void testFromRowWithGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        TestJavaBeans.SimpleBean bean = this.createSimple("string");
        Row row = (Row)registry.getToRowFunction(TestJavaBeans.SimpleBean.class).apply((Object)bean);
        TestJavaBeans.SimpleBean extracted = (TestJavaBeans.SimpleBean)registry.getFromRowFunction(TestJavaBeans.SimpleBean.class).apply((Object)row);
        Assert.assertSame((Object)bean, (Object)extracted);
    }

    @Test
    public void testRecursiveGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.NESTED_BEAN_SCHEMA, registry.getSchema(TestJavaBeans.NestedBean.class));
        TestJavaBeans.NestedBean bean = new TestJavaBeans.NestedBean(this.createSimple("string"));
        Row row = (Row)registry.getToRowFunction(TestJavaBeans.NestedBean.class).apply((Object)bean);
        Row nestedRow = row.getRow("nested");
        Assert.assertEquals((Object)"string", (Object)nestedRow.getString("str"));
        Assert.assertEquals((long)1L, (long)nestedRow.getByte("aByte"));
        Assert.assertEquals((long)2L, (long)nestedRow.getInt16("aShort"));
        Assert.assertEquals((long)3L, (long)nestedRow.getInt32("anInt"));
        Assert.assertEquals((long)4L, (long)nestedRow.getInt64("aLong"));
        Assert.assertEquals((Object)true, (Object)nestedRow.getBoolean("aBoolean"));
        Assert.assertEquals((Object)DATE.toInstant(), (Object)nestedRow.getDateTime("dateTime"));
        Assert.assertEquals((Object)DATE.toInstant(), (Object)nestedRow.getDateTime("instant"));
        Assert.assertArrayEquals((String)"not equal", (byte[])BYTE_ARRAY, (byte[])nestedRow.getBytes("bytes"));
        Assert.assertArrayEquals((String)"not equal", (byte[])BYTE_ARRAY, (byte[])nestedRow.getBytes("byteBuffer"));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)nestedRow.getDecimal("bigDecimal"));
        Assert.assertEquals((Object)"stringbuilder", (Object)nestedRow.getString("stringBuilder"));
    }

    @Test
    public void testRecursiveSetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row nestedRow = this.createSimpleRow("string");
        Row row = Row.withSchema((Schema)TestJavaBeans.NESTED_BEAN_SCHEMA).addValue((Object)nestedRow).build();
        TestJavaBeans.NestedBean bean = (TestJavaBeans.NestedBean)registry.getFromRowFunction(TestJavaBeans.NestedBean.class).apply((Object)row);
        Assert.assertEquals((Object)"string", (Object)bean.getNested().getStr());
        Assert.assertEquals((long)1L, (long)bean.getNested().getaByte());
        Assert.assertEquals((long)2L, (long)bean.getNested().getaShort());
        Assert.assertEquals((long)3L, (long)bean.getNested().getAnInt());
        Assert.assertEquals((long)4L, (long)bean.getNested().getaLong());
        Assert.assertEquals((Object)true, (Object)bean.getNested().isaBoolean());
        Assert.assertEquals((Object)DATE, (Object)bean.getNested().getDateTime());
        Assert.assertEquals((Object)DATE.toInstant(), (Object)bean.getNested().getInstant());
        Assert.assertArrayEquals((String)"not equal", (byte[])BYTE_ARRAY, (byte[])bean.getNested().getBytes());
        Assert.assertArrayEquals((String)"not equal", (byte[])BYTE_ARRAY, (byte[])bean.getNested().getByteBuffer().array());
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)bean.getNested().getBigDecimal());
        Assert.assertEquals((Object)"stringbuilder", (Object)bean.getNested().getStringBuilder().toString());
    }

    @Test
    public void testPrimitiveArrayGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.PRIMITIVE_ARRAY_BEAN_SCHEMA, registry.getSchema(TestJavaBeans.PrimitiveArrayBean.class));
        ImmutableList<String> strList = ImmutableList.of("a", "b", "c");
        int[] intArray = new int[]{1, 2, 3, 4};
        Long[] longArray = new Long[]{42L, 43L, 44L};
        TestJavaBeans.PrimitiveArrayBean bean = new TestJavaBeans.PrimitiveArrayBean(strList, intArray, longArray);
        Row row = (Row)registry.getToRowFunction(TestJavaBeans.PrimitiveArrayBean.class).apply((Object)bean);
        Assert.assertEquals(strList, (Object)row.getArray("strings"));
        Assert.assertEquals(Ints.asList(intArray), (Object)row.getArray("integers"));
        Assert.assertEquals(Arrays.asList(longArray), (Object)row.getArray("longs"));
        Assert.assertSame((Object)row.getArray("strings"), (Object)row.getArray("strings"));
        Assert.assertSame((Object)row.getArray("integers"), (Object)row.getArray("integers"));
        Assert.assertSame((Object)row.getArray("longs"), (Object)row.getArray("longs"));
    }

    @Test
    public void testPrimitiveArraySetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row row = Row.withSchema((Schema)TestJavaBeans.PRIMITIVE_ARRAY_BEAN_SCHEMA).addArray(new Object[]{"a", "b", "c", "d"}).addArray(new Object[]{1, 2, 3, 4}).addArray(new Object[]{42L, 43L, 44L, 45L}).build();
        TestJavaBeans.PrimitiveArrayBean bean = (TestJavaBeans.PrimitiveArrayBean)registry.getFromRowFunction(TestJavaBeans.PrimitiveArrayBean.class).apply((Object)row);
        Assert.assertEquals((Object)row.getArray("strings"), bean.getStrings());
        Assert.assertEquals((Object)row.getArray("integers"), Ints.asList(bean.getIntegers()));
        Assert.assertEquals((Object)row.getArray("longs"), Arrays.asList(bean.getLongs()));
    }

    @Test
    public void testRecursiveArrayGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.NESTED_ARRAY_BEAN_SCHEMA, registry.getSchema(TestJavaBeans.NestedArrayBean.class));
        TestJavaBeans.SimpleBean simple1 = this.createSimple("string1");
        TestJavaBeans.SimpleBean simple2 = this.createSimple("string2");
        TestJavaBeans.SimpleBean simple3 = this.createSimple("string3");
        TestJavaBeans.NestedArrayBean bean = new TestJavaBeans.NestedArrayBean(simple1, simple2, simple3);
        Row row = (Row)registry.getToRowFunction(TestJavaBeans.NestedArrayBean.class).apply((Object)bean);
        List rows = row.getArray("beans");
        Assert.assertSame((Object)simple1, (Object)registry.getFromRowFunction(TestJavaBeans.NestedArrayBean.class).apply((Object)((Row)rows.get(0))));
        Assert.assertSame((Object)simple2, (Object)registry.getFromRowFunction(TestJavaBeans.NestedArrayBean.class).apply((Object)((Row)rows.get(1))));
        Assert.assertSame((Object)simple3, (Object)registry.getFromRowFunction(TestJavaBeans.NestedArrayBean.class).apply((Object)((Row)rows.get(2))));
    }

    @Test
    public void testRecursiveArraySetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row row1 = this.createSimpleRow("string1");
        Row row2 = this.createSimpleRow("string2");
        Row row3 = this.createSimpleRow("string3");
        Row row = Row.withSchema((Schema)TestJavaBeans.NESTED_ARRAY_BEAN_SCHEMA).addArray(new Object[]{row1, row2, row3}).build();
        TestJavaBeans.NestedArrayBean bean = (TestJavaBeans.NestedArrayBean)registry.getFromRowFunction(TestJavaBeans.NestedArrayBean.class).apply((Object)row);
        Assert.assertEquals((long)3L, (long)bean.getBeans().length);
        Assert.assertEquals((Object)"string1", (Object)bean.getBeans()[0].getStr());
        Assert.assertEquals((Object)"string2", (Object)bean.getBeans()[1].getStr());
        Assert.assertEquals((Object)"string3", (Object)bean.getBeans()[2].getStr());
    }

    @Test
    public void testNestedArraysGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.NESTED_ARRAYS_BEAM_SCHEMA, registry.getSchema(TestJavaBeans.NestedArraysBean.class));
        ArrayList<List<String>> listOfLists = Lists.newArrayList(Lists.newArrayList("a", "b", "c"), Lists.newArrayList("d", "e", "f"), Lists.newArrayList("g", "h", "i"));
        TestJavaBeans.NestedArraysBean bean = new TestJavaBeans.NestedArraysBean(listOfLists);
        Row row = (Row)registry.getToRowFunction(TestJavaBeans.NestedArraysBean.class).apply((Object)bean);
        Assert.assertEquals(listOfLists, (Object)row.getArray("lists"));
    }

    @Test
    public void testNestedArraysSetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        ArrayList<List> listOfLists = Lists.newArrayList(Lists.newArrayList("a", "b", "c"), Lists.newArrayList("d", "e", "f"), Lists.newArrayList("g", "h", "i"));
        Row row = Row.withSchema((Schema)TestJavaBeans.NESTED_ARRAYS_BEAM_SCHEMA).addArray(listOfLists).build();
        TestJavaBeans.NestedArraysBean bean = (TestJavaBeans.NestedArraysBean)registry.getFromRowFunction(TestJavaBeans.NestedArraysBean.class).apply((Object)row);
        Assert.assertEquals(listOfLists, bean.getLists());
    }

    @Test
    public void testMapFieldGetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        SchemaTestUtils.assertSchemaEquivalent(TestJavaBeans.NESTED_MAP_BEAN_SCHEMA, registry.getSchema(TestJavaBeans.NestedMapBean.class));
        TestJavaBeans.SimpleBean simple1 = this.createSimple("string1");
        TestJavaBeans.SimpleBean simple2 = this.createSimple("string2");
        TestJavaBeans.SimpleBean simple3 = this.createSimple("string3");
        TestJavaBeans.NestedMapBean bean = new TestJavaBeans.NestedMapBean(ImmutableMap.of("simple1", simple1, "simple2", simple2, "simple3", simple3));
        Row row = (Row)registry.getToRowFunction(TestJavaBeans.NestedMapBean.class).apply((Object)bean);
        Map extractedMap = row.getMap("map");
        Assert.assertEquals((long)3L, (long)extractedMap.size());
        Assert.assertEquals((Object)"string1", (Object)((Row)extractedMap.get("simple1")).getString("str"));
        Assert.assertEquals((Object)"string2", (Object)((Row)extractedMap.get("simple2")).getString("str"));
        Assert.assertEquals((Object)"string3", (Object)((Row)extractedMap.get("simple3")).getString("str"));
    }

    @Test
    public void testMapFieldSetters() throws NoSuchSchemaException {
        SchemaRegistry registry = SchemaRegistry.createDefault();
        Row row1 = this.createSimpleRow("string1");
        Row row2 = this.createSimpleRow("string2");
        Row row3 = this.createSimpleRow("string3");
        Row row = Row.withSchema((Schema)TestJavaBeans.NESTED_MAP_BEAN_SCHEMA).addValue(ImmutableMap.of("simple1", row1, "simple2", row2, "simple3", row3)).build();
        TestJavaBeans.NestedMapBean bean = (TestJavaBeans.NestedMapBean)registry.getFromRowFunction(TestJavaBeans.NestedMapBean.class).apply((Object)row);
        Assert.assertEquals((long)3L, (long)bean.getMap().size());
        Assert.assertEquals((Object)"string1", (Object)bean.getMap().get("simple1").getStr());
        Assert.assertEquals((Object)"string2", (Object)bean.getMap().get("simple2").getStr());
        Assert.assertEquals((Object)"string3", (Object)bean.getMap().get("simple3").getStr());
    }
}

