/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Sets;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.junit.Assert;
import org.junit.Test;

public class FieldAccessDescriptorTest {
    private static final Schema SIMPLE_SCHEMA = Schema.builder().addStringField("field0").addStringField("field1").addInt32Field("field2").addInt32Field("field3").build();
    private static final Schema NESTED_SCHEMA1 = Schema.builder().addStringField("field0").addRowField("field1", SIMPLE_SCHEMA).build();
    private static final Schema NESTED_SCHEMA2 = Schema.builder().addStringField("field0").addRowField("field1", NESTED_SCHEMA1).build();
    private static final Schema NESTED_ARRAY_SCHEMA = Schema.builder().addStringField("field0").addArrayField("field1", Schema.FieldType.row((Schema)SIMPLE_SCHEMA)).build();
    private static final Schema NESTED_MAP_SCHEMA = Schema.builder().addStringField("field0").addMapField("field1", Schema.FieldType.STRING, Schema.FieldType.row((Schema)SIMPLE_SCHEMA)).build();

    @Test
    public void testAllFields() {
        FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withAllFields();
        Assert.assertTrue((boolean)fieldAccessDescriptor.resolve(SIMPLE_SCHEMA).allFields());
    }

    @Test
    public void testFieldNames() {
        FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withFieldNames((String[])new String[]{"field0", "field2"}).resolve(SIMPLE_SCHEMA);
        Assert.assertEquals(Sets.newHashSet(0, 2), (Object)fieldAccessDescriptor.fieldIdsAccessed());
    }

    @Test
    public void testFieldIds() {
        FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withFieldIds((Integer[])new Integer[]{1, 3}).resolve(SIMPLE_SCHEMA);
        Assert.assertEquals(Sets.newHashSet(1, 3), (Object)fieldAccessDescriptor.fieldIdsAccessed());
    }

    @Test
    public void testNestedFieldByName() {
        FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withFieldNames((String[])new String[]{"field1"}).withNestedField("field1", FieldAccessDescriptor.withAllFields());
        fieldAccessDescriptor = fieldAccessDescriptor.resolve(NESTED_SCHEMA2);
        Assert.assertTrue((boolean)fieldAccessDescriptor.fieldIdsAccessed().isEmpty());
        Assert.assertEquals((long)1L, (long)fieldAccessDescriptor.nestedFields().size());
        FieldAccessDescriptor nestedAccess = (FieldAccessDescriptor)fieldAccessDescriptor.nestedFields().get(1);
        Assert.assertTrue((boolean)nestedAccess.allFields());
    }

    @Test
    public void testNestedFieldById() {
        FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withFieldNames((String[])new String[]{"field1"}).withNestedField(1, FieldAccessDescriptor.withAllFields());
        fieldAccessDescriptor = fieldAccessDescriptor.resolve(NESTED_SCHEMA2);
        Assert.assertTrue((boolean)fieldAccessDescriptor.fieldIdsAccessed().isEmpty());
        Assert.assertEquals((long)1L, (long)fieldAccessDescriptor.nestedFields().size());
        FieldAccessDescriptor nestedAccess = (FieldAccessDescriptor)fieldAccessDescriptor.nestedFields().get(1);
        Assert.assertTrue((boolean)nestedAccess.allFields());
    }

    @Test
    public void testPartialAccessNestedField() {
        FieldAccessDescriptor level1 = FieldAccessDescriptor.withFieldNames((String[])new String[]{"field2"});
        FieldAccessDescriptor level2 = FieldAccessDescriptor.withFieldNames((String[])new String[]{"field1"}).withNestedField("field1", level1);
        FieldAccessDescriptor level3 = FieldAccessDescriptor.withFieldNames((String[])new String[]{"field1"}).withNestedField("field1", level2);
        FieldAccessDescriptor resolved = level3.resolve(NESTED_SCHEMA2);
        Assert.assertTrue((boolean)resolved.fieldIdsAccessed().isEmpty());
        Assert.assertEquals((long)1L, (long)resolved.nestedFields().size());
        resolved = (FieldAccessDescriptor)resolved.nestedFields().get(1);
        Assert.assertTrue((boolean)resolved.fieldIdsAccessed().isEmpty());
        Assert.assertEquals((long)1L, (long)resolved.nestedFields().size());
        resolved = (FieldAccessDescriptor)resolved.nestedFields().get(1);
        Assert.assertEquals(Sets.newHashSet(2), (Object)resolved.fieldIdsAccessed());
    }

    @Test
    public void testArrayNestedField() {
        FieldAccessDescriptor level1 = FieldAccessDescriptor.withFieldNames((String[])new String[]{"field2"});
        FieldAccessDescriptor level2 = FieldAccessDescriptor.withFieldNames((String[])new String[]{"field1"}).withNestedField("field1", level1);
        FieldAccessDescriptor resolved = level2.resolve(NESTED_ARRAY_SCHEMA);
        Assert.assertTrue((boolean)resolved.fieldIdsAccessed().isEmpty());
        Assert.assertEquals((long)1L, (long)resolved.nestedFields().size());
        resolved = (FieldAccessDescriptor)resolved.nestedFields().get(1);
        Assert.assertEquals(Sets.newHashSet(2), (Object)resolved.fieldIdsAccessed());
    }

    @Test
    public void testMapNestedField() {
        FieldAccessDescriptor level1 = FieldAccessDescriptor.withFieldNames((String[])new String[]{"field2"});
        FieldAccessDescriptor level2 = FieldAccessDescriptor.withFieldNames((String[])new String[]{"field1"}).withNestedField("field1", level1);
        FieldAccessDescriptor resolved = level2.resolve(NESTED_MAP_SCHEMA);
        Assert.assertTrue((boolean)resolved.fieldIdsAccessed().isEmpty());
        Assert.assertEquals((long)1L, (long)resolved.nestedFields().size());
        resolved = (FieldAccessDescriptor)resolved.nestedFields().get(1);
        Assert.assertEquals(Sets.newHashSet(2), (Object)resolved.fieldIdsAccessed());
    }
}

