/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.runners;

import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Sample;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TransformTreeTest {
    @Rule
    public final TestPipeline p = TestPipeline.create();
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testCompositeCapture() throws Exception {
        this.p.enableAbandonedNodeEnforcement(false);
        File inputFile = this.tmpFolder.newFile();
        File outputFile = this.tmpFolder.newFile();
        final PTransform sample = Sample.fixedSizeGlobally((int)10);
        ((PCollection)((PCollection)((PCollection)this.p.apply("ReadMyFile", (PTransform)TextIO.read().from(inputFile.getPath()))).apply(sample)).apply((PTransform)Flatten.iterables())).apply("WriteMyFile", (PTransform)TextIO.write().to(outputFile.getPath()));
        final EnumSet<TransformsSeen> visited = EnumSet.noneOf(TransformsSeen.class);
        final EnumSet<TransformsSeen> left = EnumSet.noneOf(TransformsSeen.class);
        this.p.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                if (node.isRootNode()) {
                    return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
                }
                PTransform transform = node.getTransform();
                if (sample.getClass().equals(transform.getClass())) {
                    Assert.assertTrue((boolean)visited.add(TransformsSeen.SAMPLE));
                    Assert.assertNotNull((Object)node.getEnclosingNode());
                    Assert.assertTrue((boolean)node.isCompositeNode());
                } else if (transform instanceof WriteFiles) {
                    Assert.assertTrue((boolean)visited.add(TransformsSeen.WRITE));
                    Assert.assertNotNull((Object)node.getEnclosingNode());
                    Assert.assertTrue((boolean)node.isCompositeNode());
                }
                Assert.assertThat((Object)transform, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(Read.Bounded.class)));
                return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }

            public void leaveCompositeTransform(TransformHierarchy.Node node) {
                PTransform transform = node.getTransform();
                if (!node.isRootNode() && transform.getClass().equals(sample.getClass())) {
                    Assert.assertTrue((boolean)left.add(TransformsSeen.SAMPLE));
                }
            }

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                PTransform transform = node.getTransform();
                Assert.assertThat((Object)transform, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(Combine.Globally.class)));
                Assert.assertThat((Object)transform, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(WriteFiles.class)));
                if (transform instanceof Read.Bounded && node.getEnclosingNode().getTransform() instanceof TextIO.Read) {
                    Assert.assertTrue((boolean)visited.add(TransformsSeen.READ));
                }
            }
        });
        Assert.assertTrue((boolean)visited.equals(EnumSet.allOf(TransformsSeen.class)));
        Assert.assertTrue((boolean)left.equals(EnumSet.of(TransformsSeen.SAMPLE)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOutputChecking() throws Exception {
        this.p.enableAbandonedNodeEnforcement(false);
        this.p.apply((PTransform)new InvalidCompositeTransform());
        this.p.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){});
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMultiGraphSetup() {
        PCollection input = (PCollection)this.p.begin().apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        input.apply((PTransform)new UnboundOutputCreator());
        this.p.run();
    }

    private static class UnboundOutputCreator
    extends PTransform<PCollection<Integer>, PDone> {
        private UnboundOutputCreator() {
        }

        public PDone expand(PCollection<Integer> input) {
            input.apply(Count.perElement());
            return PDone.in((Pipeline)input.getPipeline());
        }
    }

    private static class InvalidCompositeTransform
    extends PTransform<PBegin, PCollectionList<String>> {
        private InvalidCompositeTransform() {
        }

        public PCollectionList<String> expand(PBegin b) {
            PCollection result = (PCollection)b.apply((PTransform)Create.of((Object)"hello", (Object[])new String[]{"world"}));
            return PCollectionList.of(Arrays.asList(result, PCollection.createPrimitiveOutputInternal((Pipeline)b.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)result.isBounded(), (Coder)StringUtf8Coder.of())));
        }
    }

    static enum TransformsSeen {
        READ,
        WRITE,
        SAMPLE;

    }
}

