/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.runners;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.CountingSource;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TaggedPValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TransformHierarchyTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create().enableAbandonedNodeEnforcement(false);
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    private transient TransformHierarchy hierarchy;

    @Before
    public void setup() {
        this.hierarchy = new TransformHierarchy();
    }

    @Test
    public void getCurrentNoPushReturnsRoot() {
        Assert.assertThat((Object)this.hierarchy.getCurrent().isRootNode(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void pushWithoutPushFails() {
        this.thrown.expect(IllegalStateException.class);
        this.hierarchy.popNode();
    }

    @Test
    public void pushThenPopSucceeds() {
        TransformHierarchy.Node root = this.hierarchy.getCurrent();
        TransformHierarchy.Node node = this.hierarchy.pushNode("Create", (PInput)PBegin.in((Pipeline)this.pipeline), (PTransform)Create.of((Object)1, (Object[])new Integer[0]));
        Assert.assertThat((Object)this.hierarchy.getCurrent(), (Matcher)Matchers.equalTo((Object)node));
        this.hierarchy.popNode();
        Assert.assertThat((Object)node.finishedSpecifying, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.hierarchy.getCurrent(), (Matcher)Matchers.equalTo((Object)root));
    }

    @Test
    public void emptyCompositeSucceeds() {
        PCollection created = PCollection.createPrimitiveOutputInternal((Pipeline)this.pipeline, (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED, (Coder)VarLongCoder.of());
        TransformHierarchy.Node node = this.hierarchy.pushNode("Create", (PInput)PBegin.in((Pipeline)this.pipeline), (PTransform)Create.of((Object)1, (Object[])new Integer[0]));
        this.hierarchy.setOutput((POutput)created);
        this.hierarchy.popNode();
        PCollectionList pcList = PCollectionList.of((PCollection)created);
        TransformHierarchy.Node emptyTransform = this.hierarchy.pushNode("Extract", (PInput)pcList, (PTransform)new PTransform<PCollectionList<Long>, PCollection<Long>>(){

            public PCollection<Long> expand(PCollectionList<Long> input) {
                return input.get(0);
            }
        });
        this.hierarchy.setOutput((POutput)created);
        this.hierarchy.popNode();
        Assert.assertThat((Object)this.hierarchy.getProducer((PValue)created), (Matcher)Matchers.equalTo((Object)node));
        Assert.assertThat((String)"A Transform that produces non-primitive output should be composite", (Object)emptyTransform.isCompositeNode(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void producingOwnAndOthersOutputsFails() {
        PCollection created = PCollection.createPrimitiveOutputInternal((Pipeline)this.pipeline, (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED, (Coder)VarLongCoder.of());
        this.hierarchy.pushNode("Create", (PInput)PBegin.in((Pipeline)this.pipeline), (PTransform)Create.of((Object)1, (Object[])new Integer[0]));
        this.hierarchy.setOutput((POutput)created);
        this.hierarchy.popNode();
        PCollectionList pcList = PCollectionList.of((PCollection)created);
        final PCollectionList appended = pcList.and(PCollection.createPrimitiveOutputInternal((Pipeline)this.pipeline, (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED, (Coder)VarLongCoder.of()).setName("prim"));
        this.hierarchy.pushNode("AddPc", (PInput)pcList, (PTransform)new PTransform<PCollectionList<Long>, PCollectionList<Long>>(){

            public PCollectionList<Long> expand(PCollectionList<Long> input) {
                return appended;
            }
        });
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("contains a primitive POutput produced by it");
        this.thrown.expectMessage("AddPc");
        this.thrown.expectMessage("Create");
        this.thrown.expectMessage(appended.expand().toString());
        this.hierarchy.setOutput((POutput)appended);
    }

    @Test
    public void producingOwnOutputWithCompositeFails() {
        final PCollection comp = PCollection.createPrimitiveOutputInternal((Pipeline)this.pipeline, (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED, (Coder)VarLongCoder.of());
        PTransform<PBegin, PCollection<Long>> root = new PTransform<PBegin, PCollection<Long>>(){

            public PCollection<Long> expand(PBegin input) {
                return comp;
            }
        };
        this.hierarchy.pushNode("Composite", (PInput)PBegin.in((Pipeline)this.pipeline), (PTransform)root);
        Create.Values create = Create.of((Object)1, (Object[])new Integer[0]);
        this.hierarchy.pushNode("Create", (PInput)PBegin.in((Pipeline)this.pipeline), (PTransform)create);
        this.hierarchy.setOutput(this.pipeline.apply((PTransform)create));
        this.hierarchy.popNode();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("contains a primitive POutput produced by it");
        this.thrown.expectMessage("primitive transforms are permitted to produce");
        this.thrown.expectMessage("Composite");
        this.hierarchy.setOutput((POutput)comp);
    }

    @Test
    public void replaceSucceeds() {
        PTransform<PInput, POutput> enclosingPT = new PTransform<PInput, POutput>(){

            public POutput expand(PInput input) {
                return PDone.in((Pipeline)input.getPipeline());
            }
        };
        TransformHierarchy.Node enclosing = this.hierarchy.pushNode("Enclosing", (PInput)PBegin.in((Pipeline)this.pipeline), (PTransform)enclosingPT);
        Create.Values originalTransform = Create.of((Object)1L, (Object[])new Long[0]);
        TransformHierarchy.Node original = this.hierarchy.pushNode("Create", (PInput)PBegin.in((Pipeline)this.pipeline), (PTransform)originalTransform);
        Assert.assertThat((Object)this.hierarchy.getCurrent(), (Matcher)Matchers.equalTo((Object)original));
        PCollection originalOutput = (PCollection)this.pipeline.apply((PTransform)originalTransform);
        this.hierarchy.setOutput((POutput)originalOutput);
        this.hierarchy.popNode();
        Assert.assertThat((Object)original.finishedSpecifying, (Matcher)Matchers.is((Object)true));
        this.hierarchy.setOutput((POutput)PDone.in((Pipeline)this.pipeline));
        this.hierarchy.popNode();
        Assert.assertThat((Object)this.hierarchy.getCurrent(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)enclosing)));
        Read.Bounded replacementTransform = Read.from((BoundedSource)CountingSource.upTo((long)1L));
        PCollection replacementOutput = (PCollection)this.pipeline.apply((PTransform)replacementTransform);
        TransformHierarchy.Node replacement = this.hierarchy.replaceNode(original, (PInput)PBegin.in((Pipeline)this.pipeline), (PTransform)replacementTransform);
        Assert.assertThat((Object)this.hierarchy.getCurrent(), (Matcher)Matchers.equalTo((Object)replacement));
        this.hierarchy.setOutput((POutput)replacementOutput);
        TaggedPValue taggedReplacement = TaggedPValue.ofExpandedValue((PValue)replacementOutput);
        Map<PCollection, PTransformOverrideFactory.ReplacementOutput> replacementOutputs = Collections.singletonMap(replacementOutput, PTransformOverrideFactory.ReplacementOutput.of((TaggedPValue)TaggedPValue.ofExpandedValue((PValue)originalOutput), (TaggedPValue)taggedReplacement));
        this.hierarchy.replaceOutputs(replacementOutputs);
        Assert.assertThat((Object)replacement.getInputs(), (Matcher)Matchers.equalTo((Object)original.getInputs()));
        Assert.assertThat((Object)replacement.getEnclosingNode(), (Matcher)Matchers.equalTo((Object)original.getEnclosingNode()));
        Assert.assertThat((Object)replacement.getEnclosingNode(), (Matcher)Matchers.equalTo((Object)enclosing));
        Assert.assertThat((Object)replacement.getTransform(), (Matcher)Matchers.equalTo((Object)replacementTransform));
        Assert.assertThat(replacement.getOutputs().keySet(), (Matcher)Matchers.contains((Object[])new TupleTag[]{taggedReplacement.getTag()}));
        Assert.assertThat(replacement.getOutputs().values(), (Matcher)Matchers.contains((Object[])new PValue[]{originalOutput}));
        this.hierarchy.popNode();
    }

    @Test
    public void replaceWithCompositeSucceeds() {
        ParDo.SingleOutput originalParDo = ParDo.of((DoFn)new DoFn<Long, Long>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctxt) {
                ctxt.output((Object)((Long)ctxt.element() + 1L));
            }
        });
        GenerateSequence genUpstream = GenerateSequence.from((long)0L);
        PCollection upstream = (PCollection)this.pipeline.apply((PTransform)genUpstream);
        PCollection output = (PCollection)upstream.apply("Original", (PTransform)originalParDo);
        this.hierarchy.pushNode("Upstream", (PInput)this.pipeline.begin(), (PTransform)genUpstream);
        this.hierarchy.finishSpecifyingInput();
        this.hierarchy.setOutput((POutput)upstream);
        this.hierarchy.popNode();
        TransformHierarchy.Node original = this.hierarchy.pushNode("Original", (PInput)upstream, (PTransform)originalParDo);
        this.hierarchy.finishSpecifyingInput();
        this.hierarchy.setOutput((POutput)output);
        this.hierarchy.popNode();
        final TupleTag longs = new TupleTag();
        final ParDo.MultiOutput replacementParDo = ParDo.of((DoFn)new DoFn<Long, Long>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctxt) {
                ctxt.output((Object)((Long)ctxt.element() + 1L));
            }
        }).withOutputTags(longs, TupleTagList.empty());
        PTransform<PCollection<Long>, PCollection<Long>> replacementComposite = new PTransform<PCollection<Long>, PCollection<Long>>(){

            public PCollection<Long> expand(PCollection<Long> input) {
                return ((PCollectionTuple)input.apply("Contained", (PTransform)replacementParDo)).get(longs);
            }
        };
        PCollectionTuple replacementOutput = (PCollectionTuple)upstream.apply("Contained", (PTransform)replacementParDo);
        TransformHierarchy.Node compositeNode = this.hierarchy.replaceNode(original, (PInput)upstream, (PTransform)replacementComposite);
        TransformHierarchy.Node replacementParNode = this.hierarchy.pushNode("Original/Contained", (PInput)upstream, (PTransform)replacementParDo);
        this.hierarchy.finishSpecifyingInput();
        this.hierarchy.setOutput((POutput)replacementOutput);
        this.hierarchy.popNode();
        this.hierarchy.setOutput((POutput)replacementOutput.get(longs));
        Map.Entry replacementLongs = Iterables.getOnlyElement(replacementOutput.expand().entrySet());
        this.hierarchy.replaceOutputs(Collections.singletonMap(replacementOutput.get(longs), PTransformOverrideFactory.ReplacementOutput.of((TaggedPValue)TaggedPValue.ofExpandedValue((PValue)output), (TaggedPValue)TaggedPValue.of((TupleTag)((TupleTag)replacementLongs.getKey()), (PValue)((PValue)replacementLongs.getValue())))));
        Assert.assertThat(replacementParNode.getOutputs().keySet(), (Matcher)Matchers.contains((Object[])new TupleTag[]{(TupleTag)replacementLongs.getKey()}));
        Assert.assertThat(replacementParNode.getOutputs().values(), (Matcher)Matchers.contains((Object[])new PValue[]{output}));
        Assert.assertThat(compositeNode.getOutputs().keySet(), (Matcher)Matchers.equalTo(replacementOutput.get(longs).expand().keySet()));
        Assert.assertThat(compositeNode.getOutputs().values(), (Matcher)Matchers.contains((Object[])new PValue[]{output}));
        this.hierarchy.popNode();
    }

    @Test
    public void visitVisitsAllPushed() {
        TransformHierarchy.Node root = this.hierarchy.getCurrent();
        PBegin begin = PBegin.in((Pipeline)this.pipeline);
        Create.Values create = Create.of((Object)1L, (Object[])new Long[0]);
        Read.Bounded read = Read.from((BoundedSource)CountingSource.upTo((long)1L));
        PCollection created = PCollection.createPrimitiveOutputInternal((Pipeline)this.pipeline, (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED, (Coder)VarLongCoder.of());
        ParDo.SingleOutput pardo = ParDo.of((DoFn)new DoFn<Long, Long>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctxt) {
                ctxt.output((Object)((Long)ctxt.element()));
            }
        });
        PCollection mapped = PCollection.createPrimitiveOutputInternal((Pipeline)this.pipeline, (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED, (Coder)VarLongCoder.of());
        TransformHierarchy.Node compositeNode = this.hierarchy.pushNode("Create", (PInput)begin, (PTransform)create);
        this.hierarchy.finishSpecifyingInput();
        Assert.assertThat((Object)this.hierarchy.getCurrent(), (Matcher)Matchers.equalTo((Object)compositeNode));
        Assert.assertThat(compositeNode.getInputs().entrySet(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)compositeNode.getTransform(), (Matcher)Matchers.equalTo((Object)create));
        Assert.assertThat(compositeNode.getOutputs().entrySet(), (Matcher)Matchers.emptyIterable());
        Assert.assertThat((Object)compositeNode.getEnclosingNode().isRootNode(), (Matcher)Matchers.is((Object)true));
        TransformHierarchy.Node primitiveNode = this.hierarchy.pushNode("Create/Read", (PInput)begin, (PTransform)read);
        Assert.assertThat((Object)this.hierarchy.getCurrent(), (Matcher)Matchers.equalTo((Object)primitiveNode));
        this.hierarchy.finishSpecifyingInput();
        this.hierarchy.setOutput((POutput)created);
        this.hierarchy.popNode();
        Assert.assertThat(primitiveNode.getOutputs().values(), (Matcher)Matchers.containsInAnyOrder((Object[])new PValue[]{created}));
        Assert.assertThat(primitiveNode.getInputs().entrySet(), (Matcher)Matchers.emptyIterable());
        Assert.assertThat((Object)primitiveNode.getTransform(), (Matcher)Matchers.equalTo((Object)read));
        Assert.assertThat((Object)primitiveNode.getEnclosingNode(), (Matcher)Matchers.equalTo((Object)compositeNode));
        this.hierarchy.setOutput((POutput)created);
        Assert.assertThat(compositeNode.getOutputs().values(), (Matcher)Matchers.containsInAnyOrder((Object[])new PValue[]{created}));
        Assert.assertThat((Object)this.hierarchy.getProducer((PValue)created), (Matcher)Matchers.equalTo((Object)primitiveNode));
        this.hierarchy.popNode();
        TransformHierarchy.Node otherPrimitive = this.hierarchy.pushNode("ParDo", (PInput)created, (PTransform)pardo);
        this.hierarchy.finishSpecifyingInput();
        this.hierarchy.setOutput((POutput)mapped);
        this.hierarchy.popNode();
        final HashSet visitedCompositeNodes = new HashSet();
        final HashSet visitedPrimitiveNodes = new HashSet();
        final HashSet visitedValuesInVisitor = new HashSet();
        Set visitedValues = this.hierarchy.visit((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                visitedCompositeNodes.add(node);
                return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                visitedPrimitiveNodes.add(node);
            }

            public void visitValue(PValue value, TransformHierarchy.Node producer) {
                visitedValuesInVisitor.add(value);
            }
        });
        Assert.assertThat(visitedCompositeNodes, (Matcher)Matchers.containsInAnyOrder((Object[])new TransformHierarchy.Node[]{root, compositeNode}));
        Assert.assertThat(visitedPrimitiveNodes, (Matcher)Matchers.containsInAnyOrder((Object[])new TransformHierarchy.Node[]{primitiveNode, otherPrimitive}));
        Assert.assertThat(visitedValuesInVisitor, (Matcher)Matchers.containsInAnyOrder((Object[])new PValue[]{created, mapped}));
        Assert.assertThat(visitedValuesInVisitor, (Matcher)Matchers.equalTo((Object)visitedValues));
    }

    @Test
    public void visitAfterReplace() {
        TransformHierarchy.Node root = this.hierarchy.getCurrent();
        ParDo.SingleOutput originalParDo = ParDo.of((DoFn)new DoFn<Long, Long>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctxt) {
                ctxt.output((Object)((Long)ctxt.element() + 1L));
            }
        });
        GenerateSequence genUpstream = GenerateSequence.from((long)0L);
        PCollection upstream = (PCollection)this.pipeline.apply((PTransform)genUpstream);
        PCollection output = (PCollection)upstream.apply("Original", (PTransform)originalParDo);
        TransformHierarchy.Node upstreamNode = this.hierarchy.pushNode("Upstream", (PInput)this.pipeline.begin(), (PTransform)genUpstream);
        this.hierarchy.finishSpecifyingInput();
        this.hierarchy.setOutput((POutput)upstream);
        this.hierarchy.popNode();
        TransformHierarchy.Node original = this.hierarchy.pushNode("Original", (PInput)upstream, (PTransform)originalParDo);
        this.hierarchy.finishSpecifyingInput();
        this.hierarchy.setOutput((POutput)output);
        this.hierarchy.popNode();
        final TupleTag longs = new TupleTag();
        final ParDo.MultiOutput replacementParDo = ParDo.of((DoFn)new DoFn<Long, Long>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctxt) {
                ctxt.output((Object)((Long)ctxt.element() + 1L));
            }
        }).withOutputTags(longs, TupleTagList.empty());
        PTransform<PCollection<Long>, PCollection<Long>> replacementComposite = new PTransform<PCollection<Long>, PCollection<Long>>(){

            public PCollection<Long> expand(PCollection<Long> input) {
                return ((PCollectionTuple)input.apply("Contained", (PTransform)replacementParDo)).get(longs);
            }
        };
        PCollectionTuple replacementOutput = (PCollectionTuple)upstream.apply("Contained", (PTransform)replacementParDo);
        TransformHierarchy.Node compositeNode = this.hierarchy.replaceNode(original, (PInput)upstream, (PTransform)replacementComposite);
        TransformHierarchy.Node replacementParNode = this.hierarchy.pushNode("Original/Contained", (PInput)upstream, (PTransform)replacementParDo);
        this.hierarchy.finishSpecifyingInput();
        this.hierarchy.setOutput((POutput)replacementOutput);
        this.hierarchy.popNode();
        this.hierarchy.setOutput((POutput)replacementOutput.get(longs));
        Map.Entry replacementLongs = Iterables.getOnlyElement(replacementOutput.expand().entrySet());
        this.hierarchy.replaceOutputs(Collections.singletonMap(replacementOutput.get(longs), PTransformOverrideFactory.ReplacementOutput.of((TaggedPValue)TaggedPValue.ofExpandedValue((PValue)output), (TaggedPValue)TaggedPValue.of((TupleTag)((TupleTag)replacementLongs.getKey()), (PValue)((PValue)replacementLongs.getValue())))));
        this.hierarchy.popNode();
        final HashSet visitedCompositeNodes = new HashSet();
        final HashSet visitedPrimitiveNodes = new HashSet();
        Set visitedValues = this.hierarchy.visit((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                visitedCompositeNodes.add(node);
                return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                visitedPrimitiveNodes.add(node);
            }
        });
        Assert.assertThat(visitedCompositeNodes, (Matcher)Matchers.containsInAnyOrder((Object[])new TransformHierarchy.Node[]{root, compositeNode}));
        Assert.assertThat(visitedPrimitiveNodes, (Matcher)Matchers.containsInAnyOrder((Object[])new TransformHierarchy.Node[]{upstreamNode, replacementParNode}));
        Assert.assertThat((Object)visitedValues, (Matcher)Matchers.containsInAnyOrder((Object[])new PValue[]{upstream, output}));
    }

    @Test
    public void visitIsTopologicallyOrdered() {
        PCollection one = PCollection.createPrimitiveOutputInternal((Pipeline)this.pipeline, (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED, (Coder)StringUtf8Coder.of());
        PCollection two = PCollection.createPrimitiveOutputInternal((Pipeline)this.pipeline, (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED, (Coder)VarIntCoder.of());
        final PDone done = PDone.in((Pipeline)this.pipeline);
        TupleTag<String> oneTag = new TupleTag<String>(){};
        TupleTag<Integer> twoTag = new TupleTag<Integer>(){};
        final PCollectionTuple oneAndTwo = PCollectionTuple.of((TupleTag)oneTag, (PCollection)one).and((TupleTag)twoTag, two);
        PTransform<PCollection<String>, PDone> multiConsumer = new PTransform<PCollection<String>, PDone>((TupleTag)twoTag, two){
            final /* synthetic */ TupleTag val$twoTag;
            final /* synthetic */ PCollection val$two;
            {
                this.val$twoTag = tupleTag;
                this.val$two = pCollection;
            }

            public PDone expand(PCollection<String> input) {
                return done;
            }

            public Map<TupleTag<?>, PValue> getAdditionalInputs() {
                return Collections.singletonMap(this.val$twoTag, this.val$two);
            }
        };
        this.hierarchy.pushNode("consumes_both", (PInput)one, (PTransform)multiConsumer);
        this.hierarchy.setOutput((POutput)done);
        this.hierarchy.popNode();
        PTransform<PBegin, PCollectionTuple> producer = new PTransform<PBegin, PCollectionTuple>(){

            public PCollectionTuple expand(PBegin input) {
                return oneAndTwo;
            }
        };
        this.hierarchy.pushNode("encloses_producer", (PInput)PBegin.in((Pipeline)this.pipeline), (PTransform)new PTransform<PBegin, PCollectionTuple>((PTransform)producer){
            final /* synthetic */ PTransform val$producer;
            {
                this.val$producer = pTransform;
            }

            public PCollectionTuple expand(PBegin input) {
                return (PCollectionTuple)input.apply(this.val$producer);
            }
        });
        this.hierarchy.pushNode("creates_one_and_two", (PInput)PBegin.in((Pipeline)this.pipeline), (PTransform)producer);
        this.hierarchy.setOutput((POutput)oneAndTwo);
        this.hierarchy.popNode();
        this.hierarchy.setOutput((POutput)oneAndTwo);
        this.hierarchy.popNode();
        this.hierarchy.pushNode("second_copy_of_consumes_both", (PInput)one, (PTransform)multiConsumer);
        this.hierarchy.setOutput((POutput)done);
        this.hierarchy.popNode();
        final HashSet visitedNodes = new HashSet();
        final HashSet exitedNodes = new HashSet();
        final HashSet visitedValues = new HashSet();
        this.hierarchy.visit((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                for (PValue input : node.getInputs().values()) {
                    Assert.assertThat((Object)visitedValues, (Matcher)Matchers.hasItem((Object)input));
                }
                Assert.assertThat((String)"Nodes should not be visited more than once", (Object)visitedNodes, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)node)));
                if (!node.isRootNode()) {
                    Assert.assertThat((String)"Nodes should always be visited after their enclosing nodes", (Object)visitedNodes, (Matcher)Matchers.hasItem((Object)node.getEnclosingNode()));
                }
                visitedNodes.add(node);
                return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }

            public void leaveCompositeTransform(TransformHierarchy.Node node) {
                Assert.assertThat((Object)visitedNodes, (Matcher)Matchers.hasItem((Object)node));
                if (!node.isRootNode()) {
                    Assert.assertThat((String)"Nodes should always be left before their enclosing nodes are left", (Object)exitedNodes, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)node.getEnclosingNode())));
                }
                Assert.assertThat((Object)exitedNodes, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)node)));
                exitedNodes.add(node);
            }

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                Assert.assertThat((Object)visitedNodes, (Matcher)Matchers.hasItem((Object)node.getEnclosingNode()));
                Assert.assertThat((Object)exitedNodes, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)node.getEnclosingNode())));
                Assert.assertThat((String)"Nodes should not be visited more than once", (Object)visitedNodes, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)node)));
                for (PValue input : node.getInputs().values()) {
                    Assert.assertThat((Object)visitedValues, (Matcher)Matchers.hasItem((Object)input));
                }
                visitedNodes.add(node);
            }

            public void visitValue(PValue value, TransformHierarchy.Node producer) {
                Assert.assertThat((Object)visitedNodes, (Matcher)Matchers.hasItem((Object)producer));
                Assert.assertThat((Object)visitedValues, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)value)));
                visitedValues.add(value);
            }
        });
        Assert.assertThat((String)"Should have visited all the nodes", (Object)visitedNodes.size(), (Matcher)Matchers.equalTo((Object)5));
        Assert.assertThat((String)"Should have left all of the visited composites", (Object)exitedNodes.size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void visitDoesNotVisitSkippedNodes() {
        PCollection one = PCollection.createPrimitiveOutputInternal((Pipeline)this.pipeline, (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED, (Coder)StringUtf8Coder.of());
        PCollection two = PCollection.createPrimitiveOutputInternal((Pipeline)this.pipeline, (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED, (Coder)VarIntCoder.of());
        final PDone done = PDone.in((Pipeline)this.pipeline);
        TupleTag<String> oneTag = new TupleTag<String>(){};
        TupleTag<Integer> twoTag = new TupleTag<Integer>(){};
        final PCollectionTuple oneAndTwo = PCollectionTuple.of((TupleTag)oneTag, (PCollection)one).and((TupleTag)twoTag, two);
        this.hierarchy.pushNode("consumes_both", (PInput)one, (PTransform)new PTransform<PCollection<String>, PDone>((TupleTag)twoTag, two){
            final /* synthetic */ TupleTag val$twoTag;
            final /* synthetic */ PCollection val$two;
            {
                this.val$twoTag = tupleTag;
                this.val$two = pCollection;
            }

            public PDone expand(PCollection<String> input) {
                return done;
            }

            public Map<TupleTag<?>, PValue> getAdditionalInputs() {
                return Collections.singletonMap(this.val$twoTag, this.val$two);
            }
        });
        this.hierarchy.setOutput((POutput)done);
        this.hierarchy.popNode();
        PTransform<PBegin, PCollectionTuple> producer = new PTransform<PBegin, PCollectionTuple>(){

            public PCollectionTuple expand(PBegin input) {
                return oneAndTwo;
            }
        };
        final TransformHierarchy.Node enclosing = this.hierarchy.pushNode("encloses_producer", (PInput)PBegin.in((Pipeline)this.pipeline), (PTransform)new PTransform<PBegin, PCollectionTuple>((PTransform)producer){
            final /* synthetic */ PTransform val$producer;
            {
                this.val$producer = pTransform;
            }

            public PCollectionTuple expand(PBegin input) {
                return (PCollectionTuple)input.apply(this.val$producer);
            }
        });
        TransformHierarchy.Node enclosed = this.hierarchy.pushNode("creates_one_and_two", (PInput)PBegin.in((Pipeline)this.pipeline), (PTransform)producer);
        this.hierarchy.setOutput((POutput)oneAndTwo);
        this.hierarchy.popNode();
        this.hierarchy.setOutput((POutput)oneAndTwo);
        this.hierarchy.popNode();
        final HashSet visitedNodes = new HashSet();
        this.hierarchy.visit((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                visitedNodes.add(node);
                return node.equals(enclosing) ? Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM : Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                visitedNodes.add(node);
            }
        });
        Assert.assertThat(visitedNodes, (Matcher)Matchers.hasItem((Object)enclosing));
        Assert.assertThat(visitedNodes, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)enclosed)));
    }
}

