/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.runners;

import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricResultsMatchers;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.CrashingRunner;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PipelineRunnerTest {
    @Test
    public void testInstantiation() {
        PipelineOptions options = PipelineOptionsFactory.create();
        options.setRunner(CrashingRunner.class);
        PipelineRunner runner = PipelineRunner.fromOptions((PipelineOptions)options);
        Assert.assertTrue((boolean)(runner instanceof CrashingRunner));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testRunPTransform() {
        String namespace = PipelineRunnerTest.class.getName();
        final Counter counter = Metrics.counter((String)namespace, (String)"count");
        PipelineResult result = PipelineRunner.create().run((PTransform)new PTransform<PBegin, POutput>(){

            public POutput expand(PBegin input) {
                PCollection output = (PCollection)((PCollection)input.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}))).apply("ScaleByTwo", (PTransform)MapElements.via(new ScaleFn(2.0, counter)));
                PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Double[]{2.0, 4.0, 6.0, 8.0});
                return output;
            }
        });
        Assert.assertThat((Object)result.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.inNamespace((String)namespace)).build()).getCounters(), (Matcher)Matchers.hasItem(MetricResultsMatchers.metricsResult(namespace, "count", "ScaleByTwo", 4L, true)));
    }

    private static class ScaleFn<T extends Number>
    extends SimpleFunction<T, Double> {
        private final double scalar;
        private final Counter counter;

        public ScaleFn(double scalar, Counter counter) {
            this.scalar = scalar;
            this.counter = counter;
        }

        public Double apply(T input) {
            this.counter.inc();
            return this.scalar * ((Number)input).doubleValue();
        }
    }
}

