/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProviders;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ValueProvidersTest {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));

    @Test
    public void testUpdateSerialize() throws Exception {
        TestOptions submitOptions = (TestOptions)PipelineOptionsFactory.as(TestOptions.class);
        String serializedOptions = MAPPER.writeValueAsString((Object)submitOptions);
        String updatedOptions = ValueProviders.updateSerializedOptions((String)serializedOptions, ImmutableMap.of("string", "bar"));
        TestOptions runtime = (TestOptions)((PipelineOptions)MAPPER.readValue(updatedOptions, PipelineOptions.class)).as(TestOptions.class);
        Assert.assertEquals((Object)"bar", (Object)runtime.getString());
    }

    @Test
    public void testUpdateSerializeExistingValue() throws Exception {
        TestOptions submitOptions = (TestOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--string=baz", "--otherString=quux"}).as(TestOptions.class);
        String serializedOptions = MAPPER.writeValueAsString((Object)submitOptions);
        String updatedOptions = ValueProviders.updateSerializedOptions((String)serializedOptions, ImmutableMap.of("string", "bar"));
        TestOptions runtime = (TestOptions)((PipelineOptions)MAPPER.readValue(updatedOptions, PipelineOptions.class)).as(TestOptions.class);
        Assert.assertEquals((Object)"bar", (Object)runtime.getString());
        Assert.assertEquals((Object)"quux", (Object)runtime.getOtherString());
    }

    @Test
    public void testUpdateSerializeEmptyUpdate() throws Exception {
        TestOptions submitOptions = (TestOptions)PipelineOptionsFactory.as(TestOptions.class);
        String serializedOptions = MAPPER.writeValueAsString((Object)submitOptions);
        String updatedOptions = ValueProviders.updateSerializedOptions((String)serializedOptions, ImmutableMap.of());
        TestOptions runtime = (TestOptions)((PipelineOptions)MAPPER.readValue(updatedOptions, PipelineOptions.class)).as(TestOptions.class);
        Assert.assertNull((Object)runtime.getString());
    }

    public static interface TestOptions
    extends PipelineOptions {
        public String getString();

        public void setString(String var1);

        public String getOtherString();

        public void setOtherString(String var1);
    }
}

