/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ValueProviderTest {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testCommandLineNoDefault() {
        TestOptions options = (TestOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--foo=baz"}).as(TestOptions.class);
        ValueProvider<String> provider = options.getFoo();
        Assert.assertEquals((Object)"baz", (Object)provider.get());
        Assert.assertTrue((boolean)provider.isAccessible());
    }

    @Test
    public void testListValueProvider() {
        TestOptions options = (TestOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--list=1,2,3"}).as(TestOptions.class);
        ValueProvider<List<Integer>> provider = options.getList();
        Assert.assertEquals(ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), (Object)provider.get());
        Assert.assertTrue((boolean)provider.isAccessible());
    }

    @Test
    public void testCommandLineWithDefault() {
        TestOptions options = (TestOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--bar=baz"}).as(TestOptions.class);
        ValueProvider<String> provider = options.getBar();
        Assert.assertEquals((Object)"baz", (Object)provider.get());
        Assert.assertTrue((boolean)provider.isAccessible());
    }

    @Test
    public void testStaticValueProvider() {
        ValueProvider.StaticValueProvider provider = ValueProvider.StaticValueProvider.of((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)provider.get());
        Assert.assertTrue((boolean)provider.isAccessible());
        Assert.assertEquals((Object)"foo", (Object)provider.toString());
    }

    @Test
    public void testNoDefaultRuntimeProvider() {
        TestOptions options = (TestOptions)PipelineOptionsFactory.as(TestOptions.class);
        ValueProvider<String> provider = options.getFoo();
        Assert.assertFalse((boolean)provider.isAccessible());
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Value only available at runtime");
        this.expectedException.expectMessage("foo");
        provider.get();
    }

    @Test
    public void testRuntimePropertyName() {
        TestOptions options = (TestOptions)PipelineOptionsFactory.as(TestOptions.class);
        ValueProvider<String> provider = options.getFoo();
        Assert.assertEquals((Object)"foo", (Object)((ValueProvider.RuntimeValueProvider)provider).propertyName());
        Assert.assertEquals((Object)"RuntimeValueProvider{propertyName=foo, default=null}", (Object)provider.toString());
    }

    @Test
    public void testDefaultRuntimeProvider() {
        TestOptions options = (TestOptions)PipelineOptionsFactory.as(TestOptions.class);
        ValueProvider<String> provider = options.getBar();
        Assert.assertFalse((boolean)provider.isAccessible());
    }

    @Test
    public void testNoDefaultRuntimeProviderWithOverride() throws Exception {
        TestOptions runtime = (TestOptions)((PipelineOptions)MAPPER.readValue("{ \"options\": { \"foo\": \"quux\" }}", PipelineOptions.class)).as(TestOptions.class);
        TestOptions options = (TestOptions)PipelineOptionsFactory.as(TestOptions.class);
        runtime.setOptionsId(options.getOptionsId());
        ValueProvider.RuntimeValueProvider.setRuntimeOptions((PipelineOptions)runtime);
        ValueProvider<String> provider = options.getFoo();
        Assert.assertTrue((boolean)provider.isAccessible());
        Assert.assertEquals((Object)"quux", (Object)provider.get());
    }

    @Test
    public void testDefaultRuntimeProviderWithOverride() throws Exception {
        TestOptions runtime = (TestOptions)((PipelineOptions)MAPPER.readValue("{ \"options\": { \"bar\": \"quux\" }}", PipelineOptions.class)).as(TestOptions.class);
        TestOptions options = (TestOptions)PipelineOptionsFactory.as(TestOptions.class);
        runtime.setOptionsId(options.getOptionsId());
        ValueProvider.RuntimeValueProvider.setRuntimeOptions((PipelineOptions)runtime);
        ValueProvider<String> provider = options.getBar();
        Assert.assertTrue((boolean)provider.isAccessible());
        Assert.assertEquals((Object)"quux", (Object)provider.get());
    }

    @Test
    public void testDefaultRuntimeProviderWithoutOverride() throws Exception {
        TestOptions runtime = (TestOptions)PipelineOptionsFactory.as(TestOptions.class);
        TestOptions options = (TestOptions)PipelineOptionsFactory.as(TestOptions.class);
        runtime.setOptionsId(options.getOptionsId());
        ValueProvider.RuntimeValueProvider.setRuntimeOptions((PipelineOptions)runtime);
        ValueProvider<String> provider = options.getBar();
        Assert.assertTrue((boolean)provider.isAccessible());
        Assert.assertEquals((Object)"bar", (Object)provider.get());
    }

    @Test
    public void testOptionReturnTypeRuntime() {
        BadOptionsRuntime options = (BadOptionsRuntime)PipelineOptionsFactory.as(BadOptionsRuntime.class);
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Method getBar should not have return type RuntimeValueProvider, use ValueProvider instead.");
        options.getBar();
    }

    @Test
    public void testOptionReturnTypeStatic() {
        BadOptionsStatic options = (BadOptionsStatic)PipelineOptionsFactory.as(BadOptionsStatic.class);
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Method getBar should not have return type StaticValueProvider, use ValueProvider instead.");
        options.getBar();
    }

    @Test
    public void testSerializeDeserializeNoArg() throws Exception {
        TestOptions submitOptions = (TestOptions)PipelineOptionsFactory.as(TestOptions.class);
        Assert.assertFalse((boolean)submitOptions.getFoo().isAccessible());
        ObjectNode root = (ObjectNode)MAPPER.valueToTree((Object)submitOptions);
        ((ObjectNode)root.get("options")).put("foo", "quux");
        TestOptions runtime = (TestOptions)((PipelineOptions)MAPPER.convertValue((Object)root, PipelineOptions.class)).as(TestOptions.class);
        ValueProvider<String> vp = runtime.getFoo();
        Assert.assertTrue((boolean)vp.isAccessible());
        Assert.assertEquals((Object)"quux", (Object)vp.get());
        Assert.assertEquals(vp.getClass(), ValueProvider.StaticValueProvider.class);
    }

    @Test
    public void testSerializeDeserializeWithArg() throws Exception {
        TestOptions submitOptions = (TestOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--foo=baz"}).as(TestOptions.class);
        Assert.assertTrue((boolean)submitOptions.getFoo().isAccessible());
        Assert.assertEquals((Object)"baz", (Object)submitOptions.getFoo().get());
        ObjectNode root = (ObjectNode)MAPPER.valueToTree((Object)submitOptions);
        ((ObjectNode)root.get("options")).put("foo", "quux");
        TestOptions runtime = (TestOptions)((PipelineOptions)MAPPER.convertValue((Object)root, PipelineOptions.class)).as(TestOptions.class);
        ValueProvider<String> vp = runtime.getFoo();
        Assert.assertTrue((boolean)vp.isAccessible());
        Assert.assertEquals((Object)"quux", (Object)vp.get());
    }

    @Test
    public void testNestedValueProviderStatic() throws Exception {
        ValueProvider.StaticValueProvider svp = ValueProvider.StaticValueProvider.of((Object)"foo");
        ValueProvider.NestedValueProvider nvp = ValueProvider.NestedValueProvider.of((ValueProvider)svp, (SerializableFunction & Serializable)from -> from + "bar");
        Assert.assertTrue((boolean)nvp.isAccessible());
        Assert.assertEquals((Object)"foobar", (Object)nvp.get());
        Assert.assertEquals((Object)"foobar", (Object)nvp.toString());
    }

    @Test
    public void testNestedValueProviderRuntime() throws Exception {
        TestOptions options = (TestOptions)PipelineOptionsFactory.as(TestOptions.class);
        ValueProvider<String> rvp = options.getBar();
        ValueProvider.NestedValueProvider nvp = ValueProvider.NestedValueProvider.of(rvp, (SerializableFunction & Serializable)from -> from + "bar");
        ValueProvider.NestedValueProvider doubleNvp = ValueProvider.NestedValueProvider.of((ValueProvider)nvp, (SerializableFunction & Serializable)from -> from);
        Assert.assertEquals((Object)"bar", (Object)nvp.propertyName());
        Assert.assertEquals((Object)"bar", (Object)doubleNvp.propertyName());
        Assert.assertFalse((boolean)nvp.isAccessible());
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Value only available at runtime");
        nvp.get();
    }

    @Test
    public void testNestedValueProviderSerialize() throws Exception {
        ValueProvider.NestedValueProvider nvp = ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"foo"), (SerializableFunction)new NonSerializableTranslator());
        SerializableUtils.ensureSerializable((Serializable)nvp);
    }

    @Test
    public void testNestedValueProviderCached() throws Exception {
        AtomicInteger increment = new AtomicInteger();
        ValueProvider.NestedValueProvider nvp = ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)increment), (SerializableFunction)new IncrementAtomicIntegerTranslator());
        Integer originalValue = (Integer)nvp.get();
        Integer cachedValue = (Integer)nvp.get();
        Integer incrementValue = increment.incrementAndGet();
        Integer secondCachedValue = (Integer)nvp.get();
        Assert.assertEquals((Object)originalValue, (Object)cachedValue);
        Assert.assertEquals((Object)secondCachedValue, (Object)cachedValue);
        Assert.assertNotEquals((Object)originalValue, (Object)incrementValue);
    }

    private static class IncrementAtomicIntegerTranslator
    implements SerializableFunction<AtomicInteger, Integer> {
        private IncrementAtomicIntegerTranslator() {
        }

        public Integer apply(AtomicInteger from) {
            return from.incrementAndGet();
        }
    }

    private static class NonSerializableTranslator
    implements SerializableFunction<String, NonSerializable> {
        private NonSerializableTranslator() {
        }

        public NonSerializable apply(String from) {
            return new NonSerializable();
        }
    }

    private static class NonSerializable {
        private NonSerializable() {
        }
    }

    public static interface BadOptionsStatic
    extends PipelineOptions {
        public ValueProvider.StaticValueProvider<String> getBar();

        public void setBar(ValueProvider.StaticValueProvider<String> var1);
    }

    public static interface BadOptionsRuntime
    extends PipelineOptions {
        public ValueProvider.RuntimeValueProvider<String> getBar();

        public void setBar(ValueProvider.RuntimeValueProvider<String> var1);
    }

    public static interface TestOptions
    extends PipelineOptions {
        @Default.String(value="bar")
        public ValueProvider<String> getBar();

        public void setBar(ValueProvider<String> var1);

        public ValueProvider<String> getFoo();

        public void setFoo(ValueProvider<String> var1);

        public ValueProvider<List<Integer>> getList();

        public void setList(ValueProvider<List<Integer>> var1);
    }
}

