/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.options.SdkHarnessOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SdkHarnessOptionsTest {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSdkHarnessLogLevelOverrideWithInvalidLogLevel() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Unsupported log level");
        SdkHarnessOptions.SdkHarnessLogLevelOverrides.from(ImmutableMap.of("Name", "FakeLevel"));
    }

    @Test
    public void testSdkHarnessLogLevelOverrideForClass() throws Exception {
        Assert.assertEquals((Object)"{\"org.junit.Test\":\"WARN\"}", (Object)MAPPER.writeValueAsString((Object)new SdkHarnessOptions.SdkHarnessLogLevelOverrides().addOverrideForClass(Test.class, SdkHarnessOptions.LogLevel.WARN)));
    }

    @Test
    public void testSdkHarnessLogLevelOverrideForPackage() throws Exception {
        Assert.assertEquals((Object)"{\"org.junit\":\"WARN\"}", (Object)MAPPER.writeValueAsString((Object)new SdkHarnessOptions.SdkHarnessLogLevelOverrides().addOverrideForPackage(Test.class.getPackage(), SdkHarnessOptions.LogLevel.WARN)));
    }

    @Test
    public void testSdkHarnessLogLevelOverrideForName() throws Exception {
        Assert.assertEquals((Object)"{\"A\":\"WARN\"}", (Object)MAPPER.writeValueAsString((Object)new SdkHarnessOptions.SdkHarnessLogLevelOverrides().addOverrideForName("A", SdkHarnessOptions.LogLevel.WARN)));
    }

    @Test
    public void testSerializationAndDeserializationOf() throws Exception {
        String testValue = "{\"A\":\"WARN\"}";
        Assert.assertEquals((Object)testValue, (Object)MAPPER.writeValueAsString(MAPPER.readValue(testValue, SdkHarnessOptions.SdkHarnessLogLevelOverrides.class)));
    }
}

