/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.testing.EqualsTester;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableSet;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Maps;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ProxyInvocationHandler;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProxyInvocationHandlerTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TestRule resetPipelineOptionsRegistry = new ExternalResource(){

        protected void before() {
            PipelineOptionsFactory.resetCache();
        }
    };
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    @Rule
    public TestPipeline p = TestPipeline.create();

    @Test
    public void testPropertySettingAndGetting() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        Simple proxy = (Simple)handler.as(Simple.class);
        proxy.setString("OBJECT");
        proxy.setOptionEnabled(true);
        proxy.setPrimitive(4);
        Assert.assertEquals((Object)"OBJECT", (Object)proxy.getString());
        Assert.assertTrue((boolean)proxy.isOptionEnabled());
        Assert.assertEquals((long)4L, (long)proxy.getPrimitive());
    }

    @Test
    public void testGettingJLSDefaults() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        JLSDefaults proxy = (JLSDefaults)handler.as(JLSDefaults.class);
        Assert.assertFalse((boolean)proxy.getBoolean());
        Assert.assertEquals((long)0L, (long)proxy.getChar());
        Assert.assertEquals((long)0L, (long)proxy.getByte());
        Assert.assertEquals((long)0L, (long)proxy.getShort());
        Assert.assertEquals((long)0L, (long)proxy.getInt());
        Assert.assertEquals((long)0L, (long)proxy.getLong());
        Assert.assertEquals((float)0.0f, (float)proxy.getFloat(), (float)0.0f);
        Assert.assertEquals((double)0.0, (double)proxy.getDouble(), (double)0.0);
        Assert.assertNull((Object)proxy.getObject());
    }

    @Test
    public void testAnnotationDefaults() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        DefaultAnnotations proxy = (DefaultAnnotations)handler.as(DefaultAnnotations.class);
        Assert.assertTrue((boolean)proxy.getBoolean());
        Assert.assertEquals((long)97L, (long)proxy.getChar());
        Assert.assertEquals((long)4L, (long)proxy.getByte());
        Assert.assertEquals((long)5L, (long)proxy.getShort());
        Assert.assertEquals((long)6L, (long)proxy.getInt());
        Assert.assertEquals((long)7L, (long)proxy.getLong());
        Assert.assertEquals((float)8.0f, (float)proxy.getFloat(), (float)0.0f);
        Assert.assertEquals((double)9.0, (double)proxy.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"testString", (Object)proxy.getString());
        Assert.assertEquals(DefaultAnnotations.class, proxy.getClassOption());
        Assert.assertEquals((Object)((Object)EnumType.MyEnum), (Object)((Object)proxy.getEnum()));
        Assert.assertEquals((Object)"testOptionFactory", (Object)proxy.getComplex());
    }

    @Test
    public void testEqualsAndHashCode() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        Simple proxy = (Simple)handler.as(Simple.class);
        JLSDefaults sameAsProxy = (JLSDefaults)proxy.as(JLSDefaults.class);
        ProxyInvocationHandler handler2 = new ProxyInvocationHandler(Maps.newHashMap());
        Simple proxy2 = (Simple)handler2.as(Simple.class);
        JLSDefaults sameAsProxy2 = (JLSDefaults)proxy2.as(JLSDefaults.class);
        new EqualsTester().addEqualityGroup(new Object[]{handler, proxy, sameAsProxy}).addEqualityGroup(new Object[]{handler2, proxy2, sameAsProxy2}).testEquals();
    }

    @Test
    public void testToString() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        StringWithDefault proxy = (StringWithDefault)handler.as(StringWithDefault.class);
        proxy.setString("stringValue");
        DefaultAnnotations proxy2 = (DefaultAnnotations)proxy.as(DefaultAnnotations.class);
        proxy2.setLong(57L);
        Assert.assertEquals((Object)String.format("Current Settings:%n  long: 57%n  string: stringValue%n", new Object[0]), (Object)proxy.toString());
    }

    @Test
    public void testToStringAfterDeserializationContainsJsonEntries() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        StringWithDefault proxy = (StringWithDefault)handler.as(StringWithDefault.class);
        Long optionsId = proxy.getOptionsId();
        proxy.setString("stringValue");
        DefaultAnnotations proxy2 = (DefaultAnnotations)proxy.as(DefaultAnnotations.class);
        proxy2.setLong(57L);
        Assert.assertEquals((Object)String.format("Current Settings:%n  long: 57%n  optionsId: %d%n  string: \"stringValue\"%n", optionsId), (Object)this.serializeDeserialize(PipelineOptions.class, proxy2).toString());
    }

    @Test
    public void testToStringAfterDeserializationContainsOverriddenEntries() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        StringWithDefault proxy = (StringWithDefault)handler.as(StringWithDefault.class);
        Long optionsId = proxy.getOptionsId();
        proxy.setString("stringValue");
        DefaultAnnotations proxy2 = (DefaultAnnotations)proxy.as(DefaultAnnotations.class);
        proxy2.setLong(57L);
        Simple deserializedOptions = this.serializeDeserialize(Simple.class, proxy2);
        deserializedOptions.setString("overriddenValue");
        Assert.assertEquals((Object)String.format("Current Settings:%n  long: 57%n  optionsId: %d%n  string: overriddenValue%n", optionsId), (Object)deserializedOptions.toString());
    }

    @Test
    public void testInvokeWithUnknownMethod() throws Exception {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Unknown method [public abstract void org.apache.beam.sdk.options.ProxyInvocationHandlerTest$UnknownMethod.unknownMethod()] invoked with args [null].");
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        handler.invoke((Object)handler, UnknownMethod.class.getMethod("unknownMethod", new Class[0]), null);
    }

    @Test
    public void testSubClassStoresSuperInterfaceValues() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        SubClass extended = (SubClass)handler.as(SubClass.class);
        extended.setString("parentValue");
        Assert.assertEquals((Object)"parentValue", (Object)extended.getString());
    }

    @Test
    public void testUpCastRetainsSuperInterfaceValues() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        SubClass extended = (SubClass)handler.as(SubClass.class);
        extended.setString("parentValue");
        Simple simple = (Simple)extended.as(Simple.class);
        Assert.assertEquals((Object)"parentValue", (Object)simple.getString());
    }

    @Test
    public void testUpCastRetainsSubClassValues() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        SubClass extended = (SubClass)handler.as(SubClass.class);
        extended.setExtended("subClassValue");
        SubClass extended2 = (SubClass)((Simple)extended.as(Simple.class)).as(SubClass.class);
        Assert.assertEquals((Object)"subClassValue", (Object)extended2.getExtended());
    }

    @Test
    public void testAsSiblingRetainsSuperInterfaceValues() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        SubClass extended = (SubClass)handler.as(SubClass.class);
        extended.setString("parentValue");
        Sibling sibling = (Sibling)extended.as(Sibling.class);
        Assert.assertEquals((Object)"parentValue", (Object)sibling.getString());
    }

    @Test
    public void testMethodConflictProvidesSameValue() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        MethodConflict methodConflict = (MethodConflict)handler.as(MethodConflict.class);
        methodConflict.setString("conflictValue");
        Assert.assertEquals((Object)"conflictValue", (Object)methodConflict.getString());
        Assert.assertEquals((Object)"conflictValue", (Object)((Simple)methodConflict.as(Simple.class)).getString());
    }

    @Test
    public void testDeepMethodConflictProvidesSameValue() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        DeepMethodConflict deepMethodConflict = (DeepMethodConflict)handler.as(DeepMethodConflict.class);
        deepMethodConflict.setString("conflictValue");
        Assert.assertEquals((Object)"conflictValue", (Object)deepMethodConflict.getString());
        Assert.assertEquals((Object)"conflictValue", (Object)((MethodConflict)deepMethodConflict.as(MethodConflict.class)).getString());
        Assert.assertEquals((Object)"conflictValue", (Object)((Simple)deepMethodConflict.as(Simple.class)).getString());
        deepMethodConflict.setPrimitive(5);
        Assert.assertEquals((long)5L, (long)deepMethodConflict.getPrimitive());
        Assert.assertEquals((long)5L, (long)((MethodConflict)deepMethodConflict.as(MethodConflict.class)).getPrimitive());
        Assert.assertEquals((long)5L, (long)((Simple)deepMethodConflict.as(Simple.class)).getPrimitive());
    }

    @Test
    public void testDisjointSiblingsShareValues() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        SimpleSibling proxy = (SimpleSibling)handler.as(SimpleSibling.class);
        proxy.setString("siblingValue");
        Assert.assertEquals((Object)"siblingValue", (Object)proxy.getString());
        Assert.assertEquals((Object)"siblingValue", (Object)((Simple)proxy.as(Simple.class)).getString());
    }

    @Test
    public void testSiblingMethodConflict() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        SiblingMethodConflict siblingMethodConflict = (SiblingMethodConflict)handler.as(SiblingMethodConflict.class);
        siblingMethodConflict.setString("siblingValue");
        Assert.assertEquals((Object)"siblingValue", (Object)siblingMethodConflict.getString());
        Assert.assertEquals((Object)"siblingValue", (Object)((Simple)siblingMethodConflict.as(Simple.class)).getString());
        Assert.assertEquals((Object)"siblingValue", (Object)((SimpleSibling)siblingMethodConflict.as(SimpleSibling.class)).getString());
    }

    @Test
    public void testPartialMethodConflictProvidesSameValue() throws Exception {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        PartialMethodConflict partialMethodConflict = (PartialMethodConflict)handler.as(PartialMethodConflict.class);
        partialMethodConflict.setString("conflictValue");
        Assert.assertEquals((Object)"conflictValue", (Object)partialMethodConflict.getString());
        Assert.assertEquals((Object)"conflictValue", (Object)((Simple)partialMethodConflict.as(Simple.class)).getString());
        partialMethodConflict.setPrimitive(5);
        Assert.assertEquals((long)5L, (long)partialMethodConflict.getPrimitive());
        Assert.assertEquals((long)5L, (long)((Simple)partialMethodConflict.as(Simple.class)).getPrimitive());
    }

    @Test
    public void testResetRegistry() {
        HashSet defaultRegistry = new HashSet(PipelineOptionsFactory.getRegisteredOptions());
        Assert.assertThat(defaultRegistry, (Matcher)Matchers.not((Matcher)Matchers.hasItem(FooOptions.class)));
        PipelineOptionsFactory.register(FooOptions.class);
        Assert.assertThat((Object)PipelineOptionsFactory.getRegisteredOptions(), (Matcher)Matchers.hasItem(FooOptions.class));
        PipelineOptionsFactory.resetCache();
        Assert.assertEquals(defaultRegistry, (Object)PipelineOptionsFactory.getRegisteredOptions());
    }

    @Test
    public void testJsonConversionForDefault() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        Assert.assertNotNull((Object)this.serializeDeserialize(PipelineOptions.class, options));
    }

    @Test
    public void testJsonConversionForSimpleTypes() throws Exception {
        SimpleTypes options = (SimpleTypes)PipelineOptionsFactory.as(SimpleTypes.class);
        options.setString("TestValue");
        options.setInteger(5);
        SimpleTypes options2 = this.serializeDeserialize(SimpleTypes.class, options);
        Assert.assertEquals((long)5L, (long)options2.getInteger());
        Assert.assertEquals((Object)"TestValue", (Object)options2.getString());
    }

    @Test
    public void testJsonConversionOfAJsonConvertedType() throws Exception {
        SimpleTypes options = (SimpleTypes)PipelineOptionsFactory.as(SimpleTypes.class);
        options.setString("TestValue");
        options.setInteger(5);
        SimpleTypes options2 = this.serializeDeserialize(SimpleTypes.class, this.serializeDeserialize(PipelineOptions.class, options));
        Assert.assertEquals((long)5L, (long)options2.getInteger());
        Assert.assertEquals((Object)"TestValue", (Object)options2.getString());
    }

    @Test
    public void testJsonConversionForPartiallySerializedValues() throws Exception {
        SimpleTypes options = (SimpleTypes)PipelineOptionsFactory.as(SimpleTypes.class);
        options.setInteger(5);
        SimpleTypes options2 = this.serializeDeserialize(SimpleTypes.class, options);
        options2.setString("TestValue");
        SimpleTypes options3 = this.serializeDeserialize(SimpleTypes.class, options2);
        Assert.assertEquals((long)5L, (long)options3.getInteger());
        Assert.assertEquals((Object)"TestValue", (Object)options3.getString());
    }

    @Test
    public void testJsonConversionForOverriddenSerializedValues() throws Exception {
        SimpleTypes options = (SimpleTypes)PipelineOptionsFactory.as(SimpleTypes.class);
        options.setInteger(-5);
        options.setString("NeedsToBeOverridden");
        SimpleTypes options2 = this.serializeDeserialize(SimpleTypes.class, options);
        options2.setInteger(5);
        options2.setString("TestValue");
        SimpleTypes options3 = this.serializeDeserialize(SimpleTypes.class, options2);
        Assert.assertEquals((long)5L, (long)options3.getInteger());
        Assert.assertEquals((Object)"TestValue", (Object)options3.getString());
    }

    @Test
    public void testJsonConversionForContainerTypes() throws Exception {
        ImmutableList<String> list = ImmutableList.of("a", "b", "c");
        ImmutableMap<String, String> map = ImmutableMap.of("d", "x", "e", "y", "f", "z");
        ImmutableSet<String> set = ImmutableSet.of("g", "h", "i");
        ContainerTypes options = (ContainerTypes)PipelineOptionsFactory.as(ContainerTypes.class);
        options.setList(list);
        options.setMap(map);
        options.setSet(set);
        ContainerTypes options2 = this.serializeDeserialize(ContainerTypes.class, options);
        Assert.assertEquals(list, options2.getList());
        Assert.assertEquals(map, options2.getMap());
        Assert.assertEquals(set, options2.getSet());
    }

    @Test
    public void testJsonConversionForComplexType() throws Exception {
        ComplexType complexType = new ComplexType();
        complexType.stringField = "stringField";
        complexType.intField = 12;
        complexType.innerType = InnerType.of(12.0);
        complexType.genericType = ImmutableList.of(InnerType.of(16234.0), InnerType.of(24.0));
        ComplexTypes options = (ComplexTypes)PipelineOptionsFactory.as(ComplexTypes.class);
        options.setComplexType(complexType);
        ComplexTypes options2 = this.serializeDeserialize(ComplexTypes.class, options);
        Assert.assertEquals((Object)complexType, (Object)options2.getComplexType());
    }

    @Test
    public void testJsonConversionOfIgnoredProperty() throws Exception {
        IgnoredProperty options = (IgnoredProperty)PipelineOptionsFactory.as(IgnoredProperty.class);
        options.setValue("TestValue");
        IgnoredProperty options2 = this.serializeDeserialize(IgnoredProperty.class, options);
        Assert.assertNull((Object)options2.getValue());
    }

    @Test
    public void testJsonConversionOfNotSerializableProperty() throws Exception {
        NotSerializableProperty options = (NotSerializableProperty)PipelineOptionsFactory.as(NotSerializableProperty.class);
        options.setValue(new NotSerializable("TestString"));
        this.expectedException.expect(JsonMappingException.class);
        this.expectedException.expectMessage("Failed to serialize and deserialize property 'value'");
        this.serializeDeserialize(NotSerializableProperty.class, options);
    }

    @Test
    public void testJsonConversionOfIgnoredNotSerializableProperty() throws Exception {
        IgnoredNotSerializableProperty options = (IgnoredNotSerializableProperty)PipelineOptionsFactory.as(IgnoredNotSerializableProperty.class);
        options.setValue(new NotSerializable("TestString"));
        IgnoredNotSerializableProperty options2 = this.serializeDeserialize(IgnoredNotSerializableProperty.class, options);
        Assert.assertNull((Object)options2.getValue());
    }

    @Test
    public void testJsonConversionOfSerializableWithMetadataProperty() throws Exception {
        SerializableWithMetadataProperty options = (SerializableWithMetadataProperty)PipelineOptionsFactory.as(SerializableWithMetadataProperty.class);
        options.setValue(new SerializableWithMetadata("TestString"));
        SerializableWithMetadataProperty options2 = this.serializeDeserialize(SerializableWithMetadataProperty.class, options);
        Assert.assertEquals((Object)"TestString", (Object)options2.getValue().getValue());
    }

    @Test
    public void testDisplayDataItemProperties() {
        PipelineOptions options = PipelineOptionsFactory.create();
        options.setTempLocation("myTemp");
        DisplayData displayData = DisplayData.from((HasDisplayData)options);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem((Matcher<DisplayData.Item>)Matchers.allOf(DisplayDataMatchers.hasKey("tempLocation"), DisplayDataMatchers.hasType(DisplayData.Type.STRING), DisplayDataMatchers.hasValue("myTemp"), DisplayDataMatchers.hasNamespace(PipelineOptions.class))));
    }

    @Test
    public void testDisplayDataTypes() {
        Instant now = Instant.now();
        TypedOptions options = (TypedOptions)PipelineOptionsFactory.as(TypedOptions.class);
        options.setInteger(1234);
        options.setTimestamp(now);
        options.setJavaClass(ProxyInvocationHandlerTest.class);
        options.setObject(new Serializable(){

            public String toString() {
                return "foobar";
            }
        });
        DisplayData displayData = DisplayData.from((HasDisplayData)options);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("integer", 1234L));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("timestamp", now));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("javaClass", ProxyInvocationHandlerTest.class));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("object", "foobar"));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void pipelineOptionsDisplayDataExceptionShouldFail() {
        Object brokenValueType = new Object(){

            @JsonValue
            public int getValue() {
                return 42;
            }

            public String toString() {
                throw new RuntimeException("oh noes!!");
            }
        };
        ((ObjectPipelineOptions)this.p.getOptions().as(ObjectPipelineOptions.class)).setValue(brokenValueType);
        this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        this.expectedException.expectMessage(ProxyInvocationHandler.PipelineOptionsDisplayData.class.getName());
        this.expectedException.expectMessage("oh noes!!");
        this.p.run();
    }

    @Test
    public void testDisplayDataInheritanceNamespace() {
        ExtendsBaseOptions options = (ExtendsBaseOptions)PipelineOptionsFactory.as(ExtendsBaseOptions.class);
        options.setFoo("bar");
        DisplayData displayData = DisplayData.from((HasDisplayData)options);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem((Matcher<DisplayData.Item>)Matchers.allOf(DisplayDataMatchers.hasKey("foo"), DisplayDataMatchers.hasValue("bar"), DisplayDataMatchers.hasNamespace(ExtendsBaseOptions.class))));
    }

    @Test
    public void testDisplayDataExcludedFromOverriddenBaseClass() {
        ExtendsBaseOptions options = (ExtendsBaseOptions)PipelineOptionsFactory.as(ExtendsBaseOptions.class);
        options.setFoo("bar");
        DisplayData displayData = DisplayData.from((HasDisplayData)options);
        Assert.assertThat((Object)displayData, (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem(DisplayDataMatchers.hasNamespace(BaseOptions.class))));
    }

    @Test
    public void testDisplayDataIncludedForDisjointInterfaceHierarchies() {
        FooOptions fooOptions = (FooOptions)PipelineOptionsFactory.as(FooOptions.class);
        fooOptions.setFoo("foo");
        BarOptions barOptions = (BarOptions)fooOptions.as(BarOptions.class);
        barOptions.setBar("bar");
        DisplayData data = DisplayData.from((HasDisplayData)barOptions);
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem((Matcher<DisplayData.Item>)Matchers.allOf(DisplayDataMatchers.hasKey("foo"), DisplayDataMatchers.hasNamespace(FooOptions.class))));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem((Matcher<DisplayData.Item>)Matchers.allOf(DisplayDataMatchers.hasKey("bar"), DisplayDataMatchers.hasNamespace(BarOptions.class))));
    }

    @Test
    public void testDisplayDataExcludesDefaultValues() {
        PipelineOptions options = PipelineOptionsFactory.as(HasDefaults.class);
        DisplayData data = DisplayData.from((HasDisplayData)options);
        Assert.assertThat((Object)data, (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem("foo")));
    }

    @Test
    public void testDisplayDataExcludesValuesAccessedButNeverSet() {
        HasDefaults options = (HasDefaults)PipelineOptionsFactory.as(HasDefaults.class);
        Assert.assertEquals((Object)"bar", (Object)options.getFoo());
        DisplayData data = DisplayData.from((HasDisplayData)options);
        Assert.assertThat((Object)data, (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem("foo")));
    }

    @Test
    public void testDisplayDataIncludesExplicitlySetDefaults() {
        HasDefaults options = (HasDefaults)PipelineOptionsFactory.as(HasDefaults.class);
        String defaultValue = options.getFoo();
        options.setFoo(defaultValue);
        DisplayData data = DisplayData.from((HasDisplayData)options);
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("foo", defaultValue));
    }

    @Test
    public void testDisplayDataNullValuesConvertedToEmptyString() throws Exception {
        FooOptions options = (FooOptions)PipelineOptionsFactory.as(FooOptions.class);
        options.setFoo(null);
        DisplayData data = DisplayData.from((HasDisplayData)options);
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("foo", ""));
        FooOptions deserializedOptions = this.serializeDeserialize(FooOptions.class, options);
        DisplayData deserializedData = DisplayData.from((HasDisplayData)deserializedOptions);
        Assert.assertThat((Object)deserializedData, DisplayDataMatchers.hasDisplayItem("foo", ""));
    }

    @Test
    public void testDisplayDataArrayValue() throws Exception {
        ArrayOptions options = (ArrayOptions)PipelineOptionsFactory.as(ArrayOptions.class);
        options.setDeepArray(new String[][]{{"a", "b"}, {"c"}});
        options.setDeepPrimitiveArray(new int[][]{{1, 2}, {3}});
        DisplayData data = DisplayData.from((HasDisplayData)options);
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("deepArray", "[[a, b], [c]]"));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("deepPrimitiveArray", "[[1, 2], [3]]"));
        ArrayOptions deserializedOptions = this.serializeDeserialize(ArrayOptions.class, options);
        DisplayData deserializedData = DisplayData.from((HasDisplayData)deserializedOptions);
        Assert.assertThat((Object)deserializedData, DisplayDataMatchers.hasDisplayItem("deepPrimitiveArray", "[[1, 2], [3]]"));
    }

    @Test
    public void testDisplayDataJsonSerialization() throws IOException {
        FooOptions options = (FooOptions)PipelineOptionsFactory.as(FooOptions.class);
        options.setFoo("bar");
        Map map = (Map)MAPPER.readValue(MAPPER.writeValueAsBytes((Object)options), Map.class);
        Assert.assertThat((String)"main pipeline options data keyed as 'options'", (Object)map, (Matcher)Matchers.hasKey((Object)"options"));
        Assert.assertThat((String)"display data keyed as 'display_data'", (Object)map, (Matcher)Matchers.hasKey((Object)"display_data"));
        ImmutableMap<String, String> expectedDisplayItem = ImmutableMap.builder().put("namespace", FooOptions.class.getName()).put("key", "foo").put("value", "bar").put("type", "STRING").build();
        List deserializedDisplayData = (List)map.get("display_data");
        Assert.assertThat((Object)deserializedDisplayData, (Matcher)Matchers.hasItem(expectedDisplayItem));
    }

    @Test
    public void testDisplayDataFromDeserializedJson() throws Exception {
        FooOptions options = (FooOptions)PipelineOptionsFactory.as(FooOptions.class);
        options.setFoo("bar");
        DisplayData data = DisplayData.from((HasDisplayData)options);
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("foo", "bar"));
        FooOptions deserializedOptions = this.serializeDeserialize(FooOptions.class, options);
        DisplayData dataAfterDeserialization = DisplayData.from((HasDisplayData)deserializedOptions);
        Assert.assertEquals((Object)data, (Object)dataAfterDeserialization);
    }

    @Test
    public void testDisplayDataDeserializationWithRegistration() throws Exception {
        PipelineOptionsFactory.register(HasClassOptions.class);
        HasClassOptions options = (HasClassOptions)PipelineOptionsFactory.as(HasClassOptions.class);
        options.setClassOption(ProxyInvocationHandlerTest.class);
        PipelineOptions deserializedOptions = this.serializeDeserialize(PipelineOptions.class, options);
        DisplayData displayData = DisplayData.from((HasDisplayData)deserializedOptions);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("classOption", ProxyInvocationHandlerTest.class));
    }

    @Test
    public void testDisplayDataMissingPipelineOptionsRegistration() throws Exception {
        HasClassOptions options = (HasClassOptions)PipelineOptionsFactory.as(HasClassOptions.class);
        options.setClassOption(ProxyInvocationHandlerTest.class);
        PipelineOptions deserializedOptions = this.serializeDeserialize(PipelineOptions.class, options);
        DisplayData displayData = DisplayData.from((HasDisplayData)deserializedOptions);
        String expectedJsonValue = MAPPER.writeValueAsString(ProxyInvocationHandlerTest.class);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("classOption", expectedJsonValue));
    }

    @Test
    public void testDisplayDataJsonValueSetAfterDeserialization() throws Exception {
        FooOptions options = (FooOptions)PipelineOptionsFactory.as(FooOptions.class);
        options.setFoo("bar");
        DisplayData data = DisplayData.from((HasDisplayData)options);
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("foo", "bar"));
        FooOptions deserializedOptions = this.serializeDeserialize(FooOptions.class, options);
        deserializedOptions.setFoo("baz");
        DisplayData dataAfterDeserialization = DisplayData.from((HasDisplayData)deserializedOptions);
        Assert.assertThat((Object)dataAfterDeserialization, DisplayDataMatchers.hasDisplayItem("foo", "baz"));
    }

    private <T extends PipelineOptions> T serializeDeserialize(Class<T> kls, PipelineOptions options) throws Exception {
        String value = MAPPER.writeValueAsString((Object)options);
        return (T)((PipelineOptions)MAPPER.readValue(value, PipelineOptions.class)).as(kls);
    }

    @Test
    public void testDisplayDataExcludesJsonIgnoreOptions() {
        IgnoredProperty options = (IgnoredProperty)PipelineOptionsFactory.as(IgnoredProperty.class);
        options.setValue("foobar");
        DisplayData data = DisplayData.from((HasDisplayData)options);
        Assert.assertThat((Object)data, (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem("value")));
    }

    @Test
    public void testOptionsAreNotSerializable() {
        this.expectedException.expectCause(Matchers.instanceOf(NotSerializableException.class));
        SerializableUtils.clone((Serializable)new CapturesOptions());
    }

    @Test
    public void testGetOptionNameFromMethod() throws NoSuchMethodException {
        ProxyInvocationHandler handler = new ProxyInvocationHandler(Maps.newHashMap());
        handler.as(BaseOptions.class);
        Assert.assertEquals((Object)"foo", (Object)handler.getOptionName(BaseOptions.class.getMethod("getFoo", new Class[0])));
    }

    private static class CapturesOptions
    implements Serializable {
        PipelineOptions options = PipelineOptionsFactory.create();

        private CapturesOptions() {
        }
    }

    static interface HasClassOptions
    extends PipelineOptions {
        public Class<?> getClassOption();

        public void setClassOption(Class<?> var1);
    }

    private static interface ArrayOptions
    extends PipelineOptions {
        public String[][] getDeepArray();

        public void setDeepArray(String[][] var1);

        public int[][] getDeepPrimitiveArray();

        public void setDeepPrimitiveArray(int[][] var1);
    }

    static interface HasDefaults
    extends PipelineOptions {
        @Default.String(value="bar")
        public String getFoo();

        public void setFoo(String var1);
    }

    static interface BarOptions
    extends PipelineOptions {
        public String getBar();

        public void setBar(String var1);
    }

    static interface FooOptions
    extends PipelineOptions {
        public String getFoo();

        public void setFoo(String var1);
    }

    static interface ExtendsBaseOptions
    extends BaseOptions {
        @Override
        public String getFoo();

        @Override
        public void setFoo(String var1);
    }

    static interface BaseOptions
    extends PipelineOptions {
        public String getFoo();

        public void setFoo(String var1);
    }

    public static interface ObjectPipelineOptions
    extends PipelineOptions {
        public Object getValue();

        public void setValue(Object var1);
    }

    static interface TypedOptions
    extends PipelineOptions {
        public int getInteger();

        public void setInteger(int var1);

        public Instant getTimestamp();

        public void setTimestamp(Instant var1);

        public Class<?> getJavaClass();

        public void setJavaClass(Class<?> var1);

        public Object getObject();

        public void setObject(Object var1);
    }

    private static interface SerializableWithMetadataProperty
    extends PipelineOptions {
        public SerializableWithMetadata getValue();

        public void setValue(SerializableWithMetadata var1);
    }

    public static class SerializableWithMetadata {
        private String value;

        public SerializableWithMetadata(@JsonProperty(value="value") String value) {
            this.value = value;
        }

        @JsonProperty(value="value")
        public String getValue() {
            return this.value;
        }
    }

    private static interface IgnoredNotSerializableProperty
    extends PipelineOptions {
        @JsonIgnore
        public NotSerializable getValue();

        public void setValue(NotSerializable var1);
    }

    private static interface NotSerializableProperty
    extends PipelineOptions {
        public NotSerializable getValue();

        public void setValue(NotSerializable var1);
    }

    public static class NotSerializable {
        private String value;

        public NotSerializable(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static interface IgnoredProperty
    extends PipelineOptions {
        @JsonIgnore
        public String getValue();

        public void setValue(String var1);
    }

    private static interface ComplexTypes
    extends PipelineOptions {
        public ComplexType getComplexType();

        public void setComplexType(ComplexType var1);
    }

    private static class ComplexType {
        public String stringField;
        public Integer intField;
        public List<InnerType> genericType;
        public InnerType innerType;

        private ComplexType() {
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && Objects.equals(this.stringField, ((ComplexType)obj).stringField) && Objects.equals(this.intField, ((ComplexType)obj).intField) && Objects.equals(this.genericType, ((ComplexType)obj).genericType) && Objects.equals(this.innerType, ((ComplexType)obj).innerType);
        }
    }

    private static class InnerType {
        public double doubleField;

        private InnerType() {
        }

        static InnerType of(double value) {
            InnerType rval = new InnerType();
            rval.doubleField = value;
            return rval;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && Objects.equals(this.doubleField, ((InnerType)obj).doubleField);
        }
    }

    private static interface ContainerTypes
    extends PipelineOptions {
        public List<String> getList();

        public void setList(List<String> var1);

        public Map<String, String> getMap();

        public void setMap(Map<String, String> var1);

        public Set<String> getSet();

        public void setSet(Set<String> var1);
    }

    private static interface SimpleTypes
    extends PipelineOptions {
        public int getInteger();

        public void setInteger(int var1);

        public String getString();

        public void setString(String var1);
    }

    public static interface PartialMethodConflict
    extends Simple {
        @Override
        public String getString();

        @Override
        public void setPrimitive(int var1);
    }

    public static interface SiblingMethodConflict
    extends Simple,
    SimpleSibling {
    }

    public static interface SimpleSibling
    extends PipelineOptions {
        public String getString();

        public void setString(String var1);
    }

    public static interface DeepMethodConflict
    extends MethodConflict {
        @Override
        public String getString();

        @Override
        public void setString(String var1);

        @Override
        public int getPrimitive();

        @Override
        public void setPrimitive(int var1);
    }

    public static interface MethodConflict
    extends Simple {
        @Override
        public String getString();

        @Override
        public void setString(String var1);
    }

    public static interface Sibling
    extends Simple {
        public String getSibling();

        public void setSibling(String var1);
    }

    public static interface SubClass
    extends Simple {
        public String getExtended();

        public void setExtended(String var1);
    }

    public static interface UnknownMethod {
        public void unknownMethod();
    }

    public static interface StringWithDefault
    extends PipelineOptions {
        @Default.String(value="testString")
        public String getString();

        public void setString(String var1);
    }

    public static interface DefaultAnnotations
    extends PipelineOptions {
        @Default.Boolean(value=true)
        public boolean getBoolean();

        public void setBoolean(boolean var1);

        @Default.Character(value=97)
        public char getChar();

        public void setChar(char var1);

        @Default.Byte(value=4)
        public byte getByte();

        public void setByte(byte var1);

        @Default.Short(value=5)
        public short getShort();

        public void setShort(short var1);

        @Default.Integer(value=6)
        public int getInt();

        public void setInt(int var1);

        @Default.Long(value=7L)
        public long getLong();

        public void setLong(long var1);

        @Default.Float(value=8.0f)
        public float getFloat();

        public void setFloat(float var1);

        @Default.Double(value=9.0)
        public double getDouble();

        public void setDouble(double var1);

        @Default.String(value="testString")
        public String getString();

        public void setString(String var1);

        @Default.Class(value=DefaultAnnotations.class)
        public Class<?> getClassOption();

        public void setClassOption(Class<?> var1);

        @Default.Enum(value="MyEnum")
        public EnumType getEnum();

        public void setEnum(EnumType var1);

        @Default.InstanceFactory(value=TestOptionFactory.class)
        public String getComplex();

        public void setComplex(String var1);
    }

    public static enum EnumType {
        MyEnum("MyTestEnum");

        private final String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class TestOptionFactory
    implements DefaultValueFactory<String> {
        public String create(PipelineOptions options) {
            return "testOptionFactory";
        }
    }

    public static interface JLSDefaults
    extends PipelineOptions {
        public boolean getBoolean();

        public void setBoolean(boolean var1);

        public char getChar();

        public void setChar(char var1);

        public byte getByte();

        public void setByte(byte var1);

        public short getShort();

        public void setShort(short var1);

        public int getInt();

        public void setInt(int var1);

        public long getLong();

        public void setLong(long var1);

        public float getFloat();

        public void setFloat(float var1);

        public double getDouble();

        public void setDouble(double var1);

        public Object getObject();

        public void setObject(Object var1);
    }

    public static interface Simple
    extends PipelineOptions {
        public boolean isOptionEnabled();

        public void setOptionEnabled(boolean var1);

        public int getPrimitive();

        public void setPrimitive(int var1);

        public String getString();

        public void setString(String var1);
    }
}

