/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.testing.CrashingRunner;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PipelineOptionsValidatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testWhenRequiredOptionIsSet() {
        Required required = (Required)PipelineOptionsFactory.as(Required.class);
        required.setRunner(CrashingRunner.class);
        required.setObject("blah");
        PipelineOptionsValidator.validate(Required.class, (PipelineOptions)required);
    }

    @Test
    public void testWhenRequiredOptionIsSetAndCleared() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Missing required value for [public abstract java.lang.String org.apache.beam.sdk.options.PipelineOptionsValidatorTest$Required.getObject(), \"Fake Description\"].");
        Required required = (Required)PipelineOptionsFactory.as(Required.class);
        required.setObject("blah");
        required.setObject(null);
        PipelineOptionsValidator.validate(Required.class, (PipelineOptions)required);
    }

    @Test
    public void testWhenRequiredOptionIsSetAndClearedCli() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Missing required value for [--object, \"Fake Description\"].");
        Required required = (Required)PipelineOptionsFactory.fromArgs((String[])new String[]{"--object=blah"}).as(Required.class);
        required.setObject(null);
        PipelineOptionsValidator.validateCli(Required.class, (PipelineOptions)required);
    }

    @Test
    public void testWhenRequiredOptionIsNeverSet() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Missing required value for [public abstract java.lang.String org.apache.beam.sdk.options.PipelineOptionsValidatorTest$Required.getObject(), \"Fake Description\"].");
        Required required = (Required)PipelineOptionsFactory.as(Required.class);
        PipelineOptionsValidator.validate(Required.class, (PipelineOptions)required);
    }

    @Test
    public void testWhenRequiredOptionIsNeverSetCli() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Missing required value for [--object, \"Fake Description\"].");
        Required required = (Required)PipelineOptionsFactory.fromArgs((String[])new String[0]).as(Required.class);
        PipelineOptionsValidator.validateCli(Required.class, (PipelineOptions)required);
    }

    @Test
    public void testWhenRequiredOptionIsNeverSetOnSuperInterface() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Missing required value for [public abstract java.lang.String org.apache.beam.sdk.options.PipelineOptionsValidatorTest$Required.getObject(), \"Fake Description\"].");
        PipelineOptions options = PipelineOptionsFactory.create();
        PipelineOptionsValidator.validate(Required.class, (PipelineOptions)options);
    }

    @Test
    public void testWhenRequiredOptionIsNeverSetOnSuperInterfaceCli() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Missing required value for [--object, \"Fake Description\"].");
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])new String[0]).create();
        PipelineOptionsValidator.validateCli(Required.class, (PipelineOptions)options);
    }

    @Test
    public void testValidationOnOverriddenMethods() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Missing required value for [public abstract java.lang.String org.apache.beam.sdk.options.PipelineOptionsValidatorTest$Required.getObject(), \"Fake Description\"].");
        SubClassValidation required = (SubClassValidation)PipelineOptionsFactory.as(SubClassValidation.class);
        PipelineOptionsValidator.validate(Required.class, (PipelineOptions)required);
    }

    @Test
    public void testValidationOnOverriddenMethodsCli() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Missing required value for [--object, \"Fake Description\"].");
        SubClassValidation required = (SubClassValidation)PipelineOptionsFactory.fromArgs((String[])new String[0]).as(SubClassValidation.class);
        PipelineOptionsValidator.validateCli(Required.class, (PipelineOptions)required);
    }

    @Test
    public void testWhenOneOfRequiredGroupIsSetIsValid() {
        GroupRequired groupRequired = (GroupRequired)PipelineOptionsFactory.as(GroupRequired.class);
        groupRequired.setFoo("foo");
        groupRequired.setBar(null);
        groupRequired.setRunner(CrashingRunner.class);
        PipelineOptionsValidator.validate(GroupRequired.class, (PipelineOptions)groupRequired);
        groupRequired.setFoo(null);
        groupRequired.setBar("bar");
        PipelineOptionsValidator.validate(GroupRequired.class, (PipelineOptions)groupRequired);
    }

    @Test
    public void testWhenNoneOfRequiredGroupIsSetThrowsException() {
        GroupRequired groupRequired = (GroupRequired)PipelineOptionsFactory.as(GroupRequired.class);
        groupRequired.setRunner(CrashingRunner.class);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Missing required value for group [ham]");
        this.expectedException.expectMessage("properties");
        this.expectedException.expectMessage("getFoo");
        this.expectedException.expectMessage("getBar");
        PipelineOptionsValidator.validate(GroupRequired.class, (PipelineOptions)groupRequired);
    }

    @Test
    public void testWhenOneOfMultipleRequiredGroupsIsSetIsValid() {
        MultiGroupRequired multiGroupRequired = (MultiGroupRequired)PipelineOptionsFactory.as(MultiGroupRequired.class);
        multiGroupRequired.setRunner(CrashingRunner.class);
        multiGroupRequired.setFoo("eggs");
        PipelineOptionsValidator.validate(MultiGroupRequired.class, (PipelineOptions)multiGroupRequired);
    }

    @Test
    public void testWhenOptionIsDefinedInMultipleSuperInterfacesAndIsNotPresentFailsRequirement() {
        RightOptions rightOptions = (RightOptions)PipelineOptionsFactory.as(RightOptions.class);
        rightOptions.setBoth("foo");
        rightOptions.setRunner(CrashingRunner.class);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Missing required value for group");
        this.expectedException.expectMessage("getFoo");
        PipelineOptionsValidator.validate(JoinedOptions.class, (PipelineOptions)rightOptions);
    }

    @Test
    public void testWhenOptionIsDefinedInMultipleSuperInterfacesMeetsGroupRequirement() {
        RightOptions rightOpts = (RightOptions)PipelineOptionsFactory.as(RightOptions.class);
        rightOpts.setFoo("true");
        rightOpts.setBoth("bar");
        LeftOptions leftOpts = (LeftOptions)PipelineOptionsFactory.as(LeftOptions.class);
        leftOpts.setFoo("Untrue");
        leftOpts.setBoth("Raise the");
        rightOpts.setRunner(CrashingRunner.class);
        leftOpts.setRunner(CrashingRunner.class);
        PipelineOptionsValidator.validate(JoinedOptions.class, (PipelineOptions)rightOpts);
        PipelineOptionsValidator.validate(JoinedOptions.class, (PipelineOptions)leftOpts);
    }

    @Test
    public void testWhenOptionIsDefinedOnOtherOptionsClassMeetsGroupRequirement() {
        RightOptions rightOpts = (RightOptions)PipelineOptionsFactory.as(RightOptions.class);
        rightOpts.setFoo("true");
        rightOpts.setBoth("bar");
        LeftOptions leftOpts = (LeftOptions)PipelineOptionsFactory.as(LeftOptions.class);
        leftOpts.setFoo("Untrue");
        leftOpts.setBoth("Raise the");
        rightOpts.setRunner(CrashingRunner.class);
        leftOpts.setRunner(CrashingRunner.class);
        PipelineOptionsValidator.validate(RightOptions.class, (PipelineOptions)leftOpts);
        PipelineOptionsValidator.validate(LeftOptions.class, (PipelineOptions)rightOpts);
    }

    @Test
    public void testWhenOptionIsDefinedOnMultipleInterfacesOnlyListedOnceWhenNotPresent() {
        JoinedOptions options = (JoinedOptions)PipelineOptionsFactory.as(JoinedOptions.class);
        options.setFoo("Hello");
        options.setRunner(CrashingRunner.class);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("required value for group [both]");
        this.expectedException.expectMessage("properties [getBoth()]");
        PipelineOptionsValidator.validate(JoinedOptions.class, (PipelineOptions)options);
    }

    @Test
    public void testSuperInterfaceRequiredOptionsAlsoRequiredInSubInterface() {
        SubOptions subOpts = (SubOptions)PipelineOptionsFactory.as(SubOptions.class);
        subOpts.setFoo("Bar");
        subOpts.setRunner(CrashingRunner.class);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("otherSuper");
        this.expectedException.expectMessage("Missing required value");
        this.expectedException.expectMessage("getSuperclassObj");
        PipelineOptionsValidator.validate(SubOptions.class, (PipelineOptions)subOpts);
    }

    @Test
    public void testSuperInterfaceGroupIsInAdditionToSubInterfaceGroupOnlyWhenValidatingSuperInterface() {
        SubOptions opts = (SubOptions)PipelineOptionsFactory.as(SubOptions.class);
        opts.setFoo("Foo");
        opts.setSuperclassObj("Hello world");
        opts.setRunner(CrashingRunner.class);
        PipelineOptionsValidator.validate(SubOptions.class, (PipelineOptions)opts);
        this.expectedException.expectMessage("sub");
        this.expectedException.expectMessage("Missing required value");
        this.expectedException.expectMessage("getBar");
        PipelineOptionsValidator.validate(SuperOptions.class, (PipelineOptions)opts);
    }

    @Test
    public void testSuperInterfaceRequiredOptionsSatisfiedBySubInterface() {
        SubOptions subOpts = (SubOptions)PipelineOptionsFactory.as(SubOptions.class);
        subOpts.setFoo("bar");
        subOpts.setBar("bar");
        subOpts.setSuperclassObj("SuperDuper");
        subOpts.setRunner(CrashingRunner.class);
        PipelineOptionsValidator.validate(SubOptions.class, (PipelineOptions)subOpts);
        PipelineOptionsValidator.validate(SuperOptions.class, (PipelineOptions)subOpts);
    }

    private static interface SubOptions
    extends SuperOptions {
        @Override
        @Validation.Required(groups={"sub"})
        public String getFoo();

        @Override
        public void setFoo(String var1);

        @Override
        public String getSuperclassObj();

        @Override
        public void setSuperclassObj(String var1);
    }

    private static interface SuperOptions
    extends PipelineOptions {
        @Validation.Required(groups={"super"})
        public String getFoo();

        public void setFoo(String var1);

        @Validation.Required(groups={"sub"})
        public String getBar();

        public void setBar(String var1);

        @Validation.Required(groups={"otherSuper"})
        public String getSuperclassObj();

        public void setSuperclassObj(String var1);
    }

    private static interface JoinedOptions
    extends LeftOptions,
    RightOptions {
    }

    private static interface RightOptions
    extends PipelineOptions {
        @Validation.Required(groups={"right"})
        public String getFoo();

        public void setFoo(String var1);

        @Validation.Required(groups={"right"})
        public String getRight();

        public void setRight(String var1);

        @Validation.Required(groups={"both"})
        public String getBoth();

        public void setBoth(String var1);
    }

    private static interface LeftOptions
    extends PipelineOptions {
        @Validation.Required(groups={"left"})
        public String getFoo();

        public void setFoo(String var1);

        @Validation.Required(groups={"left"})
        public String getLeft();

        public void setLeft(String var1);

        @Validation.Required(groups={"both"})
        public String getBoth();

        public void setBoth(String var1);
    }

    public static interface MultiGroupRequired
    extends PipelineOptions {
        @Validation.Required(groups={"spam", "ham"})
        public String getFoo();

        public void setFoo(String var1);

        @Validation.Required(groups={"spam"})
        public String getBar();

        public void setBar(String var1);

        @Validation.Required(groups={"ham"})
        public String getBaz();

        public void setBaz(String var1);
    }

    public static interface GroupRequired
    extends PipelineOptions {
        @Validation.Required(groups={"ham"})
        public String getFoo();

        public void setFoo(String var1);

        @Validation.Required(groups={"ham"})
        public String getBar();

        public void setBar(String var1);
    }

    public static interface SubClassValidation
    extends Required {
        @Override
        public String getObject();

        @Override
        public void setObject(String var1);
    }

    public static interface Required
    extends PipelineOptions {
        @Validation.Required
        @Description(value="Fake Description")
        public String getObject();

        public void setObject(String var1);
    }
}

