/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PipelineOptionsTest {
    private static final String DEFAULT_USER_AGENT_NAME = "Apache_Beam_SDK_for_Java";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testDynamicAs() {
        BaseTestOptions options = (BaseTestOptions)PipelineOptionsFactory.create().as(BaseTestOptions.class);
        Assert.assertNotNull((Object)options);
    }

    @Test
    public void testOutputRuntimeOptions() {
        ValueProviderOptions options = (ValueProviderOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--string=baz"}).as(ValueProviderOptions.class);
        ImmutableMap<String, ImmutableMap<String, Class<Boolean>>> expected = ImmutableMap.of("bool", ImmutableMap.of("type", Boolean.class));
        Assert.assertEquals(expected, (Object)options.outputRuntimeOptions());
    }

    @Test
    public void testPipelineOptionsIdIsUniquePerInstance() {
        HashSet<Long> ids = new HashSet<Long>();
        for (int i = 0; i < 1000; ++i) {
            long id = PipelineOptionsFactory.create().getOptionsId();
            if (ids.add(id)) continue;
            Assert.fail((String)String.format("Generated duplicate id %s, existing generated ids %s", id, ids));
        }
    }

    @Test
    public void testUserAgentFactory() {
        PipelineOptions options = PipelineOptionsFactory.create();
        String userAgent = options.getUserAgent();
        Assert.assertNotNull((Object)userAgent);
        Assert.assertTrue((boolean)userAgent.contains(DEFAULT_USER_AGENT_NAME));
    }

    private static interface ValueProviderOptions
    extends PipelineOptions {
        public ValueProvider<Boolean> getBool();

        public void setBool(ValueProvider<Boolean> var1);

        public ValueProvider<String> getString();

        public void setString(ValueProvider<String> var1);

        public String getNotAValueProvider();

        public void setNotAValueProvider(String var1);
    }

    private static interface BaseTestOptions
    extends PipelineOptions {
        public List<Boolean> getBaseValue();

        public void setBaseValue(List<Boolean> var1);

        @JsonIgnore
        public Set<String> getIgnoredValue();

        public void setIgnoredValue(Set<String> var1);
    }

    private static interface ConflictedTestOptions
    extends BaseTestOptions {
        public String getDerivedValue();

        public void setDerivedValue(String var1);

        @Override
        @JsonIgnore
        public Set<String> getIgnoredValue();

        @Override
        public void setIgnoredValue(Set<String> var1);
    }

    private static interface DerivedTestOptions
    extends BaseTestOptions {
        public int getDerivedValue();

        public void setDerivedValue(int var1);

        @Override
        @JsonIgnore
        public Set<String> getIgnoredValue();

        @Override
        public void setIgnoredValue(Set<String> var1);
    }
}

