/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableSet;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptionSpec;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsReflector;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PipelineOptionsReflectorTest {
    @Test
    public void testGetOptionSpecs() throws NoSuchMethodException {
        Set properties = PipelineOptionsReflector.getOptionSpecs(SimpleOptions.class);
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.hasItems((Object[])new PipelineOptionSpec[]{PipelineOptionSpec.of(SimpleOptions.class, (String)"foo", (Method)SimpleOptions.class.getDeclaredMethod("getFoo", new Class[0]))}));
    }

    @Test
    public void testFiltersNonGetterMethods() {
        Set properties = PipelineOptionsReflector.getOptionSpecs(OnlyTwoValidGetters.class);
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.not((Matcher)Matchers.hasItem(PipelineOptionsReflectorTest.hasName((Matcher<String>)Matchers.isOneOf((Object[])new String[]{"misspelled", "hasParameter", "prefix"})))));
    }

    @Test
    public void testBaseClassOptions() {
        Set props = PipelineOptionsReflector.getOptionSpecs(ExtendsSimpleOptions.class);
        MatcherAssert.assertThat((Object)props, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf(PipelineOptionsReflectorTest.hasName("foo"), PipelineOptionsReflectorTest.hasClass(SimpleOptions.class))));
        MatcherAssert.assertThat((Object)props, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf(PipelineOptionsReflectorTest.hasName("foo"), PipelineOptionsReflectorTest.hasClass(ExtendsSimpleOptions.class))));
        MatcherAssert.assertThat((Object)props, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf(PipelineOptionsReflectorTest.hasName("bar"), PipelineOptionsReflectorTest.hasClass(ExtendsSimpleOptions.class))));
    }

    @Test
    public void testExcludesNonPipelineOptionsMethods() {
        Set properties = PipelineOptionsReflector.getOptionSpecs(ExtendsNonPipelineOptions.class);
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.not((Matcher)Matchers.hasItem(PipelineOptionsReflectorTest.hasName("foo"))));
    }

    @Test
    public void testExcludesHiddenInterfaces() {
        Set properties = PipelineOptionsReflector.getOptionSpecs(HiddenOptions.class);
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.not((Matcher)Matchers.hasItem(PipelineOptionsReflectorTest.hasName("foo"))));
    }

    @Test
    public void testShouldSerialize() {
        Set properties = PipelineOptionsReflector.getOptionSpecs(JsonIgnoreOptions.class);
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf(PipelineOptionsReflectorTest.hasName("notIgnored"), PipelineOptionsReflectorTest.shouldSerialize())));
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf(PipelineOptionsReflectorTest.hasName("ignored"), (Matcher)Matchers.not(PipelineOptionsReflectorTest.shouldSerialize()))));
    }

    @Test
    public void testMultipleInputInterfaces() {
        ImmutableSet<Class<ExtendOptions2>> interfaces = ImmutableSet.of(BaseOptions.class, ExtendOptions1.class, ExtendOptions2.class);
        Set props = PipelineOptionsReflector.getOptionSpecs(interfaces);
        MatcherAssert.assertThat((Object)props, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf(PipelineOptionsReflectorTest.hasName("baseOption"), PipelineOptionsReflectorTest.hasClass(BaseOptions.class))));
        MatcherAssert.assertThat((Object)props, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf(PipelineOptionsReflectorTest.hasName("extendOption1"), PipelineOptionsReflectorTest.hasClass(ExtendOptions1.class))));
        MatcherAssert.assertThat((Object)props, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf(PipelineOptionsReflectorTest.hasName("extendOption2"), PipelineOptionsReflectorTest.hasClass(ExtendOptions2.class))));
    }

    private static Matcher<PipelineOptionSpec> hasName(String name) {
        return PipelineOptionsReflectorTest.hasName((Matcher<String>)Matchers.is((Object)name));
    }

    private static Matcher<PipelineOptionSpec> hasName(Matcher<String> matcher) {
        return new FeatureMatcher<PipelineOptionSpec, String>(matcher, "name", "name"){

            protected String featureValueOf(PipelineOptionSpec actual) {
                return actual.getName();
            }
        };
    }

    private static Matcher<PipelineOptionSpec> hasClass(Class<?> clazz) {
        return new FeatureMatcher<PipelineOptionSpec, Class<?>>(Matchers.is(clazz), "defining class", "class"){

            protected Class<?> featureValueOf(PipelineOptionSpec actual) {
                return actual.getDefiningInterface();
            }
        };
    }

    private static Matcher<PipelineOptionSpec> hasGetter(String methodName) {
        return new FeatureMatcher<PipelineOptionSpec, String>(Matchers.is((Object)methodName), "getter method", "name"){

            protected String featureValueOf(PipelineOptionSpec actual) {
                return actual.getGetterMethod().getName();
            }
        };
    }

    private static Matcher<PipelineOptionSpec> shouldSerialize() {
        return new FeatureMatcher<PipelineOptionSpec, Boolean>(Matchers.equalTo((Object)true), "should serialize", "shouldSerialize"){

            protected Boolean featureValueOf(PipelineOptionSpec actual) {
                return actual.shouldSerialize();
            }
        };
    }

    static interface ExtendOptions2
    extends BaseOptions {
        public String getExtendOption2();

        public void setExtendOption2(String var1);
    }

    static interface ExtendOptions1
    extends BaseOptions {
        public String getExtendOption1();

        public void setExtendOption1(String var1);
    }

    static interface BaseOptions
    extends PipelineOptions {
        public String getBaseOption();

        public void setBaseOption(String var1);
    }

    static interface JsonIgnoreOptions
    extends PipelineOptions {
        public String getNotIgnored();

        public void setNotIgnored(String var1);

        @JsonIgnore
        public String getIgnored();

        public void setIgnored(String var1);
    }

    @Hidden
    static interface HiddenOptions
    extends PipelineOptions {
        public String getFoo();

        public void setFoo(String var1);
    }

    static interface ExtendsNonPipelineOptions
    extends NoExtendsClause,
    PipelineOptions {
    }

    static interface NoExtendsClause {
        public String getFoo();

        public void setFoo(String var1);
    }

    static interface ExtendsSimpleOptions
    extends SimpleOptions {
        @Override
        public String getFoo();

        @Override
        public void setFoo(String var1);

        public String getBar();

        public void setBar(String var1);
    }

    static interface OnlyTwoValidGetters
    extends PipelineOptions {
        public String getFoo();

        public void setFoo(String var1);

        public boolean isBar();

        public void setBar(boolean var1);

        public String gtMisspelled();

        public void setMisspelled(String var1);

        public String getHasParameter(String var1);

        public void setHasParameter(String var1);

        public String noPrefix();

        public void setNoPrefix(String var1);
    }

    static interface SimpleOptions
    extends PipelineOptions {
        public String getFoo();

        public void setFoo(String var1);
    }
}

