/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.auto.service.AutoService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Charsets;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PipelineOptionsRegistrar;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.PipelineRunnerRegistrar;
import org.apache.beam.sdk.testing.CrashingRunner;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.InterceptingUrlClassLoader;
import org.apache.beam.sdk.testing.RestoreSystemProperties;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PipelineOptionsFactoryTest {
    private static final String DEFAULT_RUNNER_NAME = "DirectRunner";
    private static final Class<? extends PipelineRunner<?>> REGISTERED_RUNNER = RegisteredTestRunner.class;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TestRule restoreSystemProperties = new RestoreSystemProperties();
    @Rule
    public ExpectedLogs expectedLogs = ExpectedLogs.none(PipelineOptionsFactory.class);

    @Test
    public void testAutomaticRegistrationOfPipelineOptions() {
        Assert.assertTrue((boolean)PipelineOptionsFactory.getRegisteredOptions().contains(RegisteredTestOptions.class));
    }

    @Test
    public void testAutomaticRegistrationOfRunners() {
        Assert.assertEquals(REGISTERED_RUNNER, PipelineOptionsFactory.getRegisteredRunners().get(REGISTERED_RUNNER.getSimpleName().toLowerCase()));
    }

    @Test
    public void testAutomaticRegistrationInculdesWithoutRunnerSuffix() {
        Assert.assertEquals((Object)"RegisteredTest", (Object)REGISTERED_RUNNER.getSimpleName().substring(0, REGISTERED_RUNNER.getSimpleName().length() - "Runner".length()));
        Map registered = ((PipelineOptionsFactory.Cache)PipelineOptionsFactory.CACHE.get()).getSupportedPipelineRunners();
        Assert.assertEquals(REGISTERED_RUNNER, registered.get(REGISTERED_RUNNER.getSimpleName().toLowerCase().substring(0, REGISTERED_RUNNER.getSimpleName().length() - "Runner".length())));
    }

    @Test
    public void testAppNameIsSet() {
        ApplicationNameOptions options = (ApplicationNameOptions)PipelineOptionsFactory.as(ApplicationNameOptions.class);
        Assert.assertEquals((Object)PipelineOptionsFactoryTest.class.getSimpleName(), (Object)options.getAppName());
    }

    @Test
    public void testAppNameIsSetWhenUsingAs() {
        TestPipelineOptions options = (TestPipelineOptions)PipelineOptionsFactory.as(TestPipelineOptions.class);
        Assert.assertEquals((Object)PipelineOptionsFactoryTest.class.getSimpleName(), (Object)((ApplicationNameOptions)options.as(ApplicationNameOptions.class)).getAppName());
    }

    @Test
    public void testOptionsIdIsSet() throws Exception {
        ObjectMapper mapper = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
        PipelineOptions options = PipelineOptionsFactory.create();
        PipelineOptions clone = (PipelineOptions)mapper.readValue(mapper.writeValueAsString((Object)options), PipelineOptions.class);
        Assert.assertEquals((long)options.getOptionsId(), (long)clone.getOptionsId());
    }

    @Test
    public void testManualRegistration() {
        Assert.assertFalse((boolean)PipelineOptionsFactory.getRegisteredOptions().contains(TestPipelineOptions.class));
        PipelineOptionsFactory.register(TestPipelineOptions.class);
        Assert.assertTrue((boolean)PipelineOptionsFactory.getRegisteredOptions().contains(TestPipelineOptions.class));
    }

    @Test
    public void testDefaultRegistration() {
        Assert.assertTrue((boolean)PipelineOptionsFactory.getRegisteredOptions().contains(PipelineOptions.class));
    }

    @Test
    public void testMissingGetterThrows() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Expected getter for property [object] of type [java.lang.Object] on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MissingGetter].");
        PipelineOptionsFactory.as(MissingGetter.class);
    }

    @Test
    public void testMultipleMissingGettersThrows() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("missing property methods on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MissingMultipleGetters]");
        this.expectedException.expectMessage("getter for property [object] of type [java.lang.Object]");
        this.expectedException.expectMessage("getter for property [otherObject] of type [java.lang.Object]");
        PipelineOptionsFactory.as(MissingMultipleGetters.class);
    }

    @Test
    public void testMissingSetterThrows() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Expected setter for property [object] of type [java.lang.Object] on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MissingSetter].");
        PipelineOptionsFactory.as(MissingSetter.class);
    }

    @Test
    public void testMissingMultipleSettersThrows() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("missing property methods on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MissingMultipleSetters]");
        this.expectedException.expectMessage("setter for property [object] of type [java.lang.Object]");
        this.expectedException.expectMessage("setter for property [otherObject] of type [java.lang.Object]");
        PipelineOptionsFactory.as(MissingMultipleSetters.class);
    }

    @Test
    public void testMissingGettersAndSettersThrows() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("missing property methods on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MissingGettersAndSetters]");
        this.expectedException.expectMessage("getter for property [object] of type [java.lang.Object]");
        this.expectedException.expectMessage("setter for property [otherObject] of type [java.lang.Object]");
        PipelineOptionsFactory.as(MissingGettersAndSetters.class);
    }

    @Test
    public void testGetterSetterTypeMismatchThrows() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Type mismatch between getter and setter methods for property [value]. Getter is of type [boolean] whereas setter is of type [int].");
        PipelineOptionsFactory.as(GetterSetterTypeMismatch.class);
    }

    @Test
    public void testMultiGetterSetterTypeMismatchThrows() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Type mismatches between getters and setters detected:");
        this.expectedException.expectMessage("Property [value]: Getter is of type [boolean] whereas setter is of type [int].");
        this.expectedException.expectMessage("Property [other]: Getter is of type [long] whereas setter is of type [class java.lang.String].");
        PipelineOptionsFactory.as(MultiGetterSetterTypeMismatch.class);
    }

    @Test
    public void testHavingSettersGettersFromSeparateInterfacesIsValid() {
        PipelineOptionsFactory.as(CombinedObject.class);
    }

    @Test
    public void testHavingExtraneousMethodThrows() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Methods [extraneousMethod(int, String)] on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$ExtraneousMethod] do not conform to being bean properties.");
        PipelineOptionsFactory.as(ExtraneousMethod.class);
    }

    @Test
    public void testReturnTypeConflictThrows() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Method [getObject] has multiple definitions [public abstract java.lang.Object org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MissingSetter.getObject(), public abstract java.lang.String org.apache.beam.sdk.options.PipelineOptionsFactoryTest$ReturnTypeConflict.getObject()] with different return types for [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$ReturnTypeConflict].");
        PipelineOptionsFactory.as(ReturnTypeConflict.class);
    }

    @Test
    public void testMultipleReturnTypeConflictsThrows() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("[org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultiReturnTypeConflict]");
        this.expectedException.expectMessage("Methods with multiple definitions with different return types");
        this.expectedException.expectMessage("Method [getObject] has multiple definitions");
        this.expectedException.expectMessage("public abstract java.lang.Object org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MissingSetter.getObject()");
        this.expectedException.expectMessage("public abstract java.lang.String org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultiReturnTypeConflict.getObject()");
        this.expectedException.expectMessage("Method [getOther] has multiple definitions");
        this.expectedException.expectMessage("public abstract java.lang.Object org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultiReturnTypeConflictBase.getOther()");
        this.expectedException.expectMessage("public abstract java.lang.Long org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultiReturnTypeConflict.getOther()");
        PipelineOptionsFactory.as(MultiReturnTypeConflict.class);
    }

    @Test
    public void testSetterAnnotatedWithJsonIgnore() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Expected setter for property [value] to not be marked with @JsonIgnore on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$SetterWithJsonIgnore]");
        PipelineOptionsFactory.as(SetterWithJsonIgnore.class);
    }

    @Test
    public void testMultipleSettersAnnotatedWithJsonIgnore() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Found setters marked with @JsonIgnore:");
        this.expectedException.expectMessage("property [other] should not be marked with @JsonIgnore on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultiSetterWithJsonIgnore]");
        this.expectedException.expectMessage("property [value] should not be marked with @JsonIgnore on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$SetterWithJsonIgnore]");
        PipelineOptionsFactory.as(MultiSetterWithJsonIgnore.class);
    }

    @Test
    public void testNotAllGettersAnnotatedWithJsonIgnore() throws Exception {
        GetterWithJsonIgnore options = (GetterWithJsonIgnore)PipelineOptionsFactory.as(GetterWithJsonIgnore.class);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Expected getter for property [object] to be marked with @JsonIgnore on all [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$GetterWithJsonIgnore, org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MissingSetter], found only on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$GetterWithJsonIgnore]");
        options.as(CombinedObject.class);
    }

    @Test
    public void testMultipleGettersWithInconsistentJsonIgnore() {
        MultiGetters options = (MultiGetters)PipelineOptionsFactory.as(MultiGetters.class);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Property getters are inconsistently marked with @JsonIgnore:");
        this.expectedException.expectMessage("property [object] to be marked on all");
        this.expectedException.expectMessage("found only on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultiGetters]");
        this.expectedException.expectMessage("property [other] to be marked on all");
        this.expectedException.expectMessage("found only on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultipleGettersWithInconsistentJsonIgnore]");
        this.expectedException.expectMessage((Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)java.util.Arrays.toString(new String[]{"org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultipleGettersWithInconsistentJsonIgnore", "org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultiGetters"})), (Matcher)Matchers.containsString((String)java.util.Arrays.toString(new String[]{"org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultiGetters", "org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultipleGettersWithInconsistentJsonIgnore"}))));
        this.expectedException.expectMessage(Matchers.not((Matcher)Matchers.containsString((String)"property [consistent]")));
        options.as(MultipleGettersWithInconsistentJsonIgnore.class);
    }

    @Test
    public void testSetterAnnotatedWithDefault() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Expected setter for property [value] to not be marked with @Default on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$SetterWithDefault]");
        PipelineOptionsFactory.as(SetterWithDefault.class);
    }

    @Test
    public void testMultipleSettersAnnotatedWithDefault() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Found setters marked with @Default:");
        this.expectedException.expectMessage("property [other] should not be marked with @Default on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultiSetterWithDefault]");
        this.expectedException.expectMessage("property [value] should not be marked with @Default on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$SetterWithDefault]");
        PipelineOptionsFactory.as(MultiSetterWithDefault.class);
    }

    @Test
    public void testNotAllGettersAnnotatedWithDefault() throws Exception {
        GetterWithDefault options = (GetterWithDefault)PipelineOptionsFactory.as(GetterWithDefault.class);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Expected getter for property [object] to be marked with @Default on all [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$GetterWithDefault, org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MissingSetter], found only on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$GetterWithDefault]");
        options.as(CombinedObject.class);
    }

    @Test
    public void testGettersAnnotatedWithConsistentDefault() throws Exception {
        GetterWithConsistentDefault options = (GetterWithConsistentDefault)((GetterWithDefault)PipelineOptionsFactory.as(GetterWithDefault.class)).as(GetterWithConsistentDefault.class);
        Assert.assertEquals((Object)1, (Object)options.getObject());
    }

    @Test
    public void testGettersAnnotatedWithInconsistentDefault() throws Exception {
        GetterWithDefault options = (GetterWithDefault)PipelineOptionsFactory.as(GetterWithDefault.class);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Property [object] is marked with contradictory annotations. Found [[Default.Integer(value=1) on org.apache.beam.sdk.options.PipelineOptionsFactoryTest$GetterWithDefault#getObject()], [Default.String(value=abc) on org.apache.beam.sdk.options.PipelineOptionsFactoryTest$GetterWithInconsistentDefaultType#getObject()]].");
        options.as(GetterWithInconsistentDefaultType.class);
    }

    @Test
    public void testGettersAnnotatedWithInconsistentDefaultValue() throws Exception {
        GetterWithDefault options = (GetterWithDefault)PipelineOptionsFactory.as(GetterWithDefault.class);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Property [object] is marked with contradictory annotations. Found [[Default.Integer(value=1) on org.apache.beam.sdk.options.PipelineOptionsFactoryTest$GetterWithDefault#getObject()], [Default.Integer(value=0) on org.apache.beam.sdk.options.PipelineOptionsFactoryTest$GetterWithInconsistentDefaultValue#getObject()]].");
        options.as(GetterWithInconsistentDefaultValue.class);
    }

    @Test
    public void testGettersAnnotatedWithInconsistentJsonIgnoreValue() throws Exception {
        GetterWithJsonIgnore options = (GetterWithJsonIgnore)PipelineOptionsFactory.as(GetterWithJsonIgnore.class);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Property [object] is marked with contradictory annotations. Found [[JsonIgnore(value=false) on org.apache.beam.sdk.options.PipelineOptionsFactoryTest$GetterWithInconsistentJsonIgnoreValue#getObject()], [JsonIgnore(value=true) on org.apache.beam.sdk.options.PipelineOptionsFactoryTest$GetterWithJsonIgnore#getObject()]].");
        options.as(GetterWithInconsistentJsonIgnoreValue.class);
    }

    @Test
    public void testGettersWithMultipleDefaults() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Property [object] is marked with contradictory annotations. Found [[Default.String(value=abc) on org.apache.beam.sdk.options.PipelineOptionsFactoryTest$GettersWithMultipleDefault#getObject()], [Default.Integer(value=0) on org.apache.beam.sdk.options.PipelineOptionsFactoryTest$GettersWithMultipleDefault#getObject()]].");
        PipelineOptionsFactory.as(GettersWithMultipleDefault.class);
    }

    @Test
    public void testMultipleGettersWithInconsistentDefault() {
        MultiGettersWithDefault options = (MultiGettersWithDefault)PipelineOptionsFactory.as(MultiGettersWithDefault.class);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Property getters are inconsistently marked with @Default:");
        this.expectedException.expectMessage("property [object] to be marked on all");
        this.expectedException.expectMessage("found only on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultiGettersWithDefault]");
        this.expectedException.expectMessage("property [other] to be marked on all");
        this.expectedException.expectMessage("found only on [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultipleGettersWithInconsistentDefault]");
        this.expectedException.expectMessage((Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)java.util.Arrays.toString(new String[]{"org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultipleGettersWithInconsistentDefault", "org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultiGettersWithDefault"})), (Matcher)Matchers.containsString((String)java.util.Arrays.toString(new String[]{"org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultiGettersWithDefault", "org.apache.beam.sdk.options.PipelineOptionsFactoryTest$MultipleGettersWithInconsistentDefault"}))));
        this.expectedException.expectMessage(Matchers.not((Matcher)Matchers.containsString((String)"property [consistent]")));
        options.as(MultipleGettersWithInconsistentDefault.class);
    }

    @Test
    public void testAppNameIsNotOverriddenWhenPassedInViaCommandLine() {
        ApplicationNameOptions options = (ApplicationNameOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--appName=testAppName"}).as(ApplicationNameOptions.class);
        Assert.assertEquals((Object)"testAppName", (Object)options.getAppName());
    }

    @Test
    public void testPropertyIsSetOnRegisteredPipelineOptionNotPartOfOriginalInterface() {
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])new String[]{"--streaming"}).create();
        Assert.assertTrue((boolean)((StreamingOptions)options.as(StreamingOptions.class)).isStreaming());
    }

    @Test
    public void testPrimitives() {
        String[] args = new String[]{"--boolean=true", "--char=d", "--byte=12", "--short=300", "--int=100000", "--long=123890123890", "--float=55.5", "--double=12.3"};
        Primitives options = (Primitives)PipelineOptionsFactory.fromArgs((String[])args).as(Primitives.class);
        Assert.assertTrue((boolean)options.getBoolean());
        Assert.assertEquals((long)100L, (long)options.getChar());
        Assert.assertEquals((long)12L, (long)options.getByte());
        Assert.assertEquals((long)300L, (long)options.getShort());
        Assert.assertEquals((long)100000L, (long)options.getInt());
        Assert.assertEquals((long)123890123890L, (long)options.getLong());
        Assert.assertEquals((float)55.5f, (float)options.getFloat(), (float)0.0f);
        Assert.assertEquals((double)12.3, (double)options.getDouble(), (double)0.0);
    }

    @Test
    public void testBooleanShorthandArgument() {
        String[] args = new String[]{"--boolean"};
        Primitives options = (Primitives)PipelineOptionsFactory.fromArgs((String[])args).as(Primitives.class);
        Assert.assertTrue((boolean)options.getBoolean());
    }

    @Test
    public void testEmptyValueNotAllowed() {
        String[] args = new String[]{"--byte="};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.emptyStringErrorMessage());
        PipelineOptionsFactory.fromArgs((String[])args).as(Primitives.class);
    }

    @Test
    public void testObjects() {
        String[] args = new String[]{"--boolean=true", "--char=d", "--byte=12", "--short=300", "--int=100000", "--long=123890123890", "--float=55.5", "--double=12.3", "--string=stringValue", "--emptyString=", "--classValue=" + PipelineOptionsFactoryTest.class.getName(), "--enum=" + (Object)((Object)TestEnum.Value), "--stringValue=beam", "--longValue=12389049585840", "--enumValue=" + (Object)((Object)TestEnum.Value)};
        Objects options = (Objects)PipelineOptionsFactory.fromArgs((String[])args).as(Objects.class);
        Assert.assertTrue((boolean)options.getBoolean());
        Assert.assertEquals((Object)Character.valueOf('d'), (Object)options.getChar());
        Assert.assertEquals((Object)12, (Object)options.getByte());
        Assert.assertEquals((Object)300, (Object)options.getShort());
        Assert.assertEquals((Object)100000, (Object)options.getInt());
        Assert.assertEquals((Object)123890123890L, (Object)options.getLong());
        Assert.assertEquals((float)55.5f, (float)options.getFloat().floatValue(), (float)0.0f);
        Assert.assertEquals((double)12.3, (double)options.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"stringValue", (Object)options.getString());
        Assert.assertTrue((boolean)options.getEmptyString().isEmpty());
        Assert.assertEquals(PipelineOptionsFactoryTest.class, options.getClassValue());
        Assert.assertEquals((Object)((Object)TestEnum.Value), (Object)((Object)options.getEnum()));
        Assert.assertEquals((Object)"beam", (Object)options.getStringValue().get());
        Assert.assertEquals((Object)12389049585840L, (Object)options.getLongValue().get());
        Assert.assertEquals((Object)((Object)TestEnum.Value), (Object)options.getEnumValue().get());
    }

    @Test
    public void testStringValueProvider() {
        String[] args = new String[]{"--stringValue=beam"};
        String[] emptyArgs = new String[]{"--stringValue="};
        Objects options = (Objects)PipelineOptionsFactory.fromArgs((String[])args).as(Objects.class);
        Assert.assertEquals((Object)"beam", (Object)options.getStringValue().get());
        options = (Objects)PipelineOptionsFactory.fromArgs((String[])emptyArgs).as(Objects.class);
        Assert.assertEquals((Object)"", (Object)options.getStringValue().get());
    }

    @Test
    public void testLongValueProvider() {
        String[] args = new String[]{"--longValue=12345678762"};
        String[] emptyArgs = new String[]{"--longValue="};
        Objects options = (Objects)PipelineOptionsFactory.fromArgs((String[])args).as(Objects.class);
        Assert.assertEquals((Object)12345678762L, (Object)options.getLongValue().get());
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.emptyStringErrorMessage());
        PipelineOptionsFactory.fromArgs((String[])emptyArgs).as(Objects.class);
    }

    @Test
    public void testEnumValueProvider() {
        String[] args = new String[]{"--enumValue=" + (Object)((Object)TestEnum.Value)};
        String[] emptyArgs = new String[]{"--enumValue="};
        Objects options = (Objects)PipelineOptionsFactory.fromArgs((String[])args).as(Objects.class);
        Assert.assertEquals((Object)((Object)TestEnum.Value), (Object)options.getEnumValue().get());
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.emptyStringErrorMessage());
        PipelineOptionsFactory.fromArgs((String[])emptyArgs).as(Objects.class);
    }

    @Test
    public void testComplexTypes() {
        String[] args = new String[]{"--map={\"key\":\"value\",\"key2\":\"value2\"}", "--object={\"key\":\"value\",\"key2\":\"value2\"}", "--objectValue={\"key\":\"value\",\"key2\":\"value2\"}"};
        ComplexTypes options = (ComplexTypes)PipelineOptionsFactory.fromArgs((String[])args).as(ComplexTypes.class);
        Assert.assertEquals(ImmutableMap.of("key", "value", "key2", "value2"), options.getMap());
        Assert.assertEquals((Object)"value", (Object)options.getObject().value);
        Assert.assertEquals((Object)"value2", (Object)options.getObject().value2);
        Assert.assertEquals((Object)"value", (Object)((ComplexType)options.getObjectValue().get()).value);
        Assert.assertEquals((Object)"value2", (Object)((ComplexType)options.getObjectValue().get()).value2);
    }

    @Test
    public void testMissingArgument() {
        String[] args = new String[]{};
        Objects options = (Objects)PipelineOptionsFactory.fromArgs((String[])args).as(Objects.class);
        Assert.assertNull((Object)options.getString());
    }

    @Test
    public void testArrays() {
        String[] args = new String[]{"--boolean=true", "--boolean=true", "--boolean=false", "--char=d", "--char=e", "--char=f", "--short=300", "--short=301", "--short=302", "--int=100000", "--int=100001", "--int=100002", "--long=123890123890", "--long=123890123891", "--long=123890123892", "--float=55.5", "--float=55.6", "--float=55.7", "--double=12.3", "--double=12.4", "--double=12.5", "--string=stringValue1", "--string=stringValue2", "--string=stringValue3", "--classValue=" + PipelineOptionsFactory.class.getName(), "--classValue=" + PipelineOptionsFactoryTest.class.getName(), "--enum=" + (Object)((Object)TestEnum.Value), "--enum=" + (Object)((Object)TestEnum.Value2), "--stringValue=abc", "--stringValue=beam", "--longValue=123890123890", "--longValue=123890123891", "--enumValue=" + (Object)((Object)TestEnum.Value), "--enumValue=" + (Object)((Object)TestEnum.Value2)};
        Arrays options = (Arrays)PipelineOptionsFactory.fromArgs((String[])args).as(Arrays.class);
        boolean[] bools = options.getBoolean();
        Assert.assertTrue((bools[0] && bools[1] && !bools[2] ? 1 : 0) != 0);
        Assert.assertArrayEquals((char[])new char[]{'d', 'e', 'f'}, (char[])options.getChar());
        Assert.assertArrayEquals((short[])new short[]{300, 301, 302}, (short[])options.getShort());
        Assert.assertArrayEquals((int[])new int[]{100000, 100001, 100002}, (int[])options.getInt());
        Assert.assertArrayEquals((long[])new long[]{123890123890L, 123890123891L, 123890123892L}, (long[])options.getLong());
        Assert.assertArrayEquals((float[])new float[]{55.5f, 55.6f, 55.7f}, (float[])options.getFloat(), (float)0.0f);
        Assert.assertArrayEquals((double[])new double[]{12.3, 12.4, 12.5}, (double[])options.getDouble(), (double)0.0);
        Assert.assertArrayEquals((Object[])new String[]{"stringValue1", "stringValue2", "stringValue3"}, (Object[])options.getString());
        Assert.assertArrayEquals((Object[])new Class[]{PipelineOptionsFactory.class, PipelineOptionsFactoryTest.class}, (Object[])options.getClassValue());
        Assert.assertArrayEquals((Object[])new TestEnum[]{TestEnum.Value, TestEnum.Value2}, (Object[])options.getEnum());
        Assert.assertArrayEquals((Object[])new String[]{"abc", "beam"}, (Object[])((Object[])options.getStringValue().get()));
        Assert.assertArrayEquals((Object[])new Long[]{123890123890L, 123890123891L}, (Object[])((Object[])options.getLongValue().get()));
        Assert.assertArrayEquals((Object[])new TestEnum[]{TestEnum.Value, TestEnum.Value2}, (Object[])((Object[])options.getEnumValue().get()));
    }

    @Test
    public void testEmptyInStringArrays() {
        String[] args = new String[]{"--string=", "--string=", "--string="};
        Arrays options = (Arrays)PipelineOptionsFactory.fromArgs((String[])args).as(Arrays.class);
        Assert.assertArrayEquals((Object[])new String[]{"", "", ""}, (Object[])options.getString());
    }

    @Test
    public void testEmptyInStringArraysWithCommaList() {
        String[] args = new String[]{"--string=a,,b"};
        Arrays options = (Arrays)PipelineOptionsFactory.fromArgs((String[])args).as(Arrays.class);
        Assert.assertArrayEquals((Object[])new String[]{"a", "", "b"}, (Object[])options.getString());
    }

    @Test
    public void testEmptyInNonStringArrays() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.emptyStringErrorMessage());
        String[] args = new String[]{"--boolean=true", "--boolean=", "--boolean=false"};
        PipelineOptionsFactory.fromArgs((String[])args).as(Arrays.class);
    }

    @Test
    public void testEmptyInNonStringArraysWithCommaList() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.emptyStringErrorMessage());
        String[] args = new String[]{"--int=1,,9"};
        PipelineOptionsFactory.fromArgs((String[])args).as(Arrays.class);
    }

    @Test
    public void testStringArrayValueProvider() {
        String[] args = new String[]{"--stringValue=abc", "--stringValue=xyz"};
        String[] commaArgs = new String[]{"--stringValue=abc,xyz"};
        String[] emptyArgs = new String[]{"--stringValue=", "--stringValue="};
        Arrays options = (Arrays)PipelineOptionsFactory.fromArgs((String[])args).as(Arrays.class);
        Assert.assertArrayEquals((Object[])new String[]{"abc", "xyz"}, (Object[])((Object[])options.getStringValue().get()));
        options = (Arrays)PipelineOptionsFactory.fromArgs((String[])commaArgs).as(Arrays.class);
        Assert.assertArrayEquals((Object[])new String[]{"abc", "xyz"}, (Object[])((Object[])options.getStringValue().get()));
        options = (Arrays)PipelineOptionsFactory.fromArgs((String[])emptyArgs).as(Arrays.class);
        Assert.assertArrayEquals((Object[])new String[]{"", ""}, (Object[])((Object[])options.getStringValue().get()));
    }

    @Test
    public void testLongArrayValueProvider() {
        String[] args = new String[]{"--longValue=12345678762", "--longValue=12345678763"};
        String[] commaArgs = new String[]{"--longValue=12345678762,12345678763"};
        String[] emptyArgs = new String[]{"--longValue=", "--longValue="};
        Arrays options = (Arrays)PipelineOptionsFactory.fromArgs((String[])args).as(Arrays.class);
        Assert.assertArrayEquals((Object[])new Long[]{12345678762L, 12345678763L}, (Object[])((Object[])options.getLongValue().get()));
        options = (Arrays)PipelineOptionsFactory.fromArgs((String[])commaArgs).as(Arrays.class);
        Assert.assertArrayEquals((Object[])new Long[]{12345678762L, 12345678763L}, (Object[])((Object[])options.getLongValue().get()));
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.emptyStringErrorMessage());
        PipelineOptionsFactory.fromArgs((String[])emptyArgs).as(Arrays.class);
    }

    @Test
    public void testEnumArrayValueProvider() {
        String[] args = new String[]{"--enumValue=" + (Object)((Object)TestEnum.Value), "--enumValue=" + (Object)((Object)TestEnum.Value2)};
        String[] commaArgs = new String[]{"--enumValue=" + (Object)((Object)TestEnum.Value) + "," + (Object)((Object)TestEnum.Value2)};
        String[] emptyArgs = new String[]{"--enumValue="};
        Arrays options = (Arrays)PipelineOptionsFactory.fromArgs((String[])args).as(Arrays.class);
        Assert.assertArrayEquals((Object[])new TestEnum[]{TestEnum.Value, TestEnum.Value2}, (Object[])((Object[])options.getEnumValue().get()));
        options = (Arrays)PipelineOptionsFactory.fromArgs((String[])commaArgs).as(Arrays.class);
        Assert.assertArrayEquals((Object[])new TestEnum[]{TestEnum.Value, TestEnum.Value2}, (Object[])((Object[])options.getEnumValue().get()));
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.emptyStringErrorMessage());
        PipelineOptionsFactory.fromArgs((String[])emptyArgs).as(Arrays.class);
    }

    @Test
    public void testOutOfOrderArrays() {
        String[] args = new String[]{"--char=d", "--boolean=true", "--boolean=true", "--char=e", "--char=f", "--boolean=false"};
        Arrays options = (Arrays)PipelineOptionsFactory.fromArgs((String[])args).as(Arrays.class);
        boolean[] bools = options.getBoolean();
        Assert.assertTrue((bools[0] && bools[1] && !bools[2] ? 1 : 0) != 0);
        Assert.assertArrayEquals((char[])new char[]{'d', 'e', 'f'}, (char[])options.getChar());
    }

    @Test
    public void testListRawDefaultsToString() {
        String[] manyArgs = new String[]{"--list=stringValue1", "--list=stringValue2", "--list=stringValue3"};
        String[] manyArgsWithEmptyString = new String[]{"--list=stringValue1", "--list=", "--list=stringValue3"};
        Lists options = (Lists)PipelineOptionsFactory.fromArgs((String[])manyArgs).as(Lists.class);
        Assert.assertEquals(ImmutableList.of("stringValue1", "stringValue2", "stringValue3"), (Object)options.getList());
        options = (Lists)PipelineOptionsFactory.fromArgs((String[])manyArgsWithEmptyString).as(Lists.class);
        Assert.assertEquals(ImmutableList.of("stringValue1", "", "stringValue3"), (Object)options.getList());
    }

    @Test
    public void testListString() {
        String[] manyArgs = new String[]{"--string=stringValue1", "--string=stringValue2", "--string=stringValue3"};
        String[] oneArg = new String[]{"--string=stringValue1"};
        String[] emptyArg = new String[]{"--string="};
        Lists options = (Lists)PipelineOptionsFactory.fromArgs((String[])manyArgs).as(Lists.class);
        Assert.assertEquals(ImmutableList.of("stringValue1", "stringValue2", "stringValue3"), options.getString());
        options = (Lists)PipelineOptionsFactory.fromArgs((String[])oneArg).as(Lists.class);
        Assert.assertEquals(ImmutableList.of("stringValue1"), options.getString());
        options = (Lists)PipelineOptionsFactory.fromArgs((String[])emptyArg).as(Lists.class);
        Assert.assertEquals(ImmutableList.of(""), options.getString());
    }

    @Test
    public void testListInt() {
        String[] manyArgs = new String[]{"--integer=1", "--integer=2", "--integer=3"};
        String[] manyArgsShort = new String[]{"--integer=1,2,3"};
        String[] oneArg = new String[]{"--integer=1"};
        String[] missingArg = new String[]{"--integer="};
        Lists options = (Lists)PipelineOptionsFactory.fromArgs((String[])manyArgs).as(Lists.class);
        Assert.assertEquals(ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), options.getInteger());
        options = (Lists)PipelineOptionsFactory.fromArgs((String[])manyArgsShort).as(Lists.class);
        Assert.assertEquals(ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), options.getInteger());
        options = (Lists)PipelineOptionsFactory.fromArgs((String[])oneArg).as(Lists.class);
        Assert.assertEquals(ImmutableList.of(Integer.valueOf(1)), options.getInteger());
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.emptyStringErrorMessage("java.util.List<java.lang.Integer>"));
        PipelineOptionsFactory.fromArgs((String[])missingArg).as(Lists.class);
    }

    @Test
    public void testListShorthand() {
        String[] args = new String[]{"--string=stringValue1,stringValue2,stringValue3"};
        Lists options = (Lists)PipelineOptionsFactory.fromArgs((String[])args).as(Lists.class);
        Assert.assertEquals(ImmutableList.of("stringValue1", "stringValue2", "stringValue3"), options.getString());
    }

    @Test
    public void testMixedShorthandAndLongStyleList() {
        String[] args = new String[]{"--char=d", "--char=e", "--char=f", "--char=g,h,i", "--char=j", "--char=k", "--char=l", "--char=m,n,o"};
        Arrays options = (Arrays)PipelineOptionsFactory.fromArgs((String[])args).as(Arrays.class);
        Assert.assertArrayEquals((char[])new char[]{'d', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o'}, (char[])options.getChar());
    }

    @Test
    public void testStringListValueProvider() {
        String[] args = new String[]{"--stringValue=abc", "--stringValue=xyz"};
        String[] commaArgs = new String[]{"--stringValue=abc,xyz"};
        String[] emptyArgs = new String[]{"--stringValue=", "--stringValue="};
        Lists options = (Lists)PipelineOptionsFactory.fromArgs((String[])args).as(Lists.class);
        Assert.assertEquals(ImmutableList.of("abc", "xyz"), (Object)options.getStringValue().get());
        options = (Lists)PipelineOptionsFactory.fromArgs((String[])commaArgs).as(Lists.class);
        Assert.assertEquals(ImmutableList.of("abc", "xyz"), (Object)options.getStringValue().get());
        options = (Lists)PipelineOptionsFactory.fromArgs((String[])emptyArgs).as(Lists.class);
        Assert.assertEquals(ImmutableList.of("", ""), (Object)options.getStringValue().get());
    }

    @Test
    public void testLongListValueProvider() {
        String[] args = new String[]{"--longValue=12345678762", "--longValue=12345678763"};
        String[] commaArgs = new String[]{"--longValue=12345678762,12345678763"};
        String[] emptyArgs = new String[]{"--longValue=", "--longValue="};
        Lists options = (Lists)PipelineOptionsFactory.fromArgs((String[])args).as(Lists.class);
        Assert.assertEquals(ImmutableList.of(Long.valueOf(12345678762L), Long.valueOf(12345678763L)), (Object)options.getLongValue().get());
        options = (Lists)PipelineOptionsFactory.fromArgs((String[])commaArgs).as(Lists.class);
        Assert.assertEquals(ImmutableList.of(Long.valueOf(12345678762L), Long.valueOf(12345678763L)), (Object)options.getLongValue().get());
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.emptyStringErrorMessage());
        PipelineOptionsFactory.fromArgs((String[])emptyArgs).as(Lists.class);
    }

    @Test
    public void testEnumListValueProvider() {
        String[] args = new String[]{"--enumValue=" + (Object)((Object)TestEnum.Value), "--enumValue=" + (Object)((Object)TestEnum.Value2)};
        String[] commaArgs = new String[]{"--enumValue=" + (Object)((Object)TestEnum.Value) + "," + (Object)((Object)TestEnum.Value2)};
        String[] emptyArgs = new String[]{"--enumValue="};
        Lists options = (Lists)PipelineOptionsFactory.fromArgs((String[])args).as(Lists.class);
        Assert.assertEquals(ImmutableList.of(TestEnum.Value, TestEnum.Value2), (Object)options.getEnumValue().get());
        options = (Lists)PipelineOptionsFactory.fromArgs((String[])commaArgs).as(Lists.class);
        Assert.assertEquals(ImmutableList.of(TestEnum.Value, TestEnum.Value2), (Object)options.getEnumValue().get());
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.emptyStringErrorMessage());
        PipelineOptionsFactory.fromArgs((String[])emptyArgs).as(Lists.class);
    }

    @Test
    public void testSetASingularAttributeUsingAListThrowsAnError() {
        String[] args = new String[]{"--string=100", "--string=200"};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("expected one element but was");
        PipelineOptionsFactory.fromArgs((String[])args).as(Objects.class);
    }

    @Test
    public void testSetASingularAttributeUsingAListIsIgnoredWithoutStrictParsing() {
        String[] args = new String[]{"--diskSizeGb=100", "--diskSizeGb=200"};
        PipelineOptionsFactory.fromArgs((String[])args).withoutStrictParsing().create();
        this.expectedLogs.verifyWarn("Strict parsing is disabled, ignoring option");
    }

    @Test
    public void testMapIntInt() {
        String[] manyArgsShort = new String[]{"--map={\"1\":1,\"2\":2}"};
        String[] oneArg = new String[]{"--map={\"1\":1}"};
        String[] missingArg = new String[]{"--map="};
        Maps options = (Maps)PipelineOptionsFactory.fromArgs((String[])manyArgsShort).as(Maps.class);
        Assert.assertEquals(ImmutableMap.of(1, 1, 2, 2), options.getMap());
        options = (Maps)PipelineOptionsFactory.fromArgs((String[])oneArg).as(Maps.class);
        Assert.assertEquals(ImmutableMap.of(1, 1), options.getMap());
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.emptyStringErrorMessage("java.util.Map<java.lang.Integer, java.lang.Integer>"));
        PipelineOptionsFactory.fromArgs((String[])missingArg).as(Maps.class);
    }

    @Test
    public void testNestedMap() {
        String[] manyArgsShort = new String[]{"--nestedMap={\"1\":{\"1\":1},\"2\":{\"2\":2}}"};
        String[] oneArg = new String[]{"--nestedMap={\"1\":{\"1\":1}}"};
        String[] missingArg = new String[]{"--nestedMap="};
        Maps options = (Maps)PipelineOptionsFactory.fromArgs((String[])manyArgsShort).as(Maps.class);
        Assert.assertEquals(ImmutableMap.of(1, ImmutableMap.of(1, 1), 2, ImmutableMap.of(2, 2)), options.getNestedMap());
        options = (Maps)PipelineOptionsFactory.fromArgs((String[])oneArg).as(Maps.class);
        Assert.assertEquals(ImmutableMap.of(1, ImmutableMap.of(1, 1)), options.getNestedMap());
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.emptyStringErrorMessage("java.util.Map<java.lang.Integer, java.util.Map<java.lang.Integer, java.lang.Integer>>"));
        PipelineOptionsFactory.fromArgs((String[])missingArg).as(Maps.class);
    }

    @Test
    public void testSettingRunner() {
        String[] args = new String[]{"--runner=" + RegisteredTestRunner.class.getSimpleName()};
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])args).create();
        Assert.assertEquals(RegisteredTestRunner.class, (Object)options.getRunner());
    }

    @Test
    public void testSettingRunnerFullName() {
        String[] args = new String[]{String.format("--runner=%s", CrashingRunner.class.getName())};
        PipelineOptions opts = PipelineOptionsFactory.fromArgs((String[])args).create();
        Assert.assertEquals((Object)opts.getRunner(), CrashingRunner.class);
    }

    @Test
    public void testSettingUnknownRunner() {
        String[] args = new String[]{"--runner=UnknownRunner"};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Unknown 'runner' specified 'UnknownRunner', supported pipeline runners");
        Set registeredRunners = PipelineOptionsFactory.getRegisteredRunners().keySet();
        Assert.assertThat(registeredRunners, (Matcher)Matchers.hasItem((Object)REGISTERED_RUNNER.getSimpleName().toLowerCase()));
        this.expectedException.expectMessage(((PipelineOptionsFactory.Cache)PipelineOptionsFactory.CACHE.get()).getSupportedRunners().toString());
        PipelineOptionsFactory.fromArgs((String[])args).create();
    }

    @Test
    public void testSettingRunnerCanonicalClassNameNotInSupportedExists() {
        String[] args = new String[]{String.format("--runner=%s", ExampleTestRunner.class.getName())};
        PipelineOptions opts = PipelineOptionsFactory.fromArgs((String[])args).create();
        Assert.assertEquals((Object)opts.getRunner(), ExampleTestRunner.class);
    }

    @Test
    public void testSettingRunnerCanonicalClassNameNotInSupportedNotPipelineRunner() {
        String[] args = new String[]{"--runner=java.lang.String"};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("does not implement PipelineRunner");
        this.expectedException.expectMessage("java.lang.String");
        PipelineOptionsFactory.fromArgs((String[])args).create();
    }

    @Test
    public void testUsingArgumentWithUnknownPropertyIsNotAllowed() {
        String[] args = new String[]{"--unknownProperty=value"};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("missing a property named 'unknownProperty'");
        PipelineOptionsFactory.fromArgs((String[])args).create();
    }

    @Test
    public void testUsingArgumentWithMisspelledPropertyGivesASuggestion() {
        String[] args = new String[]{"--ab=value"};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("missing a property named 'ab'. Did you mean 'abc'?");
        PipelineOptionsFactory.fromArgs((String[])args).as(SuggestedOptions.class);
    }

    @Test
    public void testUsingArgumentWithMisspelledPropertyGivesMultipleSuggestions() {
        String[] args = new String[]{"--abcde=value"};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("missing a property named 'abcde'. Did you mean one of [abc, abcdefg]?");
        PipelineOptionsFactory.fromArgs((String[])args).as(SuggestedOptions.class);
    }

    @Test
    public void testUsingArgumentWithUnknownPropertyIsIgnoredWithoutStrictParsing() {
        String[] args = new String[]{"--unknownProperty=value"};
        PipelineOptionsFactory.fromArgs((String[])args).withoutStrictParsing().create();
        this.expectedLogs.verifyWarn("missing a property named 'unknownProperty'");
    }

    @Test
    public void testUsingArgumentStartingWithIllegalCharacterIsNotAllowed() {
        String[] args = new String[]{" --diskSizeGb=100"};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Argument ' --diskSizeGb=100' does not begin with '--'");
        PipelineOptionsFactory.fromArgs((String[])args).create();
    }

    @Test
    public void testUsingArgumentStartingWithIllegalCharacterIsIgnoredWithoutStrictParsing() {
        String[] args = new String[]{" --diskSizeGb=100"};
        PipelineOptionsFactory.fromArgs((String[])args).withoutStrictParsing().create();
        this.expectedLogs.verifyWarn("Strict parsing is disabled, ignoring option");
    }

    @Test
    public void testEmptyArgumentIsIgnored() {
        String[] args = new String[]{"", "--string=100", "", "", "--runner=" + REGISTERED_RUNNER.getSimpleName()};
        PipelineOptionsFactory.fromArgs((String[])args).as(Objects.class);
    }

    @Test
    public void testNullArgumentIsIgnored() {
        String[] args = new String[]{"--string=100", null, null, "--runner=" + REGISTERED_RUNNER.getSimpleName()};
        PipelineOptionsFactory.fromArgs((String[])args).as(Objects.class);
    }

    @Test
    public void testUsingArgumentWithInvalidNameIsNotAllowed() {
        String[] args = new String[]{"--=100"};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Argument '--=100' starts with '--='");
        PipelineOptionsFactory.fromArgs((String[])args).create();
    }

    @Test
    public void testUsingArgumentWithInvalidNameIsIgnoredWithoutStrictParsing() {
        String[] args = new String[]{"--=100"};
        PipelineOptionsFactory.fromArgs((String[])args).withoutStrictParsing().create();
        this.expectedLogs.verifyWarn("Strict parsing is disabled, ignoring option");
    }

    @Test
    public void testWhenNoHelpIsRequested() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayListMultimap arguments = ArrayListMultimap.create();
        Assert.assertFalse((boolean)PipelineOptionsFactory.printHelpUsageAndExitIfNeeded(arguments, (PrintStream)new PrintStream(baos), (boolean)false));
        String output = new String(baos.toByteArray(), Charsets.UTF_8);
        Assert.assertEquals((Object)"", (Object)output);
    }

    @Test
    public void testDefaultHelpAsArgument() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayListMultimap<String, String> arguments = ArrayListMultimap.create();
        arguments.put("help", "true");
        Assert.assertTrue((boolean)PipelineOptionsFactory.printHelpUsageAndExitIfNeeded(arguments, (PrintStream)new PrintStream(baos), (boolean)false));
        String output = new String(baos.toByteArray(), Charsets.UTF_8);
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"The set of registered options are:"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"org.apache.beam.sdk.options.PipelineOptions"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"Use --help=<OptionsName> for detailed help."));
    }

    @Test
    public void testSpecificHelpAsArgument() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayListMultimap<String, String> arguments = ArrayListMultimap.create();
        arguments.put("help", "org.apache.beam.sdk.options.PipelineOptions");
        Assert.assertTrue((boolean)PipelineOptionsFactory.printHelpUsageAndExitIfNeeded(arguments, (PrintStream)new PrintStream(baos), (boolean)false));
        String output = new String(baos.toByteArray(), Charsets.UTF_8);
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"org.apache.beam.sdk.options.PipelineOptions"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"--runner"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"Default: DirectRunner"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"The pipeline runner that will be used to execute the pipeline."));
    }

    @Test
    public void testSpecificHelpAsArgumentWithSimpleClassName() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayListMultimap<String, String> arguments = ArrayListMultimap.create();
        arguments.put("help", "PipelineOptions");
        Assert.assertTrue((boolean)PipelineOptionsFactory.printHelpUsageAndExitIfNeeded(arguments, (PrintStream)new PrintStream(baos), (boolean)false));
        String output = new String(baos.toByteArray(), Charsets.UTF_8);
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"org.apache.beam.sdk.options.PipelineOptions"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"--runner"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"Default: DirectRunner"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"The pipeline runner that will be used to execute the pipeline."));
    }

    @Test
    public void testSpecificHelpAsArgumentWithClassNameSuffix() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayListMultimap<String, String> arguments = ArrayListMultimap.create();
        arguments.put("help", "options.PipelineOptions");
        Assert.assertTrue((boolean)PipelineOptionsFactory.printHelpUsageAndExitIfNeeded(arguments, (PrintStream)new PrintStream(baos), (boolean)false));
        String output = new String(baos.toByteArray(), Charsets.UTF_8);
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"org.apache.beam.sdk.options.PipelineOptions"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"--runner"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"Default: DirectRunner"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"The pipeline runner that will be used to execute the pipeline."));
    }

    @Test
    public void testShortnameSpecificHelpHasMultipleMatches() {
        PipelineOptionsFactory.register(NameConflictClassA.NameConflict.class);
        PipelineOptionsFactory.register(NameConflictClassB.NameConflict.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayListMultimap<String, String> arguments = ArrayListMultimap.create();
        arguments.put("help", "NameConflict");
        Assert.assertTrue((boolean)PipelineOptionsFactory.printHelpUsageAndExitIfNeeded(arguments, (PrintStream)new PrintStream(baos), (boolean)false));
        String output = new String(baos.toByteArray(), Charsets.UTF_8);
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"Multiple matches found for NameConflict"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"org.apache.beam.sdk.options.PipelineOptionsFactoryTest$NameConflictClassA$NameConflict"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"org.apache.beam.sdk.options.PipelineOptionsFactoryTest$NameConflictClassB$NameConflict"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"The set of registered options are:"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"org.apache.beam.sdk.options.PipelineOptions"));
    }

    @Test
    public void testHelpWithOptionThatOutputsValidEnumTypes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayListMultimap<String, String> arguments = ArrayListMultimap.create();
        arguments.put("help", Objects.class.getName());
        Assert.assertTrue((boolean)PipelineOptionsFactory.printHelpUsageAndExitIfNeeded(arguments, (PrintStream)new PrintStream(baos), (boolean)false));
        String output = new String(baos.toByteArray(), Charsets.UTF_8);
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"<Value | Value2>"));
    }

    @Test
    public void testHelpWithBadOptionNameAsArgument() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayListMultimap<String, String> arguments = ArrayListMultimap.create();
        arguments.put("help", "org.apache.beam.sdk.Pipeline");
        Assert.assertTrue((boolean)PipelineOptionsFactory.printHelpUsageAndExitIfNeeded(arguments, (PrintStream)new PrintStream(baos), (boolean)false));
        String output = new String(baos.toByteArray(), Charsets.UTF_8);
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"Unable to find option org.apache.beam.sdk.Pipeline"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"The set of registered options are:"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"org.apache.beam.sdk.options.PipelineOptions"));
    }

    @Test
    public void testHelpWithHiddenMethodAndInterface() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayListMultimap<String, String> arguments = ArrayListMultimap.create();
        arguments.put("help", "org.apache.beam.sdk.option.DataflowPipelineOptions");
        Assert.assertTrue((boolean)PipelineOptionsFactory.printHelpUsageAndExitIfNeeded(arguments, (PrintStream)new PrintStream(baos), (boolean)false));
        String output = new String(baos.toByteArray(), Charsets.UTF_8);
        Assert.assertThat((Object)output, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"org.apache.beam.sdk.options.DataflowPipelineDebugOptions")));
        Assert.assertThat((Object)output, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"--gcpCredential")));
    }

    @Test
    public void testProgrammaticPrintHelp() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PipelineOptionsFactory.printHelp((PrintStream)new PrintStream(baos));
        String output = new String(baos.toByteArray(), Charsets.UTF_8);
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"The set of registered options are:"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"org.apache.beam.sdk.options.PipelineOptions"));
    }

    @Test
    public void testProgrammaticPrintHelpForSpecificType() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PipelineOptionsFactory.printHelp((PrintStream)new PrintStream(baos), PipelineOptions.class);
        String output = new String(baos.toByteArray(), Charsets.UTF_8);
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"org.apache.beam.sdk.options.PipelineOptions"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"--runner"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"Default: DirectRunner"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"The pipeline runner that will be used to execute the pipeline."));
    }

    @Test
    public void testAllFromPipelineOptions() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("All inherited interfaces of [org.apache.beam.sdk.options.PipelineOptionsFactoryTest$PipelineOptionsInheritedInvalid] should inherit from the PipelineOptions interface. The following inherited interfaces do not:\n - org.apache.beam.sdk.options.PipelineOptionsFactoryTest$InvalidPipelineOptions1\n - org.apache.beam.sdk.options.PipelineOptionsFactoryTest$InvalidPipelineOptions2");
        PipelineOptionsFactory.as(PipelineOptionsInheritedInvalid.class);
    }

    private String emptyStringErrorMessage() {
        return this.emptyStringErrorMessage(null);
    }

    private String emptyStringErrorMessage(String type) {
        String msg = "Empty argument value is only allowed for String, String Array, Collections of Strings or any of these types in a parameterized ValueProvider";
        if (type != null) {
            return String.format("%s, but received: %s", msg, type);
        }
        return msg;
    }

    @Test
    public void testRegistrationOfJacksonModulesForObjectMapper() throws Exception {
        JacksonIncompatibleOptions options = (JacksonIncompatibleOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--jacksonIncompatible=\"testValue\""}).as(JacksonIncompatibleOptions.class);
        Assert.assertEquals((Object)"testValue", (Object)options.getJacksonIncompatible().value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPipelineOptionsFactoryUsesTccl() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader testClassLoader = thread.getContextClassLoader();
        InterceptingUrlClassLoader caseLoader = new InterceptingUrlClassLoader(testClassLoader, name -> name.toLowerCase(Locale.ROOT).contains("test"));
        thread.setContextClassLoader(caseLoader);
        PipelineOptionsFactory.resetCache();
        try {
            PipelineOptions pipelineOptions = PipelineOptionsFactory.create();
            Class<?> optionType = ((ClassLoader)caseLoader).loadClass("org.apache.beam.sdk.options.PipelineOptionsFactoryTest$ClassLoaderTestOptions");
            PipelineOptions options = pipelineOptions.as(optionType);
            Assert.assertSame((Object)caseLoader, (Object)options.getClass().getClassLoader());
            Assert.assertSame((Object)optionType.getClassLoader(), (Object)options.getClass().getClassLoader());
            Assert.assertSame((Object)testClassLoader, (Object)optionType.getInterfaces()[0].getClassLoader());
            Assert.assertTrue((boolean)((Boolean)Boolean.class.cast(optionType.getMethod("isOption", new Class[0]).invoke((Object)options, new Object[0]))));
        }
        finally {
            thread.setContextClassLoader(testClassLoader);
            PipelineOptionsFactory.resetCache();
        }
    }

    @Test
    public void testDefaultMethodIgnoresDefaultImplementation() {
        OptionsWithDefaultMethod optsWithDefault = (OptionsWithDefaultMethod)PipelineOptionsFactory.as(OptionsWithDefaultMethod.class);
        Assert.assertThat((Object)optsWithDefault.getValue(), (Matcher)Matchers.nullValue());
        optsWithDefault.setValue(12.25);
        Assert.assertThat((Object)optsWithDefault.getValue(), (Matcher)Matchers.equalTo((Object)12.25));
    }

    @Test
    public void testDefaultMethodInExtendedClassIgnoresDefaultImplementation() {
        OptionsWithDefaultMethod extendedOptsWithDefault = (OptionsWithDefaultMethod)PipelineOptionsFactory.as(ExtendedOptionsWithDefault.class);
        Assert.assertThat((Object)extendedOptsWithDefault.getValue(), (Matcher)Matchers.nullValue());
        extendedOptsWithDefault.setValue(Double.NEGATIVE_INFINITY);
        Assert.assertThat((Object)extendedOptsWithDefault.getValue(), (Matcher)Matchers.equalTo((Object)Double.NEGATIVE_INFINITY));
    }

    @Test
    public void testStaticMethodsAreAllowed() {
        Assert.assertEquals((Object)"value", (Object)OptionsWithStaticMethod.myStaticMethod((OptionsWithStaticMethod)PipelineOptionsFactory.fromArgs((String[])new String[]{"--myMethod=value"}).as(OptionsWithStaticMethod.class)));
    }

    private static interface OptionsWithStaticMethod
    extends PipelineOptions {
        public String getMyMethod();

        public void setMyMethod(String var1);

        public static String myStaticMethod(OptionsWithStaticMethod o) {
            return o.getMyMethod();
        }
    }

    private static interface OptionsWithDefaultMethod
    extends PipelineOptions {
        default public Number getValue() {
            return 1024;
        }

        public void setValue(Number var1);
    }

    private static interface ExtendedOptionsWithDefault
    extends OptionsWithDefaultMethod {
    }

    public static interface ClassLoaderTestOptions
    extends PipelineOptions {
        @Default.Boolean(value=true)
        @Description(value="A test option.")
        public boolean isOption();

        public void setOption(boolean var1);
    }

    public static class JacksonIncompatibleSerializer
    extends JsonSerializer<JacksonIncompatible> {
        public void serialize(JacksonIncompatible jacksonIncompatible, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeString(jacksonIncompatible.value);
        }
    }

    public static class JacksonIncompatibleDeserializer
    extends JsonDeserializer<JacksonIncompatible> {
        public JacksonIncompatible deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return new JacksonIncompatible((String)jsonParser.readValueAs(String.class));
        }
    }

    @JsonDeserialize(using=JacksonIncompatibleDeserializer.class)
    @JsonSerialize(using=JacksonIncompatibleSerializer.class)
    public static final class JacksonIncompatibleMixin {
    }

    public static class JacksonIncompatible {
        private final String value;

        public JacksonIncompatible(String value) {
            this.value = value;
        }
    }

    @AutoService(value=Module.class)
    public static class RegisteredTestModule
    extends SimpleModule {
        public RegisteredTestModule() {
            super("RegisteredTestModule");
            this.setMixInAnnotation(JacksonIncompatible.class, JacksonIncompatibleMixin.class);
        }
    }

    static interface JacksonIncompatibleOptions
    extends PipelineOptions {
        public JacksonIncompatible getJacksonIncompatible();

        public void setJacksonIncompatible(JacksonIncompatible var1);
    }

    @AutoService(value=PipelineOptionsRegistrar.class)
    public static class RegisteredTestOptionsRegistrar
    implements PipelineOptionsRegistrar {
        public Iterable<Class<? extends PipelineOptions>> getPipelineOptions() {
            return ImmutableList.of(RegisteredTestOptions.class);
        }
    }

    private static interface RegisteredTestOptions
    extends PipelineOptions {
        public Object getRegisteredExampleFooBar();

        public void setRegisteredExampleFooBar(Object var1);
    }

    @AutoService(value=PipelineRunnerRegistrar.class)
    public static class RegisteredTestRunnerRegistrar
    implements PipelineRunnerRegistrar {
        public Iterable<Class<? extends PipelineRunner<?>>> getPipelineRunners() {
            return ImmutableList.of(RegisteredTestRunner.class);
        }
    }

    private static class RegisteredTestRunner
    extends PipelineRunner<PipelineResult> {
        private RegisteredTestRunner() {
        }

        public static PipelineRunner<PipelineResult> fromOptions(PipelineOptions options) {
            return new RegisteredTestRunner();
        }

        public PipelineResult run(Pipeline p) {
            throw new IllegalArgumentException();
        }
    }

    static interface InvalidPipelineOptions2 {
        public String getBar();

        public void setBar(String var1);
    }

    static interface Invalid1
    extends InvalidPipelineOptions1 {
        @Override
        public String getBar();

        @Override
        public void setBar(String var1);
    }

    static interface InvalidPipelineOptions1 {
        public String getBar();

        public void setBar(String var1);
    }

    static interface PipelineOptionsInheritedInvalid
    extends Invalid1,
    InvalidPipelineOptions2,
    PipelineOptions {
        public String getFoo();

        public void setFoo(String var1);
    }

    private static class NameConflictClassB {
        private NameConflictClassB() {
        }

        private static interface NameConflict
        extends PipelineOptions {
        }
    }

    private static class NameConflictClassA {
        private NameConflictClassA() {
        }

        private static interface NameConflict
        extends PipelineOptions {
        }
    }

    static interface SuggestedOptions
    extends PipelineOptions {
        public String getAbc();

        public void setAbc(String var1);

        public String getAbcdefg();

        public void setAbcdefg(String var1);
    }

    private static class ExampleTestRunner
    extends PipelineRunner<PipelineResult> {
        private ExampleTestRunner() {
        }

        public PipelineResult run(Pipeline pipeline) {
            return null;
        }
    }

    public static interface Maps
    extends PipelineOptions {
        public Map<Integer, Integer> getMap();

        public void setMap(Map<Integer, Integer> var1);

        public Map<Integer, Map<Integer, Integer>> getNestedMap();

        public void setNestedMap(Map<Integer, Map<Integer, Integer>> var1);
    }

    public static interface Lists
    extends PipelineOptions {
        public List<String> getString();

        public void setString(List<String> var1);

        public List<Integer> getInteger();

        public void setInteger(List<Integer> var1);

        public List getList();

        public void setList(List var1);

        public ValueProvider<List<String>> getStringValue();

        public void setStringValue(ValueProvider<List<String>> var1);

        public ValueProvider<List<Long>> getLongValue();

        public void setLongValue(ValueProvider<List<Long>> var1);

        public ValueProvider<List<TestEnum>> getEnumValue();

        public void setEnumValue(ValueProvider<List<TestEnum>> var1);
    }

    public static interface Arrays
    extends PipelineOptions {
        public boolean[] getBoolean();

        public void setBoolean(boolean[] var1);

        public char[] getChar();

        public void setChar(char[] var1);

        public short[] getShort();

        public void setShort(short[] var1);

        public int[] getInt();

        public void setInt(int[] var1);

        public long[] getLong();

        public void setLong(long[] var1);

        public float[] getFloat();

        public void setFloat(float[] var1);

        public double[] getDouble();

        public void setDouble(double[] var1);

        public String[] getString();

        public void setString(String[] var1);

        public Class<?>[] getClassValue();

        public void setClassValue(Class<?>[] var1);

        public TestEnum[] getEnum();

        public void setEnum(TestEnum[] var1);

        public ValueProvider<String[]> getStringValue();

        public void setStringValue(ValueProvider<String[]> var1);

        public ValueProvider<Long[]> getLongValue();

        public void setLongValue(ValueProvider<Long[]> var1);

        public ValueProvider<TestEnum[]> getEnumValue();

        public void setEnumValue(ValueProvider<TestEnum[]> var1);
    }

    static interface ComplexTypes
    extends PipelineOptions {
        public Map<String, String> getMap();

        public void setMap(Map<String, String> var1);

        public ComplexType getObject();

        public void setObject(ComplexType var1);

        public ValueProvider<ComplexType> getObjectValue();

        public void setObjectValue(ValueProvider<ComplexType> var1);
    }

    public static class ComplexType {
        String value;
        String value2;

        public ComplexType(@JsonProperty(value="key") String value, @JsonProperty(value="key2") String value2) {
            this.value = value;
            this.value2 = value2;
        }
    }

    public static interface Objects
    extends PipelineOptions {
        public Boolean getBoolean();

        public void setBoolean(Boolean var1);

        public Character getChar();

        public void setChar(Character var1);

        public Byte getByte();

        public void setByte(Byte var1);

        public Short getShort();

        public void setShort(Short var1);

        public Integer getInt();

        public void setInt(Integer var1);

        public Long getLong();

        public void setLong(Long var1);

        public Float getFloat();

        public void setFloat(Float var1);

        public Double getDouble();

        public void setDouble(Double var1);

        public String getString();

        public void setString(String var1);

        public String getEmptyString();

        public void setEmptyString(String var1);

        public Class<?> getClassValue();

        public void setClassValue(Class<?> var1);

        public TestEnum getEnum();

        public void setEnum(TestEnum var1);

        public ValueProvider<String> getStringValue();

        public void setStringValue(ValueProvider<String> var1);

        public ValueProvider<Long> getLongValue();

        public void setLongValue(ValueProvider<Long> var1);

        public ValueProvider<TestEnum> getEnumValue();

        public void setEnumValue(ValueProvider<TestEnum> var1);
    }

    public static enum TestEnum {
        Value,
        Value2;

    }

    public static interface Primitives
    extends PipelineOptions {
        public boolean getBoolean();

        public void setBoolean(boolean var1);

        public char getChar();

        public void setChar(char var1);

        public byte getByte();

        public void setByte(byte var1);

        public short getShort();

        public void setShort(short var1);

        public int getInt();

        public void setInt(int var1);

        public long getLong();

        public void setLong(long var1);

        public float getFloat();

        public void setFloat(float var1);

        public double getDouble();

        public void setDouble(double var1);
    }

    private static interface MultipleGettersWithInconsistentDefault
    extends PipelineOptions {
        @Default.Boolean(value=true)
        public Object getObject();

        public void setObject(Object var1);

        public Integer getOther();

        public void setOther(Integer var1);

        public Void getConsistent();

        public void setConsistent(Void var1);
    }

    private static interface MultiGettersWithDefault
    extends PipelineOptions {
        public Object getObject();

        public void setObject(Object var1);

        @Default.Integer(value=1)
        public Integer getOther();

        public void setOther(Integer var1);

        public Void getConsistent();

        public void setConsistent(Void var1);
    }

    private static interface GettersWithMultipleDefault
    extends PipelineOptions {
        @Default.String(value="abc")
        @Default.Integer(value=0)
        public Object getObject();

        public void setObject(Object var1);
    }

    private static interface GetterWithInconsistentDefaultValue
    extends PipelineOptions {
        @Default.Integer(value=0)
        public Object getObject();

        public void setObject(Object var1);
    }

    private static interface GetterWithInconsistentDefaultType
    extends PipelineOptions {
        @Default.String(value="abc")
        public Object getObject();

        public void setObject(Object var1);
    }

    private static interface GetterWithConsistentDefault
    extends PipelineOptions {
        @Default.Integer(value=1)
        public Object getObject();

        public void setObject(Object var1);
    }

    private static interface GetterWithDefault
    extends PipelineOptions {
        @Default.Integer(value=1)
        public Object getObject();

        public void setObject(Object var1);
    }

    public static interface MultiSetterWithDefault
    extends SetterWithDefault {
        public Integer getOther();

        @Default.String(value="abc")
        public void setOther(Integer var1);
    }

    public static interface SetterWithDefault
    extends PipelineOptions {
        public String getValue();

        @Default.String(value="abc")
        public void setValue(String var1);
    }

    private static interface MultipleGettersWithInconsistentJsonIgnore
    extends PipelineOptions {
        @JsonIgnore
        public Object getObject();

        public void setObject(Object var1);

        public Integer getOther();

        public void setOther(Integer var1);

        public Void getConsistent();

        public void setConsistent(Void var1);
    }

    private static interface MultiGetters
    extends PipelineOptions {
        public Object getObject();

        public void setObject(Object var1);

        @JsonIgnore
        public Integer getOther();

        public void setOther(Integer var1);

        public Void getConsistent();

        public void setConsistent(Void var1);
    }

    public static interface GetterWithInconsistentJsonIgnoreValue
    extends PipelineOptions {
        @JsonIgnore(value=false)
        public Object getObject();

        public void setObject(Object var1);
    }

    public static interface GetterWithJsonIgnore
    extends PipelineOptions {
        @JsonIgnore
        public Object getObject();

        public void setObject(Object var1);
    }

    public static interface MultiSetterWithJsonIgnore
    extends SetterWithJsonIgnore {
        public Integer getOther();

        @JsonIgnore
        public void setOther(Integer var1);
    }

    public static interface SetterWithJsonIgnore
    extends PipelineOptions {
        public String getValue();

        @JsonIgnore
        public void setValue(String var1);
    }

    public static interface MultiReturnTypeConflict
    extends MultiReturnTypeConflictBase {
        @Override
        public String getObject();

        public void setObject(String var1);

        @Override
        public Long getOther();

        public void setOther(Long var1);
    }

    public static interface MultiReturnTypeConflictBase
    extends CombinedObject {
        public Object getOther();

        public void setOther(Object var1);
    }

    public static interface ReturnTypeConflict
    extends CombinedObject {
        @Override
        public String getObject();

        public void setObject(String var1);
    }

    public static interface ExtraneousMethod
    extends PipelineOptions {
        public String extraneousMethod(int var1, String var2);
    }

    public static interface CombinedObject
    extends MissingGetter,
    MissingSetter {
    }

    public static interface MultiGetterSetterTypeMismatch
    extends GetterSetterTypeMismatch {
        public long getOther();

        public void setOther(String var1);
    }

    public static interface GetterSetterTypeMismatch
    extends PipelineOptions {
        public boolean getValue();

        public void setValue(int var1);
    }

    public static interface MissingGettersAndSetters
    extends MissingGetter {
        public Object getOtherObject();
    }

    public static interface MissingMultipleSetters
    extends MissingSetter {
        public Object getOtherObject();
    }

    public static interface MissingSetter
    extends PipelineOptions {
        public Object getObject();
    }

    public static interface MissingMultipleGetters
    extends MissingGetter {
        public void setOtherObject(Object var1);
    }

    public static interface MissingGetter
    extends PipelineOptions {
        public void setObject(Object var1);
    }

    public static interface TestPipelineOptions
    extends PipelineOptions {
        public String getTestPipelineOption();

        public void setTestPipelineOption(String var1);
    }
}

