/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResultsMatchers;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.metrics.SourceMetrics;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.UsesAttemptedMetrics;
import org.apache.beam.sdk.testing.UsesCommittedMetrics;
import org.apache.beam.sdk.testing.UsesCounterMetrics;
import org.apache.beam.sdk.testing.UsesDistributionMetrics;
import org.apache.beam.sdk.testing.UsesGaugeMetrics;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

public class MetricsTest
implements Serializable {
    private static final String NS = "test";
    private static final String NAME = "name";
    private static final MetricName METRIC_NAME = MetricName.named((String)"test", (String)"name");
    private static final String NAMESPACE = MetricsTest.class.getName();
    private static final MetricName ELEMENTS_READ = SourceMetrics.elementsRead().getName();

    private static MetricQueryResults queryTestMetrics(PipelineResult result) {
        return result.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.inNamespace(MetricsTest.class)).build());
    }

    private static void assertCounterMetrics(MetricQueryResults metrics, boolean isCommitted) {
        Assert.assertThat((Object)metrics.getCounters(), (Matcher)Matchers.hasItem(MetricResultsMatchers.metricsResult(NAMESPACE, "count", "MyStep1", 3L, isCommitted)));
        Assert.assertThat((Object)metrics.getCounters(), (Matcher)Matchers.hasItem(MetricResultsMatchers.metricsResult(NAMESPACE, "count", "MyStep2", 6L, isCommitted)));
    }

    private static void assertGaugeMetrics(MetricQueryResults metrics, boolean isCommitted) {
        Assert.assertThat((Object)metrics.getGauges(), (Matcher)Matchers.hasItem(MetricResultsMatchers.metricsResult(NAMESPACE, "my-gauge", "MyStep2", GaugeResult.create((long)12L, (Instant)Instant.now()), isCommitted)));
    }

    private static void assertDistributionMetrics(MetricQueryResults metrics, boolean isCommitted) {
        Assert.assertThat((Object)metrics.getDistributions(), (Matcher)Matchers.hasItem(MetricResultsMatchers.metricsResult(NAMESPACE, "input", "MyStep1", DistributionResult.create((long)26L, (long)3L, (long)5L, (long)13L), isCommitted)));
        Assert.assertThat((Object)metrics.getDistributions(), (Matcher)Matchers.hasItem(MetricResultsMatchers.metricsResult(NAMESPACE, "input", "MyStep2", DistributionResult.create((long)52L, (long)6L, (long)5L, (long)13L), isCommitted)));
        Assert.assertThat((Object)metrics.getDistributions(), (Matcher)Matchers.hasItem(MetricResultsMatchers.distributionMinMax(NAMESPACE, "bundle", "MyStep1", 10L, 40L, isCommitted)));
    }

    private static void assertAllMetrics(MetricQueryResults metrics, boolean isCommitted) {
        MetricsTest.assertCounterMetrics(metrics, isCommitted);
        MetricsTest.assertDistributionMetrics(metrics, isCommitted);
        MetricsTest.assertGaugeMetrics(metrics, isCommitted);
    }

    @RunWith(value=JUnit4.class)
    public static class AttemptedMetricTests
    extends SharedTestBase {
        @Category(value={ValidatesRunner.class, UsesAttemptedMetrics.class, UsesCounterMetrics.class, UsesDistributionMetrics.class, UsesGaugeMetrics.class})
        @Test
        public void testAllAttemptedMetrics() {
            PipelineResult result = this.runPipelineWithMetrics();
            MetricQueryResults metrics = MetricsTest.queryTestMetrics(result);
            MetricsTest.assertAllMetrics(metrics, false);
        }

        @Category(value={ValidatesRunner.class, UsesAttemptedMetrics.class, UsesCounterMetrics.class})
        @Test
        public void testAttemptedCounterMetrics() {
            PipelineResult result = this.runPipelineWithMetrics();
            MetricQueryResults metrics = MetricsTest.queryTestMetrics(result);
            MetricsTest.assertCounterMetrics(metrics, false);
        }

        @Category(value={ValidatesRunner.class, UsesAttemptedMetrics.class, UsesDistributionMetrics.class})
        @Test
        public void testAttemptedDistributionMetrics() {
            PipelineResult result = this.runPipelineWithMetrics();
            MetricQueryResults metrics = MetricsTest.queryTestMetrics(result);
            MetricsTest.assertDistributionMetrics(metrics, false);
        }

        @Category(value={ValidatesRunner.class, UsesAttemptedMetrics.class, UsesGaugeMetrics.class})
        @Test
        public void testAttemptedGaugeMetrics() {
            PipelineResult result = this.runPipelineWithMetrics();
            MetricQueryResults metrics = MetricsTest.queryTestMetrics(result);
            MetricsTest.assertGaugeMetrics(metrics, false);
        }
    }

    @RunWith(value=JUnit4.class)
    public static class CommittedMetricTests
    extends SharedTestBase {
        @Category(value={ValidatesRunner.class, UsesCommittedMetrics.class, UsesCounterMetrics.class, UsesDistributionMetrics.class, UsesGaugeMetrics.class})
        @Test
        public void testAllCommittedMetrics() {
            PipelineResult result = this.runPipelineWithMetrics();
            MetricQueryResults metrics = MetricsTest.queryTestMetrics(result);
            MetricsTest.assertAllMetrics(metrics, true);
        }

        @Category(value={ValidatesRunner.class, UsesCommittedMetrics.class, UsesCounterMetrics.class})
        @Test
        public void testCommittedCounterMetrics() {
            PipelineResult result = this.runPipelineWithMetrics();
            MetricQueryResults metrics = MetricsTest.queryTestMetrics(result);
            MetricsTest.assertCounterMetrics(metrics, true);
        }

        @Category(value={ValidatesRunner.class, UsesCommittedMetrics.class, UsesDistributionMetrics.class})
        @Test
        public void testCommittedDistributionMetrics() {
            PipelineResult result = this.runPipelineWithMetrics();
            MetricQueryResults metrics = MetricsTest.queryTestMetrics(result);
            MetricsTest.assertDistributionMetrics(metrics, true);
        }

        @Category(value={ValidatesRunner.class, UsesCommittedMetrics.class, UsesGaugeMetrics.class})
        @Test
        public void testCommittedGaugeMetrics() {
            PipelineResult result = this.runPipelineWithMetrics();
            MetricQueryResults metrics = MetricsTest.queryTestMetrics(result);
            MetricsTest.assertGaugeMetrics(metrics, true);
        }

        @Test
        @Category(value={NeedsRunner.class, UsesAttemptedMetrics.class, UsesCounterMetrics.class})
        public void testBoundedSourceMetrics() {
            long numElements = 1000L;
            this.pipeline.apply((PTransform)GenerateSequence.from((long)0L).to(numElements));
            PipelineResult pipelineResult = this.pipeline.run();
            MetricQueryResults metrics = pipelineResult.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.named((String)ELEMENTS_READ.getNamespace(), (String)ELEMENTS_READ.getName())).build());
            Assert.assertThat((Object)metrics.getCounters(), (Matcher)Matchers.hasItem(MetricResultsMatchers.attemptedMetricsResult(ELEMENTS_READ.getNamespace(), ELEMENTS_READ.getName(), "Read(BoundedCountingSource)", 1000L)));
        }

        @Test
        @Category(value={NeedsRunner.class, UsesAttemptedMetrics.class, UsesCounterMetrics.class})
        public void testUnboundedSourceMetrics() {
            long numElements = 1000L;
            this.pipeline.apply((PTransform)GenerateSequence.from((long)0L).to(numElements).withMaxReadTime(Duration.standardDays((long)1L)));
            PipelineResult pipelineResult = this.pipeline.run();
            MetricQueryResults metrics = pipelineResult.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.named((String)ELEMENTS_READ.getNamespace(), (String)ELEMENTS_READ.getName())).build());
            Assert.assertThat((Object)metrics.getCounters(), (Matcher)Matchers.hasItem(MetricResultsMatchers.attemptedMetricsResult(ELEMENTS_READ.getNamespace(), ELEMENTS_READ.getName(), "Read(UnboundedCountingSource)", 1000L)));
        }
    }

    @RunWith(value=JUnit4.class)
    public static class BasicTests
    extends SharedTestBase {
        @Test
        public void testDistributionWithoutContainer() {
            Assert.assertNull((Object)MetricsEnvironment.getCurrentContainer());
            Metrics.distribution((String)MetricsTest.NS, (String)MetricsTest.NAME).update(5L);
        }

        @Test
        public void testCounterWithoutContainer() {
            Assert.assertNull((Object)MetricsEnvironment.getCurrentContainer());
            Counter counter = Metrics.counter((String)MetricsTest.NS, (String)MetricsTest.NAME);
            counter.inc();
            counter.inc(5L);
            counter.dec();
            counter.dec(5L);
        }

        @Test
        public void testCounterWithEmptyName() {
            this.thrown.expect(IllegalArgumentException.class);
            Metrics.counter((String)MetricsTest.NS, (String)"");
        }

        @Test
        public void testCounterWithEmptyNamespace() {
            this.thrown.expect(IllegalArgumentException.class);
            Metrics.counter((String)"", (String)MetricsTest.NAME);
        }

        @Test
        public void testDistributionWithEmptyName() {
            this.thrown.expect(IllegalArgumentException.class);
            Metrics.distribution((String)MetricsTest.NS, (String)"");
        }

        @Test
        public void testDistributionWithEmptyNamespace() {
            this.thrown.expect(IllegalArgumentException.class);
            Metrics.distribution((String)"", (String)MetricsTest.NAME);
        }

        @Test
        public void testDistributionToCell() {
            MetricsContainer mockContainer = (MetricsContainer)Mockito.mock(MetricsContainer.class);
            Distribution mockDistribution = (Distribution)Mockito.mock(Distribution.class);
            Mockito.when((Object)mockContainer.getDistribution(METRIC_NAME)).thenReturn((Object)mockDistribution);
            Distribution distribution = Metrics.distribution((String)MetricsTest.NS, (String)MetricsTest.NAME);
            MetricsEnvironment.setCurrentContainer((MetricsContainer)mockContainer);
            distribution.update(5L);
            ((Distribution)Mockito.verify((Object)mockDistribution)).update(5L);
            distribution.update(36L);
            distribution.update(1L);
            ((Distribution)Mockito.verify((Object)mockDistribution)).update(36L);
            ((Distribution)Mockito.verify((Object)mockDistribution)).update(1L);
        }

        @Test
        public void testCounterToCell() {
            MetricsContainer mockContainer = (MetricsContainer)Mockito.mock(MetricsContainer.class);
            Counter mockCounter = (Counter)Mockito.mock(Counter.class);
            Mockito.when((Object)mockContainer.getCounter(METRIC_NAME)).thenReturn((Object)mockCounter);
            Counter counter = Metrics.counter((String)MetricsTest.NS, (String)MetricsTest.NAME);
            MetricsEnvironment.setCurrentContainer((MetricsContainer)mockContainer);
            counter.inc();
            ((Counter)Mockito.verify((Object)mockCounter)).inc(1L);
            counter.inc(47L);
            ((Counter)Mockito.verify((Object)mockCounter)).inc(47L);
            counter.dec(5L);
            ((Counter)Mockito.verify((Object)mockCounter)).inc(-5L);
        }
    }

    public static abstract class SharedTestBase
    implements Serializable {
        @Rule
        public final transient ExpectedException thrown = ExpectedException.none();
        @Rule
        public final transient TestPipeline pipeline = TestPipeline.create();

        @After
        public void tearDown() {
            MetricsEnvironment.setCurrentContainer(null);
        }

        protected PipelineResult runPipelineWithMetrics() {
            final Counter count = Metrics.counter(MetricsTest.class, (String)"count");
            TupleTag<Integer> output1 = new TupleTag<Integer>(){};
            TupleTag<Integer> output2 = new TupleTag<Integer>(){};
            ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)5, (Object[])new Integer[]{8, 13}))).apply("MyStep1", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){
                Distribution bundleDist = Metrics.distribution(MetricsTest.class, (String)"bundle");

                @DoFn.StartBundle
                public void startBundle() {
                    this.bundleDist.update(10L);
                }

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    Distribution values = Metrics.distribution(MetricsTest.class, (String)"input");
                    count.inc();
                    values.update((long)((Integer)c.element()).intValue());
                    c.output((Object)((Integer)c.element()));
                    c.output((Object)((Integer)c.element()));
                }

                @DoFn.FinishBundle
                public void finishBundle() {
                    this.bundleDist.update(40L);
                }
            }))).apply("MyStep2", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>((TupleTag)output2){
                final /* synthetic */ TupleTag val$output2;
                {
                    this.val$output2 = tupleTag;
                }

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    Distribution values = Metrics.distribution(MetricsTest.class, (String)"input");
                    Gauge gauge = Metrics.gauge(MetricsTest.class, (String)"my-gauge");
                    Integer element = (Integer)c.element();
                    count.inc();
                    values.update((long)element.intValue());
                    gauge.set(12L);
                    c.output((Object)element);
                    c.output(this.val$output2, (Object)element);
                }
            }).withOutputTags((TupleTag)output1, TupleTagList.of((TupleTag)output2)));
            PipelineResult result = this.pipeline.run();
            result.waitUntilFinish();
            return result;
        }
    }
}

