/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class MetricsEnvironmentTest {
    @After
    public void teardown() {
        MetricsEnvironment.setCurrentContainer(null);
    }

    @Test
    public void testUsesAppropriateMetricsContainer() {
        Counter counter = Metrics.counter((String)"ns", (String)"name");
        MetricsContainer c1 = (MetricsContainer)Mockito.mock(MetricsContainer.class);
        MetricsContainer c2 = (MetricsContainer)Mockito.mock(MetricsContainer.class);
        Counter counter1 = (Counter)Mockito.mock(Counter.class);
        Counter counter2 = (Counter)Mockito.mock(Counter.class);
        Mockito.when((Object)c1.getCounter(MetricName.named((String)"ns", (String)"name"))).thenReturn((Object)counter1);
        Mockito.when((Object)c2.getCounter(MetricName.named((String)"ns", (String)"name"))).thenReturn((Object)counter2);
        MetricsEnvironment.setCurrentContainer((MetricsContainer)c1);
        counter.inc();
        MetricsEnvironment.setCurrentContainer((MetricsContainer)c2);
        counter.dec();
        MetricsEnvironment.setCurrentContainer(null);
        ((Counter)Mockito.verify((Object)counter1)).inc(1L);
        ((Counter)Mockito.verify((Object)counter2)).inc(-1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{counter1, counter2});
    }

    @Test
    public void testBehavesWithoutMetricsContainer() {
        Assert.assertNull((Object)MetricsEnvironment.getCurrentContainer());
    }
}

