/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.util.Objects;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricResult;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class MetricResultsMatchers {
    public static <T> Matcher<MetricResult<T>> attemptedMetricsResult(String namespace, String name, String step, T value) {
        return MetricResultsMatchers.metricsResult(namespace, name, step, value, false);
    }

    public static <T> Matcher<MetricResult<T>> committedMetricsResult(String namespace, String name, String step, T value) {
        return MetricResultsMatchers.metricsResult(namespace, name, step, value, true);
    }

    public static <T> Matcher<MetricResult<T>> metricsResult(final String namespace, final String name, final String step, final T value, final boolean isCommitted) {
        final String metricState = isCommitted ? "committed" : "attempted";
        return new TypeSafeMatcher<MetricResult<T>>(){

            protected boolean matchesSafely(MetricResult<T> item) {
                Object metricValue = isCommitted ? item.getCommitted() : item.getAttempted();
                return Objects.equals(namespace, item.getName().getNamespace()) && Objects.equals(name, item.getName().getName()) && item.getStep().contains(step) && MetricResultsMatchers.metricResultsEqual(value, metricValue);
            }

            public void describeTo(Description description) {
                description.appendText("MetricResult{inNamespace=").appendValue((Object)namespace).appendText(", name=").appendValue((Object)name).appendText(", step=").appendValue((Object)step).appendText(String.format(", %s=", metricState)).appendValue(value).appendText("}");
            }

            protected void describeMismatchSafely(MetricResult<T> item, Description mismatchDescription) {
                mismatchDescription.appendText("MetricResult{");
                Object metricValue = isCommitted ? item.getCommitted() : item.getAttempted();
                MetricResultsMatchers.describeMetricsResultMembersMismatch(item, mismatchDescription, namespace, name, step);
                if (!Objects.equals(value, metricValue)) {
                    mismatchDescription.appendText(String.format("%s: ", metricState)).appendValue(value).appendText(" != ").appendValue(metricValue);
                }
                mismatchDescription.appendText("}");
            }
        };
    }

    private static <T> boolean metricResultsEqual(T result1, T result2) {
        if (result1 instanceof GaugeResult) {
            return ((GaugeResult)result1).getValue() == ((GaugeResult)result2).getValue();
        }
        return Objects.equals(result1, result2);
    }

    static Matcher<MetricResult<DistributionResult>> distributionAttemptedMinMax(String namespace, String name, String step, Long attemptedMin, Long attemptedMax) {
        return MetricResultsMatchers.distributionMinMax(namespace, name, step, attemptedMin, attemptedMax, false);
    }

    static Matcher<MetricResult<DistributionResult>> distributionCommittedMinMax(String namespace, String name, String step, Long committedMin, Long committedMax) {
        return MetricResultsMatchers.distributionMinMax(namespace, name, step, committedMin, committedMax, true);
    }

    public static Matcher<MetricResult<DistributionResult>> distributionMinMax(final String namespace, final String name, final String step, final Long min, final Long max, final boolean isCommitted) {
        final String metricState = isCommitted ? "committed" : "attempted";
        return new TypeSafeMatcher<MetricResult<DistributionResult>>(){

            protected boolean matchesSafely(MetricResult<DistributionResult> item) {
                DistributionResult metricValue = isCommitted ? (DistributionResult)item.getCommitted() : (DistributionResult)item.getAttempted();
                return Objects.equals(namespace, item.getName().getNamespace()) && Objects.equals(name, item.getName().getName()) && item.getStep().contains(step) && Objects.equals(min, metricValue.getMin()) && Objects.equals(max, metricValue.getMax());
            }

            public void describeTo(Description description) {
                description.appendText("MetricResult{inNamespace=").appendValue((Object)namespace).appendText(", name=").appendValue((Object)name).appendText(", step=").appendValue((Object)step).appendText(String.format(", %sMin=", metricState)).appendValue((Object)min).appendText(String.format(", %sMax=", metricState)).appendValue((Object)max).appendText("}");
            }

            protected void describeMismatchSafely(MetricResult<DistributionResult> item, Description mismatchDescription) {
                DistributionResult metricValue;
                mismatchDescription.appendText("MetricResult{");
                MetricResultsMatchers.describeMetricsResultMembersMismatch(item, mismatchDescription, namespace, name, step);
                DistributionResult distributionResult = metricValue = isCommitted ? (DistributionResult)item.getCommitted() : (DistributionResult)item.getAttempted();
                if (!Objects.equals(min, metricValue.getMin())) {
                    mismatchDescription.appendText(String.format("%sMin: ", metricState)).appendValue((Object)min).appendText(" != ").appendValue((Object)metricValue.getMin());
                }
                if (!Objects.equals(max, metricValue.getMax())) {
                    mismatchDescription.appendText(String.format("%sMax: ", metricState)).appendValue((Object)max).appendText(" != ").appendValue((Object)metricValue.getMax());
                }
                mismatchDescription.appendText("}");
            }
        };
    }

    private static <T> void describeMetricsResultMembersMismatch(MetricResult<T> item, Description mismatchDescription, String namespace, String name, String step) {
        if (!Objects.equals(namespace, item.getName().getNamespace())) {
            mismatchDescription.appendText("inNamespace: ").appendValue((Object)namespace).appendText(" != ").appendValue((Object)item.getName().getNamespace());
        }
        if (!Objects.equals(name, item.getName().getName())) {
            mismatchDescription.appendText("name: ").appendValue((Object)name).appendText(" != ").appendValue((Object)item.getName().getName());
        }
        if (!item.getStep().contains(step)) {
            mismatchDescription.appendText("step: ").appendValue((Object)step).appendText(" != ").appendValue((Object)item.getStep());
        }
    }
}

