/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import org.apache.beam.sdk.io.range.OffsetRangeTracker;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OffsetRangeTrackerTest {
    @Rule
    public final ExpectedException expected = ExpectedException.none();

    @Test
    public void testUpdateStartOffset() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(100L, 200L);
        Assert.assertEquals((long)100L, (long)tracker.getStartPosition());
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 150L));
        Assert.assertEquals((long)150L, (long)tracker.getStartPosition());
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 180L));
        Assert.assertEquals((long)150L, (long)tracker.getStartPosition());
    }

    @Test
    public void testTryReturnRecordSimpleSparse() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(100L, 200L);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 110L));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 140L));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 183L));
        Assert.assertFalse((boolean)tracker.tryReturnRecordAt(true, 210L));
    }

    @Test
    public void testTryReturnRecordSimpleDense() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(3L, 6L);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 3L));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 4L));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 5L));
        Assert.assertFalse((boolean)tracker.tryReturnRecordAt(true, 6L));
    }

    @Test
    public void testTryReturnRecordContinuesUntilSplitPoint() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(9L, 18L);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 10L));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(false, 12L));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(false, 14L));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 16L));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(false, 18L));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(false, 20L));
        Assert.assertFalse((boolean)tracker.tryReturnRecordAt(true, 22L));
    }

    @Test
    public void testSplitAtOffsetFailsIfUnstarted() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(100L, 200L);
        Assert.assertFalse((boolean)tracker.trySplitAtPosition(150L));
    }

    @Test
    public void testSplitAtOffset() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(100L, 200L);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 110L));
        Assert.assertFalse((boolean)tracker.trySplitAtPosition(109L));
        Assert.assertFalse((boolean)tracker.trySplitAtPosition(110L));
        Assert.assertFalse((boolean)tracker.trySplitAtPosition(200L));
        Assert.assertFalse((boolean)tracker.trySplitAtPosition(210L));
        Assert.assertTrue((boolean)tracker.copy().trySplitAtPosition(111L));
        Assert.assertTrue((boolean)tracker.copy().trySplitAtPosition(129L));
        Assert.assertTrue((boolean)tracker.copy().trySplitAtPosition(130L));
        Assert.assertTrue((boolean)tracker.copy().trySplitAtPosition(131L));
        Assert.assertTrue((boolean)tracker.copy().trySplitAtPosition(150L));
        Assert.assertTrue((boolean)tracker.copy().trySplitAtPosition(199L));
        Assert.assertTrue((boolean)tracker.trySplitAtPosition(170L));
        Assert.assertTrue((boolean)tracker.trySplitAtPosition(150L));
        Assert.assertTrue((boolean)tracker.copy().tryReturnRecordAt(true, 135L));
        Assert.assertTrue((boolean)tracker.copy().tryReturnRecordAt(true, 135L));
        Assert.assertTrue((boolean)tracker.copy().tryReturnRecordAt(true, 149L));
        Assert.assertFalse((boolean)tracker.tryReturnRecordAt(true, 150L));
        Assert.assertFalse((boolean)tracker.tryReturnRecordAt(true, 151L));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(false, 152L));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(false, 160L));
        Assert.assertFalse((boolean)tracker.tryReturnRecordAt(true, 171L));
    }

    @Test
    public void testGetPositionForFractionDense() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(3L, 6L);
        Assert.assertEquals((long)3L, (long)tracker.getPositionForFractionConsumed(0.0));
        Assert.assertEquals((long)3L, (long)tracker.getPositionForFractionConsumed(0.16666666666666666));
        Assert.assertEquals((long)3L, (long)tracker.getPositionForFractionConsumed(0.333));
        Assert.assertEquals((long)4L, (long)tracker.getPositionForFractionConsumed(0.334));
        Assert.assertEquals((long)4L, (long)tracker.getPositionForFractionConsumed(0.666));
        Assert.assertEquals((long)5L, (long)tracker.getPositionForFractionConsumed(0.667));
        Assert.assertEquals((long)5L, (long)tracker.getPositionForFractionConsumed(0.999));
        Assert.assertEquals((long)6L, (long)tracker.getPositionForFractionConsumed(1.0));
    }

    @Test
    public void testGetPositionForFractionDenseUpdateStartOffset() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(3L, 6L);
        Assert.assertEquals((long)3L, (long)tracker.getPositionForFractionConsumed(0.333));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 4L));
        Assert.assertEquals((long)4L, (long)tracker.getPositionForFractionConsumed(0.0));
        Assert.assertEquals((long)4L, (long)tracker.getPositionForFractionConsumed(0.499));
        Assert.assertEquals((long)5L, (long)tracker.getPositionForFractionConsumed(0.5));
        Assert.assertEquals((long)5L, (long)tracker.getPositionForFractionConsumed(0.999));
        Assert.assertEquals((long)6L, (long)tracker.getPositionForFractionConsumed(1.0));
    }

    @Test
    public void testGetFractionConsumedDense() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(3L, 6L);
        Assert.assertEquals((double)0.0, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 3L));
        Assert.assertEquals((double)0.0, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 4L));
        Assert.assertEquals((double)0.3333333333333333, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 5L));
        Assert.assertEquals((double)0.6666666666666666, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(false, 6L));
        Assert.assertEquals((double)1.0, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(false, 7L));
        Assert.assertEquals((double)1.0, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertFalse((boolean)tracker.tryReturnRecordAt(true, 7L));
    }

    @Test
    public void testGetFractionConsumedSparse() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(100L, 200L);
        Assert.assertEquals((double)0.0, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 100L));
        Assert.assertEquals((double)0.0, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 110L));
        Assert.assertEquals((double)0.1, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 150L));
        Assert.assertEquals((double)0.5, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 195L));
        Assert.assertEquals((double)0.95, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertFalse((boolean)tracker.tryReturnRecordAt(true, 200L));
        Assert.assertEquals((double)1.0, (double)tracker.getFractionConsumed(), (double)1.0E-6);
    }

    @Test
    public void testGetFractionConsumedUpdateStartOffset() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(100L, 200L);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 150L));
        Assert.assertEquals((double)0.0, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 160L));
        Assert.assertEquals((double)0.2, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 180L));
        Assert.assertEquals((double)0.6, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 195L));
        Assert.assertEquals((double)0.9, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertFalse((boolean)tracker.tryReturnRecordAt(true, 200L));
        Assert.assertEquals((double)1.0, (double)tracker.getFractionConsumed(), (double)1.0E-6);
    }

    @Test
    public void testEverythingWithUnboundedRange() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(100L, Long.MAX_VALUE);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 150L));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, 250L));
        Assert.assertEquals((double)0.0, (double)tracker.getFractionConsumed(), (double)1.0E-6);
        Assert.assertFalse((boolean)tracker.trySplitAtPosition(1000L));
        try {
            tracker.getPositionForFractionConsumed(0.5);
            Assert.fail((String)"getPositionForFractionConsumed should fail for an unbounded range");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTryReturnFirstRecordNotSplitPoint() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(100L, 200L);
        this.expected.expect(IllegalStateException.class);
        tracker.tryReturnRecordAt(false, 120L);
    }

    @Test
    public void testTryReturnRecordNonMonotonic() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(100L, 200L);
        tracker.tryReturnRecordAt(true, 120L);
        this.expected.expect(IllegalStateException.class);
        tracker.tryReturnRecordAt(true, 110L);
    }
}

