/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.beam.sdk.io.range.ByteKey;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ByteKeyTest {
    static final ByteKey[] TEST_KEYS = new ByteKey[]{ByteKey.EMPTY, ByteKey.of((int[])new int[]{0}), ByteKey.of((int[])new int[]{0, 1}), ByteKey.of((int[])new int[]{0, 1, 1}), ByteKey.of((int[])new int[]{0, 1, 2}), ByteKey.of((int[])new int[]{0, 1, 2, 254}), ByteKey.of((int[])new int[]{0, 1, 3, 254}), ByteKey.of((int[])new int[]{0, 254, 254, 254}), ByteKey.of((int[])new int[]{0, 254, 254, 255}), ByteKey.of((int[])new int[]{0, 254, 255, 0}), ByteKey.of((int[])new int[]{0, 255, 255, 0}), ByteKey.of((int[])new int[]{0, 255, 255, 1}), ByteKey.of((int[])new int[]{0, 255, 255, 254}), ByteKey.of((int[])new int[]{0, 255, 255, 255}), ByteKey.of((int[])new int[]{1}), ByteKey.of((int[])new int[]{1, 2}), ByteKey.of((int[])new int[]{1, 2, 3}), ByteKey.of((int[])new int[]{3}), ByteKey.of((int[])new int[]{221}), ByteKey.of((int[])new int[]{254}), ByteKey.of((int[])new int[]{254, 254}), ByteKey.of((int[])new int[]{254, 255}), ByteKey.of((int[])new int[]{255}), ByteKey.of((int[])new int[]{255, 0}), ByteKey.of((int[])new int[]{255, 254}), ByteKey.of((int[])new int[]{255, 255}), ByteKey.of((int[])new int[]{255, 255, 255}), ByteKey.of((int[])new int[]{255, 255, 255, 255})};

    @Test
    public void testCompareToExhaustive() {
        for (int i = 0; i < TEST_KEYS.length; ++i) {
            for (int j = 0; j < TEST_KEYS.length; ++j) {
                ByteKey left = TEST_KEYS[i];
                ByteKey right = TEST_KEYS[j];
                int cmp = left.compareTo(right);
                if (i < j && cmp >= 0) {
                    Assert.fail((String)String.format("Expected that cmp(%s, %s) < 0, got %d [i=%d, j=%d]", left, right, cmp, i, j));
                    continue;
                }
                if (i == j && cmp != 0) {
                    Assert.fail((String)String.format("Expected that cmp(%s, %s) == 0, got %d [i=%d, j=%d]", left, right, cmp, i, j));
                    continue;
                }
                if (i <= j || cmp > 0) continue;
                Assert.fail((String)String.format("Expected that cmp(%s, %s) > 0, got %d [i=%d, j=%d]", left, right, cmp, i, j));
            }
        }
    }

    @Test
    public void testEquals() {
        for (int i = 0; i < TEST_KEYS.length; ++i) {
            for (int j = 0; j < TEST_KEYS.length; ++j) {
                ByteKey left = TEST_KEYS[i];
                ByteKey right = TEST_KEYS[j];
                boolean eq = left.equals((Object)right);
                if (i == j) {
                    Assert.assertTrue((String)String.format("Expected that %s is equal to itself.", left), (boolean)eq);
                    Assert.assertTrue((String)String.format("Expected that %s is equal to a copy of itself.", left), (boolean)left.equals((Object)ByteKey.copyFrom((ByteBuffer)right.getValue())));
                    continue;
                }
                Assert.assertFalse((String)String.format("Expected that %s is not equal to %s", left, right), (boolean)eq);
            }
        }
    }

    @Test
    public void testHashCode() {
        int collisions = 0;
        for (int i = 0; i < TEST_KEYS.length; ++i) {
            int left = TEST_KEYS[i].hashCode();
            int leftClone = ByteKey.copyFrom((ByteBuffer)TEST_KEYS[i].getValue()).hashCode();
            Assert.assertEquals((String)String.format("Expected same hash code for %s and a copy of itself", TEST_KEYS[i]), (long)left, (long)leftClone);
            for (int j = i + 1; j < TEST_KEYS.length; ++j) {
                int right = TEST_KEYS[j].hashCode();
                if (left != right) continue;
                ++collisions;
            }
        }
        int totalUnequalTests = TEST_KEYS.length * (TEST_KEYS.length - 1) / 2;
        Assert.assertThat((String)"Too many hash collisions", (Object)collisions, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(totalUnequalTests / 2)));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"[]", (Object)ByteKey.EMPTY.toString());
        Assert.assertEquals((Object)"[00]", (Object)ByteKey.of((int[])new int[]{0}).toString());
        Assert.assertEquals((Object)"[0000]", (Object)ByteKey.of((int[])new int[]{0, 0}).toString());
        Assert.assertEquals((Object)"[0123456789abcdef]", (Object)ByteKey.of((int[])new int[]{1, 35, 69, 103, 137, 171, 205, 239}).toString());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((String)"[] is empty", (boolean)ByteKey.EMPTY.isEmpty());
        Assert.assertFalse((String)"[00]", (boolean)ByteKey.of((int[])new int[]{0}).isEmpty());
    }

    @Test
    public void testGetBytes() {
        Assert.assertTrue((String)"[] equal after getBytes", (boolean)Arrays.equals(new byte[0], ByteKey.EMPTY.getBytes()));
        Assert.assertTrue((String)"[00] equal after getBytes", (boolean)Arrays.equals(new byte[]{0}, ByteKey.of((int[])new int[]{0}).getBytes()));
    }
}

