/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.io.range.ByteKeyRangeTracker;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ByteKeyRangeTrackerTest {
    private static final ByteKey BEFORE_START_KEY = ByteKey.of((int[])new int[]{17});
    private static final ByteKey INITIAL_START_KEY = ByteKey.of((int[])new int[]{18});
    private static final ByteKey AFTER_START_KEY = ByteKey.of((int[])new int[]{19});
    private static final ByteKey INITIAL_MIDDLE_KEY = ByteKey.of((int[])new int[]{35});
    private static final ByteKey NEW_START_KEY = ByteKey.of((int[])new int[]{20});
    private static final ByteKey NEW_MIDDLE_KEY = ByteKey.of((int[])new int[]{36});
    private static final ByteKey BEFORE_END_KEY = ByteKey.of((int[])new int[]{51});
    private static final ByteKey END_KEY = ByteKey.of((int[])new int[]{52});
    private static final ByteKey KEY_LARGER_THAN_END = ByteKey.of((int[])new int[]{53});
    private static final double INITIAL_RANGE_SIZE = 34.0;
    private static final ByteKeyRange INITIAL_RANGE = ByteKeyRange.of((ByteKey)INITIAL_START_KEY, (ByteKey)END_KEY);
    private static final double NEW_RANGE_SIZE = 32.0;
    private static final ByteKeyRange NEW_RANGE = ByteKeyRange.of((ByteKey)NEW_START_KEY, (ByteKey)END_KEY);
    @Rule
    public final ExpectedException expected = ExpectedException.none();

    @Test
    public void testToString() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        String expected = String.format("ByteKeyRangeTracker{range=%s, position=null}", INITIAL_RANGE);
        Assert.assertEquals((Object)expected, (Object)tracker.toString());
        tracker.tryReturnRecordAt(true, INITIAL_START_KEY);
        tracker.tryReturnRecordAt(true, INITIAL_MIDDLE_KEY);
        expected = String.format("ByteKeyRangeTracker{range=%s, position=%s}", INITIAL_RANGE, INITIAL_MIDDLE_KEY);
        Assert.assertEquals((Object)expected, (Object)tracker.toString());
    }

    @Test
    public void testUpdateStartKey() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        tracker.tryReturnRecordAt(true, NEW_START_KEY);
        String expected = String.format("ByteKeyRangeTracker{range=%s, position=%s}", NEW_RANGE, NEW_START_KEY);
        Assert.assertEquals((Object)expected, (Object)tracker.toString());
    }

    @Test
    public void testBuilding() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        Assert.assertEquals((Object)INITIAL_START_KEY, (Object)tracker.getStartPosition());
        Assert.assertEquals((Object)END_KEY, (Object)tracker.getStopPosition());
    }

    @Test
    public void testGetFractionConsumed() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        double delta = 1.0E-5;
        Assert.assertEquals((double)0.0, (double)tracker.getFractionConsumed(), (double)delta);
        tracker.tryReturnRecordAt(true, INITIAL_START_KEY);
        Assert.assertEquals((double)0.0, (double)tracker.getFractionConsumed(), (double)delta);
        tracker.tryReturnRecordAt(true, INITIAL_MIDDLE_KEY);
        Assert.assertEquals((double)0.5, (double)tracker.getFractionConsumed(), (double)delta);
        tracker.tryReturnRecordAt(true, BEFORE_END_KEY);
        Assert.assertEquals((double)0.9705882352941176, (double)tracker.getFractionConsumed(), (double)delta);
    }

    @Test
    public void testGetFractionConsumedAfterDone() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        double delta = 1.0E-5;
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, INITIAL_START_KEY));
        tracker.markDone();
        Assert.assertEquals((double)1.0, (double)tracker.getFractionConsumed(), (double)delta);
    }

    @Test
    public void testGetFractionConsumedAfterOutOfRangeClaim() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        double delta = 1.0E-5;
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, INITIAL_START_KEY));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(false, KEY_LARGER_THAN_END));
        Assert.assertEquals((double)1.0, (double)tracker.getFractionConsumed(), (double)delta);
    }

    @Test
    public void testGetFractionConsumedUpdateStartKey() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        double delta = 1.0E-5;
        tracker.tryReturnRecordAt(true, NEW_START_KEY);
        Assert.assertEquals((double)0.0, (double)tracker.getFractionConsumed(), (double)delta);
        tracker.tryReturnRecordAt(true, NEW_MIDDLE_KEY);
        Assert.assertEquals((double)0.5, (double)tracker.getFractionConsumed(), (double)delta);
        tracker.tryReturnRecordAt(true, BEFORE_END_KEY);
        Assert.assertEquals((double)0.96875, (double)tracker.getFractionConsumed(), (double)delta);
    }

    @Test
    public void testTryReturnRecordAt() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, INITIAL_START_KEY));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, INITIAL_START_KEY));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, INITIAL_MIDDLE_KEY));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, INITIAL_MIDDLE_KEY));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, BEFORE_END_KEY));
        Assert.assertFalse((boolean)tracker.tryReturnRecordAt(true, END_KEY));
        Assert.assertFalse((boolean)tracker.tryReturnRecordAt(true, BEFORE_END_KEY));
    }

    @Test
    public void testTryReturnFirstRecordNotSplitPoint() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        this.expected.expect(IllegalStateException.class);
        tracker.tryReturnRecordAt(false, INITIAL_START_KEY);
    }

    @Test
    public void testTryReturnBeforeStartKey() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        this.expected.expect(IllegalStateException.class);
        tracker.tryReturnRecordAt(true, BEFORE_START_KEY);
    }

    @Test
    public void testTryReturnBeforeLastReturnedRecord() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, INITIAL_START_KEY));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, INITIAL_MIDDLE_KEY));
        this.expected.expect(IllegalStateException.class);
        tracker.tryReturnRecordAt(true, AFTER_START_KEY);
    }

    @Test
    public void testSplitAtPosition() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        Assert.assertFalse((boolean)tracker.trySplitAtPosition(INITIAL_MIDDLE_KEY));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, INITIAL_START_KEY));
        Assert.assertTrue((boolean)tracker.trySplitAtPosition(BEFORE_END_KEY));
        Assert.assertEquals((Object)BEFORE_END_KEY, (Object)tracker.getStopPosition());
        Assert.assertFalse((boolean)tracker.trySplitAtPosition(END_KEY));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, INITIAL_MIDDLE_KEY));
        Assert.assertFalse((boolean)tracker.trySplitAtPosition(INITIAL_MIDDLE_KEY));
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, INITIAL_MIDDLE_KEY));
    }

    @Test
    public void testGetSplitPointsConsumed() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)INITIAL_RANGE);
        Assert.assertEquals((long)0L, (long)tracker.getSplitPointsConsumed());
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, INITIAL_START_KEY));
        Assert.assertEquals((long)0L, (long)tracker.getSplitPointsConsumed());
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, AFTER_START_KEY));
        Assert.assertEquals((long)1L, (long)tracker.getSplitPointsConsumed());
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(false, INITIAL_MIDDLE_KEY));
        Assert.assertEquals((long)1L, (long)tracker.getSplitPointsConsumed());
        Assert.assertTrue((boolean)tracker.tryReturnRecordAt(true, BEFORE_END_KEY));
        Assert.assertEquals((long)2L, (long)tracker.getSplitPointsConsumed());
        tracker.markDone();
        Assert.assertEquals((long)3L, (long)tracker.getSplitPointsConsumed());
    }
}

