/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.io.range.ByteKeyTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ByteKeyRangeTest {
    private static final ByteKeyRange RANGE_1_10 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{1}), (ByteKey)ByteKey.of((int[])new int[]{10}));
    private static final ByteKeyRange RANGE_5_10 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{5}), (ByteKey)ByteKey.of((int[])new int[]{10}));
    private static final ByteKeyRange RANGE_5_50 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{5}), (ByteKey)ByteKey.of((int[])new int[]{50}));
    private static final ByteKeyRange RANGE_10_50 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{10}), (ByteKey)ByteKey.of((int[])new int[]{50}));
    private static final ByteKeyRange UP_TO_1 = ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)ByteKey.of((int[])new int[]{1}));
    private static final ByteKeyRange UP_TO_5 = ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)ByteKey.of((int[])new int[]{5}));
    private static final ByteKeyRange UP_TO_10 = ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)ByteKey.of((int[])new int[]{10}));
    private static final ByteKeyRange UP_TO_50 = ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)ByteKey.of((int[])new int[]{50}));
    private static final ByteKeyRange AFTER_1 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{1}), (ByteKey)ByteKey.EMPTY);
    private static final ByteKeyRange AFTER_5 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{5}), (ByteKey)ByteKey.EMPTY);
    private static final ByteKeyRange AFTER_10 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{10}), (ByteKey)ByteKey.EMPTY);
    private static final ByteKeyRange[] TEST_RANGES = new ByteKeyRange[]{ByteKeyRange.ALL_KEYS, RANGE_1_10, RANGE_5_10, RANGE_5_50, RANGE_10_50, UP_TO_1, UP_TO_5, UP_TO_10, UP_TO_50, AFTER_1, AFTER_5, AFTER_10};
    static final ByteKey[] RANGE_TEST_KEYS = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(Arrays.asList(ByteKeyTest.TEST_KEYS))).add(ByteKey.EMPTY)).build().toArray(ByteKeyTest.TEST_KEYS);

    private static void bidirectionalNonOverlap(ByteKeyRange left, ByteKeyRange right) {
        ByteKeyRangeTest.bidirectionalOverlapHelper(left, right, false);
    }

    private static void bidirectionalOverlap(ByteKeyRange left, ByteKeyRange right) {
        ByteKeyRangeTest.bidirectionalOverlapHelper(left, right, true);
    }

    private static void bidirectionalOverlapHelper(ByteKeyRange left, ByteKeyRange right, boolean result) {
        Assert.assertEquals((String)String.format("%s overlaps %s", left, right), (Object)result, (Object)left.overlaps(right));
        Assert.assertEquals((String)String.format("%s overlaps %s", right, left), (Object)result, (Object)right.overlaps(left));
    }

    @Test
    public void testOverlappingRanges() {
        ByteKeyRangeTest.bidirectionalOverlap(ByteKeyRange.ALL_KEYS, ByteKeyRange.ALL_KEYS);
        ByteKeyRangeTest.bidirectionalOverlap(ByteKeyRange.ALL_KEYS, RANGE_1_10);
        ByteKeyRangeTest.bidirectionalOverlap(UP_TO_1, UP_TO_1);
        ByteKeyRangeTest.bidirectionalOverlap(UP_TO_1, UP_TO_5);
        ByteKeyRangeTest.bidirectionalOverlap(UP_TO_50, AFTER_10);
        ByteKeyRangeTest.bidirectionalOverlap(UP_TO_50, RANGE_1_10);
        ByteKeyRangeTest.bidirectionalOverlap(UP_TO_10, UP_TO_50);
        ByteKeyRangeTest.bidirectionalOverlap(RANGE_1_10, RANGE_5_50);
        ByteKeyRangeTest.bidirectionalOverlap(AFTER_1, AFTER_5);
        ByteKeyRangeTest.bidirectionalOverlap(RANGE_5_10, RANGE_1_10);
        ByteKeyRangeTest.bidirectionalOverlap(RANGE_5_10, RANGE_5_50);
    }

    @Test
    public void testNonOverlappingRanges() {
        ByteKeyRangeTest.bidirectionalNonOverlap(UP_TO_1, AFTER_1);
        ByteKeyRangeTest.bidirectionalNonOverlap(UP_TO_1, AFTER_5);
        ByteKeyRangeTest.bidirectionalNonOverlap(RANGE_5_10, RANGE_10_50);
    }

    private static void ensureOrderedKeys(List<ByteKey> keys) {
        for (int i = 0; i < keys.size() - 1; ++i) {
            ByteKeyRange.of((ByteKey)keys.get(i), (ByteKey)keys.get(i + 1));
            if (i <= 0 || !keys.get(i).isEmpty()) continue;
            Assert.fail((String)String.format("Intermediate key %s/%s may not be empty", i, keys.size()));
        }
    }

    @Test
    public void testRejectsInvalidSplit() {
        try {
            Assert.fail((String)String.format("%s.split(0) should fail: %s", RANGE_1_10, RANGE_1_10.split(0)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Assert.fail((String)String.format("%s.split(-3) should fail: %s", RANGE_1_10, RANGE_1_10.split(-3)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSplitSpecialInputs() {
        Assert.assertEquals((String)"Split 1 should return input", ImmutableList.of(RANGE_1_10.getStartKey(), RANGE_1_10.getEndKey()), (Object)RANGE_1_10.split(1));
        ByteKeyRange unsplittable = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[0]), (ByteKey)ByteKey.of((int[])new int[]{0, 0, 0, 0}));
        Assert.assertEquals((String)"Unsplittable should return input", ImmutableList.of(unsplittable.getStartKey(), unsplittable.getEndKey()), (Object)unsplittable.split(5));
    }

    @Test
    public void testSplitKeysCombinatorial() {
        ImmutableList<Integer> sizes = ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(10), Integer.valueOf(25), Integer.valueOf(32), Integer.valueOf(64));
        for (int i = 0; i < RANGE_TEST_KEYS.length; ++i) {
            for (int j = i + 1; j < RANGE_TEST_KEYS.length; ++j) {
                ByteKeyRange range = ByteKeyRange.of((ByteKey)RANGE_TEST_KEYS[i], (ByteKey)RANGE_TEST_KEYS[j]);
                Iterator iterator = sizes.iterator();
                while (iterator.hasNext()) {
                    int s = (Integer)iterator.next();
                    List splits = range.split(s);
                    ByteKeyRangeTest.ensureOrderedKeys(splits);
                    Assert.assertThat((String)"At least two entries in splits", (Object)splits.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
                    Assert.assertEquals((String)"First split equals start of range", splits.get(0), (Object)RANGE_TEST_KEYS[i]);
                    Assert.assertEquals((String)"Last split equals end of range", splits.get(splits.size() - 1), (Object)RANGE_TEST_KEYS[j]);
                }
            }
        }
    }

    @Test
    public void testEstimateFractionForKey() {
        double delta = 1.0E-7;
        Assert.assertEquals((double)0.5, (double)ByteKeyRange.ALL_KEYS.estimateFractionForKey(ByteKey.of((int[])new int[]{128})), (double)1.0E-7);
        ByteKeyRange after0 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{0}), (ByteKey)ByteKey.EMPTY);
        Assert.assertEquals((double)0.5, (double)after0.estimateFractionForKey(ByteKey.of((int[])new int[]{128})), (double)1.0E-7);
        ByteKeyRange after00 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{0, 0}), (ByteKey)ByteKey.EMPTY);
        Assert.assertEquals((double)0.5, (double)after00.estimateFractionForKey(ByteKey.of((int[])new int[]{128})), (double)1.0E-7);
        ByteKeyRange upToFE = ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)ByteKey.of((int[])new int[]{254}));
        Assert.assertEquals((double)0.5, (double)upToFE.estimateFractionForKey(ByteKey.of((int[])new int[]{127})), (double)1.0E-7);
        Assert.assertEquals((double)0.25, (double)ByteKeyRange.ALL_KEYS.estimateFractionForKey(ByteKey.of((int[])new int[]{64})), (double)1.0E-7);
        ByteKeyRange upTo80 = ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)ByteKey.of((int[])new int[]{128}));
        Assert.assertEquals((double)0.5, (double)upTo80.estimateFractionForKey(ByteKey.of((int[])new int[]{64})), (double)1.0E-7);
        ByteKeyRange range30to50 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{48}), (ByteKey)ByteKey.of((int[])new int[]{80}));
        Assert.assertEquals((double)0.5, (double)range30to50.estimateFractionForKey(ByteKey.of((int[])new int[]{64})), (double)1.0E-7);
        ByteKeyRange range31to4f = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{48, 0, 1}), (ByteKey)ByteKey.of((int[])new int[]{79, 255, 255, 0, 0}));
        Assert.assertEquals((double)0.5, (double)range31to4f.estimateFractionForKey(ByteKey.of((int[])new int[]{64})), (double)1.0E-7);
        ByteKeyRange upTo47 = ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)ByteKey.of((int[])new int[]{47}));
        for (int i = 0; i <= 47; ++i) {
            Assert.assertEquals((String)("i=" + i), (double)((double)i / 47.0), (double)upTo47.estimateFractionForKey(ByteKey.of((int[])new int[]{i})), (double)1.0E-7);
        }
        ByteKeyRange rangeFDECtoFDEC83 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{253, 236}), (ByteKey)ByteKey.of((int[])new int[]{253, 236, 83}));
        for (int i = 0; i <= 83; ++i) {
            Assert.assertEquals((String)("i=" + i), (double)((double)i / 83.0), (double)rangeFDECtoFDEC83.estimateFractionForKey(ByteKey.of((int[])new int[]{253, 236, i})), (double)1.0E-7);
        }
    }

    @Test
    public void testInterpolateKey() {
        ByteKeyRangeTest.assertEqualExceptPadding(ByteKey.of((int[])new int[]{128}), ByteKeyRange.ALL_KEYS.interpolateKey(0.5));
        ByteKeyRange after0 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{0}), (ByteKey)ByteKey.EMPTY);
        ByteKeyRangeTest.assertEqualExceptPadding(ByteKey.of((int[])new int[]{128}), after0.interpolateKey(0.5));
        ByteKeyRange after00 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{0, 0}), (ByteKey)ByteKey.EMPTY);
        ByteKeyRangeTest.assertEqualExceptPadding(ByteKey.of((int[])new int[]{128}), after00.interpolateKey(0.5));
        ByteKeyRange upToFE = ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)ByteKey.of((int[])new int[]{254}));
        ByteKeyRangeTest.assertEqualExceptPadding(ByteKey.of((int[])new int[]{127}), upToFE.interpolateKey(0.5));
        ByteKeyRangeTest.assertEqualExceptPadding(ByteKey.of((int[])new int[]{64}), ByteKeyRange.ALL_KEYS.interpolateKey(0.25));
        ByteKeyRange upTo80 = ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)ByteKey.of((int[])new int[]{128}));
        ByteKeyRangeTest.assertEqualExceptPadding(ByteKey.of((int[])new int[]{64}), upTo80.interpolateKey(0.5));
        ByteKeyRange range30to50 = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{48}), (ByteKey)ByteKey.of((int[])new int[]{80}));
        ByteKeyRangeTest.assertEqualExceptPadding(ByteKey.of((int[])new int[]{64}), range30to50.interpolateKey(0.5));
        ByteKeyRange range31to4f = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{48, 0, 1}), (ByteKey)ByteKey.of((int[])new int[]{79, 255, 255, 0, 0}));
        ByteKeyRangeTest.assertEqualExceptPadding(ByteKey.of((int[])new int[]{64}), range31to4f.interpolateKey(0.5));
    }

    @Test
    public void testInterpolateKeyIsNotEmpty() {
        String fmt = "Interpolating %s at fraction 0.0 should not return the empty key";
        for (ByteKeyRange range : TEST_RANGES) {
            range = ByteKeyRange.ALL_KEYS;
            Assert.assertFalse((String)String.format(fmt, range), (boolean)range.interpolateKey(0.0).isEmpty());
        }
    }

    @Test
    public void testKeyGetters() {
        Assert.assertEquals((Object)AFTER_1.getStartKey(), (Object)ByteKey.of((int[])new int[]{1}));
        Assert.assertEquals((Object)AFTER_1.getEndKey(), (Object)ByteKey.EMPTY);
        Assert.assertEquals((Object)RANGE_1_10.getStartKey(), (Object)ByteKey.of((int[])new int[]{1}));
        Assert.assertEquals((Object)RANGE_1_10.getEndKey(), (Object)ByteKey.of((int[])new int[]{10}));
        Assert.assertEquals((Object)UP_TO_10.getStartKey(), (Object)ByteKey.EMPTY);
        Assert.assertEquals((Object)UP_TO_10.getEndKey(), (Object)ByteKey.of((int[])new int[]{10}));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"ByteKeyRange{startKey=[], endKey=[0a]}", (Object)UP_TO_10.toString());
    }

    @Test
    public void testEquals() {
        for (int i = 0; i < TEST_RANGES.length; ++i) {
            for (int j = 0; j < TEST_RANGES.length; ++j) {
                ByteKeyRange left = TEST_RANGES[i];
                ByteKeyRange right = TEST_RANGES[j];
                boolean eq = left.equals((Object)right);
                if (i == j) {
                    Assert.assertTrue((String)String.format("Expected that %s is equal to itself.", left), (boolean)eq);
                    Assert.assertTrue((String)String.format("Expected that %s is equal to a copy of itself.", left), (boolean)left.equals((Object)ByteKeyRange.of((ByteKey)right.getStartKey(), (ByteKey)right.getEndKey())));
                    continue;
                }
                Assert.assertFalse((String)String.format("Expected that %s is not equal to %s", left, right), (boolean)eq);
            }
        }
    }

    @Test
    public void testRejectsInvalidRanges() {
        ByteKey[] testKeys = ByteKeyTest.TEST_KEYS;
        for (int i = 0; i < testKeys.length; ++i) {
            for (int j = i; j < testKeys.length; ++j) {
                if (testKeys[i].isEmpty() || testKeys[j].isEmpty() || testKeys[j].equals((Object)testKeys[i])) continue;
                try {
                    ByteKeyRange range = ByteKeyRange.of((ByteKey)testKeys[j], (ByteKey)testKeys[i]);
                    Assert.fail((String)String.format("Expected failure constructing %s", range));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testHashCode() {
        int collisions = 0;
        for (int i = 0; i < TEST_RANGES.length; ++i) {
            ByteKeyRange current = TEST_RANGES[i];
            int left = current.hashCode();
            int leftClone = ByteKeyRange.of((ByteKey)current.getStartKey(), (ByteKey)current.getEndKey()).hashCode();
            Assert.assertEquals((String)String.format("Expected same hash code for %s and a copy of itself", current), (long)left, (long)leftClone);
            for (int j = i + 1; j < TEST_RANGES.length; ++j) {
                int right = TEST_RANGES[j].hashCode();
                if (left != right) continue;
                ++collisions;
            }
        }
        int totalUnequalTests = TEST_RANGES.length * (TEST_RANGES.length - 1) / 2;
        Assert.assertThat((String)"Too many hash collisions", (Object)collisions, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(totalUnequalTests / 2)));
    }

    private static void assertEqualExceptPadding(ByteKey expected, ByteKey key) {
        ByteBuffer shortKey = expected.getValue();
        ByteBuffer longKey = key.getValue();
        if (shortKey.remaining() > longKey.remaining()) {
            shortKey = key.getValue();
            longKey = expected.getValue();
        }
        for (int i = 0; i < shortKey.remaining(); ++i) {
            if (shortKey.get(i) == longKey.get(i)) continue;
            Assert.fail((String)String.format("Expected %s (up to trailing zeros), got %s", expected, key));
        }
        for (int j = shortKey.remaining(); j < longKey.remaining(); ++j) {
            if (longKey.get(j) == 0) continue;
            Assert.fail((String)String.format("Expected %s (up to trailing zeros), got %s", expected, key));
        }
    }
}

