/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.io.range.ByteKeyRangeTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ByteKeyRangeInterpolateKeyTest {
    private static final ByteKey[] TEST_KEYS = ByteKeyRangeTest.RANGE_TEST_KEYS;
    @Parameterized.Parameter
    public ByteKeyRange range;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> data() {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (int i = 0; i < TEST_KEYS.length; ++i) {
            for (int j = i + 1; j < TEST_KEYS.length; ++j) {
                ret.add((Object)new Object[]{ByteKeyRange.of((ByteKey)TEST_KEYS[i], (ByteKey)TEST_KEYS[j])});
            }
        }
        return ret.build();
    }

    @Test
    public void testInterpolateKeyAndEstimateFraction() {
        double delta = 1.0E-7;
        double[] testFractions = new double[]{0.01, 0.1, 0.123, 0.2, 0.3, 0.45738, 0.5, 0.6, 0.7182, 0.8, 0.95, 0.97, 0.99};
        ByteKey last = this.range.getStartKey();
        for (double fraction : testFractions) {
            String message = Double.toString(fraction);
            try {
                ByteKey key = this.range.interpolateKey(fraction);
                Assert.assertThat((String)message, (Object)key, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)last));
                Assert.assertThat((String)message, (Object)this.range.estimateFractionForKey(key), (Matcher)Matchers.closeTo((double)fraction, (double)delta));
                last = key;
            }
            catch (IllegalStateException e) {
                Assert.assertThat((String)message, (Object)e.getMessage(), (Matcher)Matchers.containsString((String)"near-empty ByteKeyRange"));
            }
        }
    }
}

