/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.io.range.ByteKeyRangeTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ByteKeyRangeEstimateFractionTest {
    private static final ByteKey[] TEST_KEYS = ByteKeyRangeTest.RANGE_TEST_KEYS;
    @Parameterized.Parameter(value=0)
    public int i;
    @Parameterized.Parameter(value=1)
    public int k;

    @Parameterized.Parameters(name="{index}: i={0}, k={1}")
    public static Iterable<Object[]> data() {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (int i = 0; i < TEST_KEYS.length; ++i) {
            for (int k = i + 1; k < TEST_KEYS.length; ++k) {
                ret.add((Object)new Object[]{i, k});
            }
        }
        return ret.build();
    }

    @Test
    public void testEstimateFractionForKey() {
        double last = 0.0;
        ByteKeyRange range = ByteKeyRange.of((ByteKey)TEST_KEYS[this.i], (ByteKey)TEST_KEYS[this.k]);
        for (int j = this.i; j < this.k; ++j) {
            ByteKey key = TEST_KEYS[j];
            if (key.isEmpty()) continue;
            double fraction = range.estimateFractionForKey(key);
            Assert.assertThat((Object)fraction, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(last)));
            last = fraction;
        }
    }
}

