/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Charsets;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Function;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Functions;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.MoreObjects;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Predicate;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Predicates;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.FluentIterable;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.TestUtils;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.DrunkWritableByteChannelFactory;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TextIOWriteTest {
    private static final String MY_HEADER = "myHeader";
    private static final String MY_FOOTER = "myFooter";
    @Rule
    public transient TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public transient TestPipeline p = TestPipeline.create();
    @Rule
    public transient ExpectedException expectedException = ExpectedException.none();

    @Test
    @Category(value={NeedsRunner.class})
    public void testDynamicDestinations() throws Exception {
        this.testDynamicDestinations(false);
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testDynamicDestinationsWithCustomType() throws Exception {
        this.testDynamicDestinations(true);
    }

    private void testDynamicDestinations(boolean customType) throws Exception {
        ResourceId baseDir = FileSystems.matchNewResource((String)Files.createTempDirectory(this.tempFolder.getRoot().toPath(), "testDynamicDestinations", new FileAttribute[0]).toString(), (boolean)true);
        ArrayList<String> elements = Lists.newArrayList("aaaa", "aaab", "baaa", "baab", "caaa", "caab");
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(elements).withCoder((Coder)StringUtf8Coder.of()));
        if (customType) {
            input.apply((PTransform)TextIO.writeCustomType().to((FileBasedSink.DynamicDestinations)new TestDynamicDestinations(baseDir)).withTempDirectory(baseDir));
        } else {
            input.apply((PTransform)TextIO.write().to((FileBasedSink.DynamicDestinations)new TestDynamicDestinations(baseDir)).withTempDirectory(baseDir));
        }
        this.p.run();
        TextIOWriteTest.assertOutputFiles(Iterables.toArray(Iterables.filter(elements, new StartsWith("a")), String.class), null, null, 0, baseDir.resolve("file_a.txt", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE), "-SSSSS-of-NNNNN");
        TextIOWriteTest.assertOutputFiles(Iterables.toArray(Iterables.filter(elements, new StartsWith("b")), String.class), null, null, 0, baseDir.resolve("file_b.txt", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE), "-SSSSS-of-NNNNN");
        TextIOWriteTest.assertOutputFiles(Iterables.toArray(Iterables.filter(elements, new StartsWith("c")), String.class), null, null, 0, baseDir.resolve("file_c.txt", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE), "-SSSSS-of-NNNNN");
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testDynamicDefaultFilenamePolicy() throws Exception {
        ResourceId baseDir = FileSystems.matchNewResource((String)Files.createTempDirectory(this.tempFolder.getRoot().toPath(), "testDynamicDestinations", new FileAttribute[0]).toString(), (boolean)true);
        ArrayList<UserWriteType> elements = Lists.newArrayList(new UserWriteType("aaaa", "first"), new UserWriteType("aaab", "second"), new UserWriteType("baaa", "third"), new UserWriteType("baab", "fourth"), new UserWriteType("caaa", "fifth"), new UserWriteType("caab", "sixth"));
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(elements));
        input.apply((PTransform)TextIO.writeCustomType().to((SerializableFunction)new UserWriteDestination(baseDir), new DefaultFilenamePolicy.Params().withBaseFilename(baseDir.resolve("empty", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE))).withFormatFunction((SerializableFunction)new SerializeUserWrite()).withTempDirectory(FileSystems.matchNewResource((String)baseDir.toString(), (boolean)true)));
        this.p.run();
        String[] aElements = Iterables.toArray((Iterable)StreamSupport.stream(elements.stream().filter(Predicates.compose(new StartsWith("a"), new ExtractWriteDestination())::apply).collect(Collectors.toList()).spliterator(), false).map(Functions.toStringFunction()::apply).collect(Collectors.toList()), String.class);
        String[] bElements = Iterables.toArray((Iterable)StreamSupport.stream(elements.stream().filter(Predicates.compose(new StartsWith("b"), new ExtractWriteDestination())::apply).collect(Collectors.toList()).spliterator(), false).map(Functions.toStringFunction()::apply).collect(Collectors.toList()), String.class);
        String[] cElements = Iterables.toArray((Iterable)StreamSupport.stream(elements.stream().filter(Predicates.compose(new StartsWith("c"), new ExtractWriteDestination())::apply).collect(Collectors.toList()).spliterator(), false).map(Functions.toStringFunction()::apply).collect(Collectors.toList()), String.class);
        TextIOWriteTest.assertOutputFiles(aElements, null, null, 0, baseDir.resolve("file_a.txt", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE), "-SSSSS-of-NNNNN");
        TextIOWriteTest.assertOutputFiles(bElements, null, null, 0, baseDir.resolve("file_b.txt", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE), "-SSSSS-of-NNNNN");
        TextIOWriteTest.assertOutputFiles(cElements, null, null, 0, baseDir.resolve("file_c.txt", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE), "-SSSSS-of-NNNNN");
    }

    private void runTestWrite(String[] elems) throws Exception {
        this.runTestWrite(elems, null, null, 1);
    }

    private void runTestWrite(String[] elems, int numShards) throws Exception {
        this.runTestWrite(elems, null, null, numShards);
    }

    private void runTestWrite(String[] elems, String header, String footer) throws Exception {
        this.runTestWrite(elems, header, footer, 1);
    }

    private void runTestWrite(String[] elems, String header, String footer, int numShards) throws Exception {
        String outputName = "file.txt";
        Path baseDir = Files.createTempDirectory(this.tempFolder.getRoot().toPath(), "testwrite", new FileAttribute[0]);
        ResourceId baseFilename = FileBasedSink.convertToFileResourceIfPossible((String)baseDir.resolve(outputName).toString());
        PCollection input = (PCollection)this.p.apply("CreateInput", (PTransform)Create.of(Arrays.asList(elems)).withCoder((Coder)StringUtf8Coder.of()));
        TextIO.TypedWrite write = TextIO.write().to(baseFilename).withHeader(header).withFooter(footer).withOutputFilenames();
        if (numShards == 1) {
            write = write.withoutSharding();
        } else if (numShards > 0) {
            write = write.withNumShards(numShards).withShardNameTemplate("-SSSSS-of-NNNNN");
        }
        input.apply((PTransform)write);
        this.p.run();
        TextIOWriteTest.assertOutputFiles(elems, header, footer, numShards, baseFilename, MoreObjects.firstNonNull(write.getShardTemplate(), "-SSSSS-of-NNNNN"));
    }

    private static void assertOutputFiles(String[] elems, String header, String footer, int numShards, ResourceId outputPrefix, String shardNameTemplate) throws Exception {
        ArrayList<File> expectedFiles = new ArrayList<File>();
        if (numShards == 0) {
            String pattern = outputPrefix.toString() + "*";
            List matches = FileSystems.match(Collections.singletonList(pattern));
            for (MatchResult.Metadata expectedFile : ((MatchResult)Iterables.getOnlyElement(matches)).metadata()) {
                expectedFiles.add(new File(expectedFile.resourceId().toString()));
            }
        } else {
            for (int i = 0; i < numShards; ++i) {
                expectedFiles.add(new File(DefaultFilenamePolicy.constructName((ResourceId)outputPrefix, (String)shardNameTemplate, (String)"", (int)i, (int)numShards, null, null).toString()));
            }
        }
        ArrayList<List<String>> actual = new ArrayList<List<String>>();
        for (File file : expectedFiles) {
            List<String> currentFile = TextIOWriteTest.readLinesFromFile(file);
            actual.add(currentFile);
        }
        ArrayList<String> expectedElements = new ArrayList<String>(elems.length);
        for (String elem : elems) {
            byte[] encodedElem = CoderUtils.encodeToByteArray((Coder)StringUtf8Coder.of(), (Object)elem);
            String line = new String(encodedElem, Charsets.UTF_8);
            expectedElements.add(line);
        }
        ArrayList<String> arrayList = Lists.newArrayList(Iterables.concat(FluentIterable.from(actual).transform(TextIOWriteTest.removeHeaderAndFooter(header, footer)).toList()));
        Assert.assertThat(arrayList, (Matcher)Matchers.containsInAnyOrder((Object[])expectedElements.toArray()));
        Assert.assertTrue((boolean)actual.stream().allMatch(TextIOWriteTest.haveProperHeaderAndFooter(header, footer)::apply));
    }

    private static List<String> readLinesFromFile(File f) throws IOException {
        ArrayList<String> currentFile = new ArrayList<String>();
        try (BufferedReader reader = Files.newBufferedReader(f.toPath(), Charsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                currentFile.add(line);
            }
        }
        return currentFile;
    }

    private static Function<List<String>, List<String>> removeHeaderAndFooter(final String header, final String footer) {
        return new Function<List<String>, List<String>>(){

            @Override
            @Nullable
            public List<String> apply(List<String> lines) {
                ArrayList<String> newLines = Lists.newArrayList(lines);
                if (header != null) {
                    newLines.remove(0);
                }
                if (footer != null) {
                    int last = newLines.size() - 1;
                    newLines.remove(last);
                }
                return newLines;
            }
        };
    }

    private static Predicate<List<String>> haveProperHeaderAndFooter(String header, String footer) {
        return fileLines -> {
            int last = fileLines.size() - 1;
            return !(header != null && !((String)fileLines.get(0)).equals(header) || footer != null && !((String)fileLines.get(last)).equals(footer));
        };
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testWriteStrings() throws Exception {
        this.runTestWrite(TestUtils.LINES_ARRAY);
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testWriteEmptyStringsNoSharding() throws Exception {
        this.runTestWrite(TestUtils.NO_LINES_ARRAY, 0);
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testWriteEmptyStrings() throws Exception {
        this.runTestWrite(TestUtils.NO_LINES_ARRAY);
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testShardedWrite() throws Exception {
        this.runTestWrite(TestUtils.LINES_ARRAY, 5);
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testWriteWithHeader() throws Exception {
        this.runTestWrite(TestUtils.LINES_ARRAY, MY_HEADER, null);
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testWriteWithFooter() throws Exception {
        this.runTestWrite(TestUtils.LINES_ARRAY, null, MY_FOOTER);
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testWriteWithHeaderAndFooter() throws Exception {
        this.runTestWrite(TestUtils.LINES_ARRAY, MY_HEADER, MY_FOOTER);
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testWriteWithWritableByteChannelFactory() throws Exception {
        StringUtf8Coder coder = StringUtf8Coder.of();
        String outputName = "file.txt";
        ResourceId baseDir = FileSystems.matchNewResource((String)Files.createTempDirectory(this.tempFolder.getRoot().toPath(), "testwrite", new FileAttribute[0]).toString(), (boolean)true);
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(Arrays.asList(TestUtils.LINES2_ARRAY)).withCoder((Coder)coder));
        DrunkWritableByteChannelFactory writableByteChannelFactory = new DrunkWritableByteChannelFactory();
        TextIO.Write write = TextIO.write().to(baseDir.resolve(outputName, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString()).withoutSharding().withWritableByteChannelFactory((FileBasedSink.WritableByteChannelFactory)writableByteChannelFactory);
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("writableByteChannelFactory", "DRUNK"));
        input.apply((PTransform)write);
        this.p.run();
        ArrayList<String> drunkElems = new ArrayList<String>(TestUtils.LINES2_ARRAY.length * 2 + 2);
        for (String elem : TestUtils.LINES2_ARRAY) {
            drunkElems.add(elem);
            drunkElems.add(elem);
        }
        TextIOWriteTest.assertOutputFiles(drunkElems.toArray(new String[0]), null, null, 1, baseDir.resolve(outputName + writableByteChannelFactory.getSuggestedFilenameSuffix(), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE), write.inner.getShardTemplate());
    }

    @Test
    public void testWriteDisplayData() {
        TextIO.Write write = TextIO.write().to("/foo").withSuffix("bar").withShardNameTemplate("-SS-of-NN-").withNumShards(100).withFooter(MY_FOOTER).withHeader(MY_HEADER);
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("filePrefix", "/foo"));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("fileSuffix", "bar"));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("fileHeader", MY_HEADER));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("fileFooter", MY_FOOTER));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("shardNameTemplate", "-SS-of-NN-"));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("numShards", 100L));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("writableByteChannelFactory", "UNCOMPRESSED"));
    }

    @Test
    public void testWriteDisplayDataValidateThenHeader() {
        TextIO.Write write = TextIO.write().to("foo").withHeader(MY_HEADER);
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("fileHeader", MY_HEADER));
    }

    @Test
    public void testWriteDisplayDataValidateThenFooter() {
        TextIO.Write write = TextIO.write().to("foo").withFooter(MY_FOOTER);
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("fileFooter", MY_FOOTER));
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)"TextIO.Write", (Object)TextIO.write().to("somefile").getName());
    }

    @Test
    public void testRuntimeOptionsNotCalledInApply() throws Exception {
        this.p.enableAbandonedNodeEnforcement(false);
        RuntimeTestOptions options = (RuntimeTestOptions)PipelineOptionsFactory.as(RuntimeTestOptions.class);
        ((PCollection)this.p.apply((PTransform)Create.of((Object)"", (Object[])new String[0]))).apply((PTransform)TextIO.write().to(options.getOutput()));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testWindowedWritesWithOnceTrigger() throws Throwable {
        PCollection data = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"0", (Object[])new String[]{"1", "2"}))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardSeconds((long)1L))).triggering((Trigger)AfterPane.elementCountAtLeast((int)3)).withAllowedLateness(Duration.standardMinutes((long)1L)).discardingFiredPanes());
        PCollection filenames = (PCollection)((WriteFilesResult)data.apply((PTransform)TextIO.write().to(new File(this.tempFolder.getRoot(), "windowed-writes").getAbsolutePath()).withNumShards(2).withWindowedWrites().withOutputFilenames())).getPerDestinationOutputFilenames().apply((PTransform)Values.create());
        PAssert.that((PCollection)((PCollection)filenames.apply((PTransform)TextIO.readAll()))).containsInAnyOrder((Object[])new String[]{"0", "1", "2"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testWriteViaSink() throws Exception {
        ImmutableList<String> data = ImmutableList.of("a", "b", "c", "d", "e", "f");
        PAssert.that((PCollection)((PCollection)((PCollection)((WriteFilesResult)((PCollection)this.p.apply((PTransform)Create.of(data))).apply((PTransform)FileIO.write().to(this.tempFolder.getRoot().toString()).withSuffix(".txt").via((FileIO.Sink)TextIO.sink()).withIgnoreWindowing())).getPerDestinationOutputFilenames().apply((PTransform)Values.create())).apply((PTransform)TextIO.readAll()))).containsInAnyOrder(data);
        this.p.run();
    }

    @Test
    public void testSink() throws Exception {
        TextIO.Sink sink = TextIO.sink().withHeader("header").withFooter("footer");
        File f = new File(this.tempFolder.getRoot(), "file");
        try (WritableByteChannel chan = Channels.newChannel(new FileOutputStream(f));){
            sink.open(chan);
            sink.write("a");
            sink.write("b");
            sink.write("c");
            sink.flush();
        }
        Assert.assertEquals(Arrays.asList("header", "a", "b", "c", "footer"), TextIOWriteTest.readLinesFromFile(f));
    }

    public static interface RuntimeTestOptions
    extends PipelineOptions {
        public ValueProvider<String> getOutput();

        public void setOutput(ValueProvider<String> var1);
    }

    private static class ExtractWriteDestination
    implements Function<UserWriteType, String> {
        private ExtractWriteDestination() {
        }

        @Override
        public String apply(@Nullable UserWriteType input) {
            return input.destination;
        }
    }

    private static class UserWriteDestination
    implements SerializableFunction<UserWriteType, DefaultFilenamePolicy.Params> {
        private ResourceId baseDir;

        UserWriteDestination(ResourceId baseDir) {
            this.baseDir = baseDir;
        }

        public DefaultFilenamePolicy.Params apply(UserWriteType input) {
            return new DefaultFilenamePolicy.Params().withBaseFilename(this.baseDir.resolve("file_" + input.destination.substring(0, 1) + ".txt", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        }
    }

    private static class SerializeUserWrite
    implements SerializableFunction<UserWriteType, String> {
        private SerializeUserWrite() {
        }

        public String apply(UserWriteType input) {
            return input.toString();
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    private static class UserWriteType {
        String destination;
        String metadata;

        UserWriteType() {
            this.destination = "";
            this.metadata = "";
        }

        UserWriteType(String destination, String metadata) {
            this.destination = destination;
            this.metadata = metadata;
        }

        public String toString() {
            return String.format("destination: %s metadata : %s", this.destination, this.metadata);
        }
    }

    static class StartsWith
    implements Predicate<String> {
        String prefix;

        StartsWith(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean apply(@Nullable String input) {
            return input.startsWith(this.prefix);
        }
    }

    static class TestDynamicDestinations
    extends FileBasedSink.DynamicDestinations<String, String, String> {
        ResourceId baseDir;

        TestDynamicDestinations(ResourceId baseDir) {
            this.baseDir = baseDir;
        }

        public String formatRecord(String record) {
            return record;
        }

        public String getDestination(String element) {
            return element.substring(0, 1);
        }

        public String getDefaultDestination() {
            return "";
        }

        @Nullable
        public Coder<String> getDestinationCoder() {
            return StringUtf8Coder.of();
        }

        public FileBasedSink.FilenamePolicy getFilenamePolicy(String destination) {
            return DefaultFilenamePolicy.fromStandardParameters((ValueProvider)ValueProvider.StaticValueProvider.of((Object)this.baseDir.resolve("file_" + destination + ".txt", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE)), null, null, (boolean)false);
        }
    }
}

