/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Charsets;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Joiner;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.repackaged.beam_sdks_java_core.org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.beam.repackaged.beam_sdks_java_core.org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.TestUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.TextSource;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ToString;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Parameterized;

public class TextIOReadTest {
    private static final int LINES_NUMBER_FOR_LARGE = 1000;
    private static final List<String> EMPTY = Collections.emptyList();
    private static final List<String> TINY = Arrays.asList("Irritable eagle", "Optimistic jay", "Fanciful hawk");
    private static final List<String> LARGE = TextIOReadTest.makeLines(1000);

    private static File writeToFile(List<String> lines, TemporaryFolder folder, String fileName, Compression compression) throws IOException {
        File file = folder.getRoot().toPath().resolve(fileName).toFile();
        OutputStream output = new FileOutputStream(file);
        switch (compression) {
            case UNCOMPRESSED: {
                break;
            }
            case GZIP: {
                output = new GZIPOutputStream(output);
                break;
            }
            case BZIP2: {
                output = new BZip2CompressorOutputStream(output);
                break;
            }
            case ZIP: {
                ZipOutputStream zipOutput = new ZipOutputStream(output);
                zipOutput.putNextEntry(new ZipEntry("entry"));
                output = zipOutput;
                break;
            }
            case DEFLATE: {
                output = new DeflateCompressorOutputStream(output);
                break;
            }
            default: {
                throw new UnsupportedOperationException(compression.toString());
            }
        }
        TextIOReadTest.writeToStreamAndClose(lines, output);
        return file;
    }

    private static void writeToStreamAndClose(List<String> lines, OutputStream outputStream) {
        try (PrintStream writer = new PrintStream(outputStream);){
            for (String line : lines) {
                writer.println(line);
            }
        }
    }

    private static List<String> makeLines(int n) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            ret.add("word" + i);
        }
        return ret;
    }

    private static void assertReadingCompressedFileMatchesExpected(File file, Compression compression, List<String> expected, Pipeline p) {
        TextIO.Read read = TextIO.read().from(file.getPath()).withCompression(compression);
        PAssert.that((PCollection)((PCollection)p.apply("Read_" + file + "_" + compression.toString(), (PTransform)read))).containsInAnyOrder(expected);
        PAssert.that((PCollection)((PCollection)p.apply("Read_" + file + "_" + compression.toString() + "_many", (PTransform)read.withHintMatchesManyFiles()))).containsInAnyOrder(expected);
        TextIO.ReadAll readAll = TextIO.readAll().withCompression(compression);
        PAssert.that((PCollection)((PCollection)((PCollection)p.apply("Create_" + file, (PTransform)Create.of((Object)file.getPath(), (Object[])new String[0]))).apply("Read_" + compression.toString(), (PTransform)readAll))).containsInAnyOrder(expected);
    }

    private static File createZipFile(List<String> expected, TemporaryFolder folder, String filename, String[] ... fieldsEntries) throws Exception {
        File tmpFile = folder.getRoot().toPath().resolve(filename).toFile();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tmpFile));
        PrintStream writer = new PrintStream(out, true);
        int index = 0;
        for (String[] entry : fieldsEntries) {
            out.putNextEntry(new ZipEntry(Integer.toString(index)));
            for (String field : entry) {
                writer.println(field);
                expected.add(field);
            }
            out.closeEntry();
            ++index;
        }
        writer.close();
        out.close();
        return tmpFile;
    }

    private static TextSource prepareSource(TemporaryFolder temporaryFolder, byte[] data, byte[] delimiter) throws IOException {
        Path path = temporaryFolder.newFile().toPath();
        Files.write(path, data, new OpenOption[0]);
        return new TextSource((ValueProvider)ValueProvider.StaticValueProvider.of((Object)path.toString()), EmptyMatchTreatment.DISALLOW, delimiter);
    }

    private static String getFileSuffix(Compression compression) {
        switch (compression) {
            case UNCOMPRESSED: {
                return ".txt";
            }
            case GZIP: {
                return ".gz";
            }
            case BZIP2: {
                return ".bz2";
            }
            case ZIP: {
                return ".zip";
            }
            case DEFLATE: {
                return ".deflate";
            }
        }
        return "";
    }

    @RunWith(value=JUnit4.class)
    public static class BasicIOTest {
        @Rule
        public TemporaryFolder tempFolder = new TemporaryFolder();
        @Rule
        public TestPipeline p = TestPipeline.create();

        private void runTestRead(String[] expected) throws Exception {
            File tmpFile = this.tempFolder.newFile();
            String filename = tmpFile.getPath();
            try (PrintStream writer = new PrintStream(new FileOutputStream(tmpFile));){
                for (String elem : expected) {
                    byte[] encodedElem = CoderUtils.encodeToByteArray((Coder)StringUtf8Coder.of(), (Object)elem);
                    String line = new String(encodedElem, Charsets.UTF_8);
                    writer.println(line);
                }
            }
            TextIO.Read read = TextIO.read().from(filename);
            PCollection output = (PCollection)this.p.apply((PTransform)read);
            PAssert.that((PCollection)output).containsInAnyOrder((Object[])expected);
            this.p.run();
        }

        @Test
        public void testDelimiterSelfOverlaps() {
            Assert.assertFalse((boolean)TextIO.Read.isSelfOverlapping((byte[])new byte[]{97, 98, 99}));
            Assert.assertFalse((boolean)TextIO.Read.isSelfOverlapping((byte[])new byte[]{99, 97, 98, 100, 97, 98}));
            Assert.assertFalse((boolean)TextIO.Read.isSelfOverlapping((byte[])new byte[]{97, 98, 99, 97, 98, 100}));
            Assert.assertTrue((boolean)TextIO.Read.isSelfOverlapping((byte[])new byte[]{97, 98, 97}));
            Assert.assertTrue((boolean)TextIO.Read.isSelfOverlapping((byte[])new byte[]{97, 98, 99, 97, 98}));
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadStringsWithCustomDelimiter() throws Exception {
            Object[] inputStrings = new String[]{"To be, or not to be: that |is the question: ", "To be, or not to be: that *is the question: ", "Whether 'tis nobler in the mind to suffer |*", "The slings and arrows of outrageous fortune,|"};
            File tmpFile = this.tempFolder.newFile("tmpfile.txt");
            String filename = tmpFile.getPath();
            try (BufferedWriter writer = Files.newBufferedWriter(tmpFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(Joiner.on("").join(inputStrings));
            }
            PAssert.that((PCollection)((PCollection)this.p.apply((PTransform)TextIO.read().from(filename).withDelimiter(new byte[]{124, 42})))).containsInAnyOrder((Object[])new String[]{"To be, or not to be: that |is the question: To be, or not to be: that *is the question: Whether 'tis nobler in the mind to suffer ", "The slings and arrows of outrageous fortune,|"});
            this.p.run();
        }

        @Test
        public void testSplittingSourceWithCustomDelimiter() throws Exception {
            ArrayList<String> testCases = Lists.newArrayList();
            String infix = "first|*second|*|*third";
            String[] affixes = new String[]{"", "|", "*", "|*"};
            for (String prefix : affixes) {
                for (String suffix : affixes) {
                    testCases.add(prefix + infix + suffix);
                }
            }
            for (String testCase : testCases) {
                SourceTestUtils.assertSplitAtFractionExhaustive((BoundedSource)TextIOReadTest.prepareSource(this.tempFolder, testCase.getBytes(StandardCharsets.UTF_8), new byte[]{124, 42}), (PipelineOptions)PipelineOptionsFactory.create());
            }
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadStrings() throws Exception {
            this.runTestRead(TestUtils.LINES_ARRAY);
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadEmptyStrings() throws Exception {
            this.runTestRead(TestUtils.NO_LINES_ARRAY);
        }

        @Test
        public void testReadNamed() throws Exception {
            File emptyFile = this.tempFolder.newFile();
            this.p.enableAbandonedNodeEnforcement(false);
            Assert.assertEquals((Object)"TextIO.Read/Read.out", (Object)((PCollection)this.p.apply((PTransform)TextIO.read().from("somefile"))).getName());
            Assert.assertEquals((Object)"MyRead/Read.out", (Object)((PCollection)this.p.apply("MyRead", (PTransform)TextIO.read().from(emptyFile.getPath()))).getName());
        }

        @Test
        public void testReadDisplayData() {
            TextIO.Read read = TextIO.read().from("foo.*").withCompression(Compression.BZIP2);
            DisplayData displayData = DisplayData.from((HasDisplayData)read);
            Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("filePattern", "foo.*"));
            Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("compressionType", Compression.BZIP2.toString()));
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testPrimitiveReadDisplayData() {
            DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
            TextIO.Read read = TextIO.read().from("foobar");
            Set<DisplayData> displayData = evaluator.displayDataForPrimitiveSourceTransforms((PTransform<? super PBegin, ? extends POutput>)read);
            Assert.assertThat((String)"TextIO.Read should include the file prefix in its primitive display data", displayData, (Matcher)Matchers.hasItem(DisplayDataMatchers.hasDisplayItem(DisplayDataMatchers.hasValue(Matchers.startsWith((String)"foobar")))));
        }

        @Test
        public void testRuntimeOptionsNotCalledInApply() throws Exception {
            this.p.enableAbandonedNodeEnforcement(false);
            RuntimeTestOptions options = (RuntimeTestOptions)PipelineOptionsFactory.as(RuntimeTestOptions.class);
            this.p.apply((PTransform)TextIO.read().from(options.getInput()));
        }

        @Test
        public void testCompressionIsSet() throws Exception {
            TextIO.Read read = TextIO.read().from("/tmp/test");
            Assert.assertEquals((Object)Compression.AUTO, (Object)read.getCompression());
            read = TextIO.read().from("/tmp/test").withCompression(Compression.GZIP);
            Assert.assertEquals((Object)Compression.GZIP, (Object)read.getCompression());
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSmallCompressedGzipReadActuallyUncompressed() throws Exception {
            File smallGzNotCompressed = TextIOReadTest.writeToFile(TINY, this.tempFolder, "tiny_uncompressed.gz", Compression.UNCOMPRESSED);
            TextIOReadTest.assertReadingCompressedFileMatchesExpected(smallGzNotCompressed, Compression.GZIP, TINY, (Pipeline)this.p);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSmallCompressedAutoReadActuallyUncompressed() throws Exception {
            File smallGzNotCompressed = TextIOReadTest.writeToFile(TINY, this.tempFolder, "tiny_uncompressed.gz", Compression.UNCOMPRESSED);
            TextIOReadTest.assertReadingCompressedFileMatchesExpected(smallGzNotCompressed, Compression.AUTO, TINY, (Pipeline)this.p);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testZipCompressedReadWithNoEntries() throws Exception {
            File file = TextIOReadTest.createZipFile(new ArrayList(), this.tempFolder, "empty zip file", new String[0][]);
            TextIOReadTest.assertReadingCompressedFileMatchesExpected(file, Compression.ZIP, EMPTY, (Pipeline)this.p);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testZipCompressedReadWithMultiEntriesFile() throws Exception {
            String[] entry0 = new String[]{"first", "second", "three"};
            String[] entry1 = new String[]{"four", "five", "six"};
            String[] entry2 = new String[]{"seven", "eight", "nine"};
            ArrayList expected = new ArrayList();
            File file = TextIOReadTest.createZipFile(expected, this.tempFolder, "multiple entries", new String[][]{entry0, entry1, entry2});
            TextIOReadTest.assertReadingCompressedFileMatchesExpected(file, Compression.ZIP, expected, (Pipeline)this.p);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testZipCompressedReadWithComplexEmptyAndPresentEntries() throws Exception {
            File file = TextIOReadTest.createZipFile(new ArrayList(), this.tempFolder, "complex empty and present entries", new String[][]{{"cat"}, new String[0], new String[0], {"dog"}});
            TextIOReadTest.assertReadingCompressedFileMatchesExpected(file, Compression.ZIP, Arrays.asList("cat", "dog"), (Pipeline)this.p);
            this.p.run();
        }

        @Test
        public void testTextIOGetName() {
            Assert.assertEquals((Object)"TextIO.Read", (Object)TextIO.read().from("somefile").getName());
            Assert.assertEquals((Object)"TextIO.Read", (Object)TextIO.read().from("somefile").toString());
        }

        private TextSource prepareSource(byte[] data) throws IOException {
            return TextIOReadTest.prepareSource(this.tempFolder, data, null);
        }

        @Test
        public void testProgressEmptyFile() throws IOException {
            try (BoundedSource.BoundedReader reader = this.prepareSource(new byte[0]).createReader(PipelineOptionsFactory.create());){
                Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
                Assert.assertFalse((boolean)reader.start());
                Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsRemaining());
            }
        }

        @Test
        public void testProgressTextFile() throws IOException {
            String file = "line1\nline2\nline3";
            try (BoundedSource.BoundedReader reader = this.prepareSource(file.getBytes(Charsets.UTF_8)).createReader(PipelineOptionsFactory.create());){
                Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
                Assert.assertTrue((boolean)reader.start());
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
                Assert.assertTrue((boolean)reader.advance());
                Assert.assertEquals((long)1L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
                Assert.assertTrue((boolean)reader.advance());
                Assert.assertEquals((long)2L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)1L, (long)reader.getSplitPointsRemaining());
                Assert.assertFalse((boolean)reader.advance());
                Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)3L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsRemaining());
            }
        }

        @Test
        public void testProgressAfterSplitting() throws IOException {
            BoundedSource remainder;
            String file = "line1\nline2\nline3";
            TextSource source = this.prepareSource(file.getBytes(Charsets.UTF_8));
            try (BoundedSource.BoundedReader readerOrig = source.createReader(PipelineOptionsFactory.create());){
                Assert.assertEquals((double)0.0, (double)readerOrig.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)0L, (long)readerOrig.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)readerOrig.getSplitPointsRemaining());
                Assert.assertTrue((boolean)readerOrig.start());
                Assert.assertEquals((long)0L, (long)readerOrig.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)readerOrig.getSplitPointsRemaining());
                remainder = readerOrig.splitAtFraction(0.1);
                System.err.println(readerOrig.getCurrentSource());
                Assert.assertNotNull((Object)remainder);
                Assert.assertEquals((long)0L, (long)readerOrig.getSplitPointsConsumed());
                Assert.assertEquals((long)1L, (long)readerOrig.getSplitPointsRemaining());
                Assert.assertFalse((boolean)readerOrig.advance());
                Assert.assertEquals((double)1.0, (double)readerOrig.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)1L, (long)readerOrig.getSplitPointsConsumed());
                Assert.assertEquals((long)0L, (long)readerOrig.getSplitPointsRemaining());
            }
            var5_4 = null;
            try (BoundedSource.BoundedReader reader = remainder.createReader(PipelineOptionsFactory.create());){
                Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
                Assert.assertTrue((boolean)reader.start());
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
                Assert.assertTrue((boolean)reader.advance());
                Assert.assertEquals((long)1L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)1L, (long)reader.getSplitPointsRemaining());
                Assert.assertFalse((boolean)reader.advance());
                Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)2L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsRemaining());
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
        }

        @Test
        public void testInitialSplitAutoModeTxt() throws Exception {
            PipelineOptions options = TestPipeline.testingPipelineOptions();
            long desiredBundleSize = 1000L;
            File largeTxt = TextIOReadTest.writeToFile(LARGE, this.tempFolder, "large.txt", Compression.UNCOMPRESSED);
            Assert.assertThat((Object)largeTxt.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(2L * desiredBundleSize)));
            FileBasedSource source = TextIO.read().from(largeTxt.getPath()).getSource();
            List splits = source.split(desiredBundleSize, options);
            Assert.assertThat((Object)splits, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1))));
            SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splits, (PipelineOptions)options);
        }

        @Test
        public void testInitialSplitAutoModeGz() throws Exception {
            PipelineOptions options = TestPipeline.testingPipelineOptions();
            long desiredBundleSize = 1000L;
            File largeGz = TextIOReadTest.writeToFile(LARGE, this.tempFolder, "large.gz", Compression.GZIP);
            Assert.assertThat((Object)largeGz.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(2L * desiredBundleSize)));
            FileBasedSource source = TextIO.read().from(largeGz.getPath()).getSource();
            List splits = source.split(desiredBundleSize, options);
            Assert.assertThat((Object)splits, (Matcher)Matchers.hasSize((Matcher)Matchers.equalTo((Object)1)));
            SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splits, (PipelineOptions)options);
        }

        @Test
        public void testInitialSplitGzipModeTxt() throws Exception {
            PipelineOptions options = TestPipeline.testingPipelineOptions();
            long desiredBundleSize = 1000L;
            File largeTxt = TextIOReadTest.writeToFile(LARGE, this.tempFolder, "large.txt", Compression.UNCOMPRESSED);
            Assert.assertThat((Object)largeTxt.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(2L * desiredBundleSize)));
            FileBasedSource source = TextIO.read().from(largeTxt.getPath()).withCompression(Compression.GZIP).getSource();
            List splits = source.split(desiredBundleSize, options);
            Assert.assertThat((Object)splits, (Matcher)Matchers.hasSize((Matcher)Matchers.equalTo((Object)1)));
            SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splits, (PipelineOptions)options);
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadAll() throws IOException {
            Path tempFolderPath = this.tempFolder.getRoot().toPath();
            TextIOReadTest.writeToFile(TINY, this.tempFolder, "readAllTiny1.zip", Compression.ZIP);
            TextIOReadTest.writeToFile(TINY, this.tempFolder, "readAllTiny2.txt", Compression.UNCOMPRESSED);
            TextIOReadTest.writeToFile(LARGE, this.tempFolder, "readAllLarge1.zip", Compression.ZIP);
            TextIOReadTest.writeToFile(LARGE, this.tempFolder, "readAllLarge2.txt", Compression.UNCOMPRESSED);
            PCollection lines = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)tempFolderPath.resolve("readAllTiny*").toString(), (Object[])new String[]{tempFolderPath.resolve("readAllLarge*").toString()}))).apply((PTransform)TextIO.readAll().withCompression(Compression.AUTO));
            PAssert.that((PCollection)lines).containsInAnyOrder(Iterables.concat(TINY, TINY, LARGE, LARGE));
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadFiles() throws IOException {
            Path tempFolderPath = this.tempFolder.getRoot().toPath();
            TextIOReadTest.writeToFile(TINY, this.tempFolder, "readAllTiny1.zip", Compression.ZIP);
            TextIOReadTest.writeToFile(TINY, this.tempFolder, "readAllTiny2.txt", Compression.UNCOMPRESSED);
            TextIOReadTest.writeToFile(LARGE, this.tempFolder, "readAllLarge1.zip", Compression.ZIP);
            TextIOReadTest.writeToFile(LARGE, this.tempFolder, "readAllLarge2.txt", Compression.UNCOMPRESSED);
            PCollection lines = (PCollection)((PCollection)((PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)tempFolderPath.resolve("readAllTiny*").toString(), (Object[])new String[]{tempFolderPath.resolve("readAllLarge*").toString()}))).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches().withCompression(Compression.AUTO))).apply((PTransform)TextIO.readFiles().withDesiredBundleSizeBytes(10L));
            PAssert.that((PCollection)lines).containsInAnyOrder(Iterables.concat(TINY, TINY, LARGE, LARGE));
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadWatchForNewFiles() throws IOException, InterruptedException {
            Path basePath = this.tempFolder.getRoot().toPath().resolve("readWatch");
            basePath.toFile().mkdir();
            ((PCollection)((PCollection)((PCollection)this.p.apply((PTransform)GenerateSequence.from((long)0L).to(10L).withRate(1L, Duration.millis((long)100L)))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)150L))).withAllowedLateness(Duration.ZERO).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)1))).discardingFiredPanes())).apply(ToString.elements())).apply((PTransform)TextIO.write().to(basePath.resolve("data").toString()).withNumShards(1).withWindowedWrites());
            PCollection lines = (PCollection)this.p.apply((PTransform)TextIO.read().from(basePath.resolve("*").toString()).watchForNewFiles(Duration.millis((long)100L), (Watch.Growth.TerminationCondition)Watch.Growth.afterTimeSinceNewOutput((ReadableDuration)Duration.standardSeconds((long)3L))));
            PAssert.that((PCollection)lines).containsInAnyOrder((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"});
            this.p.run();
        }

        public static interface RuntimeTestOptions
        extends PipelineOptions {
            public ValueProvider<String> getInput();

            public void setInput(ValueProvider<String> var1);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ReadWithDelimiterTest {
        private static final ImmutableList<String> EXPECTED = ImmutableList.of("asdf", "hjkl", "xyz");
        @Rule
        public TemporaryFolder tempFolder = new TemporaryFolder();
        @Parameterized.Parameter(value=0)
        public String line;
        @Parameterized.Parameter(value=1)
        public ImmutableList<String> expected;

        @Parameterized.Parameters(name="{index}: {0}")
        public static Iterable<Object[]> data() {
            return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add((Object)new Object[]{"\n\n\n", ImmutableList.of("", "", "")})).add((Object)new Object[]{"asdf\nhjkl\nxyz\n", EXPECTED})).add((Object)new Object[]{"asdf\rhjkl\rxyz\r", EXPECTED})).add((Object)new Object[]{"asdf\r\nhjkl\r\nxyz\r\n", EXPECTED})).add((Object)new Object[]{"asdf\rhjkl\r\nxyz\n", EXPECTED})).add((Object)new Object[]{"asdf\nhjkl\nxyz", EXPECTED})).add((Object)new Object[]{"asdf\rhjkl\rxyz", EXPECTED})).add((Object)new Object[]{"asdf\r\nhjkl\r\nxyz", EXPECTED})).add((Object)new Object[]{"asdf\rhjkl\r\nxyz", EXPECTED})).build();
        }

        @Test
        public void testReadLinesWithDelimiter() throws Exception {
            this.runTestReadWithData(this.line.getBytes(StandardCharsets.UTF_8), this.expected);
        }

        @Test
        public void testSplittingSource() throws Exception {
            TextSource source = this.prepareSource(this.line.getBytes(StandardCharsets.UTF_8));
            SourceTestUtils.assertSplitAtFractionExhaustive((BoundedSource)source, (PipelineOptions)PipelineOptionsFactory.create());
        }

        private TextSource prepareSource(byte[] data) throws IOException {
            return TextIOReadTest.prepareSource(this.tempFolder, data, null);
        }

        private void runTestReadWithData(byte[] data, List<String> expectedResults) throws Exception {
            TextSource source = this.prepareSource(data);
            List actual = SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)PipelineOptionsFactory.create());
            Assert.assertThat((Object)actual, (Matcher)Matchers.containsInAnyOrder((Object[])new ArrayList<String>(expectedResults).toArray(new String[0])));
        }
    }

    @RunWith(value=Parameterized.class)
    public static class CompressedReadTest {
        @Rule
        public TemporaryFolder tempFolder = new TemporaryFolder();
        @Rule
        public TestPipeline p = TestPipeline.create();
        @Parameterized.Parameter(value=0)
        public List<String> lines;
        @Parameterized.Parameter(value=1)
        public Compression compression;

        @Parameterized.Parameters(name="{index}: {1}")
        public static Iterable<Object[]> data() {
            return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add((Object)new Object[]{EMPTY, Compression.UNCOMPRESSED})).add((Object)new Object[]{EMPTY, Compression.GZIP})).add((Object)new Object[]{EMPTY, Compression.BZIP2})).add((Object)new Object[]{EMPTY, Compression.ZIP})).add((Object)new Object[]{EMPTY, Compression.DEFLATE})).add((Object)new Object[]{TINY, Compression.UNCOMPRESSED})).add((Object)new Object[]{TINY, Compression.GZIP})).add((Object)new Object[]{TINY, Compression.BZIP2})).add((Object)new Object[]{TINY, Compression.ZIP})).add((Object)new Object[]{TINY, Compression.DEFLATE})).add((Object)new Object[]{LARGE, Compression.UNCOMPRESSED})).add((Object)new Object[]{LARGE, Compression.GZIP})).add((Object)new Object[]{LARGE, Compression.BZIP2})).add((Object)new Object[]{LARGE, Compression.ZIP})).add((Object)new Object[]{LARGE, Compression.DEFLATE})).build();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testCompressedReadWithoutExtension() throws Exception {
            String fileName = this.lines.size() + "_" + this.compression + "_no_extension";
            File fileWithNoExtension = TextIOReadTest.writeToFile(this.lines, this.tempFolder, fileName, this.compression);
            TextIOReadTest.assertReadingCompressedFileMatchesExpected(fileWithNoExtension, this.compression, this.lines, (Pipeline)this.p);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testCompressedReadWithExtension() throws Exception {
            String fileName = this.lines.size() + "_" + this.compression + "_no_extension" + TextIOReadTest.getFileSuffix(this.compression);
            File fileWithExtension = TextIOReadTest.writeToFile(this.lines, this.tempFolder, fileName, this.compression);
            if (this.lines.size() == 1000 && !this.compression.equals((Object)Compression.UNCOMPRESSED)) {
                File uncompressedFile = TextIOReadTest.writeToFile(this.lines, this.tempFolder, "large.txt", Compression.UNCOMPRESSED);
                Assert.assertThat((Object)uncompressedFile.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(fileWithExtension.length())));
            }
            TextIOReadTest.assertReadingCompressedFileMatchesExpected(fileWithExtension, this.compression, this.lines, (Pipeline)this.p);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadWithAuto() throws Exception {
            String fileName = this.lines.size() + "_" + this.compression + "_no_extension" + TextIOReadTest.getFileSuffix(this.compression);
            File fileWithExtension = TextIOReadTest.writeToFile(this.lines, this.tempFolder, fileName, this.compression);
            TextIOReadTest.assertReadingCompressedFileMatchesExpected(fileWithExtension, Compression.AUTO, this.lines, (Pipeline)this.p);
            this.p.run();
        }
    }
}

