/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.DynamicFileDestinations;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;

class SimpleSink<DestinationT>
extends FileBasedSink<String, DestinationT, String> {
    public SimpleSink(ResourceId tempDirectory, FileBasedSink.DynamicDestinations<String, DestinationT, String> dynamicDestinations, FileBasedSink.WritableByteChannelFactory writableByteChannelFactory) {
        super((ValueProvider)ValueProvider.StaticValueProvider.of((Object)tempDirectory), dynamicDestinations, writableByteChannelFactory);
    }

    public SimpleSink(ResourceId tempDirectory, FileBasedSink.DynamicDestinations<String, DestinationT, String> dynamicDestinations, Compression compression) {
        super((ValueProvider)ValueProvider.StaticValueProvider.of((Object)tempDirectory), dynamicDestinations, compression);
    }

    public static SimpleSink<Void> makeSimpleSink(ResourceId tempDirectory, FileBasedSink.FilenamePolicy filenamePolicy) {
        return new SimpleSink<Void>(tempDirectory, DynamicFileDestinations.constant((FileBasedSink.FilenamePolicy)filenamePolicy), Compression.UNCOMPRESSED);
    }

    public static SimpleSink<Void> makeSimpleSink(ResourceId baseDirectory, String prefix, String shardTemplate, String suffix, FileBasedSink.WritableByteChannelFactory writableByteChannelFactory) {
        FileBasedSink.DynamicDestinations dynamicDestinations = DynamicFileDestinations.constant((FileBasedSink.FilenamePolicy)DefaultFilenamePolicy.fromParams((DefaultFilenamePolicy.Params)new DefaultFilenamePolicy.Params().withBaseFilename(baseDirectory.resolve(prefix, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE)).withShardTemplate(shardTemplate).withSuffix(suffix)));
        return new SimpleSink<Void>(baseDirectory, dynamicDestinations, writableByteChannelFactory);
    }

    public static SimpleSink<Void> makeSimpleSink(ResourceId baseDirectory, String prefix, String shardTemplate, String suffix, Compression compression) {
        return SimpleSink.makeSimpleSink(baseDirectory, prefix, shardTemplate, suffix, (FileBasedSink.WritableByteChannelFactory)FileBasedSink.CompressionType.fromCanonical((Compression)compression));
    }

    public SimpleWriteOperation<DestinationT> createWriteOperation() {
        return new SimpleWriteOperation(this);
    }

    static final class SimpleWriter<DestinationT>
    extends FileBasedSink.Writer<DestinationT, String> {
        static final String HEADER = "header";
        static final String FOOTER = "footer";
        private WritableByteChannel channel;

        public SimpleWriter(SimpleWriteOperation<DestinationT> writeOperation) {
            super(writeOperation, "text/plain");
        }

        private static ByteBuffer wrap(String value) {
            return ByteBuffer.wrap((value + "\n").getBytes(StandardCharsets.UTF_8));
        }

        protected void prepareWrite(WritableByteChannel channel) {
            this.channel = channel;
        }

        protected void writeHeader() throws Exception {
            this.channel.write(SimpleWriter.wrap(HEADER));
        }

        protected void writeFooter() throws Exception {
            this.channel.write(SimpleWriter.wrap(FOOTER));
        }

        public void write(String value) throws Exception {
            this.channel.write(SimpleWriter.wrap(value));
        }
    }

    static final class SimpleWriteOperation<DestinationT>
    extends FileBasedSink.WriteOperation<DestinationT, String> {
        public SimpleWriteOperation(SimpleSink<DestinationT> sink, ResourceId tempOutputDirectory) {
            super(sink, tempOutputDirectory);
        }

        public SimpleWriteOperation(SimpleSink<DestinationT> sink) {
            super(sink);
        }

        public SimpleWriter<DestinationT> createWriter() {
            return new SimpleWriter(this);
        }
    }
}

