/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.file.CodecFactory;
import org.apache.beam.sdk.io.SerializableAvroCodecFactory;
import org.apache.beam.sdk.util.SerializableUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SerializableAvroCodecFactoryTest {
    private final List<String> avroCodecs = Arrays.asList("null", "snappy", "deflate", "xz", "bzip2");

    @Test
    public void testDefaultCodecsIn() throws Exception {
        for (String codec : this.avroCodecs) {
            SerializableAvroCodecFactory codecFactory = new SerializableAvroCodecFactory(CodecFactory.fromString((String)codec));
            Assert.assertEquals((Object)CodecFactory.fromString((String)codec).toString(), (Object)codecFactory.getCodec().toString());
        }
    }

    @Test
    public void testDefaultCodecsSerDe() throws Exception {
        for (String codec : this.avroCodecs) {
            SerializableAvroCodecFactory codecFactory = new SerializableAvroCodecFactory(CodecFactory.fromString((String)codec));
            SerializableAvroCodecFactory serdeC = (SerializableAvroCodecFactory)SerializableUtils.clone((Serializable)codecFactory);
            Assert.assertEquals((Object)CodecFactory.fromString((String)codec).toString(), (Object)serdeC.getCodec().toString());
        }
    }

    @Test
    public void testDeflateCodecSerDeWithLevels() throws Exception {
        for (int i = 0; i < 10; ++i) {
            SerializableAvroCodecFactory codecFactory = new SerializableAvroCodecFactory(CodecFactory.deflateCodec((int)i));
            SerializableAvroCodecFactory serdeC = (SerializableAvroCodecFactory)SerializableUtils.clone((Serializable)codecFactory);
            Assert.assertEquals((Object)CodecFactory.deflateCodec((int)i).toString(), (Object)serdeC.getCodec().toString());
        }
    }

    @Test
    public void testXZCodecSerDeWithLevels() throws Exception {
        for (int i = 0; i < 10; ++i) {
            SerializableAvroCodecFactory codecFactory = new SerializableAvroCodecFactory(CodecFactory.xzCodec((int)i));
            SerializableAvroCodecFactory serdeC = (SerializableAvroCodecFactory)SerializableUtils.clone((Serializable)codecFactory);
            Assert.assertEquals((Object)CodecFactory.xzCodec((int)i).toString(), (Object)serdeC.getCodec().toString());
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNullCodecToString() throws Exception {
        SerializableAvroCodecFactory codec = new SerializableAvroCodecFactory();
        codec.toString();
    }
}

