/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedReadFromUnboundedSource;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.POutput;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadTest
implements Serializable {
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    public void failsWhenCustomBoundedSourceIsNotSerializable() {
        this.thrown.expect(IllegalArgumentException.class);
        Read.from((BoundedSource)new NotSerializableBoundedSource());
    }

    @Test
    public void succeedsWhenCustomBoundedSourceIsSerializable() {
        Read.from((BoundedSource)new SerializableBoundedSource());
    }

    @Test
    public void failsWhenCustomUnboundedSourceIsNotSerializable() {
        this.thrown.expect(IllegalArgumentException.class);
        Read.from((UnboundedSource)new NotSerializableUnboundedSource());
    }

    @Test
    public void succeedsWhenCustomUnboundedSourceIsSerializable() {
        Read.from((UnboundedSource)new SerializableUnboundedSource());
    }

    @Test
    public void testDisplayData() {
        SerializableBoundedSource boundedSource = new SerializableBoundedSource(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        };
        SerializableUnboundedSource unboundedSource = new SerializableUnboundedSource(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        };
        Duration maxReadTime = Duration.standardMinutes((long)2345L);
        Read.Bounded bounded = Read.from((BoundedSource)boundedSource);
        BoundedReadFromUnboundedSource unbounded = Read.from((UnboundedSource)unboundedSource).withMaxNumRecords(1234L).withMaxReadTime(maxReadTime);
        DisplayData boundedDisplayData = DisplayData.from((HasDisplayData)bounded);
        MatcherAssert.assertThat((Object)boundedDisplayData, DisplayDataMatchers.hasDisplayItem("source", ((Object)((Object)boundedSource)).getClass()));
        MatcherAssert.assertThat((Object)boundedDisplayData, DisplayDataMatchers.includesDisplayDataFor("source", (HasDisplayData)boundedSource));
        DisplayData unboundedDisplayData = DisplayData.from((HasDisplayData)unbounded);
        MatcherAssert.assertThat((Object)unboundedDisplayData, DisplayDataMatchers.hasDisplayItem("source", ((Object)((Object)unboundedSource)).getClass()));
        MatcherAssert.assertThat((Object)unboundedDisplayData, DisplayDataMatchers.includesDisplayDataFor("source", (HasDisplayData)unboundedSource));
        MatcherAssert.assertThat((Object)unboundedDisplayData, DisplayDataMatchers.hasDisplayItem("maxRecords", 1234L));
        MatcherAssert.assertThat((Object)unboundedDisplayData, DisplayDataMatchers.hasDisplayItem("maxReadTime", maxReadTime));
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testBoundedPrimitiveDisplayData() {
        this.testPrimitiveDisplayData(false);
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testStreamingPrimitiveDisplayData() {
        this.testPrimitiveDisplayData(true);
    }

    private void testPrimitiveDisplayData(boolean isStreaming) {
        PipelineOptions options = DisplayDataEvaluator.getDefaultOptions();
        ((StreamingOptions)options.as(StreamingOptions.class)).setStreaming(isStreaming);
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create(options);
        SerializableBoundedSource boundedSource = new SerializableBoundedSource(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        };
        SerializableUnboundedSource unboundedSource = new SerializableUnboundedSource(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        };
        Read.Bounded bounded = Read.from((BoundedSource)boundedSource);
        BoundedReadFromUnboundedSource unbounded = Read.from((UnboundedSource)unboundedSource).withMaxNumRecords(1234L);
        Set<DisplayData> boundedDisplayData = evaluator.displayDataForPrimitiveSourceTransforms((PTransform<? super PBegin, ? extends POutput>)bounded);
        MatcherAssert.assertThat(boundedDisplayData, (Matcher)Matchers.hasItem(DisplayDataMatchers.hasDisplayItem("source", ((Object)((Object)boundedSource)).getClass())));
        MatcherAssert.assertThat(boundedDisplayData, (Matcher)Matchers.hasItem(DisplayDataMatchers.includesDisplayDataFor("source", (HasDisplayData)boundedSource)));
        Set<DisplayData> unboundedDisplayData = evaluator.displayDataForPrimitiveSourceTransforms((PTransform<? super PBegin, ? extends POutput>)unbounded);
        MatcherAssert.assertThat(unboundedDisplayData, (Matcher)Matchers.hasItem(DisplayDataMatchers.hasDisplayItem("source")));
        MatcherAssert.assertThat(unboundedDisplayData, (Matcher)Matchers.hasItem(DisplayDataMatchers.includesDisplayDataFor("source", (HasDisplayData)unboundedSource)));
    }

    private static class NotSerializableClass {
        private NotSerializableClass() {
        }
    }

    private static class SerializableUnboundedSource
    extends CustomUnboundedSource {
        private SerializableUnboundedSource() {
        }
    }

    private static class NotSerializableUnboundedSource
    extends CustomUnboundedSource {
        private final NotSerializableClass notSerializableClass = new NotSerializableClass();

        private NotSerializableUnboundedSource() {
        }
    }

    private static class NoOpCheckpointMark
    implements UnboundedSource.CheckpointMark {
        private NoOpCheckpointMark() {
        }

        public void finalizeCheckpoint() throws IOException {
        }
    }

    private static abstract class CustomUnboundedSource
    extends UnboundedSource<String, NoOpCheckpointMark> {
        private CustomUnboundedSource() {
        }

        public List<? extends UnboundedSource<String, NoOpCheckpointMark>> split(int desiredNumSplits, PipelineOptions options) throws Exception {
            return null;
        }

        public UnboundedSource.UnboundedReader<String> createReader(PipelineOptions options, NoOpCheckpointMark checkpointMark) {
            return null;
        }

        @Nullable
        public Coder<NoOpCheckpointMark> getCheckpointMarkCoder() {
            return null;
        }

        public boolean requiresDeduping() {
            return true;
        }

        public Coder<String> getOutputCoder() {
            return StringUtf8Coder.of();
        }
    }

    private static class SerializableBoundedSource
    extends CustomBoundedSource {
        private SerializableBoundedSource() {
        }
    }

    private static class NotSerializableBoundedSource
    extends CustomBoundedSource {
        private final NotSerializableClass notSerializableClass = new NotSerializableClass();

        private NotSerializableBoundedSource() {
        }
    }

    private static abstract class CustomBoundedSource
    extends BoundedSource<String> {
        private CustomBoundedSource() {
        }

        public List<? extends BoundedSource<String>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            return null;
        }

        public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
            return 0L;
        }

        public BoundedSource.BoundedReader<String> createReader(PipelineOptions options) throws IOException {
            return null;
        }

        public Coder<String> getOutputCoder() {
            return StringUtf8Coder.of();
        }
    }
}

